/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StoreDataList
extends DataList<Store> {
    public StoreDataList(DataAccess da) {
        this.t = new Store(da);
    }

    public StoreDataList() {
    }

    @Override
    public void select() {
    }

    public void selectAll(DataAccess da) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = da.select("Select * from Store", da.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    Store request = new Store(rs.getString("name"), rs.getString("code"), rs.getString("address"), rs.getString("phoneNumber"), rs.getString("email"), this.getDataAccess());
                    request.setSn(this.getOriginalList().size() + 1);
                    request.vClone = request.clone();
                    if (request.getName().isEmpty()) continue;
                    this.getOriginalList().add((Object)request);
                }
                if (this.getOriginalList().size() > 0) {
                    Comparator<Store> comparatorMyObject_Name = new Comparator<Store>(){

                        @Override
                        public int compare(Store o1, Store o2) {
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                    };
                    Collections.sort(this.getOriginalList(), comparatorMyObject_Name);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    Store request = new Store(rs.getString("name"), rs.getString("code"), rs.getString("address"), rs.getString("phoneNumber"), rs.getString("email"), this.getDataAccess());
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                if (this.getOriginalList().size() > 0) {
                    Comparator<Store> comparatorMyObject_Name = new Comparator<Store>(){

                        @Override
                        public int compare(Store o1, Store o2) {
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                    };
                    Collections.sort(this.getOriginalList(), comparatorMyObject_Name);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select  * From Store Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by dateLog ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        try {
            if (rs != null) {
                while (rs.next()) {
                    Store request = new Store(rs.getString("name"), rs.getString("code"), rs.getString("address"), rs.getString("phoneNumber"), rs.getString("email"), this.getDataAccess());
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void deleteAll(DataAccess da) throws Exception {
        da.performDbOperation("Delete From STORE", da.getEmptyParameterValues());
    }
}

