/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.Log;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogDataList
extends DataList<Log> {
    public LogDataList(DataAccess da) {
        this.t = new Log(da);
    }

    public LogDataList() {
    }

    @Override
    public void select() {
    }

    public void selectAll() {
        try {
            String query = "Select * from Log order by dateLog desc";
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, this.getDataAccess().getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    Log log = new Log(rs.getString("msg"), rs.getTimestamp("dateLog"), rs.getString("status"), rs.getString("payLoad"), this.getDataAccess());
                    log.vClone = log.clone();
                    this.getOriginalList().add((Object)log);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectAll(String query, ParameterValue[] param, DataAccess da) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = da.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    Log log = new Log(rs.getString("msg"), rs.getDate("dateLog"), rs.getString("status"), rs.getString("payLoad"), this.getDataAccess());
                    log.vClone = log.clone();
                    this.getOriginalList().add((Object)log);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    Log log = new Log(rs.getString("msg"), rs.getDate("dateLog"), rs.getString("status"), rs.getString("payLoad"), this.getDataAccess());
                    log.vClone = log.clone();
                    this.getOriginalList().add((Object)log);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select  * From \"Log\" Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by dateLog ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        try {
            if (rs != null) {
                while (rs.next()) {
                    Log log = new Log(rs.getString("msg"), rs.getDate("dateLog"), rs.getString("status"), rs.getString("payLoad"), this.getDataAccess());
                    log.vClone = log.clone();
                    this.getOriginalList().add((Object)log);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<SearchClass> selectAutoComplete(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("firstName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("lastName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("roleDescription", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("userName", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Distinct * From \"User\" Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by firstName ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new SearchClass(rs.getString("userName"), rs.getString("firstName") + " " + rs.getString("lastName") + "[" + rs.getString("userName") + "]"));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }
}

