/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.SupplierDataList;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class Supplier
extends DbEntity {
    private int sn;
    DataAccess dt = this.getDbAccess();
    private BooleanProperty syncFlag = new SimpleBooleanProperty();
    boolean isCloned;
    public Supplier vClone;
    private StringProperty name = new SimpleStringProperty();
    private StringProperty syncError = new SimpleStringProperty("");
    private StringProperty vendorGroup = new SimpleStringProperty("");
    private StringProperty email = new SimpleStringProperty("");
    private StringProperty address = new SimpleStringProperty();
    private StringProperty vendorId = new SimpleStringProperty("");
    private StringProperty paymentTerm = new SimpleStringProperty();
    private StringProperty bankName = new SimpleStringProperty();
    private StringProperty accountName = new SimpleStringProperty();
    private StringProperty accountNumber = new SimpleStringProperty();
    private StringProperty currency = new SimpleStringProperty();
    private StringProperty sortCode = new SimpleStringProperty();
    private DoubleProperty creditLimit = new SimpleDoubleProperty();
    private StringProperty phoneNumber = new SimpleStringProperty();

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public static SupplierDataList SearchSupplier(String searchString, DataAccess da) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("address", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("phoneNumber", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searchString + "%"));
        SupplierDataList customerList = new SupplierDataList(da);
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        customerList.select(searchCondition, true, false);
        return customerList;
    }

    public Supplier() {
        this.initializeListener();
    }

    public Supplier(String address, String name, String phoneNumber, String email, String comapanyName, String paymentTerm, String bankName, String accountNumber, String accountName, String currency, String sortCode, Double creditLimit, Boolean syncFlag, String vendorGroup, DataAccess dbAccess) {
        super(dbAccess);
        this.syncFlag.set(syncFlag.booleanValue());
        this.name.set((Object)name);
        this.address.set((Object)address);
        this.phoneNumber.set((Object)phoneNumber);
        this.email.set((Object)email);
        this.vendorId.set((Object)comapanyName);
        this.paymentTerm.set((Object)paymentTerm);
        this.bankName.set((Object)bankName);
        this.vendorGroup.set((Object)vendorGroup);
        this.accountNumber.set((Object)accountNumber);
        this.accountName.set((Object)accountName);
        this.currency.set((Object)currency);
        this.sortCode.set((Object)sortCode);
        this.creditLimit.set(creditLimit.doubleValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public Supplier(DataAccess dbAccess) {
        super(dbAccess);
        this.initializeListener();
    }

    public Boolean getSyncFlag() {
        return this.syncFlag.get();
    }

    public void setSyncFlag(Boolean syncFlag) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.syncFlag.set(syncFlag.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty syncFlagProperty() {
        return this.syncFlag;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.name.set((Object)name);
        this.changeObjectState();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public StringProperty syncErrorProperty() {
        return this.syncError;
    }

    public String getSyncError() {
        return (String)this.syncError.get();
    }

    public void setSyncError(String syncError) {
        this.syncError.set((Object)syncError);
    }

    public String getVendorGroup() {
        return (String)this.vendorGroup.get();
    }

    public void setVendorGroup(String vendorGroup) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.vendorGroup.set((Object)vendorGroup);
        this.changeObjectState();
    }

    public StringProperty vendorGroupProperty() {
        return this.vendorGroup;
    }

    public String getEmail() {
        return (String)this.email.get();
    }

    public void setEmail(String email) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.email.set((Object)email);
        this.changeObjectState();
    }

    public StringProperty emailProperty() {
        return this.email;
    }

    public String getAddress() {
        return (String)this.address.get();
    }

    public void setAddress(String address) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.address.set((Object)address);
        this.changeObjectState();
    }

    public StringProperty addressProperty() {
        return this.address;
    }

    public String getVendorId() {
        return (String)this.vendorId.get();
    }

    public void setVendorId(String vendorId) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.vendorId.set((Object)vendorId);
        this.changeObjectState();
    }

    public StringProperty vendorIdProperty() {
        return this.vendorId;
    }

    public String getPaymentTerm() {
        return (String)this.paymentTerm.get();
    }

    public void setPaymentTerm(String paymentTerm) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.paymentTerm.set((Object)paymentTerm);
        this.changeObjectState();
    }

    public StringProperty paymentTermProperty() {
        return this.paymentTerm;
    }

    public String getBankName() {
        return (String)this.bankName.get();
    }

    public void setBankName(String bankName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.bankName.set((Object)bankName);
        this.changeObjectState();
    }

    public StringProperty bankNameProperty() {
        return this.bankName;
    }

    public String getAccountName() {
        return (String)this.accountName.get();
    }

    public void setAccountName(String accountName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.accountName.set((Object)accountName);
        this.changeObjectState();
    }

    public StringProperty accountNameProperty() {
        return this.accountName;
    }

    public String getAccountNumber() {
        return (String)this.accountNumber.get();
    }

    public void setAccountNumber(String accountNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.accountNumber.set((Object)accountNumber);
        this.changeObjectState();
    }

    public StringProperty accountNumberProperty() {
        return this.accountNumber;
    }

    public String getCurrency() {
        return (String)this.currency.get();
    }

    public void setCurrency(String currency) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.currency.set((Object)currency);
        this.changeObjectState();
    }

    public StringProperty currencyProperty() {
        return this.currency;
    }

    public String getSortCode() {
        return (String)this.sortCode.get();
    }

    public void setSortCode(String sortCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.sortCode.set((Object)sortCode);
        this.changeObjectState();
    }

    public StringProperty sortCodeProperty() {
        return this.sortCode;
    }

    public double getCreditLimit() {
        return this.creditLimit.get();
    }

    public void setCreditLimit(double creditLimit) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.creditLimit.set(creditLimit);
        this.changeObjectState();
    }

    public DoubleProperty creditLimitProperty() {
        return this.creditLimit;
    }

    public String getPhoneNumber() {
        return (String)this.phoneNumber.get();
    }

    public void setPhoneNumber(String phoneNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.phoneNumber.set((Object)phoneNumber);
        this.changeObjectState();
    }

    public StringProperty phoneNumberProperty() {
        return this.phoneNumber;
    }

    public Supplier clone() {
        Supplier cloneTemp = new Supplier(this.dt);
        cloneTemp.setMustClone(false);
        cloneTemp.address.set((Object)((String)this.address.get()));
        cloneTemp.name.set((Object)((String)this.name.get()));
        cloneTemp.phoneNumber.set((Object)((String)this.phoneNumber.get()));
        cloneTemp.email.set((Object)((String)this.email.get()));
        cloneTemp.vendorId.set((Object)((String)this.vendorId.get()));
        cloneTemp.paymentTerm.set((Object)((String)this.paymentTerm.get()));
        cloneTemp.bankName.set((Object)((String)this.bankName.get()));
        cloneTemp.accountNumber.set((Object)((String)this.accountNumber.get()));
        cloneTemp.accountName.set((Object)((String)this.accountName.get()));
        cloneTemp.currency.set((Object)((String)this.currency.get()));
        cloneTemp.sortCode.set((Object)((String)this.sortCode.get()));
        cloneTemp.creditLimit.set(this.creditLimit.get());
        cloneTemp.syncFlag.set(this.syncFlag.get());
        cloneTemp.vendorGroup.set((Object)((String)this.vendorGroup.get()));
        cloneTemp.setMustClone(true);
        this.isCloned = true;
        return cloneTemp;
    }

    private void rollBack() {
        this.name.set((Object)((String)this.vClone.name.get()));
        this.address.set((Object)((String)this.vClone.address.get()));
        this.phoneNumber.set((Object)((String)this.vClone.phoneNumber.get()));
        this.email.set((Object)((String)this.vClone.email.get()));
        this.vendorId.set((Object)((String)this.vClone.vendorId.get()));
        this.paymentTerm.set((Object)((String)this.vClone.paymentTerm.get()));
        this.bankName.set((Object)((String)this.vClone.bankName.get()));
        this.accountNumber.set((Object)((String)this.vClone.accountNumber.get()));
        this.accountName.set((Object)((String)this.vClone.accountName.get()));
        this.currency.set((Object)((String)this.vClone.currency.get()));
        this.sortCode.set((Object)((String)this.vClone.sortCode.get()));
        this.creditLimit.set(this.vClone.creditLimit.get());
        this.syncFlag.set(this.vClone.syncFlag.get());
        this.vendorGroup.set((Object)((String)this.vClone.vendorGroup.get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("address", JDBCType.VARCHAR, this.address.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("phoneNumber", JDBCType.VARCHAR, this.phoneNumber.get()), new ParameterValue("email", JDBCType.VARCHAR, this.email.get()), new ParameterValue("vendorId", JDBCType.VARCHAR, this.vendorId.get()), new ParameterValue("paymentTerm", JDBCType.VARCHAR, this.paymentTerm.get()), new ParameterValue("bankName", JDBCType.VARCHAR, this.bankName.get()), new ParameterValue("accountNumber", JDBCType.VARCHAR, this.accountNumber.get()), new ParameterValue("accountName", JDBCType.VARCHAR, this.accountName.get()), new ParameterValue("currency", JDBCType.VARCHAR, this.currency.get()), new ParameterValue("sortCode", JDBCType.VARCHAR, this.sortCode.get()), new ParameterValue("creditLimit", JDBCType.DOUBLE, this.creditLimit.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("vendorGroup", JDBCType.VARCHAR, this.vendorGroup.get())};
            String query = "insert into Supplier (name,address,phoneNumber,email,vendorId,paymentTerm,bankName,accountNumber,accountName,currency,sortCode,creditLimit,syncFlag,vendorGroup) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            this.getDbAccess().performDbOperation(query, paramValue);
            this.vClone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isCloned = false;
            throw ex;
        }
    }

    @Override
    public void update() throws BaseConcurrencyException, Exception {
        try {
            String query = "Update Supplier set name=?,address=?,phoneNumber=?,email=?,vendorId=?,paymentTerm=?,bankName=?,accountNumber=?,accountName=?,currency=?,sortCode=?,creditLimit=?,syncFlag=?,vendorGroup=? where email=? ";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("address", JDBCType.VARCHAR, this.address.get()), new ParameterValue("phoneNumber", JDBCType.VARCHAR, this.phoneNumber.get()), new ParameterValue("email", JDBCType.VARCHAR, this.email.get()), new ParameterValue("vendorId", JDBCType.VARCHAR, this.vendorId.get()), new ParameterValue("paymentTerm", JDBCType.VARCHAR, this.paymentTerm.get()), new ParameterValue("bankName", JDBCType.VARCHAR, this.bankName.get()), new ParameterValue("accountNumber", JDBCType.VARCHAR, this.accountNumber.get()), new ParameterValue("accountName", JDBCType.VARCHAR, this.accountName.get()), new ParameterValue("currency", JDBCType.VARCHAR, this.currency.get()), new ParameterValue("sortCode", JDBCType.VARCHAR, this.sortCode.get()), new ParameterValue("creditLimit", JDBCType.DOUBLE, this.creditLimit.get()), new ParameterValue("syncFlag", JDBCType.BOOLEAN, this.syncFlag.get()), new ParameterValue("vendorGroup", JDBCType.VARCHAR, this.vendorGroup.get()), new ParameterValue("email", JDBCType.VARCHAR, this.vClone.email.get())});
            this.vClone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isCloned = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() {
        String query = "Delete from Supplier where phoneNumber=? ";
        try {
            this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("phoneNumber", JDBCType.VARCHAR, this.phoneNumber.get())});
        }
        catch (Exception ex) {
            Logger.getLogger(Supplier.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        String[] parameters = new String[]{"address", "name", "phoneNumber", "companyName"};
        sb.setTableName("Supplier");
        sb.setParameters(parameters);
        return sb;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    public String toString() {
        return (String)this.name.get();
    }

    @Override
    public void initializeListener() {
        this.phoneNumber.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Supplier.this.setPhoneNumber(newValue);
            }
        });
        this.address.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Supplier.this.setAddress(newValue);
            }
        });
        this.name.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Supplier.this.setName(newValue);
            }
        });
        this.syncError.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Supplier.this.setSyncError(newValue);
            }
        });
    }
}

