/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import java.sql.JDBCType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class SaleItemSerial
extends DbEntity {
    private BooleanProperty whschangable = new SimpleBooleanProperty();
    private BooleanProperty cns = new SimpleBooleanProperty();
    private BooleanProperty dsp = new SimpleBooleanProperty();
    private BooleanProperty act = new SimpleBooleanProperty();
    Company parentCompany;
    private StringProperty saleItemCode = new SimpleStringProperty();
    private StringProperty whscode = new SimpleStringProperty();
    private StringProperty status = new SimpleStringProperty();
    private StringProperty itemCode = new SimpleStringProperty();
    private StringProperty serial = new SimpleStringProperty();
    private IntegerProperty quantity = new SimpleIntegerProperty();
    private IntegerProperty sysSerial = new SimpleIntegerProperty();
    public SaleItemSerial vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private int sn;

    public BooleanProperty whschangableProperty() {
        return this.whschangable;
    }

    public BooleanProperty cnsProperty() {
        return this.cns;
    }

    public Boolean getCns() {
        return this.cns.get();
    }

    public void setCns(Boolean cns) {
        this.cns.set(cns.booleanValue());
        if (cns.booleanValue()) {
            this.setWhscode("02");
            this.act.set(false);
            this.dsp.set(false);
        }
    }

    public BooleanProperty dspProperty() {
        return this.dsp;
    }

    public Boolean getDsp() {
        return this.dsp.get();
    }

    public void setDsp(Boolean dsp) {
        this.dsp.set(dsp.booleanValue());
        if (dsp.booleanValue()) {
            this.setWhscode("07");
            this.cns.set(false);
            this.act.set(false);
        }
    }

    public BooleanProperty actProperty() {
        return this.act;
    }

    public Boolean getAct() {
        return this.act.get();
    }

    private void loadParentCompany() {
        CompanyDataList compList = new CompanyDataList(this.getDbAccess());
        String query = "Select * From Company";
        compList.selectAll(query, this.getDbAccess().getEmptyParameterValues());
        if (compList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)compList.getOriginalList().get(0);
        }
    }

    public Company getParentCompany() {
        if (this.parentCompany == null) {
            this.loadParentCompany();
        }
        return this.parentCompany;
    }

    public void setAct(Boolean act) {
        this.act.set(act.booleanValue());
        if (act.booleanValue()) {
            this.setWhscode(this.getParentCompany().getStoreCode());
            this.cns.set(false);
            this.dsp.set(false);
        }
    }

    public StringProperty saleItemCodeProperty() {
        return this.saleItemCode;
    }

    public String getSaleItemCode() {
        return (String)this.saleItemCode.get();
    }

    public void setSaleItemCode(String saleItemCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.saleItemCode.set((Object)saleItemCode);
        this.changeObjectState();
    }

    public StringProperty whscodeProperty() {
        return this.whscode;
    }

    public String getWhscode() {
        return (String)this.whscode.get();
    }

    public void setWhscode(String whscode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.whscode.set((Object)whscode);
        this.changeObjectState();
    }

    public StringProperty statusProperty() {
        return this.status;
    }

    public String getStatus() {
        return (String)this.status.get();
    }

    public void setStatus(String status) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.status.set((Object)status);
        this.changeObjectState();
    }

    public StringProperty itemCodeProperty() {
        return this.itemCode;
    }

    public String getItemCode() {
        return (String)this.itemCode.get();
    }

    public void setItemCode(String itemCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.itemCode.set((Object)itemCode);
        this.changeObjectState();
    }

    public StringProperty serialProperty() {
        return this.serial;
    }

    public String getSerial() {
        return (String)this.serial.get();
    }

    public void setSerial(String serial) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.serial.set((Object)serial);
        this.changeObjectState();
    }

    public float getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(int quantity) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.quantity.set(quantity);
        this.changeObjectState();
    }

    public IntegerProperty quantityProperty() {
        return this.quantity;
    }

    public float getSysSerial() {
        return this.sysSerial.get();
    }

    public void setSysSerial(int sysSerial) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.sysSerial.set(sysSerial);
        this.changeObjectState();
    }

    public IntegerProperty sysSerialProperty() {
        return this.sysSerial;
    }

    public SaleItemSerial(DataAccess dt) {
        super(dt);
        this.initializeListener();
    }

    public SaleItemSerial(String itemCode, String serial, Integer qty, Integer sysSerial, String status, String whscode, String saleitemCode, DataAccess dbAccess) {
        super(dbAccess);
        this.itemCode.set((Object)itemCode);
        this.serial.set((Object)serial);
        this.quantity.set(qty.intValue());
        this.sysSerial.set(sysSerial.intValue());
        this.status.set((Object)status);
        this.whscode.set((Object)whscode);
        this.saleItemCode.set((Object)saleitemCode);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public SaleItemSerial clone() {
        SaleItemSerial product = new SaleItemSerial(this.dt);
        product.setMustClone(false);
        product.itemCode.set((Object)((String)this.itemCode.get()));
        product.serial.set((Object)((String)this.serial.get()));
        product.quantity.set(this.quantity.get());
        product.sysSerial.set(this.sysSerial.get());
        product.status.set((Object)((String)this.status.get()));
        product.whscode.set((Object)((String)this.whscode.get()));
        product.saleItemCode.set((Object)((String)this.saleItemCode.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return product;
    }

    protected void rollBack() {
        this.itemCode.set((Object)((String)this.vClone.itemCode.get()));
        this.serial.set((Object)((String)this.vClone.serial.get()));
        this.quantity.set(this.vClone.quantity.get());
        this.sysSerial.set(this.vClone.sysSerial.get());
        this.status.set((Object)((String)this.vClone.status.get()));
        this.whscode.set((Object)((String)this.vClone.whscode.get()));
        this.saleItemCode.set((Object)((String)this.vClone.saleItemCode.get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO SALEITEMSERIAL (itemCode,serial,quantity,sysSerial,status,whscode,saleItemCode) Values(?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("serial", JDBCType.VARCHAR, this.serial.get()), new ParameterValue("quantity", JDBCType.INTEGER, this.quantity.get()), new ParameterValue("sysSerial", JDBCType.INTEGER, this.sysSerial.get()), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("whscode", JDBCType.VARCHAR, this.whscode.get()), new ParameterValue("saleItemCode", JDBCType.VARCHAR, this.saleItemCode.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE SALEITEMSERIAL SET itemCode=?, serial=?,quantity=?,sysSerial=?,status=?,whscode=?,saleItemCode=? WHERE serial=? and itemCode=? and saleItemCode=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("serial", JDBCType.VARCHAR, this.serial.get()), new ParameterValue("quantity", JDBCType.INTEGER, this.quantity.get()), new ParameterValue("sysSerial", JDBCType.INTEGER, this.sysSerial.get()), new ParameterValue("status", JDBCType.VARCHAR, this.status.get()), new ParameterValue("whscode", JDBCType.VARCHAR, this.whscode.get()), new ParameterValue("saleItemCode", JDBCType.VARCHAR, this.saleItemCode.get()), new ParameterValue("clone", JDBCType.VARCHAR, this.vClone.serial.get()), new ParameterValue("clone1", JDBCType.VARCHAR, this.vClone.itemCode.get()), new ParameterValue("clone2", JDBCType.VARCHAR, this.vClone.saleItemCode.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM SALEITEMSERIAL WHERE serial=? and saleItemCode=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("serial", JDBCType.VARCHAR, this.serial.get()), new ParameterValue("saleItemCode", JDBCType.VARCHAR, this.saleItemCode.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
        this.cns.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                SaleItemSerial.this.setCns(newValue);
            }
        });
        this.dsp.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                SaleItemSerial.this.setDsp(newValue);
            }
        });
        this.act.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                SaleItemSerial.this.setAct(newValue);
            }
        });
    }

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public String toString() {
        return (String)this.serial.get();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        SaleItemSerial store = (SaleItemSerial)object;
        return ((String)this.serial.get()).equals(store.serial.get()) && ((String)this.serial.get()).equals(store.serial.get());
    }
}

