/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.ui.MailOperationEnum;
import java.sql.JDBCType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class RequestApprovalUser
extends DbEntity {
    private StringProperty operationType = new SimpleStringProperty("");
    private StringProperty email = new SimpleStringProperty();
    private StringProperty name = new SimpleStringProperty();
    private BooleanProperty isEnable = new SimpleBooleanProperty(true);
    public RequestApprovalUser vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private int sn;

    public String getEmail() {
        return (String)this.email.get();
    }

    public void setEmail(String email) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.email.set((Object)email);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.name.set((Object)name);
    }

    public String getOperationType() {
        return (String)this.operationType.get();
    }

    public void setOperationType(String operationType) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.operationType.set((Object)operationType);
    }

    public boolean getIsEnable() {
        return this.isEnable.get();
    }

    public void setIsEnable(boolean Enable) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.isEnable.set(Enable);
        this.changeObjectState();
    }

    public BooleanProperty isEnableProperty() {
        return this.isEnable;
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public StringProperty emailProperty() {
        return this.email;
    }

    public StringProperty operationTypeProperty() {
        return this.operationType;
    }

    public RequestApprovalUser(DataAccess dt) {
        super(dt);
        this.operationType.set((Object)MailOperationEnum.TransferApproval.name());
        this.initializeListener();
    }

    public RequestApprovalUser(String accNumber, String name, Boolean isEnable, String operationType, DataAccess dbAccess) {
        super(dbAccess);
        this.email.set((Object)accNumber);
        this.name.set((Object)name);
        this.isEnable.set(isEnable.booleanValue());
        this.operationType.set((Object)operationType);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public RequestApprovalUser clone() {
        RequestApprovalUser request = new RequestApprovalUser(this.dt);
        request.setMustClone(false);
        request.email.set((Object)((String)this.email.get()));
        request.name.set((Object)((String)this.name.get()));
        request.isEnable.set(this.isEnable.get());
        request.operationType.set((Object)((String)this.operationType.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return request;
    }

    protected void rollBack() {
        this.email.set((Object)((String)this.vClone.email.get()));
        this.name.set((Object)((String)this.vClone.name.get()));
        this.isEnable.set(this.vClone.isEnable.get());
        this.operationType.set((Object)((String)this.vClone.operationType.get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO RequestApprovalUser (accNumber,name,isEnable,operationType) Values(?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("email", JDBCType.VARCHAR, this.email.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("isEnable", JDBCType.CHAR, this.isEnable.get()), new ParameterValue("operationType", JDBCType.VARCHAR, this.operationType.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE RequestApprovalUser SET accNumber=?, name=?, isEnable=?,operationType=? WHERE accNumber=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("email", JDBCType.VARCHAR, this.email.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("isEnable", JDBCType.CHAR, this.isEnable.get()), new ParameterValue("operationType", JDBCType.VARCHAR, this.operationType.get()), new ParameterValue("accNumber", JDBCType.VARCHAR, this.vClone.email.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM Account WHERE email=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("email", JDBCType.VARCHAR, this.email.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
        this.name.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                RequestApprovalUser.this.setName(newValue);
            }
        });
        this.email.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                RequestApprovalUser.this.setEmail(newValue);
            }
        });
    }

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public String toString() {
        return String.valueOf(this.name.get());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        RequestApprovalUser store = (RequestApprovalUser)object;
        if (store.email == null || store == null) {
            return false;
        }
        return ((String)this.email.get()).equals(store.email.get()) && ((String)this.name.get()).equals(store.name.get());
    }
}

