/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestItemBin;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.RequestitemSerial;
import com.xputertechnologies.santa.TransferSAPDockHistory;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.RequestDataList;
import com.xputertechnologies.santa.list.RequestItemBinDataList;
import com.xputertechnologies.santa.list.RequestItemDataList;
import com.xputertechnologies.santa.list.RequestitemSerialDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.TransferPane;
import com.xputertechnologies.santa.ui.TransferReleaseItemCard;
import com.xputertechnologies.santa.ui.TransferSaleItemScanDialog;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TransferReleasePane
extends UIParent {
    @FXML
    public StackPane stackPane;
    @FXML
    private JFXDatePicker from;
    @FXML
    private JFXDatePicker to;
    @FXML
    private JFXTextField searchBox;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton btnRelease;
    @FXML
    private JFXButton btnReturn;
    @FXML
    private JFXComboBox<?> cmbReqType;
    @FXML
    private JFXListView<Request> list;
    @FXML
    private FlowPane itemContainer;
    Button accptRelease;
    VBox progressContainer;
    RequestDataList requestItemDataList;
    RequestDataList requestDataList;
    StoreDataList storeDataList;
    Request temp;
    String searchRequest;

    public TransferReleasePane(Santa app) {
        super("TransferReleasePane.fxml", app);
        this.requestItemDataList = new RequestDataList(this.da);
        this.requestDataList = new RequestDataList(this.da);
        this.temp = null;
        this.searchRequest = "";
        this.santa = app;
        this.title = "Transfer Planning & Release";
        this.from.setValue((Object)LocalDate.now().minusDays(5L));
        this.to.setValue((Object)LocalDate.now());
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll(this.da);
        this.btnRelease.setVisible(false);
        this.btnReturn.setVisible(false);
        this.btnReturn.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.ROCKET).color(Color.WHITE).size(13.0));
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.searchBox, t -> {
            List<Request> result = this.searchResult(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<Request>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<Request> event) {
                TransferReleasePane.this.populateResult((Request)event.getCompletion());
            }
        });
        this.list.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Request>(){

            public void onChanged(ListChangeListener.Change<? extends Request> c) {
                Request newValue = (Request)TransferReleasePane.this.list.getItems().get(((Integer)TransferReleasePane.this.list.getSelectionModel().getSelectedIndices().get(0)).intValue());
                if (newValue != null) {
                    if (newValue.getItems().isEmpty()) {
                        TransferReleasePane.this.loadRequestItem(newValue);
                    }
                    if (newValue.getStatus().equals(RequestStatus.APPROVED.name()) && !newValue.Loaded) {
                        TransferReleasePane.this.loadSelectedRequest(newValue);
                    } else {
                        if (((RequestItem)newValue.getItems().get(0)).getRequestItemBins().isEmpty() && newValue.getStatus().equals(RequestStatus.APPROVED.name())) {
                            newValue.Loaded = false;
                        }
                        TransferReleasePane.this.itemContainer.getChildren().clear();
                        newValue.getItems().forEach(x -> TransferReleasePane.this.itemContainer.getChildren().add((Object)new TransferReleaseItemCard(TransferReleasePane.this, (RequestItem)x, !newValue.getStatus().equals(RequestStatus.APPROVED.name()))));
                        if ((newValue.getStatus().equals(RequestStatus.ACCEPTED.name()) || newValue.getStatus().equals(RequestStatus.APPROVED.name()) || newValue.getStatus().equals(RequestStatus.RETURNED.name()) || newValue.getStatus().equals(RequestStatus.RELEASED.name())) && (newValue.getToStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Inbound.name()) || newValue.getFromStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Outbound.name()) || newValue.getToStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Outbound.name()) || newValue.getFromStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Inbound.name()))) {
                            if (newValue.getStatus().equals(RequestStatus.APPROVED.name()) && (newValue.getFromStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Outbound.name()) || newValue.getToStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Inbound.name()))) {
                                TransferReleasePane.this.btnRelease.setText("Release");
                                TransferReleasePane.this.btnRelease.setGraphic((Node)TransferReleasePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.ROCKET).color(Color.WHITE).size(13.0));
                                TransferReleasePane.this.btnRelease.setVisible(true);
                                TransferReleasePane.this.btnReturn.setVisible(false);
                            } else if (newValue.getStatus().equals(RequestStatus.RETURNED.name()) && (newValue.getFromStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Outbound.name()) || newValue.getToStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Inbound.name()))) {
                                TransferReleasePane.this.btnReturn.setText("Accept Return");
                                TransferReleasePane.this.btnReturn.setGraphic((Node)TransferReleasePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.WHITE).size(13.0));
                                TransferReleasePane.this.btnRelease.setVisible(false);
                                TransferReleasePane.this.btnReturn.setVisible(true);
                            } else if (newValue.getStatus().equals(RequestStatus.ACCEPTED.name()) && newValue.getFromStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Inbound.name())) {
                                TransferReleasePane.this.btnReturn.setText("Return");
                                TransferReleasePane.this.btnRelease.setGraphic((Node)TransferReleasePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.WHITE).size(13.0));
                                TransferReleasePane.this.btnRelease.setVisible(true);
                                TransferReleasePane.this.btnReturn.setVisible(true);
                                TransferReleasePane.this.btnRelease.setText("Accept");
                            } else if (newValue.getStatus().equals(RequestStatus.RELEASED.name()) && (newValue.getFromStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Inbound.name()) || newValue.getToStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Outbound.name()))) {
                                TransferReleasePane.this.btnRelease.setText("Accept");
                                TransferReleasePane.this.btnRelease.setGraphic((Node)TransferReleasePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.WHITE).size(13.0));
                                TransferReleasePane.this.btnRelease.setVisible(true);
                                TransferReleasePane.this.btnReturn.setVisible(false);
                            } else if (newValue.getStatus().equals(RequestStatus.RELEASED.name()) && (newValue.getFromStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Outbound.name()) || newValue.getToStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && newValue.getRequestType().equals(RequestType.Inbound.name()))) {
                                TransferReleasePane.this.btnReturn.setText("Recall");
                                TransferReleasePane.this.btnRelease.setVisible(false);
                                TransferReleasePane.this.btnReturn.setVisible(true);
                            }
                        } else {
                            TransferReleasePane.this.btnRelease.setVisible(false);
                            TransferReleasePane.this.btnReturn.setVisible(false);
                        }
                    }
                }
            }
        });
        this.btnReturn.setOnAction(x -> {
            if (this.list.getSelectionModel().getSelectedItem() != null && (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RETURNED.name()) || ((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.ACCEPTED.name()) || ((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RELEASED.name()))) {
                if (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RELEASED.name())) {
                    this.mainPage.showNotification(NotificationType.Warning, "Are you sure you want to recall all the item(s) for this request " + ((Request)this.list.getSelectionModel().getSelectedItem()).getCode(), this);
                } else if (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RETURNED.name())) {
                    this.mainPage.showNotification(NotificationType.Warning, "Are you sure you want to accept all the item(s) in this return " + ((Request)this.list.getSelectionModel().getSelectedItem()).getCode(), this);
                } else if (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.ACCEPTED.name())) {
                    this.mainPage.showNotification(NotificationType.Warning, "Are you sure you want to return all the remaining item(s) in this request " + ((Request)this.list.getSelectionModel().getSelectedItem()).getCode(), this);
                }
            }
        });
        this.btnRelease.setOnAction(x -> {
            if (this.list.getSelectionModel().getSelectedItem() != null && (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.APPROVED.name()) || ((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RELEASED.name()) || ((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.ACCEPTED.name()))) {
                if (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.APPROVED.name())) {
                    if (((Request)this.list.getSelectionModel().getSelectedItem()).getItems().stream().filter(va -> va.getReleasedQuantity() > 0).count() > 0L) {
                        if (((Request)this.list.getSelectionModel().getSelectedItem()).getItems().stream().filter(v -> v.getReleasedQuantity() > v.getApprovedQty()).findAny().orElse(null) == null) {
                            this.Release((Request)this.list.getSelectionModel().getSelectedItem());
                        } else {
                            this.mainPage.showNotification(NotificationType.Error, "One or more items(s) has quantity greater than approved quantity", this);
                        }
                    } else {
                        this.mainPage.showNotification(NotificationType.Error, "No release quantity specified", this);
                    }
                } else if (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RELEASED.name()) || ((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.ACCEPTED.name())) {
                    try {
                        Dialog dialog = new Dialog();
                        dialog.initStyle(StageStyle.DECORATED);
                        dialog.initOwner((Window)this.santa.stage);
                        dialog.setTitle("Transfer(Release/Accept)");
                        dialog.setResizable(true);
                        dialog.getDialogPane().setContent((Node)new TransferSaleItemScanDialog(this.santa, (Request)this.list.getSelectionModel().getSelectedItem()));
                        ButtonType buttonType = new ButtonType(((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.APPROVED.name()) ? "Release" : "Accept", ButtonBar.ButtonData.OK_DONE);
                        dialog.getDialogPane().getButtonTypes().add((Object)buttonType);
                        Optional result = dialog.showAndWait();
                        if (result.isPresent() && result.get() == buttonType && (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RELEASED.name()) || ((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.ACCEPTED.name()))) {
                            if (((Request)this.list.getSelectionModel().getSelectedItem()).getItems().stream().filter(v -> v.getAcceptedQty() > v.getReleasedQuantity()).findAny().orElse(null) == null && !this.isAcceptedQtyGreaterThanReleaseQty((Request)this.list.getSelectionModel().getSelectedItem())) {
                                if (((Request)this.list.getSelectionModel().getSelectedItem()).getItems().stream().filter(v -> v.editableAccptQtyProperty().get() != v.getReleasedQuantity()).findAny().orElse(null) == null || ((Request)this.list.getSelectionModel().getSelectedItem()).getItems().stream().filter(v -> v.editableAccptQtyProperty().get() != v.getReleasedQuantity()).findAny().orElse(null) != null && !((Request)this.list.getSelectionModel().getSelectedItem()).getAcceptedComment().isEmpty()) {
                                    this.Accept((Request)this.list.getSelectionModel().getSelectedItem());
                                } else {
                                    this.mainPage.showNotification(NotificationType.Error, "One or more items(s) has quantity not equals to requested quantity, Please specify comment and try again", this);
                                }
                            } else {
                                this.mainPage.showNotification(NotificationType.Error, "One or more items(s) has quantity greater than released quantity", this);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ((Request)this.list.getSelectionModel().getSelectedItem()).setStatus(RequestStatus.APPROVED.name());
                        Logger.getLogger(TransferPane.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.list.setCellFactory((Callback)new Callback<ListView<Request>, ListCell<Request>>(){

            public ListCell<Request> call(ListView<Request> param) {
                Label leadLbl = new Label();
                final Tooltip tooltip = new Tooltip();
                ListCell<Request> cell = new ListCell<Request>(){

                    public void updateItem(Request req, boolean empty) {
                        super.updateItem((Object)req, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            GridPane grid = new GridPane();
                            grid.setHgap(10.0);
                            grid.setVgap(4.0);
                            grid.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            Label reqCodelbl = new Label(req.getCode());
                            reqCodelbl.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0));
                            reqCodelbl.setPrefWidth(200.0);
                            Pane pane1 = new Pane();
                            HBox.setHgrow((Node)pane1, (Priority)Priority.ALWAYS);
                            Label reqDatelbl = new Label(new SimpleDateFormat("dd-MM-yyyy hh:mm").format(req.getRequestDate()));
                            reqDatelbl.setPrefWidth(150.0);
                            reqDatelbl.setFont(Font.font((String)"Times New Roman", (FontWeight)FontWeight.BOLD, (double)11.0));
                            HBox header = new HBox(new Node[]{reqCodelbl, pane1, reqDatelbl});
                            header.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            Label origStoreCaption = new Label("Originated Store:");
                            origStoreCaption.setPrefWidth(90.0);
                            Label origStorelbl = new Label((String)req.fromStoreNameProperty().get());
                            origStoreCaption.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)11.0));
                            origStorelbl.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0));
                            HBox fromStore = new HBox(new Node[]{origStoreCaption, origStorelbl});
                            fromStore.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            fromStore.setSpacing(10.0);
                            Label targetStoreCaption = new Label("Target Store:");
                            targetStoreCaption.setPrefWidth(90.0);
                            Label targetStorelbl = new Label(req.getFromStoreName());
                            targetStoreCaption.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)11.0));
                            targetStorelbl.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0));
                            HBox targettore = new HBox(new Node[]{targetStoreCaption, targetStorelbl});
                            targettore.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            targettore.setSpacing(10.0);
                            Label origUserCaption = new Label("Originated User:");
                            origUserCaption.setPrefWidth(90.0);
                            Label origUserStorelbl = new Label(req.getoriginatedUser());
                            origUserCaption.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)11.0));
                            origUserStorelbl.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0));
                            HBox origuser = new HBox(new Node[]{origUserCaption, origUserStorelbl});
                            origuser.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            origuser.setSpacing(10.0);
                            Label statusCaption = new Label("Status:");
                            Label statuslbl = new Label();
                            statuslbl.textProperty().bindBidirectional((Property)req.statusProperty());
                            statuslbl.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
                            if (req.getStatus().equals(RequestStatus.CANCELLED.name())) {
                                statuslbl.setStyle("-fx-background-color:lightcoral;-fx-font-size: 12.0px;-fx-text-fill:white;");
                            } else if (req.getStatus().equals(RequestStatus.PENDING.name())) {
                                statuslbl.setStyle("-fx-background-color:#FC02DD;-fx-font-size: 12.0px;-fx-text-fill:white;");
                            } else if (req.getStatus().equals(RequestStatus.DECLINED.name())) {
                                statuslbl.setStyle("-fx-background-color:#FF0000;-fx-font-size: 12.0px;-fx-text-fill:white;");
                            } else if (req.getStatus().equals(RequestStatus.APPROVED.name())) {
                                statuslbl.setStyle("-fx-background-color:#34b962;-fx-font-size: 12.0px;-fx-text-fill:white;");
                                Tooltip tooltip2 = new Tooltip(req.getApprovingUser());
                                statuslbl.setTooltip(tooltip2);
                            } else if (req.getStatus().equals(RequestStatus.COMPLETED.name())) {
                                statuslbl.setStyle("-fx-background-color:#CCFFFF;-fx-font-size: 12.0px;");
                            } else if (req.getStatus().equals(RequestStatus.RELEASED.name())) {
                                statuslbl.setStyle("-fx-background-color:#0afff5;-fx-font-size: 12.0px;");
                            } else if (req.getStatus().equals(RequestStatus.ACCEPTED.name())) {
                                statuslbl.setStyle("-fx-background-color:#B5C460;-fx-font-size: 12.0px;");
                            } else if (req.getStatus().equals(RequestStatus.RETURNED.name())) {
                                statuslbl.setStyle("-fx-background-color:#59c5c5;-fx-font-size: 12.0px;-fx-text-fill:white;");
                            }
                            statusCaption.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)11.0));
                            statusCaption.setPrefWidth(90.0);
                            statuslbl.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0));
                            HBox status = new HBox(new Node[]{statusCaption, statuslbl});
                            status.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            status.setSpacing(10.0);
                            Label requestTypeCaption = new Label("Request Type:");
                            requestTypeCaption.setPrefWidth(90.0);
                            Label requestTypelbl = new Label(req.getRequestType());
                            requestTypeCaption.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)11.0));
                            requestTypelbl.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0));
                            HBox reqType = new HBox(new Node[]{requestTypeCaption, requestTypelbl});
                            reqType.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            reqType.setSpacing(10.0);
                            JFXButton printBtn = new JFXButton("Print");
                            printBtn.setButtonType(JFXButton.ButtonType.RAISED);
                            printBtn.setStyle("-fx-background-color: #843C98;");
                            printBtn.setOnAction(va -> {
                                if (req.getItems().isEmpty()) {
                                    TransferReleasePane.this.loadRequestItem(req);
                                }
                                Dialog dialog = new Dialog();
                                dialog.initStyle(StageStyle.DECORATED);
                                dialog.initOwner((Window)TransferReleasePane.this.santa.stage);
                                dialog.setTitle("Release Items(s) Stock Report");
                                dialog.setResizable(true);
                                try {
                                    dialog.getDialogPane().setContent((Node)new ReportPane(TransferReleasePane.this.santa, ReportType.ReleaseReportBin, req));
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                                Optional result = dialog.showAndWait();
                                if (!req.getIsPrinted().booleanValue() && result.isPresent()) {
                                    try {
                                        req.setIsPrinted(true);
                                        RequestDataList requestDataList = new RequestDataList(TransferReleasePane.this.da);
                                        requestDataList.getOriginalList().add((Object)req);
                                        req.update();
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(TransferPane.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            });
                            if (req.getStatus().equals(RequestStatus.RELEASED.name()) && (req.getToStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && req.getRequestType().equals(RequestType.Inbound.name()) || req.getFromStoreCode().equals(TransferReleasePane.this.currentUser.getParentCompany().getStoreCode()) && req.getRequestType().equals(RequestType.Outbound.name()))) {
                                printBtn.setVisible(true);
                            } else {
                                printBtn.setVisible(false);
                            }
                            JFXButton reloadBtn = new JFXButton("Reload");
                            reloadBtn.setButtonType(JFXButton.ButtonType.RAISED);
                            reloadBtn.setStyle("-fx-background-color: #00A86B;");
                            reloadBtn.setOnAction(va -> TransferReleasePane.this.loadSelectedRequest(req));
                            Pane pane2 = new Pane();
                            HBox.setHgrow((Node)pane2, (Priority)Priority.ALWAYS);
                            HBox bottom = new HBox(new Node[]{printBtn, pane2, reloadBtn});
                            bottom.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                            this.setTooltip(tooltip);
                            VBox vBox = new VBox(new Node[]{header, fromStore, targettore, origuser, status, reqType, bottom});
                            this.setGraphic((Node)vBox);
                        }
                    }
                };
                return cell;
            }
        });
        this.loadRequests();
        this.btnSearch.setOnAction(c -> {
            if (!this.searchBox.getText().isEmpty()) {
                Request request = new Request(this.da);
                request.setCode(this.searchBox.getText().toUpperCase());
                this.loadSelectedRequest(request);
            } else {
                this.requestDataList.getOriginalList().clear();
                this.loadRequests();
            }
        });
    }

    void Accept(final Request request) {
        request.setAcceptingUser(this.currentUser.getUserName());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            BufferedReader br;
                            Object url = TransferReleasePane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RRequest/AcceptRequestItems";
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("Code", (Object)request.getCode());
                            job.put("Reason", (Object)request.getReason());
                            job.put("Status", (Object)RequestStatus.RELEASED.name());
                            job.put("Reason", (Object)request.getReason());
                            job.put("StoreCode", (Object)request.getFromStoreCode());
                            job.put("DocEntry", request.getDocEntry());
                            job.put("DateAccepted", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("ReleaseComment", (Object)request.getReleaseComment());
                            job.put("ReleasingUser", (Object)request.getReleasingUser());
                            job.put("ApprovalComment", (Object)request.getApprovalComment());
                            job.put("AcceptComment", (Object)request.getAcceptedComment());
                            job.put("AcceptingUser", (Object)request.getAcceptingUser());
                            job.put("ApprovingUser", (Object)request.getApprovingUser());
                            job.put("RequestType", (Object)request.getRequestType());
                            job.put("OriginatingUser", (Object)request.getoriginatedUser());
                            job.put("DestinationStore", (Object)request.getToStoreCode());
                            job.put("LastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("RequestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(request.getRequestDate()));
                            JSONArray jab = new JSONArray();
                            for (RequestItem requestItem : request.getItems()) {
                                if (requestItem.hasAccepted) continue;
                                JSONObject joItem = new JSONObject();
                                joItem.put("RequestCode", (Object)request.getCode());
                                joItem.put("Quantity", requestItem.getQuantity());
                                joItem.put("DestinationStore", (Object)request.getToStoreCode());
                                joItem.put("ReleasedQty", requestItem.getReleasedQuantity());
                                joItem.put("ApprovedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("AcceptedQty", requestItem.editableAccptQtyProperty().get());
                                joItem.put("ItemCode", (Object)requestItem.getItemCode());
                                joItem.put("ItemName", (Object)requestItem.getItemName());
                                joItem.put("Code", (Object)requestItem.getCode());
                                JSONArray jsonSerials = new JSONArray();
                                for (RequestitemSerial serial : requestItem.getSerials()) {
                                    JSONObject jsSerial = new JSONObject();
                                    jsSerial.put("RequestItemCode", (Object)serial.getRequestItemCode());
                                    jsSerial.put("Serial", (Object)serial.getSerial());
                                    jsSerial.put("ItemCode", (Object)serial.getItemCode());
                                    jsSerial.put("IsAccepted", false);
                                    jsSerial.put("SysSerial", serial.getSysSerial());
                                    jsonSerials.put((Object)jsSerial);
                                }
                                joItem.put("Serials", (Object)jsonSerials);
                                jab.put((Object)joItem);
                            }
                            job.put("RequestItems", (Object)jab);
                            jSONArray.put((Object)job);
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            System.out.println(jSONArray.toString());
                            File f = Santa.writePayLoadToFileAll(jSONArray.toString());
                            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                            httpPost.setEntity(reqEntity);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONObject ra = new JSONObject(result);
                                Platform.runLater(() -> {
                                    try {
                                        if (ra.getString("Message").equals("Success")) {
                                            request.getItems().forEach(x -> x.setAcceptedQty(x.hasAccepted ? x.getAcceptedQty() : x.getAcceptedQty() + x.editableAccptQtyProperty().get()));
                                            if (request.getItems().stream().filter(v -> v.getAcceptedQty().intValue() != v.getReleasedQuantity()).findAny().orElse(null) == null) {
                                                request.setStatus(RequestStatus.COMPLETED.name());
                                            } else {
                                                request.setStatus(RequestStatus.ACCEPTED.name());
                                            }
                                            RequestDataList requestDataList1 = new RequestDataList(TransferReleasePane.this.da);
                                            requestDataList1.getOriginalList().add((Object)request);
                                            RequestItemDataList requestItemDataList1 = new RequestItemDataList(TransferReleasePane.this.da);
                                            requestItemDataList1.getOriginalList().addAll(request.getItems());
                                            requestDataList1.update();
                                            requestItemDataList1.update();
                                            TransferReleasePane.this.btnRelease.setVisible(false);
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Success, "Request " + request.getCode() + " Successfully Accepted", TransferReleasePane.this);
                                            TransferReleasePane.this.list.refresh();
                                            TransferReleasePane.this.list.getItems().set(TransferReleasePane.this.list.getSelectionModel().getSelectedIndex(), (Object)request);
                                        } else {
                                            JSONArray jSONArray1 = ra.getJSONArray("Responses");
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, jSONArray1.getJSONObject(0).getString("Message"), TransferReleasePane.this);
                                        }
                                    }
                                    catch (Exception ex) {
                                        TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                        TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                                    }
                                });
                            } else {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, fullError, TransferReleasePane.this);
                                    TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                                TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void loadSelectedRequest(final Request request) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = TransferReleasePane.this.santa.syncSetting.getBEURL() + "RRequest/GetRequstItemsLocations";
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("requestCode", request.getCode());
                            listParam.add(param1);
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                if (!result.equals("null\n")) {
                                    JSONObject jSONObject = new JSONObject(result);
                                    request.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                    request.setReason(jSONObject.isNull("Reason") ? "" : jSONObject.getString("Reason"));
                                    Platform.runLater(() -> {
                                        try {
                                            request.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        }
                                        catch (JSONException ex) {
                                            Logger.getLogger(TransferReleasePane.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    });
                                    request.setFromStoreCode(jSONObject.isNull("StoreCode") ? "" : jSONObject.getString("StoreCode"));
                                    request.setRequestType(jSONObject.isNull("RequestType") ? "" : jSONObject.getString("RequestType"));
                                    request.setOriginatedUser(jSONObject.isNull("OriginatingUser") ? "" : jSONObject.getString("OriginatingUser"));
                                    request.setDocEntry(jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry"));
                                    request.tempCode = jSONObject.isNull("StoreTempCode") ? "" : jSONObject.getString("StoreTempCode");
                                    request.isDeleted = jSONObject.isNull("Deleted") ? false : jSONObject.getBoolean("Deleted");
                                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                    Date dt = df.parse(jSONObject.getString("DateAccepted"));
                                    request.setDateAccept(new java.sql.Date(dt.getTime()));
                                    dt = df.parse(jSONObject.getString("LastUpdatedDate"));
                                    request.setLastUpdatedDate(new java.sql.Date(dt.getTime()));
                                    dt = df.parse(jSONObject.getString("ApprovalDate"));
                                    request.approvalDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                    dt = df.parse(jSONObject.getString("ReleaseDate"));
                                    request.releaseDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                    dt = df.parse(jSONObject.getString("RequestDate"));
                                    request.requestDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                    dt = df.parse(jSONObject.getString("ReturnDate"));
                                    request.returnDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                    request.setApprovingUser(jSONObject.isNull("ApprovingUser") ? "" : jSONObject.getString("ApprovingUser"));
                                    request.setReleasingUser(jSONObject.isNull("ReleasingUser") ? "" : jSONObject.getString("ReleasingUser"));
                                    request.setAcceptingUser(jSONObject.isNull("AcceptingUser") ? "" : jSONObject.getString("AcceptingUser"));
                                    request.setApprovalComment(jSONObject.isNull("ApprovalComment") ? "" : jSONObject.getString("ApprovalComment"));
                                    request.setReleaseComment(jSONObject.isNull("ReleaseComment") ? "" : jSONObject.getString("ReleaseComment"));
                                    request.setAcceptedComment(jSONObject.isNull("AcceptComment") ? "" : jSONObject.getString("AcceptComment"));
                                    request.setToStoreCode(jSONObject.isNull("DestinationStore") ? "" : jSONObject.getString("DestinationStore"));
                                    request.setReturningUser(jSONObject.isNull("ReturningUser") ? "" : jSONObject.getString("ReturningUser"));
                                    request.setReturningComment(jSONObject.isNull("ReturningComment") ? "" : jSONObject.getString("ReturningComment"));
                                    request.getItems().clear();
                                    JSONArray requestArray = jSONObject.getJSONArray("RequestItems");
                                    for (int j = 0; j < requestArray.length(); ++j) {
                                        JSONObject jsono = requestArray.getJSONObject(j);
                                        RequestItem requestItem = new RequestItem(TransferReleasePane.this.da);
                                        requestItem.setRequestCode(jsono.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        requestItem.setQuantity(jsono.isNull("Quantity") ? 0 : jsono.getInt("Quantity"));
                                        requestItem.setReason(jsono.isNull("Reason") ? "" : jsono.getString("Reason"));
                                        requestItem.setReleasedQuantity(jsono.isNull("ReleasedQty") ? 0 : jsono.getInt("ReleasedQty"));
                                        requestItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                        requestItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                        requestItem.setOriginatedStore(jsono.isNull("OriginatingStore") ? "" : jsono.getString("OriginatingStore"));
                                        requestItem.setToStoreInitQty(jsono.isNull("DestinationStoreQty") ? 0 : jsono.getInt("DestinationStoreQty"));
                                        requestItem.setApprovedQty(jsono.isNull("ApprovedQty") ? 0 : jsono.getInt("ApprovedQty"));
                                        requestItem.setAcceptedQty(jsono.isNull("AcceptedQty") ? 0 : jsono.getInt("AcceptedQty"));
                                        requestItem.setReturnedQty(jsono.isNull("ReturnedQty") ? 0 : jsono.getInt("ReturnedQty"));
                                        requestItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                        JSONArray jSONArray = jsono.getJSONArray("Serials");
                                        for (int k = 0; k < jSONArray.length(); ++k) {
                                            JSONObject jsono1 = jSONArray.getJSONObject(k);
                                            RequestitemSerial requestitemSerial = new RequestitemSerial(TransferReleasePane.this.da);
                                            requestitemSerial.setRequestItemCode(jsono1.isNull("RequestItemCode") ? "" : jsono1.getString("RequestItemCode"));
                                            requestitemSerial.setSerial(jsono1.isNull("Serial") ? "" : jsono1.getString("Serial"));
                                            requestitemSerial.setItemCode(jsono1.isNull("ItemCode") ? "" : jsono1.getString("ItemCode"));
                                            requestitemSerial.setIsAccepted(jsono1.isNull("IsAccepted") ? false : jsono1.getBoolean("IsAccepted"));
                                            requestitemSerial.setSysSerial(jsono1.isNull("SysSerial") ? 0 : jsono1.getInt("SysSerial"));
                                            requestItem.getSerials().add((Object)requestitemSerial);
                                        }
                                        JSONArray jSONArrayBin = jsono.getJSONArray("ItemLocations");
                                        for (int k = 0; k < jSONArrayBin.length(); ++k) {
                                            JSONObject jsono1 = jSONArrayBin.getJSONObject(k);
                                            RequestItemBin requestItemBin = new RequestItemBin(TransferReleasePane.this.da);
                                            requestItemBin.setCode(jsono1.isNull("BinLocation") ? "" : jsono1.getString("BinLocation"));
                                            requestItemBin.setItemCode(requestItem.getItemCode());
                                            requestItemBin.setRequestCode(request.getCode());
                                            requestItemBin.setAvailableQty(jsono1.isNull("AvailableQty") ? 0 : jsono1.getInt("AvailableQty"));
                                            requestItemBin.setBinbsEntry(jsono1.isNull("BinAbsEntry") ? 0 : jsono1.getInt("BinAbsEntry"));
                                            requestItemBin.setQuantity(jsono1.isNull("PickedQty") ? 0 : jsono1.getInt("PickedQty"));
                                            requestItem.getRequestItemBins().add((Object)requestItemBin);
                                        }
                                        request.getItems().add((Object)requestItem);
                                    }
                                    JSONArray jSONArrayDoc = jSONObject.getJSONArray("SapDocs");
                                    for (int k = 0; k < jSONArrayDoc.length(); ++k) {
                                        JSONObject jsono1 = jSONArrayDoc.getJSONObject(k);
                                        TransferSAPDockHistory transferDocHistory = new TransferSAPDockHistory();
                                        transferDocHistory.setRequestCode(jsono1.isNull("RequestCode") ? 0 : jsono1.getInt("RequestCode"));
                                        transferDocHistory.setDocEntry(jsono1.isNull("DocEntry") ? 0 : jsono1.getInt("DocEntry"));
                                        transferDocHistory.setRequestAction(jsono1.isNull("RequestStatus") ? "" : jsono1.getString("RequestStatus"));
                                        dt = df.parse(jsono1.getString("CreatedDate"));
                                        request.returnDateProperty().set((Object)new Date(dt.getTime()));
                                        transferDocHistory.setCreatedDate(new Date(dt.getTime()));
                                        transferDocHistory.setFromDescription(jsono1.isNull("FromDescription") ? "" : jsono1.getString("FromDescription"));
                                        transferDocHistory.setToDescription(jsono1.isNull("ToDescription") ? "" : jsono1.getString("ToDescription"));
                                        transferDocHistory.setUser(jsono1.isNull("StoreUser") ? "" : jsono1.getString("StoreUser"));
                                        if (transferDocHistory.getRequestAction().equals(RequestStatus.RELEASED.name())) {
                                            request.setDocEntry(transferDocHistory.getDocEntry());
                                        }
                                        request.getDocHistories().add((Object)transferDocHistory);
                                    }
                                    Platform.runLater(() -> {
                                        try {
                                            RequestDataList requestDataList1 = new RequestDataList(TransferReleasePane.this.da);
                                            requestDataList1.selectAll("Select * From Request where Code=? or Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, request.tempCode), new ParameterValue("Code", JDBCType.VARCHAR, request.getCode())});
                                            if (requestDataList1.getOriginalList().size() > 0) {
                                                if (request.isDeleted) {
                                                    request.setState(ObjectState.Removed);
                                                } else {
                                                    try {
                                                        StockItemList.deleteAll("Delete From Request where Code=? or Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, request.tempCode), new ParameterValue("Code", JDBCType.VARCHAR, request.getCode())}, TransferReleasePane.this.da);
                                                    }
                                                    catch (Exception ex) {
                                                        Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                                                    }
                                                }
                                            }
                                            request.setState(ObjectState.New);
                                            RequestDataList requestDataList = new RequestDataList(TransferReleasePane.this.da);
                                            requestDataList.getOriginalList().add((Object)request);
                                            requestDataList.update();
                                            RequestItemDataList requestItemDataListt = new RequestItemDataList(TransferReleasePane.this.da);
                                            RequestitemSerialDataList requestitemSerialDataList = new RequestitemSerialDataList(TransferReleasePane.this.da);
                                            RequestItemBinDataList requestItemBinDataList = new RequestItemBinDataList(TransferReleasePane.this.da);
                                            if (!request.isDeleted) {
                                                requestItemDataListt.getOriginalList().addAll(request.getItems());
                                            }
                                            requestItemDataListt.getOriginalList().forEach(v -> {
                                                requestitemSerialDataList.getOriginalList().addAll(v.getSerials());
                                                if (!request.getStatus().equals(RequestStatus.APPROVED.name())) {
                                                    requestItemBinDataList.getOriginalList().addAll(v.getRequestItemBins());
                                                }
                                            });
                                            requestItemDataListt.update();
                                            requestItemBinDataList.update();
                                            requestitemSerialDataList.getOriginalList().forEach(v -> {
                                                RequestitemSerialDataList requestDataList11 = new RequestitemSerialDataList(TransferReleasePane.this.da);
                                                requestDataList11.selectAll("Select * From RequestitemSerial where Serial=? and RequestItemCode=?", new ParameterValue[]{new ParameterValue("Serial", JDBCType.VARCHAR, v.getSerial()), new ParameterValue("RequestItemCode", JDBCType.VARCHAR, v.getRequestItemCode())});
                                                if (requestDataList11.getOriginalList().size() == 1) {
                                                    v.setState(ObjectState.Changed);
                                                }
                                            });
                                            requestitemSerialDataList.update();
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.itemContainer.getChildren().clear();
                                            if (TransferReleasePane.this.list.getItems().stream().filter(x -> x.getCode().equals(request.getCode())).findAny().orElse(null) == null) {
                                                TransferReleasePane.this.list.getItems().add(0, (Object)request);
                                            }
                                            if (TransferReleasePane.this.list.getSelectionModel().getSelectedItem() != null) {
                                                request.getItems().forEach(x -> TransferReleasePane.this.itemContainer.getChildren().add((Object)new TransferReleaseItemCard(TransferReleasePane.this, (RequestItem)x, !request.getStatus().equals(RequestStatus.APPROVED.name()))));
                                            }
                                            TransferReleasePane.this.list.refresh();
                                            request.Loaded = true;
                                            if (TransferReleasePane.this.list.getSelectionModel().getSelectedIndex() > -1) {
                                                TransferReleasePane.this.list.getItems().set(TransferReleasePane.this.list.getSelectionModel().getSelectedIndex(), (Object)request);
                                            }
                                        }
                                        catch (Exception ex) {
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                                        }
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        try {
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, "Request Not Found", TransferReleasePane.this);
                                        }
                                        catch (Exception ex) {
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                                        }
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                    TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, fullError, TransferReleasePane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), TransferReleasePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    boolean isAcceptedQtyGreaterThanReleaseQty(Request req) {
        return req.getItems().stream().filter(c -> c.editableAccptQtyProperty().get() + c.getAcceptedQty() > c.getReleasedQuantity() && !c.hasAccepted).count() > 0L;
    }

    public List<Request> searchResult(String searchString) {
        LinkedList<Request> searchResult = new LinkedList<Request>();
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<Request>();
        }
        try {
            List result = RequestDataList.searchRequest(searchString, this.da).stream().filter(e -> e.getCode().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
            searchResult.addAll((Collection<Request>)(result.isEmpty() ? this.requestItemDataList.getOriginalList() : result));
            return searchResult.subList(0, searchResult.size());
        }
        catch (SQLException ex) {
            Logger.getLogger(TransferReleasePane.class.getName()).log(Level.SEVERE, null, ex);
            return searchResult;
        }
    }

    public void populateResult(Request data) {
        ObservableList lsit = FXCollections.observableArrayList();
        lsit.add((Object)data);
        this.list.getItems().clear();
        lsit.forEach(val -> this.list.setItems(lsit));
        this.list.refresh();
    }

    void reloadRequest(final Request request1) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = TransferReleasePane.this.santa.syncSetting.getBEURL() + "RRequest/GetRequestsRegular";
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("storeCode", TransferReleasePane.this.currentUser.getParentCompany().getStoreCode());
                            listParam.add(param1);
                            BasicNameValuePair param2 = new BasicNameValuePair("searchString", request1.getCode());
                            listParam.add(param2);
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                if (ra.length() > 0) {
                                    TransferReleasePane.this.requestDataList.getOriginalList().clear();
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        Request request = new Request(TransferReleasePane.this.da);
                                        request.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        request.setReason(jSONObject.isNull("Reason") ? "" : jSONObject.getString("Reason"));
                                        request.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        request.setFromStoreCode(jSONObject.isNull("StoreCode") ? "" : jSONObject.getString("StoreCode"));
                                        request.setRequestType(jSONObject.isNull("RequestType") ? "" : jSONObject.getString("RequestType"));
                                        request.setOriginatedUser(jSONObject.isNull("OriginatingUser") ? "" : jSONObject.getString("OriginatingUser"));
                                        request.setDocEntry(jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry"));
                                        request.tempCode = jSONObject.isNull("StoreTempCode") ? "" : jSONObject.getString("StoreTempCode");
                                        request.isDeleted = jSONObject.isNull("Deleted") ? false : jSONObject.getBoolean("Deleted");
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        Date dt = df.parse(jSONObject.getString("DateAccepted"));
                                        request.setDateAccept(new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("LastUpdatedDate"));
                                        request.setLastUpdatedDate(new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ApprovalDate"));
                                        request.approvalDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ReleaseDate"));
                                        request.releaseDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("RequestDate"));
                                        request.requestDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ReturnDate"));
                                        request.returnDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                        request.setApprovingUser(jSONObject.isNull("ApprovingUser") ? "" : jSONObject.getString("ApprovingUser"));
                                        request.setReleasingUser(jSONObject.isNull("ReleasingUser") ? "" : jSONObject.getString("ReleasingUser"));
                                        request.setAcceptingUser(jSONObject.isNull("AcceptingUser") ? "" : jSONObject.getString("AcceptingUser"));
                                        request.setApprovalComment(jSONObject.isNull("ApprovalComment") ? "" : jSONObject.getString("ApprovalComment"));
                                        request.setReleaseComment(jSONObject.isNull("ReleaseComment") ? "" : jSONObject.getString("ReleaseComment"));
                                        request.setAcceptedComment(jSONObject.isNull("AcceptComment") ? "" : jSONObject.getString("AcceptComment"));
                                        request.setToStoreCode(jSONObject.isNull("DestinationStore") ? "" : jSONObject.getString("DestinationStore"));
                                        request.setReturningUser(jSONObject.isNull("ReturningUser") ? "" : jSONObject.getString("ReturningUser"));
                                        request.setReturningComment(jSONObject.isNull("ReturningComment") ? "" : jSONObject.getString("ReturningComment"));
                                        JSONArray requestArray = jSONObject.getJSONArray("RequestItems");
                                        for (int j = 0; j < requestArray.length(); ++j) {
                                            JSONObject jsono = requestArray.getJSONObject(j);
                                            RequestItem requestItem = new RequestItem(TransferReleasePane.this.da);
                                            requestItem.setRequestCode(jsono.isNull("Code") ? "" : jSONObject.getString("Code"));
                                            requestItem.setQuantity(jsono.isNull("Quantity") ? 0 : jsono.getInt("Quantity"));
                                            requestItem.setReason(jsono.isNull("Reason") ? "" : jsono.getString("Reason"));
                                            requestItem.setReleasedQuantity(jsono.isNull("ReleasedQty") ? 0 : jsono.getInt("ReleasedQty"));
                                            requestItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            requestItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            requestItem.setOriginatedStore(jsono.isNull("OriginatingStore") ? "" : jsono.getString("OriginatingStore"));
                                            requestItem.setToStoreInitQty(jsono.isNull("DestinationStoreQty") ? 0 : jsono.getInt("DestinationStoreQty"));
                                            requestItem.setApprovedQty(jsono.isNull("ApprovedQty") ? 0 : jsono.getInt("ApprovedQty"));
                                            requestItem.setAcceptedQty(jsono.isNull("AcceptedQty") ? 0 : jsono.getInt("AcceptedQty"));
                                            requestItem.setReturnedQty(jsono.isNull("ReturnedQty") ? 0 : jsono.getInt("ReturnedQty"));
                                            requestItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            JSONArray jSONArray = jsono.getJSONArray("Serials");
                                            for (int k = 0; k < jSONArray.length(); ++k) {
                                                JSONObject jsono1 = jSONArray.getJSONObject(k);
                                                RequestitemSerial requestitemSerial = new RequestitemSerial(TransferReleasePane.this.da);
                                                requestitemSerial.setRequestItemCode(jsono1.isNull("RequestItemCode") ? "" : jsono1.getString("RequestItemCode"));
                                                requestitemSerial.setSerial(jsono1.isNull("Serial") ? "" : jsono1.getString("Serial"));
                                                requestitemSerial.setItemCode(jsono1.isNull("ItemCode") ? "" : jsono1.getString("ItemCode"));
                                                requestitemSerial.setIsAccepted(jsono1.isNull("IsAccepted") ? false : jsono1.getBoolean("IsAccepted"));
                                                requestitemSerial.setSysSerial(jsono1.isNull("SysSerial") ? 0 : jsono1.getInt("SysSerial"));
                                                requestitemSerial.setRequestCode(request.getCode());
                                                requestItem.getSerials().add((Object)requestitemSerial);
                                            }
                                            request.getItems().add((Object)requestItem);
                                        }
                                        JSONArray jSONArrayDoc = jSONObject.getJSONArray("SapDocs");
                                        for (int k = 0; k < jSONArrayDoc.length(); ++k) {
                                            JSONObject jsono1 = jSONArrayDoc.getJSONObject(k);
                                            TransferSAPDockHistory transferDocHistory = new TransferSAPDockHistory();
                                            transferDocHistory.setRequestCode(jsono1.isNull("RequestCode") ? 0 : jsono1.getInt("RequestCode"));
                                            transferDocHistory.setDocEntry(jsono1.isNull("DocEntry") ? 0 : jsono1.getInt("DocEntry"));
                                            transferDocHistory.setRequestAction(jsono1.isNull("RequestStatus") ? "" : jsono1.getString("RequestStatus"));
                                            dt = df.parse(jsono1.getString("CreatedDate"));
                                            request.returnDateProperty().set((Object)new Date(dt.getTime()));
                                            transferDocHistory.setCreatedDate(new Date(dt.getTime()));
                                            transferDocHistory.setFromDescription(jsono1.isNull("FromDescription") ? "" : jsono1.getString("FromDescription"));
                                            transferDocHistory.setToDescription(jsono1.isNull("ToDescription") ? "" : jsono1.getString("ToDescription"));
                                            transferDocHistory.setUser(jsono1.isNull("StoreUser") ? "" : jsono1.getString("StoreUser"));
                                            if (transferDocHistory.getRequestAction().equals(RequestStatus.RELEASED.name())) {
                                                request.setDocEntry(transferDocHistory.getDocEntry());
                                            }
                                            request.getDocHistories().add((Object)transferDocHistory);
                                        }
                                        TransferReleasePane.this.requestDataList.getOriginalList().add((Object)request);
                                    }
                                    TransferReleasePane.this.requestDataList.getOriginalList().forEach(t -> {
                                        RequestDataList requestDataList1 = new RequestDataList(TransferReleasePane.this.da);
                                        requestDataList1.selectAll("Select * From Request where Code=? or Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, t.tempCode), new ParameterValue("Code", JDBCType.VARCHAR, t.getCode())});
                                        if (requestDataList1.getOriginalList().size() > 0) {
                                            if (t.isDeleted) {
                                                t.setState(ObjectState.Removed);
                                            } else {
                                                try {
                                                    StockItemList.deleteAll("Delete From Request where Code=? or Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, t.tempCode), new ParameterValue("Code", JDBCType.VARCHAR, t.getCode())}, TransferReleasePane.this.da);
                                                }
                                                catch (Exception ex) {
                                                    Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            }
                                        }
                                    });
                                    int count = TransferReleasePane.this.requestDataList.getOriginalList().size();
                                    TransferReleasePane.this.requestDataList.update();
                                    RequestItemDataList requestItemDataListt = new RequestItemDataList(TransferReleasePane.this.da);
                                    RequestitemSerialDataList requestitemSerialDataList = new RequestitemSerialDataList(TransferReleasePane.this.da);
                                    TransferReleasePane.this.requestDataList.getOriginalList().forEach(v -> {
                                        if (!v.isDeleted) {
                                            requestItemDataListt.getOriginalList().addAll(v.getItems());
                                        }
                                    });
                                    requestItemDataListt.getOriginalList().forEach(v -> requestitemSerialDataList.getOriginalList().addAll(v.getSerials()));
                                    requestItemDataListt.update();
                                    requestitemSerialDataList.getOriginalList().forEach(v -> {
                                        RequestitemSerialDataList requestDataList1 = new RequestitemSerialDataList(TransferReleasePane.this.da);
                                        requestDataList1.selectAll("Select * From RequestitemSerial where Serial=? and RequestItemCode=?", new ParameterValue[]{new ParameterValue("Serial", JDBCType.VARCHAR, v.getSerial()), new ParameterValue("RequestItemCode", JDBCType.VARCHAR, v.getRequestItemCode())});
                                        if (requestDataList1.getOriginalList().size() == 1) {
                                            v.setState(ObjectState.Changed);
                                        }
                                    });
                                    requestitemSerialDataList.update();
                                    SyncSettingDataList sdl = new SyncSettingDataList(TransferReleasePane.this.da);
                                    TransferReleasePane.this.santa.syncSetting.setTransferLastDateRead(new Timestamp(new Date().getTime()));
                                    sdl.getOriginalList().add((Object)TransferReleasePane.this.santa.syncSetting);
                                    sdl.update();
                                    Platform.runLater(() -> {
                                        TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                        TransferReleasePane.this.mainPage.showNotification(NotificationType.Success, "Request reloaded successfully", TransferReleasePane.this);
                                        TransferReleasePane.this.requestDataList.getOriginalList().clear();
                                        TransferReleasePane.this.loadRequests();
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                        TransferReleasePane.this.mainPage.showNotification(NotificationType.Information, "No Request Found", TransferReleasePane.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                    TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, fullError, TransferReleasePane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), TransferReleasePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void search() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = TransferReleasePane.this.santa.syncSetting.getBEURL() + "RRequest/GetRequestsRegular";
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("storeCode", TransferReleasePane.this.currentUser.getParentCompany().getStoreCode());
                            listParam.add(param1);
                            BasicNameValuePair param2 = new BasicNameValuePair("searchString", TransferReleasePane.this.searchBox.getText());
                            listParam.add(param2);
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                if (ra.length() > 0) {
                                    TransferReleasePane.this.requestDataList.getOriginalList().clear();
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        Request request = new Request(TransferReleasePane.this.da);
                                        request.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        request.setReason(jSONObject.isNull("Reason") ? "" : jSONObject.getString("Reason"));
                                        request.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        request.setFromStoreCode(jSONObject.isNull("StoreCode") ? "" : jSONObject.getString("StoreCode"));
                                        request.setRequestType(jSONObject.isNull("RequestType") ? "" : jSONObject.getString("RequestType"));
                                        request.setOriginatedUser(jSONObject.isNull("OriginatingUser") ? "" : jSONObject.getString("OriginatingUser"));
                                        request.setDocEntry(jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry"));
                                        request.tempCode = jSONObject.isNull("StoreTempCode") ? "" : jSONObject.getString("StoreTempCode");
                                        request.isDeleted = jSONObject.isNull("Deleted") ? false : jSONObject.getBoolean("Deleted");
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        Date dt = df.parse(jSONObject.getString("DateAccepted"));
                                        request.setDateAccept(new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("LastUpdatedDate"));
                                        request.setLastUpdatedDate(new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ApprovalDate"));
                                        request.approvalDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ReleaseDate"));
                                        request.releaseDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("RequestDate"));
                                        request.requestDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("ReturnDate"));
                                        request.returnDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                        request.setApprovingUser(jSONObject.isNull("ApprovingUser") ? "" : jSONObject.getString("ApprovingUser"));
                                        request.setReleasingUser(jSONObject.isNull("ReleasingUser") ? "" : jSONObject.getString("ReleasingUser"));
                                        request.setAcceptingUser(jSONObject.isNull("AcceptingUser") ? "" : jSONObject.getString("AcceptingUser"));
                                        request.setApprovalComment(jSONObject.isNull("ApprovalComment") ? "" : jSONObject.getString("ApprovalComment"));
                                        request.setReleaseComment(jSONObject.isNull("ReleaseComment") ? "" : jSONObject.getString("ReleaseComment"));
                                        request.setAcceptedComment(jSONObject.isNull("AcceptComment") ? "" : jSONObject.getString("AcceptComment"));
                                        request.setToStoreCode(jSONObject.isNull("DestinationStore") ? "" : jSONObject.getString("DestinationStore"));
                                        request.setReturningUser(jSONObject.isNull("ReturningUser") ? "" : jSONObject.getString("ReturningUser"));
                                        request.setReturningComment(jSONObject.isNull("ReturningComment") ? "" : jSONObject.getString("ReturningComment"));
                                        JSONArray requestArray = jSONObject.getJSONArray("RequestItems");
                                        for (int j = 0; j < requestArray.length(); ++j) {
                                            JSONObject jsono = requestArray.getJSONObject(j);
                                            RequestItem requestItem = new RequestItem(TransferReleasePane.this.da);
                                            requestItem.setRequestCode(jsono.isNull("Code") ? "" : jSONObject.getString("Code"));
                                            requestItem.setQuantity(jsono.isNull("Quantity") ? 0 : jsono.getInt("Quantity"));
                                            requestItem.setReason(jsono.isNull("Reason") ? "" : jsono.getString("Reason"));
                                            requestItem.setReleasedQuantity(jsono.isNull("ReleasedQty") ? 0 : jsono.getInt("ReleasedQty"));
                                            requestItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            requestItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            requestItem.setOriginatedStore(jsono.isNull("OriginatingStore") ? "" : jsono.getString("OriginatingStore"));
                                            requestItem.setToStoreInitQty(jsono.isNull("DestinationStoreQty") ? 0 : jsono.getInt("DestinationStoreQty"));
                                            requestItem.setApprovedQty(jsono.isNull("ApprovedQty") ? 0 : jsono.getInt("ApprovedQty"));
                                            requestItem.setAcceptedQty(jsono.isNull("AcceptedQty") ? 0 : jsono.getInt("AcceptedQty"));
                                            requestItem.setReturnedQty(jsono.isNull("ReturnedQty") ? 0 : jsono.getInt("ReturnedQty"));
                                            requestItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            JSONArray jSONArray = jsono.getJSONArray("Serials");
                                            for (int k = 0; k < jSONArray.length(); ++k) {
                                                JSONObject jsono1 = jSONArray.getJSONObject(k);
                                                RequestitemSerial requestitemSerial = new RequestitemSerial(TransferReleasePane.this.da);
                                                requestitemSerial.setRequestItemCode(jsono1.isNull("RequestItemCode") ? "" : jsono1.getString("RequestItemCode"));
                                                requestitemSerial.setSerial(jsono1.isNull("Serial") ? "" : jsono1.getString("Serial"));
                                                requestitemSerial.setItemCode(jsono1.isNull("ItemCode") ? "" : jsono1.getString("ItemCode"));
                                                requestitemSerial.setIsAccepted(jsono1.isNull("IsAccepted") ? false : jsono1.getBoolean("IsAccepted"));
                                                requestitemSerial.setSysSerial(jsono1.isNull("SysSerial") ? 0 : jsono1.getInt("SysSerial"));
                                                requestItem.getSerials().add((Object)requestitemSerial);
                                            }
                                            request.getItems().add((Object)requestItem);
                                        }
                                        JSONArray jSONArrayDoc = jSONObject.getJSONArray("SapDocs");
                                        for (int k = 0; k < jSONArrayDoc.length(); ++k) {
                                            JSONObject jsono1 = jSONArrayDoc.getJSONObject(k);
                                            TransferSAPDockHistory transferDocHistory = new TransferSAPDockHistory();
                                            transferDocHistory.setRequestCode(jsono1.isNull("RequestCode") ? 0 : jsono1.getInt("RequestCode"));
                                            transferDocHistory.setDocEntry(jsono1.isNull("DocEntry") ? 0 : jsono1.getInt("DocEntry"));
                                            transferDocHistory.setRequestAction(jsono1.isNull("RequestStatus") ? "" : jsono1.getString("RequestStatus"));
                                            dt = df.parse(jsono1.getString("CreatedDate"));
                                            request.returnDateProperty().set((Object)new Date(dt.getTime()));
                                            transferDocHistory.setCreatedDate(new Date(dt.getTime()));
                                            transferDocHistory.setFromDescription(jsono1.isNull("FromDescription") ? "" : jsono1.getString("FromDescription"));
                                            transferDocHistory.setToDescription(jsono1.isNull("ToDescription") ? "" : jsono1.getString("ToDescription"));
                                            transferDocHistory.setUser(jsono1.isNull("StoreUser") ? "" : jsono1.getString("StoreUser"));
                                            if (transferDocHistory.getRequestAction().equals(RequestStatus.RELEASED.name())) {
                                                request.setDocEntry(transferDocHistory.getDocEntry());
                                            }
                                            request.getDocHistories().add((Object)transferDocHistory);
                                        }
                                        TransferReleasePane.this.requestDataList.getOriginalList().add((Object)request);
                                    }
                                    TransferReleasePane.this.requestDataList.getOriginalList().forEach(t -> {
                                        RequestDataList requestDataList1 = new RequestDataList(TransferReleasePane.this.da);
                                        requestDataList1.selectAll("Select * From Request where Code=? or Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, t.tempCode), new ParameterValue("Code", JDBCType.VARCHAR, t.getCode())});
                                        if (requestDataList1.getOriginalList().size() > 0) {
                                            if (t.isDeleted) {
                                                t.setState(ObjectState.Removed);
                                            } else {
                                                try {
                                                    StockItemList.deleteAll("Delete From Request where Code=? or Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, t.tempCode), new ParameterValue("Code", JDBCType.VARCHAR, t.getCode())}, TransferReleasePane.this.da);
                                                }
                                                catch (Exception ex) {
                                                    Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            }
                                        }
                                    });
                                    Platform.runLater(() -> {
                                        try {
                                            int count = TransferReleasePane.this.requestDataList.getOriginalList().size();
                                            TransferReleasePane.this.requestDataList.update();
                                            RequestItemDataList requestItemDataListt = new RequestItemDataList(TransferReleasePane.this.da);
                                            RequestitemSerialDataList requestitemSerialDataList = new RequestitemSerialDataList(TransferReleasePane.this.da);
                                            TransferReleasePane.this.requestDataList.getOriginalList().forEach(v -> {
                                                if (!v.isDeleted) {
                                                    requestItemDataListt.getOriginalList().addAll(v.getItems());
                                                }
                                            });
                                            requestItemDataListt.getOriginalList().forEach(v -> requestitemSerialDataList.getOriginalList().addAll(v.getSerials()));
                                            requestItemDataListt.update();
                                            requestitemSerialDataList.getOriginalList().forEach(v -> {
                                                RequestitemSerialDataList requestDataList1 = new RequestitemSerialDataList(TransferReleasePane.this.da);
                                                requestDataList1.selectAll("Select * From RequestitemSerial where Serial=? and RequestItemCode=?", new ParameterValue[]{new ParameterValue("Serial", JDBCType.VARCHAR, v.getSerial()), new ParameterValue("RequestItemCode", JDBCType.VARCHAR, v.getRequestItemCode())});
                                                if (requestDataList1.getOriginalList().size() == 1) {
                                                    v.setState(ObjectState.Changed);
                                                }
                                            });
                                            requestitemSerialDataList.update();
                                            SyncSettingDataList sdl = new SyncSettingDataList(TransferReleasePane.this.da);
                                            TransferReleasePane.this.santa.syncSetting.setTransferLastDateRead(new Timestamp(new Date().getTime()));
                                            sdl.getOriginalList().add((Object)TransferReleasePane.this.santa.syncSetting);
                                            sdl.update();
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.searchRequest = TransferReleasePane.this.requestDataList.getOriginalList().isEmpty() ? "" : ((Request)TransferReleasePane.this.requestDataList.getOriginalList().get(0)).getCode();
                                            TransferReleasePane.this.loadRequests();
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Success, "Request reloaded successfully", TransferReleasePane.this);
                                        }
                                        catch (Exception ex) {
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                                        }
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                        TransferReleasePane.this.mainPage.showNotification(NotificationType.Information, "No Request Found", TransferReleasePane.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                    TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, fullError, TransferReleasePane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), TransferReleasePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void Release(final Request request) {
        request.setReleasingUser(this.currentUser.getUserName());
        request.setReleaseDate(new Date());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String output;
                            BufferedReader br;
                            Object url = TransferReleasePane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RRequest/ReleaseRequestItems";
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("Code", (Object)request.getCode());
                            job.put("Reason", (Object)request.getReason());
                            job.put("Status", (Object)RequestStatus.APPROVED.name());
                            job.put("Reason", (Object)request.getReason());
                            job.put("StoreCode", (Object)request.getFromStoreCode());
                            job.put("DocEntry", request.getDocEntry());
                            job.put("ReleaseDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("ReleaseComment", (Object)request.getReleaseComment());
                            job.put("ReleasingUser", (Object)request.getReleasingUser());
                            job.put("ApprovalComment", (Object)request.getApprovalComment());
                            job.put("AcceptComment", (Object)request.getAcceptedComment());
                            job.put("AcceptingUser", (Object)request.getAcceptingUser());
                            job.put("ApprovingUser", (Object)request.getApprovingUser());
                            job.put("RequestType", (Object)request.getRequestType());
                            job.put("OriginatingUser", (Object)request.getoriginatedUser());
                            job.put("DestinationStore", (Object)request.getToStoreCode());
                            job.put("LastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("RequestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(request.getRequestDate()));
                            JSONArray jab = new JSONArray();
                            for (RequestItem requestItem : request.getItems()) {
                                Object serial2;
                                JSONObject joItem = new JSONObject();
                                joItem.put("RequestCode", (Object)request.getCode());
                                joItem.put("Quantity", requestItem.getQuantity());
                                joItem.put("DestinationStore", (Object)request.getToStoreCode());
                                joItem.put("ReleasedQty", requestItem.getReleasedQuantity());
                                joItem.put("ApprovedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("ItemCode", (Object)requestItem.getItemCode());
                                joItem.put("ItemName", (Object)requestItem.getItemName());
                                joItem.put("Code", (Object)requestItem.getCode());
                                JSONArray jsonSerials = new JSONArray();
                                for (Object serial2 : requestItem.getSerials()) {
                                    JSONObject jsSerial = new JSONObject();
                                    jsSerial.put("RequestItemCode", (Object)((RequestitemSerial)serial2).getRequestItemCode());
                                    jsSerial.put("Serial", (Object)((RequestitemSerial)serial2).getSerial());
                                    jsSerial.put("ItemCode", (Object)((RequestitemSerial)serial2).getItemCode());
                                    jsSerial.put("IsAccepted", false);
                                    jsSerial.put("SysSerial", ((RequestitemSerial)serial2).getSysSerial());
                                    jsonSerials.put((Object)jsSerial);
                                }
                                joItem.put("Serials", (Object)jsonSerials);
                                JSONArray jsonBins = new JSONArray();
                                serial2 = requestItem.getRequestItemBins().iterator();
                                while (serial2.hasNext()) {
                                    RequestItemBin bin = (RequestItemBin)serial2.next();
                                    if (bin.getQuantity() <= 0) continue;
                                    JSONObject jsBin = new JSONObject();
                                    jsBin.put("BinLocation", (Object)bin.getCode());
                                    jsBin.put("RequestItemCode", (Object)bin.getItemCode());
                                    jsBin.put("AvailableQty", bin.getAvailableQty());
                                    jsBin.put("PickedQty", bin.getQuantity());
                                    jsBin.put("BinAbsEntry", bin.getBinbsEntry());
                                    jsonBins.put((Object)jsBin);
                                }
                                joItem.put("ItemLocations", (Object)jsonBins);
                                jab.put((Object)joItem);
                            }
                            job.put("RequestItems", (Object)jab);
                            jSONArray.put((Object)job);
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            File f = Santa.writePayLoadToFileAll(jSONArray.toString());
                            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                            httpPost.setEntity(reqEntity);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONObject ra = new JSONObject(result);
                                Platform.runLater(() -> {
                                    try {
                                        if (ra.getString("Message").equals("Success")) {
                                            request.setStatus(RequestStatus.RELEASED.name());
                                            JSONArray jSONArray1 = ra.getJSONArray("Responses");
                                            request.setDocEntry(jSONArray1.getJSONObject(0).getInt("JournalNo"));
                                            RequestDataList requestDataList1 = new RequestDataList(TransferReleasePane.this.da);
                                            requestDataList1.getOriginalList().add((Object)request);
                                            requestDataList1.update();
                                            RequestItemDataList requestItemDataList1 = new RequestItemDataList(TransferReleasePane.this.da);
                                            requestItemDataList1.getOriginalList().addAll(request.getItems());
                                            RequestItemBinDataList requestItemBinDataList = new RequestItemBinDataList(TransferReleasePane.this.da);
                                            request.getItems().forEach(val -> requestItemBinDataList.getOriginalList().addAll((Collection)val.getRequestItemBins().stream().filter(c -> c.getQuantity() > 0).collect(Collectors.toList())));
                                            requestItemDataList1.update();
                                            requestItemBinDataList.update();
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Success, "Request " + request.getCode() + " Successfully Released", TransferReleasePane.this);
                                            TransferReleasePane.this.list.refresh();
                                            TransferReleasePane.this.list.getItems().set(TransferReleasePane.this.list.getSelectionModel().getSelectedIndex(), (Object)request);
                                        } else {
                                            JSONArray jSONArray1 = ra.getJSONArray("Responses");
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, jSONArray1.getJSONObject(0).getString("Message"), TransferReleasePane.this);
                                        }
                                    }
                                    catch (Exception ex) {
                                        TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                        TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                    }
                                });
                            } else {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                    TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, fullError, TransferReleasePane.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                            Platform.runLater(() -> {
                                TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void ReturnAccept(final Request request) {
        request.setReturningUser(this.currentUser.getUserName());
        request.setReturnDate(new Date());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            BufferedReader br;
                            Object url = TransferReleasePane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RRequest/AcceptRequestItemsInwards";
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("Code", (Object)request.getCode());
                            job.put("Reason", (Object)request.getReason());
                            job.put("Status", (Object)RequestStatus.RELEASED);
                            job.put("Reason", (Object)request.getReason());
                            job.put("StoreCode", (Object)request.getFromStoreCode());
                            job.put("ReturningUser", (Object)request.getReturningUser());
                            job.put("ReturningComment", (Object)request.getReturningComment());
                            job.put("ReturnDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("DocEntry", request.getDocEntry());
                            job.put("DateAccepted", (Object)request.getDateAccept());
                            job.put("ReleaseComment", (Object)request.getReleaseComment());
                            job.put("ReleasingUser", (Object)request.getReleasingUser());
                            job.put("ApprovalComment", (Object)request.getApprovalComment());
                            job.put("AcceptComment", (Object)request.getAcceptedComment());
                            job.put("AcceptingUser", (Object)request.getAcceptingUser());
                            job.put("ApprovingUser", (Object)request.getApprovingUser());
                            job.put("RequestType", (Object)request.getRequestType());
                            job.put("OriginatingUser", (Object)request.getoriginatedUser());
                            job.put("DestinationStore", (Object)request.getToStoreCode());
                            job.put("LastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("RequestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(request.getRequestDate()));
                            JSONArray jab = new JSONArray();
                            if (request.getItems().isEmpty()) {
                                TransferReleasePane.this.loadRequestItem(request);
                            }
                            for (RequestItem requestItem : request.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("RequestCode", (Object)request.getCode());
                                joItem.put("Quantity", requestItem.getQuantity());
                                joItem.put("DestinationStore", (Object)request.getToStoreCode());
                                joItem.put("ReleasedQty", requestItem.getReleasedQuantity());
                                joItem.put("ApprovedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("AcceptedQty", (Object)requestItem.getAcceptedQty());
                                if (requestItem.getReturnedQty() == 0) continue;
                                joItem.put("ReturnedQty", (Object)requestItem.getReturnedQty());
                                joItem.put("ItemCode", (Object)requestItem.getItemCode());
                                joItem.put("ItemName", (Object)requestItem.getItemName());
                                joItem.put("Code", (Object)requestItem.getCode());
                                JSONArray jsonSerials = new JSONArray();
                                for (RequestitemSerial serial : requestItem.getSerials()) {
                                    JSONObject jsSerial = new JSONObject();
                                    jsSerial.put("RequestItemCode", (Object)serial.getRequestItemCode());
                                    jsSerial.put("Serial", (Object)serial.getSerial());
                                    jsSerial.put("ItemCode", (Object)serial.getItemCode());
                                    jsSerial.put("IsAccepted", false);
                                    jsSerial.put("SysSerial", serial.getSysSerial());
                                    jsonSerials.put((Object)jsSerial);
                                }
                                joItem.put("Serials", (Object)jsonSerials);
                                jab.put((Object)joItem);
                            }
                            job.put("RequestItems", (Object)jab);
                            jSONArray.put((Object)job);
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            File f = Santa.writePayLoadToFileAll(jSONArray.toString());
                            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                            httpPost.setEntity(reqEntity);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONObject ra = new JSONObject(result);
                                Platform.runLater(() -> {
                                    try {
                                        if (ra.getString("Message").equals("Success")) {
                                            request.setStatus(RequestStatus.COMPLETED.name());
                                            RequestDataList requestDataList1 = new RequestDataList(TransferReleasePane.this.da);
                                            requestDataList1.getOriginalList().add((Object)request);
                                            request.getItems().forEach(val -> val.setReturnedQty(val.getReleasedQuantity() - val.getAcceptedQty()));
                                            RequestItemDataList requestItemDataList1 = new RequestItemDataList(TransferReleasePane.this.da);
                                            requestItemDataList1.getOriginalList().addAll(request.getItems());
                                            requestDataList1.update();
                                            requestItemDataList1.update();
                                            TransferReleasePane.this.btnRelease.setVisible(false);
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", TransferReleasePane.this);
                                            TransferReleasePane.this.list.refresh();
                                            TransferReleasePane.this.list.getItems().set(TransferReleasePane.this.list.getSelectionModel().getSelectedIndex(), (Object)request);
                                        } else {
                                            JSONArray jSONArray1 = ra.getJSONArray("Responses");
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, jSONArray1.getJSONObject(0).getString("Message"), TransferReleasePane.this);
                                        }
                                    }
                                    catch (Exception ex) {
                                        TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                        TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                });
                            } else {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                    TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, fullError, TransferReleasePane.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void loadRequestItem(Request req) {
        if (req.getItems().isEmpty()) {
            RequestItemDataList requestItemDataList1 = new RequestItemDataList(this.da);
            requestItemDataList1.selectAll("Select * from RequestItem where requestCode=?", new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, req.getCode())});
            requestItemDataList1.getOriginalList().forEach(val -> this.loadRequestItemBin((RequestItem)val));
            req.getItems().addAll(requestItemDataList1.getOriginalList());
        }
    }

    void loadRequestItemBin(RequestItem reqItem) {
        if (reqItem.getRequestItemBins().isEmpty()) {
            RequestItemBinDataList requestItemDataList1 = new RequestItemBinDataList(this.da);
            requestItemDataList1.selectAll("Select * from RequestItemBin where requestCode=? and itemCode=?", new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, reqItem.getRequestCode()), new ParameterValue("requestCode", JDBCType.VARCHAR, reqItem.getItemCode())});
            reqItem.getRequestItemBins().addAll(requestItemDataList1.getOriginalList());
        }
    }

    private void loadRequests() {
        Object sRequest;
        this.requestItemDataList.selectApprovedByDateWithNotCompleted(java.sql.Date.valueOf((LocalDate)this.from.getValue()), java.sql.Date.valueOf((LocalDate)this.to.getValue()), this.da);
        if (!this.searchRequest.isEmpty() && (sRequest = (Request)this.requestItemDataList.getOriginalList().stream().filter(v -> v.getCode().equals(this.searchRequest)).findAny().orElse(null)) != null) {
            this.requestItemDataList.getOriginalList().removeIf(arg_0 -> TransferReleasePane.lambda$loadRequests$14((Request)sRequest, arg_0));
            this.requestItemDataList.getOriginalList().add(0, sRequest);
        }
        this.searchRequest = "";
        this.requestItemDataList.getOriginalList().addAll(this.requestDataList.getOriginalList());
        this.requestItemDataList.getOriginalList().forEach(v -> {
            v.getItems().clear();
            this.loadRequestItem((Request)v);
        });
        this.itemContainer.getChildren().clear();
        this.list.setItems(this.requestItemDataList.getOriginalList());
        this.list.refresh();
        try {
            for (Request req : this.requestItemDataList.getOriginalList()) {
                req.setIsNew(false);
            }
            this.mainPage.showNotificationRequest();
        }
        catch (Exception ex) {
            Logger.getLogger(TransferReleasePane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void Return(final Request request) {
        request.setReturningUser(this.currentUser.getUserName());
        request.setReturnDate(new Date());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            BufferedReader br;
                            Object url = TransferReleasePane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RRequest/ReturnRequestItems";
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("Code", (Object)request.getCode());
                            job.put("Reason", (Object)request.getReason());
                            job.put("Status", (Object)RequestStatus.RELEASED.name());
                            job.put("Reason", (Object)request.getReason());
                            job.put("StoreCode", (Object)request.getFromStoreCode());
                            job.put("ReturningUser", (Object)request.getReturningUser());
                            job.put("ReturningComment", (Object)request.getReturningComment());
                            job.put("ReturnDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("DocEntry", request.getDocEntry());
                            job.put("DateAccepted", (Object)request.getDateAccept());
                            job.put("ReleaseComment", (Object)request.getReleaseComment());
                            job.put("ReleasingUser", (Object)request.getReleasingUser());
                            job.put("ApprovalComment", (Object)request.getApprovalComment());
                            job.put("AcceptComment", (Object)request.getAcceptedComment());
                            job.put("AcceptingUser", (Object)request.getAcceptingUser());
                            job.put("ApprovingUser", (Object)request.getApprovingUser());
                            job.put("RequestType", (Object)request.getRequestType());
                            job.put("OriginatingUser", (Object)request.getoriginatedUser());
                            job.put("DestinationStore", (Object)request.getToStoreCode());
                            job.put("LastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("RequestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(request.getRequestDate()));
                            JSONArray jab = new JSONArray();
                            if (request.getItems().isEmpty()) {
                                TransferReleasePane.this.loadRequestItem(request);
                            }
                            for (RequestItem requestItem : request.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("RequestCode", (Object)request.getCode());
                                joItem.put("Quantity", requestItem.getQuantity());
                                joItem.put("DestinationStore", (Object)request.getToStoreCode());
                                joItem.put("ReleasedQty", requestItem.getReleasedQuantity());
                                joItem.put("ApprovedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("AcceptedQty", (Object)requestItem.getAcceptedQty());
                                if (requestItem.getReleasedQuantity() - requestItem.getAcceptedQty() == 0) continue;
                                joItem.put("ReturnedQty", requestItem.getReleasedQuantity() - requestItem.getAcceptedQty());
                                joItem.put("ItemCode", (Object)requestItem.getItemCode());
                                joItem.put("ItemName", (Object)requestItem.getItemName());
                                joItem.put("Code", (Object)requestItem.getCode());
                                JSONArray jsonSerials = new JSONArray();
                                for (RequestitemSerial serial : requestItem.getSerials()) {
                                    JSONObject jsSerial = new JSONObject();
                                    jsSerial.put("RequestItemCode", (Object)serial.getRequestItemCode());
                                    jsSerial.put("Serial", (Object)serial.getSerial());
                                    jsSerial.put("ItemCode", (Object)serial.getItemCode());
                                    jsSerial.put("IsAccepted", false);
                                    jsSerial.put("SysSerial", serial.getSysSerial());
                                    jsonSerials.put((Object)jsSerial);
                                }
                                joItem.put("Serials", (Object)jsonSerials);
                                jab.put((Object)joItem);
                            }
                            job.put("RequestItems", (Object)jab);
                            jSONArray.put((Object)job);
                            HttpPost httpPost = new HttpPost((String)url);
                            if (request.getRequestType().equals(RequestType.Outbound.name()) && Santa.getWareHousesList().contains(request.getFromStoreCode()) || request.getRequestType().equals(RequestType.Inbound.name()) && Santa.getWareHousesList().contains(request.getToStoreCode())) {
                                System.out.println("Request Type:" + request.getRequestType() + " From Store" + request.getFromStoreCode() + ",To store:" + request.getToStoreCode());
                                ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                                BasicNameValuePair param1 = new BasicNameValuePair("returnOutwards", "true");
                                listParam.add(param1);
                                URI uri = new URIBuilder(httpPost.getURI()).addParameters(listParam).build();
                                httpPost.setURI(uri);
                            }
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            File f = Santa.writePayLoadToFileAll(jSONArray.toString());
                            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                            httpPost.setEntity(reqEntity);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONObject ra = new JSONObject(result);
                                Platform.runLater(() -> {
                                    try {
                                        if (ra.getString("Message").equals("Success")) {
                                            if (request.getRequestType().equals(RequestType.Outbound.name()) && Santa.getWareHousesList().contains(request.getFromStoreCode()) || request.getRequestType().equals(RequestType.Inbound.name()) && Santa.getWareHousesList().contains(request.getToStoreCode())) {
                                                System.out.println("Request Type:2 " + request.getRequestType() + " From Store" + request.getToStoreCode() + ",To store:" + request.getToStoreCode());
                                                request.setStatus(RequestStatus.RETURNED.name());
                                            } else {
                                                request.setStatus(RequestStatus.COMPLETED.name());
                                            }
                                            RequestDataList requestDataList1 = new RequestDataList(TransferReleasePane.this.da);
                                            requestDataList1.getOriginalList().add((Object)request);
                                            request.getItems().forEach(val -> val.setReturnedQty(val.getReleasedQuantity() - val.getAcceptedQty()));
                                            RequestItemDataList requestItemDataList1 = new RequestItemDataList(TransferReleasePane.this.da);
                                            requestItemDataList1.getOriginalList().addAll(request.getItems());
                                            requestDataList1.update();
                                            requestItemDataList1.update();
                                            TransferReleasePane.this.btnRelease.setVisible(false);
                                            TransferReleasePane.this.btnReturn.setVisible(false);
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", TransferReleasePane.this);
                                            TransferReleasePane.this.list.refresh();
                                            TransferReleasePane.this.list.getItems().set(TransferReleasePane.this.list.getSelectionModel().getSelectedIndex(), (Object)request);
                                        } else {
                                            JSONArray jSONArray1 = ra.getJSONArray("Responses");
                                            TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                            TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, jSONArray1.getJSONObject(0).getString("Message"), TransferReleasePane.this);
                                        }
                                    }
                                    catch (Exception ex) {
                                        TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                        TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                });
                            } else {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                    TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, fullError, TransferReleasePane.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                TransferReleasePane.this.stackPane.getChildren().remove((Object)box);
                                TransferReleasePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferReleasePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    @Override
    public void yes() {
        if (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RELEASED.name())) {
            this.Return((Request)this.list.getSelectionModel().getSelectedItem());
        } else if (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.RETURNED.name())) {
            this.ReturnAccept((Request)this.list.getSelectionModel().getSelectedItem());
        } else if (((Request)this.list.getSelectionModel().getSelectedItem()).getStatus().equals(RequestStatus.ACCEPTED.name())) {
            this.Return((Request)this.list.getSelectionModel().getSelectedItem());
        }
    }

    private static /* synthetic */ boolean lambda$loadRequests$14(Request sRequest, Request v) {
        return v.getCode().equals(sRequest.getCode());
    }
}

