/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.ui.TransferReleasePane;
import com.xputertechnologies.santa.ui.TransferReleasePlanCard;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.glyphfont.FontAwesome;

public class TransferReleaseItemCard
extends UIParent {
    @FXML
    private Label lblItemCode;
    @FXML
    private Label lblItemName;
    @FXML
    private StackPane stackPane;
    @FXML
    private Label lblReqQty;
    @FXML
    private Label lblApprQty;
    @FXML
    private Label lblRelQty;
    @FXML
    private Label lblReturnQty;
    @FXML
    private Label lblAccptQty;
    @FXML
    private JFXButton btnPlan;
    JFXDialog dialog = null;
    protected StringConverter<? extends Number> IntConverter = new IntegerStringConverter(){

        public String toString(Integer object) {
            if (object != null) {
                return Integer.toString(object);
            }
            return null;
        }

        public Integer fromString(String string) {
            Integer d = 0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Integer.parseInt(string);
            }
            return d;
        }
    };

    public TransferReleaseItemCard(TransferReleasePane transferReleasePane, RequestItem requestItem, boolean isCompleted) {
        super("TransferReleaseItemCard.fxml", null);
        this.lblItemCode.setText(requestItem.getItemCode());
        this.lblItemName.setText(requestItem.getItemName());
        this.lblReqQty.setText(String.valueOf(requestItem.getQuantity()));
        this.lblApprQty.setText(String.valueOf(requestItem.getApprovedQty()));
        this.lblRelQty.textProperty().bindBidirectional((Property)requestItem.releasedQuantityProperty(), this.IntConverter);
        this.lblAccptQty.setText(String.valueOf(requestItem.getAcceptedQty()));
        this.lblReturnQty.setText(String.valueOf(requestItem.getReturnedQty()));
        this.btnPlan.setText(isCompleted ? "View" : "Plan");
        this.btnPlan.setGraphic((Node)(isCompleted ? this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.WHITE).size(13.0) : this.fontAwesome.create((Enum)FontAwesome.Glyph.GE).color(Color.WHITE).size(13.0)));
        this.btnPlan.setOnAction(val -> {
            this.dialog = new JFXDialog(transferReleasePane.stackPane, (Region)new TransferReleasePlanCard(this, requestItem, isCompleted), JFXDialog.DialogTransition.CENTER);
            this.dialog.setOverlayClose(false);
            this.dialog.show();
        });
    }
}

