/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Account;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.AccountPaymentType;
import com.xputertechnologies.santa.Approval;
import com.xputertechnologies.santa.ApprovalStage;
import com.xputertechnologies.santa.BatchSale;
import com.xputertechnologies.santa.BatchStatusEnum;
import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.CustomerData;
import com.xputertechnologies.santa.Employee;
import com.xputertechnologies.santa.FileBodyPart;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.ISaleCallBack;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.InventoryMovement;
import com.xputertechnologies.santa.Log;
import com.xputertechnologies.santa.ManualPendingStatus;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.ObjectDb;
import com.xputertechnologies.santa.PaymentBatch;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestTypeEnum;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleAccountDetailResolver;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.StageUser;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.SyncSetting;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDataList;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.list.ApprovalDataList;
import com.xputertechnologies.santa.list.ApprovalStageDataList;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.list.EmployeeDataList;
import com.xputertechnologies.santa.list.LogDataList;
import com.xputertechnologies.santa.list.PaymentBatchDataList;
import com.xputertechnologies.santa.list.RequestDataList;
import com.xputertechnologies.santa.list.RequestItemDataList;
import com.xputertechnologies.santa.list.SaleItemList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StageUserDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TempRoleManagement;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SyncData {
    public static final String READTIMEOUT_ERROR = "Unable to fulfil your request at the moment , Please try again";
    DataAccess da = null;
    Company companyName;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    List<CustomerData> customers;
    List<StockItemData> products;
    Santa app;
    boolean oneTimeSynced = false;
    String myStoreName = "";
    boolean saleSynced = true;
    ObjectDb objectDb = ObjectDb.loadLocalDb() == null ? new ObjectDb() : ObjectDb.loadLocalDb();

    public SyncData(Santa app, DataAccess da, Company companyName) {
        this.da = da;
        this.app = app;
        this.companyName = companyName;
        if (companyName != null) {
            StoreDataList stores = new StoreDataList(da);
            stores.selectAll(da);
            Store store = stores.getOriginalList().stream().filter(prdct -> prdct.getCode().equals(companyName.getStoreCode())).findAny().orElse(null);
            if (store != null) {
                this.myStoreName = store.getName();
            }
        }
    }

    public static boolean isInternetAvailable() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection connection = url.openConnection();
            connection.connect();
            System.out.println("Internet Connected");
            return Boolean.TRUE;
        }
        catch (Exception e) {
            System.out.println("Sorry, No Internet Connection");
            return Boolean.FALSE;
        }
    }

    public void Synchronize(SyncSetting syncSet) {
        if (this.app.mainpage == null) {
            return;
        }
        try {
            if (!TempRoleManagement.canRunBackgroundSync(UserType.valueOf(this.app.mainpage.currentUser.getRoleDescription()))) {
                this.app.timer.cancel();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
        }
        LogDataList lgd = new LogDataList(this.da);
        Log logSale = null;
        if (TempRoleManagement.canMakeSale(UserType.valueOf(this.app.currentUser.getRoleDescription())) && this.saleSynced) {
            logSale = this.pushSales(syncSet, null, "salesorder/createSalesorder", null);
        }
        Log logTransfer = null;
        Log logProducts = null;
        if (TempRoleManagement.canCreateTransfer(UserType.valueOf(this.app.currentUser.getRoleDescription()))) {
            String url = WebRequest.GET_LASTSYNC_TRANSFERS + "/" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(syncSet.getTransferLastDateRead()) + "/" + this.companyName.getStoreCode().trim() + "/" + this.myStoreName;
            logTransfer = this.getRequest(syncSet, url, true, null);
            logProducts = this.getProducts(syncSet, null);
        }
        if (logSale != null) {
            lgd.getOriginalList().add((Object)logSale);
        }
        if (logTransfer != null) {
            lgd.getOriginalList().add(logTransfer);
        }
        if (logProducts != null) {
            lgd.getOriginalList().add(logProducts);
        }
        try {
            lgd.update();
        }
        catch (Exception ex) {
            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadYuproductDated(SyncSetting syncSet) {
        try {
            HttpGet httpGet = new HttpGet(syncSet.getBEURL() + "RProduct/GetSAPItems");
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LocalDateTime Strtdatetime = LocalDate.now().minusDays(1L).atTime(0, 0, 0);
            String fromDt = format.format(java.sql.Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
            BasicNameValuePair param2 = new BasicNameValuePair("lastSyncDate", fromDt);
            listParam.add(param2);
            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
            httpGet.setURI(uri);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        StockItemData stkData = new StockItemData();
                        stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                        stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                        list.add(stkData);
                    }
                    StockItemList.insertYudalaProduct(list, this.da);
                    if (list.size() > 0) {
                        this.app.Products.clear();
                        this.app.Products.addAll(StockItemList.selectAllYuProducts(this.da));
                    }
                    this.objectDb.setLastUpdateYuProduct(new Date());
                    this.objectDb.setOneTimeEndPointsLoaded(Boolean.TRUE);
                    this.objectDb.saveLocalDb();
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                System.err.println(fullError);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    void loadApprovaltemplate(SyncSetting syncSet) {
        try {
            String url = syncSet.getBEURL() + "RApprovalTemplate/GetApprovalTemplates";
            HttpGet httpGet = new HttpGet(url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray ra = new JSONArray(result);
                if (ra.length() > 0) {
                    ApprovalDataList approvalList = new ApprovalDataList(this.da);
                    for (int i = 0; i < ra.length(); ++i) {
                        JSONObject jSONObject = ra.getJSONObject(i);
                        Approval apppvApproval = new Approval(this.da);
                        apppvApproval.setDescription(jSONObject.isNull("Description") ? "" : jSONObject.getString("Description"));
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                        Date dt = df.parse(jSONObject.getString("DateCreated"));
                        apppvApproval.setDateCreated(new java.sql.Date(dt.getTime()));
                        apppvApproval.setIsDisable(jSONObject.isNull("IsDisable") ? true : jSONObject.getBoolean("IsDisable"));
                        apppvApproval.setSyncFlag(Boolean.TRUE);
                        apppvApproval.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                        JSONArray approvalStageArray = jSONObject.getJSONArray("Stages");
                        for (int j = 0; j < approvalStageArray.length(); ++j) {
                            JSONObject stageJSONObject = approvalStageArray.getJSONObject(j);
                            ApprovalStage approvalStage = new ApprovalStage(this.da);
                            approvalStage.setApprovalDescription(stageJSONObject.isNull("ApprovalDescription") ? "" : stageJSONObject.getString("ApprovalDescription"));
                            approvalStage.setDescription(stageJSONObject.isNull("Description") ? "" : stageJSONObject.getString("Description"));
                            approvalStage.setCode(stageJSONObject.isNull("Code") ? "" : stageJSONObject.getString("Code"));
                            approvalStage.setIsDisable(stageJSONObject.isNull("IsDisable") ? true : stageJSONObject.getBoolean("IsDisable"));
                            approvalStage.setCanEdit(stageJSONObject.isNull("CanEdit") ? false : stageJSONObject.getBoolean("CanEdit"));
                            approvalStage.setOrder(stageJSONObject.isNull("Order") ? 0 : stageJSONObject.getInt("Order"));
                            approvalStage.setName(stageJSONObject.isNull("Name") ? "" : stageJSONObject.getString("Name"));
                            approvalStage.setMinimumApprove(stageJSONObject.isNull("MinimumApprove") ? 0 : stageJSONObject.getInt("MinimumApprove"));
                            approvalStage.setMinimumReject(stageJSONObject.isNull("MinimumReject") ? 0 : stageJSONObject.getInt("MinimumReject"));
                            JSONArray stageuserArray = stageJSONObject.getJSONArray("StageUsers");
                            for (int k = 0; k < stageuserArray.length(); ++k) {
                                JSONObject stageUserJSONObject = stageuserArray.getJSONObject(k);
                                StageUser stageUser = new StageUser(this.da);
                                stageUser.setApprovalDescription(stageUserJSONObject.isNull("ApprovalDescription") ? "" : stageUserJSONObject.getString("ApprovalDescription"));
                                stageUser.setStageName(stageUserJSONObject.isNull("StageName") ? "" : stageUserJSONObject.getString("StageName"));
                                stageUser.setStageCode(stageUserJSONObject.isNull("StageCode") ? "" : stageUserJSONObject.getString("StageCode"));
                                stageUser.setEmail(stageUserJSONObject.isNull("Email") ? "" : stageUserJSONObject.getString("Email"));
                                stageUser.setName(stageUserJSONObject.isNull("Name") ? "" : stageUserJSONObject.getString("Name"));
                                stageUser.setIsDisable(stageUserJSONObject.isNull("IsDisable") ? true : stageUserJSONObject.getBoolean("IsDisable"));
                                approvalStage.getStageUsers().add((Object)stageUser);
                            }
                            apppvApproval.getStages().add((Object)approvalStage);
                        }
                        approvalList.getOriginalList().add((Object)apppvApproval);
                    }
                    Platform.runLater(() -> {
                        try {
                            ApprovalStageDataList approvalStageDataListSave = new ApprovalStageDataList(this.da);
                            StageUserDataList stageUserDataListSave = new StageUserDataList(this.da);
                            approvalList.getOriginalList().forEach(c -> {
                                ApprovalDataList appList = new ApprovalDataList(this.da);
                                appList.selectAll("Select * From Approval where Description=?", new ParameterValue[]{new ParameterValue("Description", JDBCType.VARCHAR, c.getDescription())});
                                if (appList.getOriginalList().size() == 1) {
                                    c.setState(ObjectState.Changed);
                                    for (ApprovalStage stage : c.getStages()) {
                                        ApprovalStageDataList approvalStageDataList = new ApprovalStageDataList(this.da);
                                        approvalStageDataList.selectAll("Select * From ApprovalStage where Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, stage.getCode())});
                                        if (approvalStageDataList.getOriginalList().size() == 1) {
                                            stage.setState(ObjectState.Changed);
                                            for (StageUser stageUser : stage.getStageUsers()) {
                                                StageUserDataList stageUserDataList = new StageUserDataList(this.da);
                                                stageUserDataList.selectAll("Select * From StageUser where Email=? and StageCode=?", new ParameterValue[]{new ParameterValue("Email", JDBCType.VARCHAR, stageUser.getEmail()), new ParameterValue("StageCode", JDBCType.VARCHAR, stageUser.getStageCode())});
                                                if (stageUserDataList.getOriginalList().size() != 1) continue;
                                                stageUser.setState(ObjectState.Changed);
                                            }
                                        }
                                        stageUserDataListSave.getOriginalList().addAll(stage.getStageUsers());
                                    }
                                }
                                approvalStageDataListSave.getOriginalList().addAll(c.getStages());
                            });
                            approvalList.update();
                            approvalStageDataListSave.update();
                            stageUserDataListSave.update();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                } else {
                    Platform.runLater(() -> {});
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                Platform.runLater(() -> {});
            }
        }
        catch (Exception e) {
            Platform.runLater(() -> {});
        }
    }

    private void getBaseData(SyncSetting syncSet) {
        Log lg = new Log(this.da);
        Object url = syncSet.getBEURL();
        url = (String)url + "RMIsc/GetBaseData";
        ArrayList<NameValueObject> baseDataList = new ArrayList<NameValueObject>();
        try {
            HttpGet httpGet = new HttpGet((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONObject jar = new JSONObject(result);
                if (jar != null) {
                    NameValueObject obj;
                    JSONObject jo;
                    int i;
                    ArrayList<NameValueObject> nameValueObjects;
                    JSONArray suppliersArray = jar.getJSONArray("Suppliers");
                    JSONArray CostCentresArray = jar.getJSONArray("CostCentres");
                    JSONArray TaxCodesArray = jar.getJSONArray("TaxCodes");
                    JSONArray CurrenciesArray = jar.getJSONArray("Currencies");
                    JSONArray BanksArray = jar.getJSONArray("Banks");
                    JSONArray PaymentTermsArray = jar.getJSONArray("PaymentTerms");
                    JSONArray WarehousesArray = jar.getJSONArray("Warehouses");
                    JSONArray ItemGroupArray = jar.getJSONArray("ItemGroups");
                    JSONArray ManufacturersArray = jar.getJSONArray("Manufacturers");
                    if (suppliersArray.length() > 0) {
                        nameValueObjects = new ArrayList<NameValueObject>();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Supplier.name())}, this.da);
                        for (i = 0; i < suppliersArray.length(); ++i) {
                            jo = suppliersArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("VendorId") || jo.isNull("VendorName") || jo.getString("VendorName").isEmpty()) continue;
                            obj.setKey(jo.isNull("VendorId") ? "" : jo.getString("VendorId"));
                            obj.setData(jo.isNull("VendorName") ? "" : jo.getString("VendorName"));
                            obj.setType(NameValueObjectType.Supplier.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (CostCentresArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.CostCentre.name())}, this.da);
                        for (i = 0; i < CostCentresArray.length(); ++i) {
                            jo = CostCentresArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Name") ? "" : jo.getString("Name"));
                            obj.setType(NameValueObjectType.CostCentre.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (TaxCodesArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.TaxCodes.name())}, this.da);
                        for (i = 0; i < TaxCodesArray.length(); ++i) {
                            jo = TaxCodesArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Name") ? "" : jo.getString("Name"));
                            obj.setType(NameValueObjectType.TaxCodes.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (CurrenciesArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Currencies.name())}, this.da);
                        for (i = 0; i < CurrenciesArray.length(); ++i) {
                            jo = CurrenciesArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Name") ? "" : jo.getString("Name"));
                            obj.setType(NameValueObjectType.Currencies.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (BanksArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Banks.name())}, this.da);
                        for (i = 0; i < BanksArray.length(); ++i) {
                            jo = BanksArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("BankCode")) continue;
                            obj.setKey(jo.isNull("BankCode") ? "" : jo.getString("BankCode").trim());
                            obj.setData(jo.isNull("BankName") ? "" : jo.getString("BankName"));
                            obj.setType(NameValueObjectType.Banks.name());
                            if (obj.getKey().equals("CITI Bank")) {
                                System.out.println("ob");
                            }
                            if (nameValueObjects.stream().filter(c -> c.getKey().equalsIgnoreCase(obj.getKey())).findAny().orElse(null) != null) continue;
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (PaymentTermsArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.PaymentTerm.name())}, this.da);
                        for (i = 0; i < PaymentTermsArray.length(); ++i) {
                            jo = PaymentTermsArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Description") ? "" : jo.getString("Description"));
                            obj.setType(NameValueObjectType.PaymentTerm.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (ItemGroupArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.ItemGroups.name())}, this.da);
                        for (i = 0; i < ItemGroupArray.length(); ++i) {
                            jo = ItemGroupArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Description") ? "" : jo.getString("Description"));
                            obj.setType(NameValueObjectType.ItemGroups.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    if (WarehousesArray.length() > 0) {
                        StoreDataList storeDataList = new StoreDataList(this.da);
                        StockItemList.deleteAll("Store", this.da);
                        for (i = 0; i < WarehousesArray.length(); ++i) {
                            jo = WarehousesArray.getJSONObject(i);
                            Store store = new Store(this.da);
                            if (jo.isNull("Code")) continue;
                            store.setCode(jo.isNull("Code") ? "" : jo.getString("Code"));
                            store.setName(jo.isNull("Name") ? "" : jo.getString("Name"));
                            storeDataList.getOriginalList().add((Object)store);
                        }
                        storeDataList.update();
                    }
                    if (ManufacturersArray.length() > 0) {
                        nameValueObjects = new ArrayList();
                        StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Manufacturers.name())}, this.da);
                        for (i = 0; i < ManufacturersArray.length(); ++i) {
                            jo = ManufacturersArray.getJSONObject(i);
                            obj = new NameValueObject(this.da);
                            if (jo.isNull("Code")) continue;
                            obj.setKey(jo.isNull("Code") ? "" : jo.getString("Code"));
                            obj.setData(jo.isNull("Name") ? "" : jo.getString("Name"));
                            obj.setType(NameValueObjectType.Manufacturers.name());
                            nameValueObjects.add(obj);
                        }
                        baseDataList.addAll(nameValueObjects);
                    }
                    NameValueObject.insertBatch(baseDataList, this.da);
                    this.objectDb.setOneTimeEndPointsLoaded(Boolean.TRUE);
                    this.objectDb.saveLocalDb();
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                lg.setDateLog(new Date());
                lg.setMsg(fullError + "\r\n" + fullError);
                lg.setStatus("Failure");
            }
        }
        catch (Exception e) {
            lg.setDateLog(new Date());
            lg.setStatus("Failure");
            lg.setMsg(e.getMessage());
        }
    }

    private Log pushCustomers(final SyncSetting syncSet) {
        final Log lg = new Log(this.da);
        final CustomerDataList cdl = new CustomerDataList(this.da);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        cdl.selectAll("select * from Customer where lastSyncDate > ?", new ParameterValue[]{new ParameterValue("lastSyncDate", JDBCType.TIMESTAMP, new Timestamp(syncSet.getCustDateLastSync().getTime()))});
        final SyncSettingDataList sdl = new SyncSettingDataList(this.da);
        try {
            if (cdl.getOriginalList().size() > 0) {
                Object url = syncSet.getBEURL();
                url = (String)url + "customer/createCustomer";
                JSONArray jSONArray = new JSONArray();
                for (Customer cs : cdl.getOriginalList()) {
                    JSONObject job = new JSONObject();
                    job.put("firstName", (Object)cs.getName().split(" ")[0]);
                    job.put("lastName", (Object)(cs.getName().split(" ").length > 1 ? cs.getName().split(" ")[1] : ""));
                    job.put("email", (Object)cs.getEmail());
                    job.put("phoneNumber", (Object)cs.getPhoneNumber());
                    job.put("storeCode", (Object)this.companyName.getStoreCode());
                    jSONArray.put((Object)job);
                }
                new WebRequest((String)url, RequestTypeEnum.POST, jSONArray.toString(), null, new IWebCallBack(){

                    @Override
                    public void onSuccess(String data) {
                        try {
                            JSONArray customerJSONArray = new JSONArray(data);
                            for (int i = 0; i < customerJSONArray.length(); ++i) {
                                JSONObject custJSONObject = customerJSONArray.getJSONObject(i);
                                String pnum = custJSONObject.getString("phoneNumber");
                                String email = custJSONObject.getString("email");
                                List custs = cdl.getOriginalList().stream().filter(p -> p.getPhoneNumber().equals(pnum) || p.getEmail().equals(email)).collect(Collectors.toList());
                                if (custs.size() <= 0) continue;
                                Customer cus = (Customer)custs.get(0);
                                cus.setPhoneNumber(custJSONObject.getString("phoneNumber"));
                                cus.setEmail(custJSONObject.getString("email"));
                                cus.setName(custJSONObject.getString("firstName") + " " + custJSONObject.getString("lastName"));
                                cus.setD365Code(custJSONObject.getString("customerAccount"));
                                cus.setCode(custJSONObject.getString("_id"));
                                cus.setStoreCode(custJSONObject.getString("storeCode"));
                            }
                            cdl.update();
                            syncSet.setCustDateLastSync(new Timestamp(new Date().getTime()));
                            sdl.getOriginalList().add((Object)syncSet);
                            sdl.update();
                            lg.setDateLog(new Date());
                            lg.setMsg(Integer.toString(cdl.getOriginalList().size()) + " Customers(s) Synchronized with D365");
                            lg.setStatus("Success");
                        }
                        catch (Exception ex) {
                            lg.setDateLog(new Date());
                            lg.setStatus("Failure");
                            lg.setMsg(ex.getMessage());
                        }
                    }

                    @Override
                    public void onError(String data) {
                        lg.setDateLog(new Date());
                        lg.setStatus("Failure");
                        lg.setMsg(data);
                    }

                    @Override
                    public void onTimeOut(String data) {
                        lg.setDateLog(new Date());
                        lg.setStatus("Failure");
                        lg.setMsg("Timeout");
                    }
                }).execute(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return lg;
    }

    public Log getProducts(final SyncSetting syncSet, final IDBEntity<StockItem> callback) {
        final Log lg = new Log(this.da);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            JSONObject param = new JSONObject().put("locationId", (Object)this.companyName.getStoreCode()).put("fromDateTime", (Object)(callback != null ? "01/01/2015 00:00:00" : sdf.format(syncSet.getProdDateLastRead()))).put("isRetailLocation", !this.companyName.getIsMainHub());
            if (callback != null || syncSet.getProdDateLastRead().toInstant().plus((long)syncSet.getSyncInterval(), ChronoUnit.MINUTES).compareTo(new Timestamp(new Date().getTime()).toInstant()) < 0) {
                new WebRequest(WebRequest.PRODUCTS, RequestTypeEnum.POST, param.toString(), null, new IWebCallBack(){

                    @Override
                    public void onSuccess(String data) {
                        try {
                            StockItemList list = new StockItemList(SyncData.this.da);
                            JSONObject res = new JSONObject(data);
                            JSONArray arr = res.getJSONArray("inventoryResults");
                            if (callback != null) {
                                StockItemList.deleteAll(SyncData.this.da);
                            }
                            for (int i = 0; i < arr.length(); ++i) {
                                JSONObject locJSONObject = arr.getJSONObject(i);
                                StockItem obj = new StockItem(SyncData.this.da);
                                obj.setItemCode(locJSONObject.getString("itemId"));
                                obj.setName(locJSONObject.getString("itemName"));
                                obj.setStoreName(locJSONObject.getString("locationName"));
                                obj.setGroups(locJSONObject.getString("itemGroupId"));
                                obj.setQuantity((float)locJSONObject.getDouble("quantity"));
                                obj.setNetWeight(locJSONObject.isNull("netWeight") ? 0.0f : (float)locJSONObject.getDouble("netWeight"));
                                JSONArray priceArray = locJSONObject.getJSONArray("itemPrices");
                                for (int j = 0; j < priceArray.length(); ++j) {
                                    JSONObject js = priceArray.getJSONObject(j);
                                    if (!js.getString("priceGroup").equals("BasePrice")) continue;
                                    obj.setSellingPrice(js.getDouble("amount"));
                                }
                                obj.setParentCompany(SyncData.this.companyName);
                                obj.setItemUnit("Pieces");
                                if (callback == null) {
                                    StockItemList getProductLocal = new StockItemList(SyncData.this.da);
                                    getProductLocal.selectAll("Select * from stockitem where itemCode=?", new ParameterValue[]{new ParameterValue("itemCode", JDBCType.VARCHAR, obj.getItemCode())});
                                    if (!getProductLocal.getOriginalList().isEmpty()) {
                                        obj.setState(ObjectState.Changed);
                                        obj.vclone = obj.clone();
                                    }
                                }
                                obj.setPriceB2B(obj.getPriceB2B() > 0.0 ? obj.getPriceB2B() : 0.0);
                                obj.setSn(i + 1);
                                list.getOriginalList().add((Object)obj);
                            }
                            if (callback != null) {
                                Platform.runLater(() -> callback.onSuccess(list.getOriginalList()));
                            } else {
                                list.update();
                                lg.setDateLog(new Date());
                                lg.setMsg(Integer.toString(list.getOriginalList().size()) + " Product(s) Synchronized with D365");
                                lg.setStatus("Success");
                                syncSet.setProdDateLastRead(new Timestamp(new Date().getTime()));
                                SyncSettingDataList sdl = new SyncSettingDataList(SyncData.this.da);
                                sdl.getOriginalList().add((Object)syncSet);
                                try {
                                    sdl.update();
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (callback != null) {
                                Platform.runLater(() -> callback.onError(ex.getMessage()));
                            }
                            lg.setDateLog(new Date());
                            lg.setStatus("Failure");
                            lg.setMsg(ex.getMessage());
                        }
                    }

                    @Override
                    public void onError(String data) {
                        if (callback != null) {
                            Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
                        } else {
                            lg.setDateLog(new Date());
                            lg.setStatus("Failure");
                            lg.setMsg(data);
                        }
                    }

                    @Override
                    public void onTimeOut(String data) {
                        if (callback != null) {
                            Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
                        } else {
                            lg.setDateLog(new Date());
                            lg.setStatus("Failure");
                            lg.setMsg("Timeout");
                        }
                    }
                }).execute(true);
            }
            return lg;
        }
        catch (JSONException ex) {
            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
            lg.setDateLog(new Date());
            lg.setStatus("Failure");
            lg.setMsg(ex.getMessage());
            return lg;
        }
    }

    public void getInventory(JSONObject param, final IDBEntity<StockItem> callback) throws JSONException {
        new WebRequest(WebRequest.PRODUCTS_LOOKUP, RequestTypeEnum.POST, param.toString(), null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    StockItemList list = new StockItemList(SyncData.this.da);
                    JSONObject res = new JSONObject(data);
                    JSONArray arr = res.getJSONArray("inventoryResults");
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject locJSONObject = arr.getJSONObject(i);
                        StockItem obj = new StockItem(SyncData.this.da);
                        obj.setItemCode(locJSONObject.getString("itemId"));
                        obj.setName(locJSONObject.getString("itemName"));
                        obj.setStoreName(locJSONObject.getString("locationName"));
                        obj.setGroups(locJSONObject.getString("itemGroupId"));
                        obj.setQuantity((float)locJSONObject.getDouble("quantity"));
                        obj.setNetWeight(locJSONObject.isNull("netWeight") ? 0.0f : (float)locJSONObject.getDouble("netWeight"));
                        if (obj.getItemCode().equals("4554342")) {
                            System.err.println("heyyyy");
                        }
                        if (!locJSONObject.isNull("itemPrices")) {
                            JSONArray priceArray = locJSONObject.getJSONArray("itemPrices");
                            if (priceArray.length() > 0) {
                                JSONArray finalPriceArray = SyncData.this.sortedPrice(priceArray);
                                obj.setSellingPrice(finalPriceArray.getJSONObject(0).getDouble("amount"));
                            } else {
                                obj.setSellingPrice(locJSONObject.getDouble("price"));
                            }
                        } else {
                            obj.setSellingPrice(locJSONObject.getDouble("price"));
                        }
                        obj.setPriceB2B(obj.getPriceB2B() > 0.0 ? obj.getPriceB2B() : 0.0);
                        obj.setParentCompany(SyncData.this.companyName);
                        obj.setSn(i + 1);
                        list.getOriginalList().add((Object)obj);
                    }
                    Platform.runLater(() -> callback.onSuccess(list.getOriginalList()));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void getITem(JSONObject param, final IDBEntity<StockItem> callback) throws JSONException {
        new WebRequest(WebRequest.PRODUCTS_ITEM, RequestTypeEnum.POST, param.toString(), null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    StockItemList list = new StockItemList(SyncData.this.da);
                    JSONObject res = new JSONObject(data);
                    JSONArray arr = res.getJSONArray("inventoryResults");
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject locJSONObject = arr.getJSONObject(i);
                        StockItem obj = new StockItem(SyncData.this.da);
                        obj.setItemCode(locJSONObject.getString("itemId"));
                        obj.setName(locJSONObject.getString("itemName"));
                        obj.setStoreName(locJSONObject.getString("locationName"));
                        obj.setGroups(locJSONObject.getString("itemGroupId"));
                        obj.setQuantity((float)locJSONObject.getDouble("quantity"));
                        obj.setNetWeight(locJSONObject.isNull("netWeight") ? 0.0f : (float)locJSONObject.getDouble("netWeight"));
                        obj.setParentCompany(SyncData.this.companyName);
                        obj.setSn(i + 1);
                        if (!locJSONObject.isNull("itemPrices")) {
                            System.err.println("crap");
                        }
                        list.getOriginalList().add((Object)obj);
                    }
                    Platform.runLater(() -> callback.onSuccess(list.getOriginalList()));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void getLocations(final DataAccess d, final IDBEntity<Store> callback) throws JSONException {
        JSONObject param = new JSONObject().put("isRetailLocation", true);
        new WebRequest(WebRequest.LOCATIONS, RequestTypeEnum.POST, param.toString(), null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    StoreDataList storeDataList = new StoreDataList(d);
                    JSONObject res = new JSONObject(data);
                    JSONArray locations = res.getJSONArray("locationResults");
                    for (int i = 0; i < locations.length(); ++i) {
                        JSONObject locJSONObject = locations.getJSONObject(i);
                        Store store = new Store(d);
                        store.setCode(locJSONObject.getString("locationId"));
                        store.setName(locJSONObject.getString("locationName"));
                        store.setAddress(locJSONObject.getString("locationAddress"));
                        store.setSn(i + 1);
                        storeDataList.getOriginalList().add((Object)store);
                    }
                    Store store = new Store(d);
                    store.setCode("LAGM001");
                    store.setName("Lagos MWH50");
                    store.setAddress("Ogba Lagos ");
                    store.setSn(storeDataList.getOriginalList().size() + 1);
                    storeDataList.getOriginalList().add((Object)store);
                    store = new Store(d);
                    store.setCode("ABJM002");
                    store.setName("Abuja MWH");
                    store.setAddress("Abuja");
                    store.setSn(storeDataList.getOriginalList().size() + 1);
                    storeDataList.getOriginalList().add((Object)store);
                    store = new Store(d);
                    store.setCode("PHCM003");
                    store.setName("Port-Harcourt MWH");
                    store.setAddress("Port-Harcourt");
                    store.setSn(storeDataList.getOriginalList().size() + 1);
                    storeDataList.getOriginalList().add((Object)store);
                    StoreDataList.deleteAll(d);
                    storeDataList.update();
                    System.out.println(data);
                    Platform.runLater(() -> callback.onSuccess(storeDataList.getOriginalList()));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void getEmployee(final DataAccess d, final IDBEntity<Employee> callback) throws JSONException {
        new WebRequest(WebRequest.EMPLOYEE, RequestTypeEnum.POST, null, null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    EmployeeDataList list = new EmployeeDataList(d);
                    JSONObject res = new JSONObject(data);
                    JSONArray locations = res.getJSONArray("workerResults");
                    for (int i = 0; i < locations.length(); ++i) {
                        JSONObject locJSONObject = locations.getJSONObject(i);
                        Employee employee = new Employee(d);
                        employee.setEmpId(locJSONObject.getString("staffCode"));
                        employee.setEmpName(locJSONObject.getString("staffName"));
                        list.getOriginalList().add((Object)employee);
                    }
                    EmployeeDataList.deleteAll(d);
                    list.update();
                    System.out.println(data);
                    Platform.runLater(() -> callback.onSuccess(list.getOriginalList()));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void getInventoryMovement(String data, final IDBEntity<InventoryMovement> callback) throws JSONException {
        new WebRequest(WebRequest.INVENTORYMOVEMENT, RequestTypeEnum.POST, data, null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    ArrayList<InventoryMovement> list = new ArrayList<InventoryMovement>();
                    JSONObject res = new JSONObject(data);
                    JSONArray arr = res.getJSONArray("inventoryResults");
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject obj = arr.getJSONObject(i);
                        InventoryMovement inventoryMovement = new InventoryMovement();
                        inventoryMovement.setItemId(obj.getString("itemId"));
                        inventoryMovement.setItemName(obj.getString("itemName"));
                        inventoryMovement.setTransType(obj.getString("transType"));
                        inventoryMovement.setTransNo(obj.getString("transNo"));
                        inventoryMovement.setLocation(obj.getString("location"));
                        inventoryMovement.setStatusIssue(obj.getString("statusIssue"));
                        inventoryMovement.setStatusReceipt(obj.getString("statusReceipt"));
                        inventoryMovement.setQuantity(String.valueOf(obj.getDouble("quantity")));
                        Date dt = df.parse(obj.getString("transDate"));
                        inventoryMovement.setTransDate(new Timestamp(dt.getTime()));
                        list.add(inventoryMovement);
                    }
                    System.out.println(data);
                    Platform.runLater(() -> callback.onSuccess(FXCollections.observableArrayList((Collection)list)));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void getBank(final DataAccess d, String storeId, final IDBEntity<AccountDetail> callback) throws JSONException {
        JSONObject data = new JSONObject().put("storeId", (Object)storeId);
        new WebRequest(WebRequest.BANKS, RequestTypeEnum.POST, data.toString(), null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    AccountDetailDataList list = new AccountDetailDataList(d);
                    JSONObject js = new JSONObject(data);
                    JSONArray res = js.getJSONArray("bankResults");
                    for (int i = 0; i < res.length(); ++i) {
                        JSONObject locJSONObject = res.getJSONObject(i);
                        for (int j = 0; j < AccountPaymentType.values().length; ++j) {
                            AccountDetail obj = new AccountDetail(d);
                            obj.setAccName(locJSONObject.getString("bankName"));
                            obj.setAccNumber(locJSONObject.getString("accountNum"));
                            obj.setAccType(AccountPaymentType.values()[j].name());
                            list.getOriginalList().add((Object)obj);
                        }
                    }
                    AccountDetailDataList.deleteAll(d);
                    list.update();
                    System.out.println(data);
                    Platform.runLater(() -> callback.onSuccess(list.getOriginalList()));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void getPaymentTerms(final DataAccess d, final IDBEntity<NameValueObject> callback) throws JSONException {
        new WebRequest(WebRequest.PAYMENT_TERMS_LOCAL, RequestTypeEnum.GET, null, null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    ObservableList list = FXCollections.observableArrayList();
                    JSONArray jsonList = new JSONArray(data);
                    for (int i = 0; i < jsonList.length(); ++i) {
                        JSONObject jSONObject = jsonList.getJSONObject(i);
                        NameValueObject obj = new NameValueObject(d);
                        obj.setKey(jSONObject.getString("code"));
                        obj.setData(jSONObject.getString("description"));
                        list.add((Object)obj);
                    }
                    StockItemList.insertPaymentTerm((List<NameValueObject>)list, d);
                    System.out.println(data);
                    Platform.runLater(() -> callback.onSuccess(list));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(false);
    }

    public void getPaymentModes(final DataAccess d, final IDBEntity<NameValueObject> callback) throws JSONException {
        new WebRequest(WebRequest.PAYMENT_METHODS, RequestTypeEnum.POST, null, null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    ObservableList list = FXCollections.observableArrayList();
                    JSONObject res = new JSONObject(data);
                    JSONArray jsonList = res.getJSONArray("paymentModeResults");
                    for (int i = 0; i < jsonList.length(); ++i) {
                        JSONObject jSONObject = jsonList.getJSONObject(i);
                        NameValueObject obj = new NameValueObject(d);
                        obj.setKey(jSONObject.getString("paymentMode"));
                        obj.setData(jSONObject.getString("description"));
                        list.add((Object)obj);
                    }
                    StockItemList.insertPaymentMode((List<NameValueObject>)list, d);
                    System.out.println(data);
                    Platform.runLater(() -> callback.onSuccess(list));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void getDimenssions(final DataAccess d, final IDBEntity<NameValueObject> callback) throws JSONException {
        new WebRequest(WebRequest.DIMENSIONS, RequestTypeEnum.POST, null, null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    NameValueObject obj;
                    JSONObject jSONObject;
                    int i;
                    ObservableList list = FXCollections.observableArrayList();
                    JSONObject res = new JSONObject(data);
                    for (i = 0; i < res.getJSONArray("businessStreams").length(); ++i) {
                        jSONObject = res.getJSONArray("businessStreams").getJSONObject(i);
                        obj = new NameValueObject(d);
                        obj.setData(jSONObject.getString("name"));
                        obj.setKey(jSONObject.getString("displayValue"));
                        obj.setType(NameValueObjectType.BusinessStream.name());
                        list.add((Object)obj);
                    }
                    for (i = 0; i < res.getJSONArray("businessUnits").length(); ++i) {
                        jSONObject = res.getJSONArray("businessUnits").getJSONObject(i);
                        obj = new NameValueObject(d);
                        obj.setData(jSONObject.getString("name"));
                        obj.setKey(jSONObject.getString("displayValue"));
                        obj.setType(NameValueObjectType.BusinessUnit.name());
                        list.add((Object)obj);
                    }
                    for (i = 0; i < res.getJSONArray("costCenters").length(); ++i) {
                        jSONObject = res.getJSONArray("costCenters").getJSONObject(i);
                        obj = new NameValueObject(d);
                        obj.setData(jSONObject.getString("name"));
                        obj.setKey(jSONObject.getString("displayValue"));
                        obj.setType(NameValueObjectType.CostCentre.name());
                        list.add((Object)obj);
                    }
                    StockItemList.insertDimensions((List<NameValueObject>)list, d);
                    System.out.println(data);
                    Platform.runLater(() -> callback.onSuccess(list));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void resendManualSaleMail(String storeId, String invoiceNo, final IDBEntity<String> callback) throws JSONException {
        new WebRequest("salesorder/sendEmail/" + invoiceNo + "/" + storeId.trim(), RequestTypeEnum.GET, null, null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    System.out.println(data);
                    Platform.runLater(() -> {
                        ObservableList result = FXCollections.observableArrayList((Object[])new String[]{""});
                        callback.onSuccess(result);
                    });
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(false);
    }

    public void sendSMS(String msg, final IDBEntity<String> callback) throws JSONException {
        String url = "";
        new WebRequest(url, RequestTypeEnum.POST, null, null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    System.out.println(data);
                    Platform.runLater(() -> {
                        ObservableList result = FXCollections.observableArrayList((Object[])new String[]{""});
                        callback.onSuccess(result);
                    });
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(true);
    }

    public void getCustomer(String param, final IDBEntity<Customer> callback) throws JSONException {
        new WebRequest(WebRequest.SEARCHCUSTOMER + "/" + param, RequestTypeEnum.GET, null, null, new IWebCallBack(){

            @Override
            public void onSuccess(String data) {
                try {
                    CustomerDataList list = new CustomerDataList(SyncData.this.da);
                    JSONArray custs = new JSONArray(data);
                    for (int i = 0; i < custs.length(); ++i) {
                        JSONObject locJSONObject = custs.getJSONObject(i);
                        CustomerDataList custList = new CustomerDataList(SyncData.this.da);
                        custList.selectAll("Select * from Customer where PhoneNumber=? or d365Code=?", new ParameterValue[]{new ParameterValue("PhoneNumber", JDBCType.VARCHAR, locJSONObject.getString("phoneNumber")), new ParameterValue("PhoneNumber", JDBCType.VARCHAR, locJSONObject.getString("customerAccount"))});
                        Customer cus = new Customer(SyncData.this.da);
                        if (!custList.getOriginalList().isEmpty()) {
                            cus = (Customer)custList.getOriginalList().get(0);
                        }
                        cus.setD365Code(locJSONObject.getString("customerAccount"));
                        cus.setEmail(locJSONObject.getString("email"));
                        cus.setName((locJSONObject.isNull("firstName") ? "" : locJSONObject.getString("firstName")) + " " + (locJSONObject.isNull("lastName") ? "" : locJSONObject.getString("lastName")));
                        cus.setPhoneNumber(locJSONObject.getString("phoneNumber"));
                        list.getOriginalList().add((Object)cus);
                    }
                    if (!list.getOriginalList().isEmpty()) {
                        list.update();
                    }
                    System.out.println(data);
                    Platform.runLater(() -> callback.onSuccess(list.getOriginalList()));
                }
                catch (Exception ex) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
            }

            @Override
            public void onError(String data) {
                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
            }

            @Override
            public void onTimeOut(String data) {
                Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
            }
        }).execute(false);
    }

    private String JsonArrayToString(JSONArray array) {
        Object result = "";
        if (array.length() > 0) {
            for (int p = 0; p < array.length(); ++p) {
                try {
                    String t = array.getString(p).toString();
                    if (p == 0) {
                        result = t;
                        continue;
                    }
                    result = (String)result + "," + t;
                    continue;
                }
                catch (JSONException ex) {
                    Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return result;
    }

    private JSONArray sortedPrice(JSONArray jsonArr) {
        JSONArray sortedJsonArray = new JSONArray();
        try {
            ArrayList<JSONObject> jsonValues = new ArrayList<JSONObject>();
            for (int i = 0; i < jsonArr.length(); ++i) {
                jsonValues.add(jsonArr.getJSONObject(i));
            }
            Collections.sort(jsonValues, new Comparator<JSONObject>(){

                @Override
                public int compare(JSONObject a, JSONObject b) {
                    try {
                        SimpleDateFormat sdfo = new SimpleDateFormat("yyyy-MM-dd");
                        Date d1 = sdfo.parse(a.getString("fromDate"));
                        Date d2 = sdfo.parse(b.getString("fromDate"));
                        return d2.compareTo(d1);
                    }
                    catch (Exception ex) {
                        return -1;
                    }
                }
            });
            jsonValues.forEach(j -> sortedJsonArray.put(j));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sortedJsonArray;
    }

    public Log getRequest(final SyncSetting syncSet, String url, final boolean save, final IDBEntity<Request> callback) {
        final Log lg = new Log(this.da);
        if (this.companyName.getStoreCode() != null && !this.companyName.getStoreCode().isEmpty()) {
            try {
                new WebRequest(url, RequestTypeEnum.GET, null, null, new IWebCallBack(){

                    @Override
                    public void onSuccess(String data) {
                        try {
                            JSONArray ra = new JSONArray(data);
                            RequestDataList requestDataList = new RequestDataList(SyncData.this.da);
                            if (ra.length() > 0) {
                                for (int i = 0; i < ra.length(); ++i) {
                                    Date dt;
                                    JSONObject jSONObject = ra.getJSONObject(i);
                                    Request request = new Request(SyncData.this.da);
                                    request.setCode(jSONObject.isNull("recId") ? "" : jSONObject.getString("recId"));
                                    request.setReason(jSONObject.isNull("requestReason") ? "" : jSONObject.getString("requestReason"));
                                    request.setStatus(jSONObject.isNull("status") ? "" : jSONObject.getString("status"));
                                    request.setFromStoreCode(jSONObject.isNull("fromLocationCode") ? "" : jSONObject.getString("fromLocationCode"));
                                    request.setRequestType(jSONObject.isNull("requesttype") ? "" : jSONObject.getString("requesttype"));
                                    request.setOriginatedUser(jSONObject.isNull("requestUser") ? "" : jSONObject.getString("requestUser"));
                                    request.setTransferId(jSONObject.isNull("transferId") ? "" : jSONObject.getString("transferId"));
                                    request.setOriginatedUser(jSONObject.isNull("requestUser") ? "" : jSONObject.getString("requestUser"));
                                    request.setTransferId(jSONObject.isNull("transferId") ? "" : jSONObject.getString("transferId"));
                                    request.setIsRecall(jSONObject.isNull("isRecall") ? false : jSONObject.getBoolean("isRecall"));
                                    if (jSONObject.isNull("toLocationName") || jSONObject.getString("toLocationName").isEmpty() || jSONObject.isNull("fromLocationName") || jSONObject.getString("fromLocationName").isEmpty()) {
                                        StoreDataList stores = new StoreDataList(SyncData.this.da);
                                        stores.selectAll(SyncData.this.da);
                                        Store fromLocationName = stores.getOriginalList().stream().filter(prdct -> prdct.getCode().equals(request.getFromStoreCode())).findAny().orElse(null);
                                        request.setFromStoreName(fromLocationName != null ? fromLocationName.getName() : "");
                                        Store toLocationName = stores.getOriginalList().stream().filter(prdct -> prdct.getCode().equals(request.getToStoreCode())).findAny().orElse(null);
                                        request.setToStoreName(toLocationName != null ? toLocationName.getName() : "");
                                    } else {
                                        request.setFromStoreName(jSONObject.isNull("fromLocationName") ? "" : jSONObject.getString("fromLocationName"));
                                        request.setToStoreName(jSONObject.isNull("toLocationName") ? "" : jSONObject.getString("toLocationName"));
                                    }
                                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                    if (!jSONObject.isNull("dateaccept")) {
                                        dt = df.parse(jSONObject.getString("dateaccept"));
                                        request.setDateAccept(new java.sql.Date(dt.getTime()));
                                    }
                                    if (!jSONObject.isNull("lastUpdatedDate")) {
                                        dt = df.parse(jSONObject.getString("lastUpdatedDate"));
                                        request.setLastUpdatedDate(new java.sql.Date(dt.getTime()));
                                    }
                                    if (!jSONObject.isNull("approvalDate")) {
                                        dt = df.parse(jSONObject.getString("approvalDate"));
                                        request.approvalDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                    }
                                    if (!jSONObject.isNull("releaseDate")) {
                                        dt = df.parse(jSONObject.getString("releaseDate"));
                                        request.releaseDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                    }
                                    if (!jSONObject.isNull("requestDate")) {
                                        dt = df.parse(jSONObject.getString("requestDate"));
                                        request.requestDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                    }
                                    if (!jSONObject.isNull("returnDate")) {
                                        dt = df.parse(jSONObject.getString("returnDate"));
                                        request.returnDateProperty().set((Object)new java.sql.Date(dt.getTime()));
                                    }
                                    request.setApprovingUser(jSONObject.isNull("approvinguser") ? "" : SyncData.this.JsonArrayToString(jSONObject.getJSONArray("approvinguser")));
                                    request.setDeclineBy(jSONObject.isNull("rejectinguser") ? "" : SyncData.this.JsonArrayToString(jSONObject.getJSONArray("rejectinguser")));
                                    request.setReleasingUser(jSONObject.isNull("releasinguser") ? "" : jSONObject.getString("releasinguser"));
                                    request.setAcceptingUser(jSONObject.isNull("acceptinguser") ? "" : jSONObject.getString("acceptinguser"));
                                    request.setApprovalComment(jSONObject.isNull("approvalComment") ? "" : jSONObject.getString("approvalComment"));
                                    request.setReleaseComment(jSONObject.isNull("releaseComment") ? "" : jSONObject.getString("releaseComment"));
                                    request.setAcceptedComment(jSONObject.isNull("acceptComment") ? "" : jSONObject.getString("acceptComment"));
                                    request.setToStoreCode(jSONObject.isNull("toLocationCode") ? "" : jSONObject.getString("toLocationCode"));
                                    request.setReturningUser(jSONObject.isNull("returningUser") ? "" : jSONObject.getString("returningUser"));
                                    request.setReturningComment(jSONObject.isNull("returningComment") ? "" : jSONObject.getString("returningComment"));
                                    JSONArray requestArray = jSONObject.getJSONArray("transferOrderLines");
                                    for (int j = 0; j < requestArray.length(); ++j) {
                                        JSONObject jsono = requestArray.getJSONObject(j);
                                        RequestItem requestItem = new RequestItem(SyncData.this.da);
                                        requestItem.setRequestCode(jsono.isNull("requestCode") ? "" : request.getCode());
                                        requestItem.setQuantity(jsono.isNull("quantityTransfer") ? 0 : jsono.getInt("quantityTransfer"));
                                        requestItem.setLineNumber(jsono.isNull("lineNumber") ? "" : jsono.getString("lineNumber"));
                                        requestItem.setReleasedQuantity(jsono.isNull("releasedQuantity") ? 0 : jsono.getInt("releasedQuantity"));
                                        requestItem.setItemCode(jsono.isNull("itemId") ? "" : jsono.getString("itemId"));
                                        requestItem.setItemName(jsono.isNull("itemName") ? "" : jsono.getString("itemName"));
                                        requestItem.setToStoreInitQty(jsono.isNull("toStoreInitQty") ? 0 : jsono.getInt("toStoreInitQty"));
                                        requestItem.setApprovedQty(jsono.isNull("approvedQty") ? 0 : jsono.getInt("approvedQty"));
                                        requestItem.setAcceptedQty(jsono.isNull("acceptedQty") ? 0 : jsono.getInt("acceptedQty"));
                                        requestItem.setReturnedQty(jsono.isNull("returnedQty") ? 0 : jsono.getInt("returnedQty"));
                                        requestItem.setCode(jsono.isNull("code") ? "" : jsono.getString("code"));
                                        if (request.getItems().stream().filter(prdct -> prdct.getItemCode().equals(requestItem.getItemCode())).count() != 0L) continue;
                                        request.getItems().add((Object)requestItem);
                                    }
                                    requestDataList.getOriginalList().add((Object)request);
                                }
                                if (save) {
                                    requestDataList.getOriginalList().forEach(t -> {
                                        RequestDataList requestDataList1 = new RequestDataList(SyncData.this.da);
                                        requestDataList1.selectAll("Select * From Request where Code=? or Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, t.tempCode), new ParameterValue("Code", JDBCType.VARCHAR, t.getCode())});
                                        if (requestDataList1.getOriginalList().size() > 0) {
                                            if (t.isDeleted) {
                                                t.setState(ObjectState.Removed);
                                            } else {
                                                try {
                                                    StockItemList.deleteAll("Delete From Request where Code=? or Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, t.tempCode), new ParameterValue("Code", JDBCType.VARCHAR, t.getCode())}, SyncData.this.da);
                                                    t.getItems().forEach(item -> {
                                                        try {
                                                            StockItemList.deleteAll("Delete From RequestItem where requestCode=?", new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, t.getCode())}, SyncData.this.da);
                                                        }
                                                        catch (Exception ex) {
                                                            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                                                        }
                                                    });
                                                }
                                                catch (Exception ex) {
                                                    Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                                                    if (callback != null) {
                                                        Platform.runLater(() -> callback.onError(ex.getMessage()));
                                                    }
                                                    lg.setDateLog(new Date());
                                                    lg.setMsg(ex.getMessage());
                                                    lg.setStatus("Failure");
                                                }
                                            }
                                        }
                                    });
                                    if (!requestDataList.getOriginalList().isEmpty()) {
                                        SyncData.this.da.start();
                                        requestDataList.update();
                                        RequestItemDataList requestItemDataList = new RequestItemDataList(SyncData.this.da);
                                        requestDataList.getOriginalList().forEach(v -> {
                                            if (!v.isDeleted) {
                                                requestItemDataList.getOriginalList().addAll(v.getItems());
                                            }
                                        });
                                        requestItemDataList.update();
                                        SyncSettingDataList sdl = new SyncSettingDataList(SyncData.this.da);
                                        syncSet.setTransferLastDateRead(new Timestamp(new Date().getTime()));
                                        sdl.getOriginalList().add((Object)syncSet);
                                        sdl.update();
                                        SyncData.this.da.end();
                                    }
                                }
                                if (callback != null) {
                                    Platform.runLater(() -> callback.onSuccess(requestDataList.getOriginalList()));
                                } else {
                                    lg.setDateLog(new Date());
                                    lg.setMsg(requestDataList.getOriginalList().size() + "Transfer Request Read");
                                    lg.setStatus("Success");
                                    Platform.runLater(() -> SyncData.this.app.mainpage.showNotification(NotificationType.Information, requestDataList.getOriginalList().size() + " Transfer request(s) needs your attention", null));
                                }
                            } else if (callback != null) {
                                Platform.runLater(() -> callback.onSuccess(requestDataList.getOriginalList()));
                            } else {
                                lg.setDateLog(new Date());
                                lg.setMsg("0 Transfer request read");
                                lg.setStatus("Success");
                            }
                        }
                        catch (Exception ex) {
                            if (callback != null) {
                                Platform.runLater(() -> callback.onError(ex.getMessage()));
                            } else {
                                lg.setDateLog(new Date());
                                lg.setMsg(ex.getMessage());
                                lg.setStatus("Failure");
                            }
                            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }

                    @Override
                    public void onError(String data) {
                        if (callback != null) {
                            Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
                        } else {
                            lg.setDateLog(new Date());
                            lg.setMsg(data);
                            lg.setStatus("Failure");
                        }
                    }

                    @Override
                    public void onTimeOut(String data) {
                        if (callback != null) {
                            Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
                        } else {
                            lg.setDateLog(new Date());
                            lg.setMsg(data);
                            lg.setStatus("Failure");
                        }
                    }
                }).execute(false);
            }
            catch (Exception ex) {
                if (callback != null) {
                    Platform.runLater(() -> callback.onError(ex.getMessage()));
                }
                lg.setDateLog(new Date());
                lg.setMsg(ex.getMessage());
                lg.setStatus("Failure");
            }
        }
        return lg;
    }

    public void getSale(String url, final DataAccess dac, final ISaleCallBack callback) {
        try {
            StringBuilder sbNotification = new StringBuilder();
            new WebRequest(url, RequestTypeEnum.GET, null, null, new IWebCallBack(){

                @Override
                public void onSuccess(String data) {
                    try {
                        SaleList toSaveSaleList = new SaleList(dac);
                        JSONArray arr = new JSONArray(data);
                        if (arr.length() > 0) {
                            for (int saa = 0; saa < arr.length(); ++saa) {
                                String t;
                                int p;
                                JSONObject saleJSONObject = arr.getJSONObject(saa);
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                int invoice = saleJSONObject.getInt("invoiceNumber");
                                Sale s = new Sale(dac);
                                s.setCreditToken(saleJSONObject.isNull("creditToken") ? "" : saleJSONObject.getString("creditToken"));
                                s.setCreditDescription(saleJSONObject.isNull("creditDescription") ? "" : saleJSONObject.getString("creditDescription"));
                                s.setCustomerName(saleJSONObject.isNull("customerName") ? "" : saleJSONObject.getString("customerName"));
                                s.setCustomerEmail(saleJSONObject.isNull("customerEmail") ? "" : saleJSONObject.getString("customerEmail"));
                                s.setD365CustomerNo(saleJSONObject.isNull("customerAccount") ? "" : saleJSONObject.getString("customerAccount"));
                                s.setCustomerPhoneNumber(saleJSONObject.getString("customerPhone"));
                                s.setStoreCode(saleJSONObject.getString("storeId").trim());
                                s.setInvoiceNumber(invoice);
                                s.setHdInvoiceNo(saleJSONObject.getString("invoiceNumber"));
                                s.setSaleId(saleJSONObject.isNull("salesId") ? "" : saleJSONObject.getString("salesId"));
                                s.setActionComment(saleJSONObject.getString("salesComment"));
                                s.storeName = saleJSONObject.getString("storeName");
                                s.setSaleStaffResponsible(saleJSONObject.getString("soldBy"));
                                s.setSalesRep(saleJSONObject.isNull("salesResponsible") ? "" : saleJSONObject.getString("salesResponsible"));
                                Date dt = df.parse(saleJSONObject.getString("createdAt"));
                                s.setTransactionDate(new Timestamp(dt.getTime()));
                                s.setIsManual(saleJSONObject.getBoolean("isManualSale"));
                                s.setSaleComment(saleJSONObject.getString("salesComment"));
                                s.setSalesChannel(saleJSONObject.getString("salesChannel"));
                                s.setTotalAmount(saleJSONObject.getDouble("totalAmount"));
                                s.setAmountPaid(saleJSONObject.getDouble("totalAmount"));
                                s.setPaymentTerm(saleJSONObject.isNull("paymentTerms") ? "" : saleJSONObject.getString("paymentTerms"));
                                s.setPaymentTermDescription(saleJSONObject.isNull("paymentTermsDescription") ? "" : saleJSONObject.getString("paymentTermsDescription"));
                                s.setParentCompany(SyncData.this.companyName);
                                s.setSaleStatus(saleJSONObject.isNull("salesOrderStatus") ? SaleStatus.PENDING.name() : saleJSONObject.getString("salesOrderStatus"));
                                if (s.getManualSaleStatus().equals(ManualPendingStatus.Created.name())) {
                                    s.setManualSaleStatus(ManualPendingStatus.Pending.name());
                                }
                                s.setSyncError(saleJSONObject.isNull("syncError") ? "" : saleJSONObject.getString("syncError"));
                                s.setReturnApprovals(saleJSONObject.isNull("returnApprovedBy") ? "" : SyncData.this.JsonArrayToString(saleJSONObject.getJSONArray("returnApprovedBy")));
                                s.setReturnRejectedBy(saleJSONObject.isNull("returnRejectedBy") ? "" : SyncData.this.JsonArrayToString(saleJSONObject.getJSONArray("returnRejectedBy")));
                                s.setReturnComment(saleJSONObject.isNull("returnComment") ? "" : saleJSONObject.getString("returnComment"));
                                s.setReturnedBy(saleJSONObject.isNull("returnedBy") ? "" : saleJSONObject.getString("returnedBy"));
                                if (!saleJSONObject.isNull("salesOrderStatus")) {
                                    if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.COMPLETED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.CANCELLED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.DELETED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.RETURNED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.RETURNAPPROVED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.PENDINGRETURN.name())) {
                                        if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.CANCELLED.name())) {
                                            s.setManualSaleStatus(ManualPendingStatus.Declined.name());
                                        }
                                        if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.COMPLETED.name())) {
                                            s.setManualSaleStatus(ManualPendingStatus.Completed.name());
                                        }
                                        s.setSyncFlag(true);
                                    } else if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.APPROVED.name().toUpperCase())) {
                                        s.setManualSaleStatus(ManualPendingStatus.Approved.name());
                                    } else if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.PENDING.name().toUpperCase()) && !s.getSaleId().isEmpty()) {
                                        s.setManualSaleStatus(ManualPendingStatus.Completed.name());
                                    }
                                }
                                s.setSyncError(saleJSONObject.isNull("syncError") ? "" : saleJSONObject.getString("syncError"));
                                if (s.getManualSaleStatus().equals(ManualPendingStatus.Created.name())) {
                                    s.setManualSaleStatus(ManualPendingStatus.Pending.name());
                                }
                                if (!saleJSONObject.isNull("salesApprovedBy") && saleJSONObject.getJSONArray("salesApprovedBy").length() > 0) {
                                    Object approvals = "";
                                    for (p = 0; p < saleJSONObject.getJSONArray("salesApprovedBy").length(); ++p) {
                                        t = saleJSONObject.getJSONArray("salesApprovedBy").getString(p).toString();
                                        approvals = p == 0 ? t : (String)approvals + "," + t;
                                    }
                                    if (!s.getApprovals().equals(approvals)) {
                                        s.setApprovals((String)approvals);
                                    }
                                }
                                if (!saleJSONObject.isNull("salesRejectedBy") && saleJSONObject.getJSONArray("salesRejectedBy").length() > 0) {
                                    Object rejects = "";
                                    for (p = 0; p < saleJSONObject.getJSONArray("salesRejectedBy").length(); ++p) {
                                        t = saleJSONObject.getJSONArray("salesRejectedBy").getString(p).toString();
                                        rejects = p == 0 ? t : (String)rejects + "," + t;
                                    }
                                    if (!s.getSalesRejectedBy().equals(rejects)) {
                                        s.setSalesRejectedBy((String)rejects);
                                    }
                                }
                                JSONArray salelines = saleJSONObject.getJSONArray("salesOrderLines");
                                for (int j = 0; j < salelines.length(); ++j) {
                                    JSONObject sljson = salelines.getJSONObject(j);
                                    SaleItem sl = new SaleItem();
                                    sl.setParentSale(s);
                                    sl.setItemCode(sljson.getString("itemId"));
                                    sl.setItemName(sljson.getString("itemName"));
                                    sl.setQuantity(sljson.getInt("quantity"));
                                    sl.setSellingPrice(sljson.getDouble("price"));
                                    if (s.getSaleStatus().equals(SaleStatus.RETURNED.name())) {
                                        sl.setReturnQty(sljson.isNull("returnQty") ? 0.0f : (float)sljson.getInt("returnQty"));
                                    }
                                    sl.setVariablePrice(sljson.getDouble("priceSold"));
                                    sl.setCostPrice(sljson.getDouble("costPrice"));
                                    sl.setLineStatus(sljson.isNull("lineStatus") ? "" : sljson.getString("lineStatus"));
                                    sl.setState(ObjectState.Changed);
                                    s.getSaleItemsList().add((Object)sl);
                                }
                                JSONArray payments = saleJSONObject.getJSONArray("paymentDetails");
                                for (int j = 0; j < payments.length(); ++j) {
                                    JSONObject payjson = payments.getJSONObject(j);
                                    SaleAccountDetailResolver acr = new SaleAccountDetailResolver(dac);
                                    acr.setAmountPaid(payjson.getDouble("amountPaid"));
                                    acr.setAccountName(payjson.getString("accountName"));
                                    acr.setAccType(payjson.getString("accountType"));
                                    acr.setInvoiceNumber(payjson.getInt("invoiceNumber"));
                                    acr.setAccNumber(payjson.getString("accountNumber"));
                                    acr.StoreName = payjson.getString("storeId");
                                    acr.setPaymentCode(payjson.isNull("chequeNumber") ? "" : payjson.getString("chequeNumber"));
                                    acr.setState(ObjectState.Changed);
                                    s.getSaleAccountDetailResolvers().add((Object)acr);
                                }
                                toSaveSaleList.getOriginalList().add((Object)s);
                            }
                        }
                        Platform.runLater(() -> callback.onSuccess(toSaveSaleList));
                    }
                    catch (Exception ex) {
                        Platform.runLater(() -> callback.onError(ex.getMessage()));
                    }
                }

                @Override
                public void onError(String data) {
                    Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
                }

                @Override
                public void onTimeOut(String data) {
                    Platform.runLater(() -> callback.onError(SyncData.READTIMEOUT_ERROR));
                }
            }).execute(false);
        }
        catch (Exception ex) {
            callback.onError("Sale Error \n" + ex.getMessage());
        }
    }

    public Log pushSales(SyncSetting syncSet, final Sale sale, String url, final IWebCallBack callback) {
        Log lg = new Log(this.da);
        SyncSettingDataList sdl = new SyncSettingDataList(this.da);
        final SaleList cdl = new SaleList(this.da);
        final StringBuilder sb = new StringBuilder();
        final StringBuilder sbError = new StringBuilder();
        final StringBuilder sbNotification = new StringBuilder();
        ArrayList<FileBodyPart> files = null;
        if (sale != null) {
            cdl.getOriginalList().add((Object)sale);
        } else {
            cdl.selectAllFull("select * from Sale where syncflag = 0 and manualSaleStatus =? order by transactionDate asc", new ParameterValue[]{new ParameterValue("manualSaleStatus", JDBCType.VARCHAR, ManualPendingStatus.Completed.name())});
        }
        try {
            if (cdl.getOriginalList().size() > 0) {
                List<NameValueObject> dimensions = StockItemList.selectAllNameValue(this.da, "SalesDimension", "Code", "Stream", "Name");
                final List<SaleList> tranches = SyncData.split(cdl.getOriginalList(), 10, this.da);
                this.saleSynced = false;
                for (SaleList sl : tranches) {
                    JSONArray jSONArray = new JSONArray();
                    for (Sale sa : sl.getOriginalList()) {
                        String[] splits;
                        JSONArray appArray;
                        JSONObject param = new JSONObject();
                        NameValueObject BU = dimensions.stream().filter(prdct -> prdct.getData().equals(sa.getSalesChannel()) && prdct.getType().equals(NameValueObjectType.BusinessUnit.name())).findAny().orElse(null);
                        NameValueObject BS = dimensions.stream().filter(prdct -> prdct.getData().equals(sa.getSalesChannel()) && prdct.getType().equals(NameValueObjectType.BusinessStream.name())).findAny().orElse(null);
                        NameValueObject CC = dimensions.stream().filter(prdct -> prdct.getData().equals(sa.getSalesChannel()) && prdct.getType().equals(NameValueObjectType.CostCentre.name())).findAny().orElse(null);
                        if (BU != null) {
                            param.put("businessUnit", (Object)BU.getKey());
                        }
                        if (BS != null) {
                            param.put("businessStream", (Object)BS.getKey());
                        }
                        if (CC != null) {
                            param.put("costCenter", (Object)CC.getKey());
                        }
                        if (sa.img.size() > 0) {
                            // empty if block
                        }
                        param.put("paymentTerms", (Object)sa.getPaymentTerm());
                        param.put("paymentTermsDescription", (Object)sa.getPaymentTermDescription());
                        param.put("invoiceNumber", (Object)sa.getHdInvoiceNo());
                        param.put("customerName", (Object)sa.getCustomerName());
                        param.put("customerEmail", (Object)sa.getCustomerEmail());
                        if (sa.getd365CustomerNo().length() < 20) {
                            param.put("customerAccount", (Object)sa.getd365CustomerNo());
                        }
                        param.put("creditToken", (Object)sa.getCreditToken());
                        param.put("creditDescription", (Object)sa.getCreditDescription());
                        param.put("customerPhone", (Object)sa.getCustomerPhoneNumber());
                        param.put("hubLocationCode", (Object)(this.companyName.getHubLocationCode().isEmpty() ? sa.getStoreCode().trim() : this.companyName.getHubLocationCode().trim()));
                        param.put("storeId", (Object)(sa.getStoreCode().isEmpty() ? this.companyName.getStoreCode().trim() : sa.getStoreCode().trim()));
                        param.put("salesId", (Object)sa.getSaleId());
                        param.put("comment", (Object)sa.getActionComment());
                        param.put("storeName", (Object)(sa.getStoreCode().isEmpty() ? this.companyName.getStoreCode() : sa.getStoreCode()));
                        param.put("soldBy", (Object)sa.getSaleStaffResponsible());
                        param.put("salesResponsible", (Object)sa.getSalesRep());
                        param.put("createdAt", (Object)sa.getTransactionDate());
                        param.put("isManualSale", (Object)sa.getIsManual());
                        param.put("salesComment", (Object)sa.getSaleComment());
                        param.put("salesChannel", (Object)sa.getSalesChannel());
                        param.put("totalAmount", sa.getAmountPaid());
                        if (sa.getApprovals() != null && !sa.getApprovals().isEmpty()) {
                            appArray = new JSONArray();
                            splits = sa.getApprovals().split(",");
                            for (String split : splits) {
                                appArray.put((Object)split);
                            }
                            param.put("salesApprovedBy", (Object)appArray);
                        }
                        if (sa.getSalesRejectedBy() != null && !sa.getSalesRejectedBy().isEmpty()) {
                            appArray = new JSONArray();
                            splits = sa.getSalesRejectedBy().split(",");
                            for (String split : splits) {
                                appArray.put((Object)split);
                            }
                            param.put("salesRejectedBy", (Object)appArray);
                        }
                        JSONArray jsObjectArray = new JSONArray();
                        for (SaleItem item : sa.getSaleItemsList()) {
                            JSONObject jsItem = new JSONObject();
                            jsItem.put("itemId", (Object)item.getItemCode());
                            jsItem.put("quantity", item.getTotalQty());
                            jsItem.put("price", item.getSellingPrice());
                            jsItem.put("priceSold", item.getVariablePrice());
                            jsItem.put("costPrice", item.getCostPrice());
                            jsItem.put("itemName", (Object)item.getItemName());
                            JSONArray jaArraySerial = new JSONArray();
                            if (item.getDbAccess() == null) {
                                item.setDbAccess(this.da);
                            }
                            item.loadSerials();
                            item.getSerials().getOriginalList().forEach(v -> {
                                try {
                                    JSONObject jSONObject = new JSONObject();
                                    jSONObject.put("itemId", (Object)v.getItemCode());
                                    jSONObject.put("serial", (Object)v.getSerial());
                                    jaArraySerial.put((Object)jSONObject);
                                }
                                catch (JSONException ex) {
                                    Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            jsItem.put("serials", (Object)jaArraySerial);
                            jsObjectArray.put((Object)jsItem);
                        }
                        param.put("salesOrderLines", (Object)jsObjectArray);
                        JSONArray payementArray = new JSONArray();
                        Iterator iterator = (sa.getSaleAccountDetailResolvers().size() > 0 ? sa.getSaleAccountDetailResolvers() : sa.getPayments().getOriginalList()).iterator();
                        while (iterator.hasNext()) {
                            SaleAccountDetailResolver sadr = (SaleAccountDetailResolver)iterator.next();
                            JSONObject jSONObject = new JSONObject();
                            jSONObject.put("accountNumber", (Object)sadr.getAccNumber());
                            jSONObject.put("amountPaid", sadr.getAmountPaid());
                            jSONObject.put("accountType", (Object)sadr.getAccType());
                            jSONObject.put("accountName", (Object)sadr.getAccountName());
                            jSONObject.put("invoiceNumber", (Object)sa.getHdInvoiceNo());
                            jSONObject.put("chequeNumber", (Object)sadr.getPaymentCode());
                            jSONObject.put("storeId", (Object)(sa.getStoreCode().isEmpty() ? this.companyName.getStoreCode() : sa.getStoreCode()));
                            payementArray.put((Object)jSONObject);
                        }
                        param.put("paymentDetails", (Object)payementArray);
                        jSONArray.put((Object)param);
                    }
                    new WebRequest(url, RequestTypeEnum.POST, jSONArray.toString(), files, new IWebCallBack(){

                        @Override
                        public void onSuccess(String data) {
                            try {
                                SaleList toSaveSaleList = new SaleList(SyncData.this.da);
                                SaleItemList toSaveSaleLines = new SaleItemList(SyncData.this.da);
                                CustomerDataList toCustomerList = new CustomerDataList(SyncData.this.da);
                                JSONArray res = new JSONArray(data);
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                for (int i = 0; i < res.length(); ++i) {
                                    String t;
                                    String str;
                                    JSONObject saleJSONObject = res.getJSONObject(i);
                                    String invoice = saleJSONObject.getString("invoiceNumber");
                                    Sale s = cdl.getOriginalList().stream().filter(sa -> sa.getHdInvoiceNo().equals(invoice)).findAny().orElse(null);
                                    s.setCustomerName(saleJSONObject.getString("customerName"));
                                    s.setCustomerEmail(saleJSONObject.isNull("customerEmail") ? "" : saleJSONObject.getString("customerEmail"));
                                    s.setCustomerPhoneNumber(saleJSONObject.getString("customerPhone"));
                                    if (s.getd365CustomerNo().length() > 20) {
                                        CustomerDataList cus = new CustomerDataList(SyncData.this.da);
                                        cus.selectAll("Select * from Customer where d365Code=?", new ParameterValue[]{new ParameterValue("d365Code", JDBCType.VARCHAR, s.getd365CustomerNo())});
                                        if (cus.getOriginalList().size() > 0) {
                                            Customer localCus = (Customer)cus.getOriginalList().get(0);
                                            localCus.setName(s.getCustomerName());
                                            localCus.setPhoneNumber(s.getCustomerPhoneNumber());
                                            localCus.setEmail(s.getCustomerEmail());
                                            localCus.setD365Code(saleJSONObject.getString("customerAccount"));
                                            toCustomerList.getOriginalList().add((Object)localCus);
                                        }
                                    }
                                    s.setPaymentTerm(saleJSONObject.isNull("paymentTerms") ? "" : saleJSONObject.getString("paymentTerms"));
                                    s.setPaymentTermDescription(saleJSONObject.isNull("paymentTermsDescription") ? "" : saleJSONObject.getString("paymentTermsDescription"));
                                    s.setD365CustomerNo(saleJSONObject.isNull("customerAccount") ? "" : saleJSONObject.getString("customerAccount"));
                                    s.setCreditToken(saleJSONObject.isNull("creditToken") ? "" : saleJSONObject.getString("creditToken"));
                                    s.setCreditDescription(saleJSONObject.isNull("creditDescription") ? "" : saleJSONObject.getString("creditDescription"));
                                    s.setCustomerPhoneNumber(saleJSONObject.getString("customerPhone"));
                                    s.setStoreCode(saleJSONObject.getString("storeId"));
                                    s.setInvoiceNumber(saleJSONObject.getInt("invoiceNumber"));
                                    s.setHdInvoiceNo(saleJSONObject.getString("invoiceNumber"));
                                    s.setSaleId(saleJSONObject.isNull("salesId") ? "" : saleJSONObject.getString("salesId"));
                                    s.setActionComment(saleJSONObject.getString("salesComment"));
                                    s.storeName = saleJSONObject.getString("salesComment");
                                    s.setSaleStaffResponsible(saleJSONObject.getString("soldBy"));
                                    s.setSalesRep(saleJSONObject.isNull("salesResponsible") ? "" : saleJSONObject.getString("salesResponsible"));
                                    Date dt = df.parse(saleJSONObject.getString("createdAt"));
                                    s.setIsManual(saleJSONObject.getBoolean("isManualSale"));
                                    s.setSaleComment(saleJSONObject.getString("salesComment"));
                                    s.setSalesChannel(saleJSONObject.getString("salesChannel"));
                                    s.setSaleComment(saleJSONObject.getString("salesComment"));
                                    s.setTotalAmount(saleJSONObject.getDouble("totalAmount"));
                                    s.setAmountPaid(saleJSONObject.getDouble("totalAmount"));
                                    s.setParentCompany(SyncData.this.companyName);
                                    s.setSaleStatus(saleJSONObject.isNull("salesOrderStatus") ? SaleStatus.PENDING.name() : saleJSONObject.getString("salesOrderStatus"));
                                    if (!saleJSONObject.isNull("returnApprovedBy")) {
                                        str = SyncData.this.JsonArrayToString(saleJSONObject.getJSONArray("returnApprovedBy"));
                                        if (!s.getReturnApprovals().equals(str)) {
                                            sbNotification.append("Manual Sale with invoice Number " + invoice + " needs your attention");
                                            sbNotification.append("\n ");
                                        }
                                        s.setReturnApprovals(str);
                                    }
                                    if (!saleJSONObject.isNull("returnRejectedBy")) {
                                        str = SyncData.this.JsonArrayToString(saleJSONObject.getJSONArray("returnRejectedBy"));
                                        if (!s.getReturnRejectedBy().equals(str)) {
                                            sbNotification.append("Manual Sale with invoice Number " + invoice + " needs your attention");
                                            sbNotification.append("\n ");
                                        }
                                        s.setReturnRejectedBy(str);
                                    }
                                    s.setReturnComment(saleJSONObject.isNull("returnComment") ? "" : saleJSONObject.getString("returnComment"));
                                    s.setReturnedBy(saleJSONObject.isNull("returnedBy") ? "" : saleJSONObject.getString("returnedBy"));
                                    if (!saleJSONObject.isNull("salesApprovedBy") && saleJSONObject.getJSONArray("salesApprovedBy").length() > 0) {
                                        Object approvals = "";
                                        for (int p = 0; p < saleJSONObject.getJSONArray("salesApprovedBy").length(); ++p) {
                                            t = saleJSONObject.getJSONArray("salesApprovedBy").getString(p).toString();
                                            approvals = p == 0 ? t : (String)approvals + "," + t;
                                        }
                                        if (!s.getApprovals().equals(approvals)) {
                                            sbNotification.append("Manual Sale with invoice Number " + invoice + " needs your attention");
                                            sbNotification.append("\n ");
                                            s.setApprovals((String)approvals);
                                        }
                                    }
                                    if (!saleJSONObject.isNull("salesRejectedBy") && saleJSONObject.getJSONArray("salesRejectedBy").length() > 0) {
                                        Object rejects = "";
                                        for (int p = 0; p < saleJSONObject.getJSONArray("salesRejectedBy").length(); ++p) {
                                            t = saleJSONObject.getJSONArray("salesRejectedBy").getString(p).toString();
                                            rejects = p == 0 ? t : (String)rejects + "," + t;
                                        }
                                        if (!s.getSalesRejectedBy().equals(rejects)) {
                                            sbNotification.append("Manual Sale with invoice Number " + invoice + " needs your attention");
                                            sbNotification.append("\n ");
                                            s.setSalesRejectedBy((String)rejects);
                                        }
                                    }
                                    if (!saleJSONObject.isNull("salesOrderStatus")) {
                                        if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.COMPLETED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.CANCELLED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.DELETED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.RETURNED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.RETURNAPPROVED.name()) || saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.PENDINGRETURN.name())) {
                                            if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.CANCELLED.name())) {
                                                s.setManualSaleStatus(ManualPendingStatus.Declined.name());
                                            }
                                            if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.COMPLETED.name())) {
                                                s.setManualSaleStatus(ManualPendingStatus.Completed.name());
                                            }
                                            s.setSyncFlag(true);
                                        } else if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.APPROVED.name().toUpperCase())) {
                                            s.setManualSaleStatus(ManualPendingStatus.Approved.name());
                                        } else if (saleJSONObject.getString("salesOrderStatus").equals(SaleStatus.PENDING.name().toUpperCase()) && !s.getSaleId().isEmpty()) {
                                            s.setManualSaleStatus(ManualPendingStatus.Completed.name());
                                        }
                                    }
                                    s.setSyncError(saleJSONObject.isNull("syncError") ? "" : saleJSONObject.getString("syncError"));
                                    if (s.getManualSaleStatus().equals(ManualPendingStatus.Created.name())) {
                                        s.setManualSaleStatus(ManualPendingStatus.Pending.name());
                                    }
                                    JSONArray linesJson = saleJSONObject.getJSONArray("salesOrderLines");
                                    for (int j = 0; j < linesJson.length(); ++j) {
                                        JSONObject lineJ = linesJson.getJSONObject(j);
                                        String itemCodeLine = lineJ.getString("itemId");
                                        SaleItem lineItem = s.getSaleItemsList().stream().filter(prdct -> prdct.getItemCode().equals(itemCodeLine)).findAny().orElse(null);
                                        if (lineItem == null) continue;
                                        lineItem.setLineStatus(lineJ.isNull("lineStatus") ? "" : lineJ.getString("lineStatus"));
                                        if (s.getSaleStatus().equals(SaleStatus.RETURNED.name())) {
                                            lineItem.setReturnQty(lineJ.isNull("returnQty") ? 0.0f : (float)lineJ.getInt("returnQty"));
                                        }
                                        toSaveSaleLines.getOriginalList().add((Object)lineItem);
                                    }
                                    toSaveSaleList.getOriginalList().add((Object)s);
                                }
                                toCustomerList.update();
                                if (sbNotification.length() > 0) {
                                    Platform.runLater(() -> SyncData.this.app.mainpage.showNotification(NotificationType.Information, sbNotification.toString(), null));
                                }
                                if (callback != null) {
                                    if (sale == null) {
                                        toSaveSaleList.update();
                                        toSaveSaleLines.update();
                                    }
                                    Platform.runLater(() -> callback.onSuccess("Saved"));
                                    return;
                                }
                                toSaveSaleList.update();
                                toSaveSaleLines.update();
                                sb.append(toSaveSaleList.getOriginalList().size() + "Sale(s) pushed and saved out of " + cdl.getOriginalList().size());
                                sb.append("\n ");
                                SyncData.this.app.mainpage.updateSalesList(new ArrayList<Sale>((Collection<Sale>)toSaveSaleList.getOriginalList()));
                            }
                            catch (Exception ex) {
                                if (callback != null) {
                                    Platform.runLater(() -> callback.onError(tranches.size() + "Sale(s) pushed and but unable to save with error: " + ex.getMessage()));
                                    return;
                                }
                                System.err.println(ex.getMessage());
                                sbError.append(tranches.size() + "Sale(s) pushed and but unable to save with error: " + ex.getMessage());
                                sb.append("\n ");
                            }
                        }

                        @Override
                        public void onError(String data) {
                            if (callback != null) {
                                Platform.runLater(() -> callback.onError(data.equals("Read timed out") ? SyncData.READTIMEOUT_ERROR : data));
                                return;
                            }
                            sbError.append(tranches.size() + "Sale(s) unable to push with error:" + data);
                            sb.append("\n ");
                        }

                        @Override
                        public void onTimeOut(String data) {
                            if (callback != null) {
                                callback.onError(tranches.size() + "Sale(s) unable to push with error: Timeout");
                                return;
                            }
                            sbError.append(tranches.size() + "Sale(s) unable to push with error: Timeout");
                            sb.append("\n ");
                        }
                    }).execute(false);
                }
                lg.setDateLog(new Date());
                lg.setMsg((String)(!sbError.toString().isEmpty() ? "Sale Error \n" + sbError.toString() : ""));
                lg.setMsg((String)(!sb.toString().isEmpty() ? lg.getmsg() + "\n" + sb.toString() : lg.getmsg()));
                lg.setStatus(sbError.toString().isEmpty() ? "Success" : "Failure");
                this.saleSynced = true;
            } else if (callback != null) {
                Platform.runLater(() -> callback.onSuccess("Done"));
            } else {
                lg.setDateLog(new Date());
                lg.setStatus("Success");
                lg.setMsg("0 sale pushed to D365");
            }
        }
        catch (Exception ex) {
            if (callback != null) {
                Platform.runLater(() -> callback.onError("Sale Error \n" + sb.toString()));
            }
            lg.setDateLog(new Date());
            lg.setMsg("Sale Error \n" + sb.toString());
            lg.setMsg((String)(!sbError.toString().isEmpty() ? lg.getmsg() + "\n" + sbError.toString() : lg.getmsg()));
            lg.setMsg((String)(!sb.toString().isEmpty() ? lg.getmsg() + "\n" + sb.toString() : lg.getmsg()));
            lg.setStatus("Failure");
        }
        syncSet.setSaleDateLastSync(new Timestamp(new Date().getTime()));
        sdl.getOriginalList().add((Object)syncSet);
        try {
            sdl.update();
        }
        catch (Exception ex) {
            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
        }
        return lg;
    }

    private Log pushPaymentBatch(SyncSetting syncSet) {
        Log lg = new Log(this.da);
        SyncSettingDataList sdl = new SyncSettingDataList(this.da);
        String payload = "";
        try {
            List<PaymentBatch> list = PaymentBatchDataList.selectAllPendingPostingPaymentBaqtch(this.da);
            StringBuilder sb = new StringBuilder();
            syncSet.setSaleDateLastSync(new Timestamp(new Date().getTime()));
            sdl.getOriginalList().add((Object)syncSet);
            Object url = syncSet.getBEURL();
            url = (String)url + "RBatchPayment/CreateBatchPayment";
            if (list.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (PaymentBatch payBatch : list) {
                    JSONObject job = new JSONObject();
                    job.put("Code", (Object)payBatch.getBatchCode());
                    job.put("BatchUser", (Object)payBatch.getBatchUser());
                    job.put("Status", (Object)payBatch.getStatus());
                    job.put("StoreCode", (Object)payBatch.getStore());
                    job.put("TellerNo", (Object)payBatch.getTellerNo());
                    job.put("TotalAmount", payBatch.getAmount());
                    job.put("AmountDeposited", payBatch.getAmountDeposited());
                    job.put("DateCreated", (Object)payBatch.getDateCreated());
                    job.put("Bank", (Object)payBatch.getBankName());
                    job.put("BankAccount", (Object)payBatch.getAccountNo());
                    job.put("Comment", (Object)payBatch.getRemark());
                    job.put("AuditStatus", (Object)(payBatch.getAmountDeposited() != payBatch.getAmount() ? "Failed" : "Pending"));
                    JSONArray sales = new JSONArray();
                    for (BatchSale batchSale : payBatch.getBatchSales()) {
                        JSONObject jsono = new JSONObject();
                        jsono.put("InvoiceNumber", (Object)batchSale.getInvoiceNumber());
                        jsono.put("SalesChannel", (Object)batchSale.getSalesChannel());
                        jsono.put("CashAmount", batchSale.getAmount());
                        jsono.put("BalanceNotCash", batchSale.getAmountNotCash());
                        sales.put((Object)jsono);
                    }
                    job.put("Sales", (Object)sales);
                    jSONArray.put((Object)job);
                }
                HttpPost httpPost = new HttpPost((String)url);
                RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                StringEntity stringEntity = new StringEntity(jSONArray.toString());
                httpPost.setEntity((HttpEntity)stringEntity);
                httpPost.setHeader("Content-type", "application/json");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                    PaymentBatchDataList payDataList = new PaymentBatchDataList(this.da);
                    list.forEach(val -> {
                        val.setSyncFlag(true);
                        val.setSyncError("");
                        val.setStatus(BatchStatusEnum.Posted.name());
                        payDataList.getOriginalList().add(val);
                    });
                    payDataList.update();
                } else {
                    String output;
                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((output = br.readLine()) != null) {
                        System.out.println(output);
                        stringBuilder.append(output + "\n");
                    }
                    br.close();
                    String fullError = stringBuilder.toString();
                    sb.append(fullError);
                }
                if (sb.toString().isEmpty()) {
                    lg.setDateLog(new Date());
                    lg.setMsg(list.size() + " Payment Batch  Synchronized with SAP");
                    lg.setStatus("Success");
                    sdl.update();
                } else {
                    lg.setDateLog(new Date());
                    lg.setMsg("Payment Batch Error \n" + sb.toString());
                    this.app.logError(sb.toString() + " \n" + payload);
                    lg.setStatus("Failure");
                    sdl.update();
                }
            } else {
                lg.setDateLog(new Date());
                this.app.logError(payload);
                lg.setMsg("0 Payment Batch Synchronized with SAP");
                lg.setStatus("Success");
                sdl.update();
            }
        }
        catch (Exception ex) {
            lg.setDateLog(new Date());
            lg.setMsg("Payment Batch: " + ex.getMessage());
            this.app.logError(ex.getMessage() + " \n" + payload);
            lg.setStatus("Failure");
        }
        return lg;
    }

    private Log getSalesChannel(SyncSetting syncSet) {
        Log lg = new Log(this.da);
        ArrayList<NameValueObject> list = new ArrayList<NameValueObject>();
        Object url = syncSet.getBEURL();
        url = (String)url + "RMIsc/GetChannels";
        try {
            HttpGet httpGet = new HttpGet((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        NameValueObject stkData = new NameValueObject(this.da);
                        stkData.setKey(jo.isNull("Name") ? "" : jo.getString("Name"));
                        stkData.setData(jo.isNull("Code") ? "" : jo.getString("Code"));
                        list.add(stkData);
                    }
                    StockItemList.deleteAll("SaleChannel", this.da);
                    StockItemList.insertChannels(list, this.da);
                    this.objectDb.setLastSalesChannel(new Date());
                    lg.setDateLog(new Date());
                    lg.setMsg(Integer.toString(list.size()) + " Sales Channels Loaded from SAP");
                    lg.setStatus("Success");
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                lg.setDateLog(new Date());
                lg.setMsg(fullError + "\r\n" + fullError);
                lg.setStatus("Failure");
            }
        }
        catch (Exception e) {
            lg.setDateLog(new Date());
            lg.setStatus("Failure");
            lg.setMsg(e.getMessage());
        }
        return lg;
    }

    private Log getAccount(SyncSetting syncSet) {
        Log lg = new Log(this.da);
        ArrayList<Account> list = new ArrayList<Account>();
        Object url = syncSet.getBEURL();
        url = (String)url + "RMIsc/GetAccounts";
        try {
            HttpGet httpGet = new HttpGet((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        Account stkData = new Account(this.da);
                        stkData.setName(jo.isNull("AccountName") ? "" : jo.getString("AccountName"));
                        stkData.setAccNumber(jo.isNull("AccountNumber") ? "" : jo.getString("AccountNumber"));
                        list.add(stkData);
                    }
                    AccountDataList accountDataList = new AccountDataList(this.da);
                    accountDataList.selectAll("Select * from Account", this.da.getEmptyParameterValues());
                    for (Account acc : list) {
                        Account found = accountDataList.getOriginalList().stream().filter(p -> p.equals(acc)).findAny().orElse(null);
                        if (found != null) {
                            found.setAccNumber(acc.getAccNumber());
                            found.setName(acc.getName());
                            continue;
                        }
                        accountDataList.getOriginalList().add((Object)acc);
                    }
                    accountDataList.update();
                    lg.setDateLog(new Date());
                    lg.setMsg(Integer.toString(list.size()) + " Account Information List Synchronized from SAP");
                    lg.setStatus("Success");
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                lg.setDateLog(new Date());
                lg.setMsg(fullError + "\r\n" + fullError);
                lg.setStatus("Failure");
            }
            return lg;
        }
        catch (Exception e) {
            lg.setDateLog(new Date());
            lg.setStatus("Failure");
            lg.setMsg(e.getMessage());
            return lg;
        }
    }

    private Log getB2BEmployees(SyncSetting syncSet) {
        Log lg = new Log(this.da);
        ArrayList<Employee> list = new ArrayList<Employee>();
        Object url = syncSet.getBEURL();
        url = (String)url + "RMIsc/GetSalesEmployees";
        try {
            HttpGet httpGet = new HttpGet((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        Employee stkData = new Employee(this.da);
                        stkData.setEmpId(jo.isNull("EmpID") ? "" : jo.getString("EmpID"));
                        stkData.setEmpName(jo.isNull("EmpName") ? "" : jo.getString("EmpName"));
                        list.add(stkData);
                    }
                    EmployeeDataList employeeDataList = new EmployeeDataList(this.da);
                    employeeDataList.selectAll("Select * from Employee", this.da.getEmptyParameterValues());
                    for (Employee store : list) {
                        Employee found = employeeDataList.getOriginalList().stream().filter(p -> p.equals(store)).findAny().orElse(null);
                        if (found != null) {
                            found.setEmpId(store.getEmpId());
                            found.setEmpName(store.getEmpName());
                            continue;
                        }
                        employeeDataList.getOriginalList().add((Object)store);
                    }
                    employeeDataList.update();
                    lg.setDateLog(new Date());
                    lg.setMsg(Integer.toString(list.size()) + " Employee List Synchronized with SAP");
                    lg.setStatus("Success");
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                lg.setDateLog(new Date());
                lg.setMsg(fullError + "\r\n" + fullError);
                lg.setStatus("Failure");
            }
            return lg;
        }
        catch (Exception e) {
            lg.setDateLog(new Date());
            lg.setStatus("Failure");
            lg.setMsg(e.getMessage());
            return lg;
        }
    }

    private Log getAllYudalaProduct(SyncSetting syncSet) {
        Log lg = new Log(this.da);
        try {
            HttpGet httpGet = new HttpGet(syncSet.getBEURL() + "rProduct/GetSAPItems");
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        StockItemData stkData = new StockItemData();
                        stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                        stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                        list.add(stkData);
                    }
                    StockItemList.insertAllYudalaProduct(list, this.da);
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                lg.setDateLog(new Date());
                lg.setMsg(fullError);
                lg.setStatus("Failure");
            }
        }
        catch (Exception ex) {
            lg.setDateLog(new Date());
            lg.setMsg(ex.getMessage());
            lg.setStatus("Failure");
        }
        return lg;
    }

    private void sample() {
    }

    private void updatePushedSale(List<Sale> sales, Boolean flag) {
        try {
            SaleList sl = new SaleList();
            for (Sale sa : sales) {
                sa.setSyncFlag(flag);
                sa.lastSyncDate = new java.sql.Date(new Date().getTime());
                sl.getOriginalList().add((Object)sa);
            }
            sl.update();
        }
        catch (Exception ex) {
            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static List<SaleList> split(List<Sale> origList, int size, DataAccess da) {
        ArrayList<SaleList> saleLists = new ArrayList<SaleList>();
        int ct = origList.size() / size;
        SaleList sl = null;
        if (ct == 0) {
            sl = new SaleList(da);
            sl.getOriginalList().addAll(origList);
            saleLists.add(sl);
        } else {
            for (int i = 0; i <= ct; ++i) {
                if (i * size >= origList.size()) continue;
                sl = new SaleList(da);
                sl.getOriginalList().addAll(origList.subList(i * size, i * size + (origList.size() - i * size >= size ? size : origList.size() - i * size)));
                saleLists.add(sl);
            }
        }
        return saleLists;
    }

    public JSONObject proccessMalformedJsonStr(String str) throws JSONException {
        String str1 = str.substring(str.indexOf("Exception"), str.length() - 1);
        if (str1.length() > 15) {
            String[] str2 = str1.split(":");
            String str3 = str2[1].replace("\"", "");
            String str4 = str2[0] + ":\"" + str3 + "\"}";
            String str5 = str.substring(0, str.indexOf("Exception")) + str4;
            JSONObject js = new JSONObject(str5);
            return js;
        }
        return new JSONObject(str);
    }
}

