/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.Supplier;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.PurchaseOrderDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.SupplierDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SupplierDailog;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class SupplierPane
extends UIParent {
    @FXML
    private TextField SearchTextField;
    @FXML
    private TableView<Supplier> table;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnPost;
    @FXML
    private JFXButton SearchButton;
    @FXML
    private JFXButton btnClear;
    @FXML
    private StackPane stackPane;
    @FXML
    private JFXComboBox<String> cmbSupplier;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colAddress;
    @FXML
    private TableColumn colEmail;
    @FXML
    private TableColumn colPnum;
    @FXML
    private TableColumn colPayTerm;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colBankName;
    @FXML
    private TableColumn colAccName;
    @FXML
    private TableColumn colAccNo;
    @FXML
    private TableColumn colCurrency;
    @FXML
    private TableColumn colSortCode;
    @FXML
    private TableColumn colCreditLimit;
    @FXML
    private TableColumn colVendor;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colDelete;
    @FXML
    private TableColumn colHasSynced;
    JFXDialog dialog;
    Supplier selectedSupplier = null;
    public SupplierDataList supplierDataList;
    ObservableList<NameValueObject> suppliers;
    ObservableList<NameValueObject> paymentTerms;
    ObservableList<NameValueObject> banksNames;
    ObservableList<NameValueObject> currencies;

    public SupplierPane(Santa app) {
        super("SupplierPane.fxml", app);
        this.santa = app;
        this.title = "Vendor";
        this.suppliers = NameValueObject.select(NameValueObjectType.Supplier.name(), this.da);
        this.supplierDataList = new SupplierDataList(this.da);
        this.supplierDataList.selectAll("Select * from Supplier where syncFlag=?", new ParameterValue[]{new ParameterValue("", JDBCType.CHAR, false)});
        this.supplierDataList.getOriginalList().forEach(va -> va.setVendorId(""));
        this.table.setItems(this.supplierDataList.getOriginalList());
        this.paymentTerms = NameValueObject.select(NameValueObjectType.PaymentTerm.name(), this.da);
        this.banksNames = NameValueObject.select(NameValueObjectType.Banks.name(), this.da);
        this.currencies = NameValueObject.select(NameValueObjectType.Currencies.name(), this.da);
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colAddress.setCellValueFactory((Callback)new PropertyValueFactory("address"));
        this.colEmail.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.colPnum.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.colPayTerm.setCellValueFactory((Callback)new PropertyValueFactory("paymentTerm"));
        this.colVendor.setCellValueFactory((Callback)new PropertyValueFactory("vendorId"));
        this.colBankName.setCellValueFactory((Callback)new PropertyValueFactory("bankName"));
        this.colAccNo.setCellValueFactory((Callback)new PropertyValueFactory("accountNumber"));
        this.colAccName.setCellValueFactory((Callback)new PropertyValueFactory("accountName"));
        this.colCurrency.setCellValueFactory((Callback)new PropertyValueFactory("currency"));
        this.colSortCode.setCellValueFactory((Callback)new PropertyValueFactory("sortCode"));
        this.colCreditLimit.setCellValueFactory((Callback)new PropertyValueFactory("creditLimit"));
        this.colDelete.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colHasSynced.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.btnClear.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.WHITE).size(15.0));
        Callback<TableColumn<Supplier, String>, TableCell<Supplier, String>> cellFactoryViewDel = new Callback<TableColumn<Supplier, String>, TableCell<Supplier, String>>(){

            public TableCell call(TableColumn<Supplier, String> param) {
                TableCell<Supplier, String> cell = new TableCell<Supplier, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)SupplierPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES_CIRCLE).color(Color.WHITE).size(20.0));
                            this.btn.setStyle("-fx-background-color: #FF0000;");
                            Supplier req = (Supplier)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                SupplierPane.this.selectedSupplier = req;
                                req.setState(ObjectState.Removed);
                                SupplierDataList supplierDataListdel = new SupplierDataList(SupplierPane.this.da);
                                supplierDataListdel.getOriginalList().add((Object)req);
                                try {
                                    supplierDataListdel.update();
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(SupplierPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                SupplierPane.this.supplierDataList.getOriginalList().remove((Object)req);
                                SupplierPane.this.table.refresh();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDelete.setCellFactory((Callback)cellFactoryViewDel);
        Callback<TableColumn<Supplier, String>, TableCell<Supplier, String>> cellFactoryViewEdit = new Callback<TableColumn<Supplier, String>, TableCell<Supplier, String>>(){

            public TableCell call(TableColumn<Supplier, String> param) {
                TableCell<Supplier, String> cell = new TableCell<Supplier, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)SupplierPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            Supplier req = (Supplier)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                SupplierPane.this.selectedSupplier = req;
                                SupplierPane.this.showDialog();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryViewEdit);
        Callback<TableColumn<Supplier, String>, TableCell<Supplier, String>> cellFactoryVieSync = new Callback<TableColumn<Supplier, String>, TableCell<Supplier, String>>(){

            public TableCell call(TableColumn<Supplier, String> param) {
                TableCell<Supplier, String> cell = new TableCell<Supplier, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            Supplier req = (Supplier)this.getTableView().getItems().get(this.getIndex());
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            if (req.getSyncFlag().booleanValue()) {
                                this.lbl.setText("Posted");
                                this.lbl.setStyle("-fx-background-color: #00A86B;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            } else {
                                this.lbl.setText("Not Posted");
                                this.lbl.setStyle("-fx-background-color: #FF0000;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            }
                            this.setGraphic((Node)this.lbl);
                            this.setTooltip(new Tooltip(req.getSyncError()));
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colHasSynced.setCellFactory((Callback)cellFactoryVieSync);
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SupplierPane.this.selectedSupplier = null;
                SupplierPane.this.showDialog();
            }
        });
        this.btnPost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (SupplierPane.this.validateControl()) {
                    final String url = SupplierPane.this.santa.syncSetting.getBEURL() + "RSupplier/CreateSuppliers";
                    JFXProgressBar progressIndicator = new JFXProgressBar();
                    progressIndicator.setProgress(-1.0);
                    final VBox box = new VBox(new Node[]{progressIndicator});
                    box.setAlignment(Pos.CENTER);
                    SupplierPane.this.stackPane.getChildren().add((Object)box);
                    Service service = new Service(){

                        protected Task createTask() {
                            return new Task(){

                                protected Object call() throws Exception {
                                    try {
                                        JSONArray jSONArray = new JSONArray();
                                        for (Supplier supplier : SupplierPane.this.supplierDataList.getOriginalList()) {
                                            JSONObject job = new JSONObject();
                                            job.put("VendorId", (Object)supplier.getVendorId());
                                            job.put("Name", (Object)supplier.getName());
                                            job.put("Address", (Object)supplier.getAddress());
                                            job.put("PhoneNumber", (Object)supplier.getPhoneNumber());
                                            job.put("Email", (Object)supplier.getEmail());
                                            job.put("PaymentTerm", (Object)SupplierPane.this.paymentTerms.stream().filter(k -> k.getData().equals(supplier.getPaymentTerm())).findAny().get().getKey());
                                            job.put("BankName", (Object)SupplierPane.this.banksNames.stream().filter(k -> k.getData().equals(supplier.getBankName())).findAny().get().getKey());
                                            job.put("AccountNumber", (Object)supplier.getAccountNumber());
                                            job.put("AccountName", (Object)supplier.getAccountName());
                                            job.put("Currency", (Object)SupplierPane.this.currencies.stream().filter(k -> k.getData().equals(supplier.getCurrency())).findAny().get().getKey());
                                            job.put("SortCode", (Object)supplier.getSortCode());
                                            job.put("CreditLimit", supplier.getCreditLimit());
                                            jSONArray.put((Object)job);
                                        }
                                        HttpPost httpPost = new HttpPost(url);
                                        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                        StringEntity stringEntity = new StringEntity(jSONArray.toString());
                                        httpPost.setEntity((HttpEntity)stringEntity);
                                        httpPost.setHeader("Content-type", "application/json");
                                        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                        if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                            String output;
                                            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                            StringBuilder stringBuilder = new StringBuilder();
                                            while ((output = br.readLine()) != null) {
                                                stringBuilder.append(output + "\n");
                                            }
                                            br.close();
                                            httpClient.getConnectionManager().shutdown();
                                            String result = stringBuilder.toString();
                                            JSONArray ra = new JSONArray(result);
                                            Platform.runLater(() -> {
                                                try {
                                                    for (int i = 0; i < ra.length(); ++i) {
                                                        JSONObject jSONObject = ra.getJSONObject(i);
                                                        String email = jSONObject.getString("Email");
                                                        Supplier found = SupplierPane.this.supplierDataList.getOriginalList().stream().filter(s -> s.getEmail().equals(email)).findAny().orElse(null);
                                                        if (found == null) continue;
                                                        found.setVendorId(jSONObject.isNull("VendorId") ? "" : jSONObject.getString("VendorId"));
                                                        found.setSyncError(jSONObject.isNull("SyncError") ? "" : jSONObject.getString("SyncError"));
                                                        found.setSyncFlag(found.getSyncError().isEmpty());
                                                    }
                                                    if (SupplierPane.this.supplierDataList.getOriginalList().stream().filter(v -> !v.getSyncError().isEmpty()).findAny().orElse(null) == null) {
                                                        StockItemList.deleteAll("Delete From Supplier where syncFlag=?", new ParameterValue[]{new ParameterValue("syncFlag", JDBCType.CHAR, false)}, SupplierPane.this.da);
                                                        ArrayList nameValueObjects = new ArrayList();
                                                        SupplierPane.this.supplierDataList.getOriginalList().forEach(x -> {
                                                            if (!x.getVendorId().isEmpty()) {
                                                                try {
                                                                    StockItemList.deleteAll("Delete from NameValueObject where \"TYPE\"=? and \"KEY\"=? ", new ParameterValue[]{new ParameterValue("\"Type\"", JDBCType.VARCHAR, NameValueObjectType.Supplier.name()), new ParameterValue("\"KEY\"", JDBCType.VARCHAR, x.getVendorId())}, SupplierPane.this.da);
                                                                    NameValueObject obj = new NameValueObject(SupplierPane.this.da);
                                                                    obj.setKey(x.getVendorId());
                                                                    obj.setData(x.getName().toUpperCase());
                                                                    obj.setType(NameValueObjectType.Supplier.name());
                                                                    nameValueObjects.add(obj);
                                                                    x.setSyncError("");
                                                                }
                                                                catch (Exception ex) {
                                                                    Logger.getLogger(SupplierPane.class.getName()).log(Level.SEVERE, null, ex);
                                                                }
                                                            }
                                                        });
                                                        nameValueObjects.forEach(val -> {
                                                            try {
                                                                val.insert();
                                                            }
                                                            catch (Exception ex) {
                                                                SupplierPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SupplierPane.this);
                                                            }
                                                        });
                                                        SupplierPane.this.mainPage.showNotification(NotificationType.Success, "Supplier posted successfully", SupplierPane.this);
                                                    } else {
                                                        SupplierPane.this.mainPage.showNotification(NotificationType.Information, "Some suppliers(s) cannot be posted,please check the error message from the tooltip", SupplierPane.this);
                                                        SupplierDataList supplierDataListdel = new SupplierDataList(SupplierPane.this.da);
                                                        SupplierPane.this.supplierDataList.getOriginalList().forEach(val -> val.setState(ObjectState.Removed));
                                                        supplierDataListdel.getOriginalList().addAll(SupplierPane.this.supplierDataList.getOriginalList());
                                                        supplierDataListdel.update();
                                                        SupplierPane.this.supplierDataList.getOriginalList().forEach(val -> val.setState(ObjectState.New));
                                                        List dataTosave = SupplierPane.this.supplierDataList.getOriginalList().stream().filter(v -> v.getSyncFlag() == false).collect(Collectors.toList());
                                                        SupplierDataList sdl = new SupplierDataList(SupplierPane.this.da);
                                                        sdl.getOriginalList().addAll(dataTosave);
                                                        sdl.update();
                                                    }
                                                    SupplierPane.this.table.refresh();
                                                }
                                                catch (Exception ex) {
                                                    SupplierPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SupplierPane.this);
                                                }
                                                SupplierPane.this.stackPane.getChildren().remove((Object)box);
                                            });
                                        } else {
                                            String output;
                                            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                            StringBuilder stringBuilder = new StringBuilder();
                                            while ((output = br.readLine()) != null) {
                                                System.out.println(output);
                                                stringBuilder.append(output + "\n");
                                            }
                                            br.close();
                                            String fullError = stringBuilder.toString();
                                            Platform.runLater(() -> {
                                                SupplierPane.this.stackPane.getChildren().remove((Object)box);
                                                SupplierPane.this.mainPage.showNotification(NotificationType.Error, fullError, SupplierPane.this);
                                            });
                                        }
                                    }
                                    catch (Exception e) {
                                        Platform.runLater(() -> {
                                            SupplierPane.this.stackPane.getChildren().remove((Object)box);
                                            SupplierPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), SupplierPane.this);
                                        });
                                    }
                                    return null;
                                }
                            };
                        }
                    };
                    progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                    service.start();
                }
            }
        });
        this.btnClear.setOnAction(x -> {
            try {
                List<Supplier> dataTosave = this.supplierDataList.getOriginalList().stream().filter(v -> v.getSyncFlag() == false).collect(Collectors.toList());
                SupplierDataList sdl = new SupplierDataList(this.da);
                dataTosave.forEach(val -> val.setState(ObjectState.Removed));
                sdl.getOriginalList().addAll(dataTosave);
                sdl.update();
                this.supplierDataList.getOriginalList().clear();
                this.table.getItems().clear();
                this.table.refresh();
            }
            catch (Exception ex) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        });
        this.SearchButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SupplierPane.this.searchSupplier();
            }
        });
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTextField, t -> {
            List<NameValueObject> result = this.searchDataH(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<NameValueObject>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<NameValueObject> event) {
                SupplierPane.this.SearchTextField.setText(((NameValueObject)event.getCompletion()).getKey());
            }
        });
        autoCompletionBinding.setPrefWidth(400.0);
    }

    public List<NameValueObject> searchDataH(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<NameValueObject>();
        }
        try {
            List result = this.suppliers.stream().filter(e -> e.getData().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
            LinkedList searchResult = new LinkedList();
            searchResult.addAll(result.isEmpty() && result.size() > 0 ? this.suppliers : result);
            return searchResult.subList(0, searchResult.size());
        }
        catch (Exception ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<NameValueObject>();
        }
    }

    @Override
    boolean validateControl() {
        if (this.supplierDataList.getOriginalList().stream().filter(x -> (x.getEmail() == null || x.getEmail().isEmpty()) && x.getVendorId().isEmpty()).count() > 0L) {
            this.mainPage.showNotification(NotificationType.Error, "Please set email for all suppliers,and try again", this);
            return false;
        }
        return true;
    }

    void searchSupplier() {
        this.supplierDataList.getOriginalList().clear();
        this.table.refresh();
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = SupplierPane.this.santa.syncSetting.getBEURL() + "RSupplier/GetSuppliers";
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("searchString", SupplierPane.this.SearchTextField.getText());
                            listParam.add(param1);
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                PurchaseOrderDataList podl = new PurchaseOrderDataList(SupplierPane.this.da);
                                if (ra.length() > 0) {
                                    SupplierPane.this.supplierDataList.getOriginalList().clear();
                                    for (int i = 0; i < ra.length(); ++i) {
                                        String currency;
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        Supplier supplier = new Supplier(SupplierPane.this.da);
                                        supplier.setVendorId(jSONObject.isNull("VendorId") ? "" : jSONObject.getString("VendorId"));
                                        supplier.setName(jSONObject.isNull("VendorName") ? "" : jSONObject.getString("VendorName"));
                                        supplier.setAddress(jSONObject.isNull("Address") ? "" : jSONObject.getString("Address"));
                                        supplier.setPhoneNumber(jSONObject.isNull("PhoneNumber") ? "" : jSONObject.getString("PhoneNumber"));
                                        supplier.setEmail(jSONObject.isNull("Email") ? "" : jSONObject.getString("Email"));
                                        supplier.setPaymentTerm(jSONObject.isNull("PaymentTerm") ? "" : jSONObject.getString("PaymentTerm"));
                                        supplier.setBankName(jSONObject.isNull("BankName") ? "" : jSONObject.getString("BankName"));
                                        supplier.setAccountName(jSONObject.isNull("AccountName") ? "" : jSONObject.getString("AccountName"));
                                        supplier.setAccountNumber(jSONObject.isNull("AccountNumber") ? "" : jSONObject.getString("AccountNumber"));
                                        String string = currency = jSONObject.isNull("Currency") ? "" : jSONObject.getString("Currency");
                                        if (currency == null || currency.isEmpty() || SupplierPane.this.currencies.stream().filter(x -> x.getKey().equals(currency)).count() == 1L) {
                                            // empty if block
                                        }
                                        supplier.setCurrency(jSONObject.isNull("Currency") ? "" : jSONObject.getString("Currency"));
                                        supplier.setSortCode(jSONObject.isNull("SortCode") ? "" : jSONObject.getString("SortCode"));
                                        supplier.setCreditLimit(jSONObject.isNull("CreditLimit") ? 0.0 : (double)jSONObject.getInt("CreditLimit"));
                                        supplier.setSn(i + 1);
                                        SupplierPane.this.supplierDataList.getOriginalList().add((Object)supplier);
                                    }
                                    Platform.runLater(() -> {
                                        SupplierPane.this.stackPane.getChildren().remove((Object)box);
                                        SupplierPane.this.table.setItems(SupplierPane.this.supplierDataList.getOriginalList());
                                        SupplierPane.this.table.refresh();
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        SupplierPane.this.stackPane.getChildren().remove((Object)box);
                                        SupplierPane.this.mainPage.showNotification(NotificationType.Information, "No Supplier Found", SupplierPane.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    SupplierPane.this.stackPane.getChildren().remove((Object)box);
                                    SupplierPane.this.mainPage.showNotification(NotificationType.Error, fullError, SupplierPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                SupplierPane.this.stackPane.getChildren().remove((Object)box);
                                SupplierPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), SupplierPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void showDialog() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new SupplierDailog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }
}

