/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.ProductSerial;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.SerialItemData;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.SyncSetting;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.ProductSerialDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SerialView;
import com.xputertechnologies.santa.ui.StockItemPane;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class StockItemListPane
extends UIParent {
    @FXML
    private TextField SearchTF;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableView<StockItem> tbItems;
    @FXML
    private TableColumn<StockItem, String> colItemCode;
    @FXML
    private TableColumn<StockItem, String> colItemName;
    @FXML
    private TableColumn<StockItem, String> colGroup;
    @FXML
    private TableColumn<StockItem, Integer> sn;
    @FXML
    private TableColumn<StockItem, Double> colPrice;
    @FXML
    private TableColumn<StockItem, Double> colB2BPrice;
    @FXML
    private TableColumn<StockItem, Float> colQty;
    @FXML
    private TableColumn<StockItem, Float> colCnsQty;
    @FXML
    private TableColumn<StockItem, Float> colDspQty;
    @FXML
    private TableColumn<StockItem, Float> colWeight;
    @FXML
    private TableColumn<StockItem, Integer> colTotQty;
    @FXML
    private TableColumn colSerial;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton resync;
    @FXML
    private JFXButton btnAddINewtem;
    @FXML
    private JFXButton btnAddItemTransfer;
    public StockItemList stockItemList;
    @FXML
    private Label lblItemCount;
    VBox progressContainer;
    VBox box;
    SyncSettingDataList syncSettingDataList = null;
    int i = 0;

    public StockItemListPane(Santa app) {
        super("StockItemListPane.fxml", app);
        this.title = "Stock Item List";
        this.syncSettingDataList = new SyncSettingDataList(this.da);
        this.syncSettingDataList.selectAll("Select * From SyncSetting", this.da);
        this.stockItemList = new StockItemList(this.da);
        this.lblItemCount.setText(String.valueOf(this.stockItemList.getTotalRecord("StockItem")) + " Items available");
        this.resync.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.btnAddINewtem.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.resync.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ProgressBar progressIndicator = new ProgressBar();
                progressIndicator.setProgress(-1.0);
                StockItemListPane.this.box = new VBox(new Node[]{progressIndicator});
                StockItemListPane.this.box.setAlignment(Pos.CENTER);
                StockItemListPane.this.progressContainer = StockItemListPane.this.box;
                StockItemListPane.this.stackPane.getChildren().add((Object)StockItemListPane.this.box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData sync = new SyncData(StockItemListPane.this.santa, StockItemListPane.this.da, StockItemListPane.this.currentUser.getParentCompany());
                                JSONObject param = new JSONObject().put("item_Id", (Object)"").put("locationId", (Object)StockItemListPane.this.currentUser.getParentCompany().getStoreCode()).put("isRetailLocation", !StockItemListPane.this.currentUser.getParentCompany().getIsMainHub());
                                sync.getInventory(param, new IDBEntity<StockItem>(){

                                    @Override
                                    public void onSuccess(ObservableList<StockItem> data) {
                                        try {
                                            StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                            StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.progressContainer);
                                            StockItemListPane.this.SearchTF.setText("");
                                            StockItemListPane.this.populateSearch("");
                                            StockItemListPane.this.stockItemList.getOriginalList().clear();
                                            StockItemListPane.this.stockItemList.getOriginalList().addAll(data);
                                            if (data.size() > 0) {
                                                StockItemList.deleteAll(StockItemListPane.this.da);
                                                StockItemListPane.this.stockItemList.BatchInsert();
                                            }
                                            StockItemListPane.this.tbItems.refresh();
                                            StockItemListPane.this.lblItemCount.setText(String.valueOf(StockItemListPane.this.stockItemList.getOriginalList().size()) + " Items available");
                                            StockItemListPane.this.mainPage.showNotification(NotificationType.Success, "Products Synchronized successfully", StockItemListPane.this);
                                        }
                                        catch (Exception ex) {
                                            Logger.getLogger(StockItemListPane.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }

                                    @Override
                                    public void onError(String data) {
                                        StockItemListPane.this.mainPage.showNotification(NotificationType.Error, data, StockItemListPane.this);
                                        StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                        StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.progressContainer);
                                        StockItemListPane.this.SearchTF.setText("");
                                        StockItemListPane.this.populateSearch("");
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        StockItemListPane.this.mainPage.showNotification(NotificationType.Error, data, StockItemListPane.this);
                                        StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                        StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.progressContainer);
                                        StockItemListPane.this.SearchTF.setText("");
                                        StockItemListPane.this.populateSearch("");
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
        });
        this.btnAddItemTransfer.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (StockItemListPane.this.SearchTF.getText().isEmpty()) {
                    StockItemListPane.this.mainPage.showNotification(NotificationType.Error, "Please supply item code and try again", StockItemListPane.this);
                } else {
                    StockItemList temp = new StockItemList(StockItemListPane.this.da);
                    temp.searPrecise(StockItemListPane.this.SearchTF.getText());
                    if (temp.getOriginalList().isEmpty()) {
                        JFXProgressBar progressIndicator = new JFXProgressBar();
                        progressIndicator.setProgress(-1.0);
                        StockItemListPane.this.box = new VBox(new Node[]{progressIndicator});
                        StockItemListPane.this.box.setAlignment(Pos.CENTER);
                        StockItemListPane.this.progressContainer = StockItemListPane.this.box;
                        StockItemListPane.this.stackPane.getChildren().add((Object)StockItemListPane.this.box);
                        Service service = new Service(){

                            protected Task createTask() {
                                return new Task(){

                                    protected Object call() throws Exception {
                                        HttpGet httpget = null;
                                        try {
                                            String url = ((SyncSetting)StockItemListPane.this.syncSettingDataList.getOriginalList().get(0)).getBEURL();
                                            httpget = new HttpGet(url + "RProduct/GetOrCreateProductsForStore");
                                            CloseableHttpClient client = HttpClientBuilder.create().build();
                                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                                            BasicNameValuePair param1 = new BasicNameValuePair("storeCode", StockItemListPane.this.mainPage.currentUser.getParentCompany().getStoreCode());
                                            listParam.add(param1);
                                            BasicNameValuePair param2 = new BasicNameValuePair("itemCode", StockItemListPane.this.SearchTF.getText());
                                            listParam.add(param2);
                                            httpget.setHeader("Content-type", "application/json");
                                            URI uri = new URIBuilder(httpget.getURI()).addParameters(listParam).build();
                                            httpget.setURI(uri);
                                            HttpResponse response = client.execute((HttpUriRequest)httpget);
                                            if (response.getStatusLine().getStatusCode() == 200) {
                                                String output;
                                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                                StringBuilder stringBuilder = new StringBuilder();
                                                System.out.println("Output from Server .... \n");
                                                while ((output = br.readLine()) != null) {
                                                    System.out.println(output);
                                                    stringBuilder.append(output + "\n");
                                                }
                                                br.close();
                                                client.getConnectionManager().shutdown();
                                                String result = stringBuilder.toString();
                                                JSONArray ra = new JSONArray(result);
                                                if (ra.length() > 0) {
                                                    ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                                                    for (int i = 0; i < ra.length(); ++i) {
                                                        JSONObject jo = ra.getJSONObject(i);
                                                        StockItemData stkData = new StockItemData();
                                                        stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                                                        stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                                                        list.add(stkData);
                                                    }
                                                    StockItemList.insertYudalaProduct(list, StockItemListPane.this.da);
                                                    StockItemListPane.this.santa.Products.addAll(list);
                                                    Platform.runLater(() -> StockItemListPane.this.mainPage.showNotification(NotificationType.Success, "Operation successful", StockItemListPane.this));
                                                } else {
                                                    Platform.runLater(() -> StockItemListPane.this.mainPage.showNotification(NotificationType.Information, "no result found", StockItemListPane.this));
                                                }
                                            } else {
                                                String output;
                                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                                StringBuilder stringBuilder = new StringBuilder();
                                                while ((output = br.readLine()) != null) {
                                                    System.out.println(output);
                                                    stringBuilder.append(output + "\n");
                                                }
                                                br.close();
                                                String fullError = stringBuilder.toString();
                                                Platform.runLater(() -> {
                                                    StockItemListPane.this.mainPage.showNotification(NotificationType.Error, fullError, StockItemListPane.this);
                                                    StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                                });
                                            }
                                        }
                                        catch (Exception e) {
                                            StockItemListPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), StockItemListPane.this);
                                            StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                            Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
                                        }
                                        return null;
                                    }
                                };
                            }
                        };
                        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                        service.start();
                    } else {
                        StockItemListPane.this.mainPage.showNotification(NotificationType.Information, "Product already exist in your store", StockItemListPane.this);
                    }
                }
            }
        });
        this.btnAddINewtem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (StockItemListPane.this.SearchTF.getText().isEmpty()) {
                    StockItemListPane.this.mainPage.showNotification(NotificationType.Error, "Please supply item code and try again", StockItemListPane.this);
                } else {
                    StockItemList temp = new StockItemList(StockItemListPane.this.da);
                    temp.searPrecise(StockItemListPane.this.SearchTF.getText());
                    if (temp.getOriginalList().size() == 0) {
                        ProgressBar progressIndicator = new ProgressBar();
                        progressIndicator.setProgress(-1.0);
                        StockItemListPane.this.box = new VBox(new Node[]{progressIndicator});
                        StockItemListPane.this.box.setAlignment(Pos.CENTER);
                        StockItemListPane.this.progressContainer = StockItemListPane.this.box;
                        StockItemListPane.this.stackPane.getChildren().add((Object)StockItemListPane.this.box);
                        Service service = new Service(){

                            protected Task createTask() {
                                return new Task(){

                                    protected Object call() throws Exception {
                                        JSONObject param = new JSONObject().put("itemIds", (Object)StockItemListPane.this.SearchTF.getText().trim());
                                        new SyncData(StockItemListPane.this.santa, StockItemListPane.this.da, StockItemListPane.this.currentUser.getParentCompany()).getITem(param, new IDBEntity<StockItem>(){

                                            @Override
                                            public void onSuccess(ObservableList<StockItem> data) {
                                                StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                                if (data.isEmpty()) {
                                                    StockItemListPane.this.mainPage.showNotification(NotificationType.Information, "No result found", StockItemListPane.this);
                                                } else {
                                                    try {
                                                        StockItemList lst = new StockItemList(StockItemListPane.this.da);
                                                        data.forEach(dat -> {
                                                            dat.setState(ObjectState.New);
                                                            dat.setDbAccess(StockItemListPane.this.da);
                                                        });
                                                        StockItemList.deleteAll("delete from StockItem where ItemCode=?", new ParameterValue[]{new ParameterValue("ItemCode", JDBCType.VARCHAR, StockItemListPane.this.SearchTF.getText().trim())}, StockItemListPane.this.da);
                                                        lst.getOriginalList().addAll(data);
                                                        lst.update();
                                                    }
                                                    catch (Exception ex) {
                                                        StockItemListPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), StockItemListPane.this);
                                                    }
                                                    StockItemListPane.this.SearchTF.setText("");
                                                    StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                                    StockItemListPane.this.mainPage.showNotification(NotificationType.Success, "Item added to your inventory", StockItemListPane.this);
                                                }
                                            }

                                            @Override
                                            public void onError(String data) {
                                                StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                                StockItemListPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, StockItemListPane.this);
                                            }

                                            @Override
                                            public void onTimeOut(String data) {
                                                StockItemListPane.this.stackPane.getChildren().remove((Object)StockItemListPane.this.box);
                                                StockItemListPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", StockItemListPane.this);
                                            }
                                        });
                                        return null;
                                    }
                                };
                            }
                        };
                        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                        service.start();
                    } else {
                        StockItemListPane.this.mainPage.showNotification(NotificationType.Information, "Product already exist in your store", StockItemListPane.this);
                    }
                }
            }
        });
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTF, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                StockItemListPane.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        autoCompletionBinding.setPrefWidth(400.0);
        this.populateSearch(this.SearchTF.getText().toString());
        this.btnSearch.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    if (!StockItemListPane.this.SearchTF.getText().toString().isEmpty()) {
                        // empty if block
                    }
                    StockItemListPane.this.populateSearch(StockItemListPane.this.SearchTF.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.sn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colWeight.setCellValueFactory((Callback)new PropertyValueFactory("netWeight"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colItemName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colGroup.setCellValueFactory((Callback)new PropertyValueFactory("maker"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colCnsQty.setCellValueFactory((Callback)new PropertyValueFactory("cnsQty"));
        this.colDspQty.setCellValueFactory((Callback)new PropertyValueFactory("dspQty"));
        this.colTotQty.setCellValueFactory((Callback)new PropertyValueFactory("totalQty"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("sellingPrice"));
        this.colB2BPrice.setCellValueFactory((Callback)new PropertyValueFactory("priceB2B"));
        this.prefWidthProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.widthProperty());
        this.tbItems.prefHeightProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.heightProperty());
        this.sn.setCellFactory(param -> {
            TableCell<StockItem, Integer> cell = new TableCell<StockItem, Integer>(){

                public void updateItem(Integer value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(Integer.toString(value));
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colTotQty.setCellFactory(param -> {
            TableCell<StockItem, Integer> cell = new TableCell<StockItem, Integer>(){

                public void updateItem(Integer value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(Integer.toString(Math.round(value.intValue())));
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colQty.setCellFactory(param -> {
            TableCell<StockItem, Float> cell = new TableCell<StockItem, Float>(){

                public void updateItem(Float value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(Integer.toString(Math.round(value.floatValue())));
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colCnsQty.setCellFactory(param -> {
            TableCell<StockItem, Float> cell = new TableCell<StockItem, Float>(){

                public void updateItem(Float value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(Integer.toString(Math.round(value.floatValue())));
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colDspQty.setCellFactory(param -> {
            TableCell<StockItem, Float> cell = new TableCell<StockItem, Float>(){

                public void updateItem(Float value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(Integer.toString(Math.round(value.floatValue())));
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colItemCode.setCellFactory(param -> {
            TableCell<StockItem, String> cell = new TableCell<StockItem, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colItemName.setCellFactory(param -> {
            TableCell<StockItem, String> cell = new TableCell<StockItem, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colGroup.setCellFactory(param -> {
            TableCell<StockItem, String> cell = new TableCell<StockItem, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colPrice.setCellFactory(param -> {
            TableCell<StockItem, Double> cell = new TableCell<StockItem, Double>(){

                public void updateItem(Double value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(General.formatDecimalToMoneyString((double)value));
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colB2BPrice.setCellFactory(param -> {
            TableCell<StockItem, Double> cell = new TableCell<StockItem, Double>(){

                public void updateItem(Double value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(General.formatDecimalToMoneyString(value));
                        StockItem item = (StockItem)this.getTableRow().getItem();
                        if (item != null && (item.totalQty == 0 || item.getSellingPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>> cellFactoryVieSerial = new Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>>(){

            public TableCell call(TableColumn<StockItem, String> param) {
                TableCell<StockItem, String> cell = new TableCell<StockItem, String>(){
                    final JFXButton lbl = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            StockItem req = (StockItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getSerials().getOriginalList().isEmpty()) {
                                this.lbl.setPrefHeight(30.0);
                                this.lbl.setPrefWidth(30.0);
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.lbl.setGraphic((Node)StockItemListPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.GREEN).size(15.0));
                                this.lbl.setOnAction(c -> {
                                    ObservableList observableList = FXCollections.observableArrayList();
                                    StockItemListPane.this.i = 0;
                                    req.getSerials().getOriginalList().forEach(x -> {
                                        ++StockItemListPane.this.i;
                                        NameValueObject valuePair = new NameValueObject(StockItemListPane.this.da);
                                        valuePair.setKey(Integer.toString(StockItemListPane.this.i));
                                        valuePair.setData(x.getSerial());
                                        observableList.add((Object)valuePair);
                                    });
                                    JFXDialog dialog = new JFXDialog();
                                    dialog.setDialogContainer(StockItemListPane.this.stackPane);
                                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    dialog.setContent((Region)new SerialView(StockItemListPane.this.santa, dialog, req.getName(), (ObservableList<NameValueObject>)observableList));
                                    dialog.setOverlayClose(false);
                                    dialog.show();
                                });
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.setGraphic(null);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colSerial.setCellFactory((Callback)cellFactoryVieSerial);
    }

    @Override
    public void populateSearch(String SearchValue) {
        if (!SearchValue.isEmpty()) {
            this.stockItemList.currentPage = 0;
            this.stockItemList.searPrecise(SearchValue);
        } else {
            this.stockItemList.searchStock(SearchValue);
        }
        this.stockItemList.getOriginalList().forEach(x -> x.loadSerials());
        this.tbItems.setItems(this.stockItemList.getOriginalList());
        this.tbItems.refresh();
    }

    public void getProductsOld() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object url = this.santa.syncSetting.getBEURL();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        StockItemList sil = new StockItemList(this.da);
        url = (String)url + "rproduct/GetProducts";
        try {
            HttpGet httpGet = new HttpGet((String)url);
            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair param1 = new BasicNameValuePair("storeCode", this.currentUser.getParentCompany().getStoreCode());
            listParam.add(param1);
            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
            httpGet.setURI(uri);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray jar = new JSONArray(result);
                if (jar.length() > 0) {
                    String str = jar.toString();
                    for (int i = 0; i < jar.length(); ++i) {
                        JSONObject jo = jar.getJSONObject(i);
                        StockItemData stkData = new StockItemData();
                        stkData.setDescription(jo.isNull("Name") ? "" : jo.getString("Name"));
                        stkData.setGroup(jo.isNull("Group") ? "" : jo.getString("Group"));
                        stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                        stkData.setPartNumber(jo.isNull("BarCode") ? "" : jo.getString("BarCode"));
                        stkData.setSellingPrice(jo.isNull("SellingPrice") ? 0.0 : jo.getDouble("SellingPrice"));
                        stkData.setCostPrice(jo.isNull("CostPrice") ? 0.0 : jo.getDouble("CostPrice"));
                        stkData.setB2bprice(jo.isNull("B2BPrice") ? 0.0 : jo.getDouble("B2BPrice"));
                        stkData.setStoreQuantity(jo.isNull("Quantity") ? 0 : (int)Math.round(jo.getDouble("Quantity")));
                        stkData.setCnsQty(jo.isNull("ConsignmentQty") ? 0.0 : jo.getDouble("ConsignmentQty"));
                        stkData.setDspQty(jo.isNull("DisplayQty") ? 0.0 : jo.getDouble("DisplayQty"));
                        JSONArray jSONArray = jo.getJSONArray("Serials");
                        if (jSONArray != null && jSONArray.length() > 0) {
                            for (int j = 0; j < jSONArray.length(); ++j) {
                                JSONObject joS = jSONArray.getJSONObject(j);
                                SerialItemData serialItemData = new SerialItemData();
                                serialItemData.setItemCode(joS.isNull("ItemCode") ? "" : joS.getString("ItemCode"));
                                serialItemData.setQuantity(joS.isNull("Quantity") ? 0 : joS.getInt("Quantity"));
                                serialItemData.setSerial(joS.isNull("Serial") ? "" : joS.getString("Serial"));
                                serialItemData.setStatus(joS.isNull("Status") ? "" : joS.getString("Status"));
                                serialItemData.setSysSerial(joS.isNull("SysSerial") ? 0 : joS.getInt("SysSerial"));
                                serialItemData.setWhsCode(joS.isNull("WhsCode") ? "" : joS.getString("WhsCode"));
                                stkData.getSerials().add(serialItemData);
                            }
                        }
                        list.add(stkData);
                    }
                    ObservableList finalProds = FXCollections.observableArrayList();
                    StockItemList.deleteAll(this.da);
                    for (StockItemData stockItemData : list) {
                        StockItem si = new StockItem(this.da);
                        si.setName(stockItemData.getDescription());
                        si.setItemCode(stockItemData.getItemCode());
                        si.setType(stockItemData.getGroup());
                        si.setQuantity(stockItemData.getStoreQuantity());
                        si.setCostPrice((float)stockItemData.getCostPrice());
                        si.setSellingPrice((float)stockItemData.getSellingPrice());
                        si.setPriceB2B(stockItemData.getB2bprice());
                        si.setParentCompany(this.currentUser.getParentCompany());
                        si.setCnsQty((float)stockItemData.getCnsQty());
                        si.setDspQty((float)stockItemData.getDspQty());
                        si.setStockUnit("Pieces");
                        if (finalProds.stream().filter(p -> p.getItemCode().equals(prod.getPartNumber()) && p.getItemCode().equals(prod.getItemCode())).findAny().orElse(null) != null) continue;
                        StockItemList.deleteAllProductwithItemCodeFromProductSerial(this.da, si.getItemCode());
                        for (SerialItemData serial : stockItemData.getSerials()) {
                            ProductSerial productSerial = new ProductSerial(this.da);
                            productSerial.setItemCode(serial.getItemCode());
                            productSerial.setQuantity(serial.getQuantity());
                            productSerial.setSerial(serial.getSerial());
                            productSerial.setStatus(serial.getStatus());
                            productSerial.setSysSerial(serial.getSysSerial());
                            productSerial.setWhscode(serial.getWhsCode());
                            si.getSerials().getOriginalList().add((Object)productSerial);
                        }
                        finalProds.add((Object)si);
                    }
                    sil.getOriginalList().clear();
                    sil.getOriginalList().addAll((Collection)finalProds);
                    ProductSerialDataList productSerialDataList = new ProductSerialDataList(this.da);
                    finalProds.forEach(val -> productSerialDataList.getOriginalList().addAll(val.getSerials().getOriginalList()));
                    ProductSerialDataList.deleteAll(this.da);
                    try {
                        this.da.start();
                        sil.BatchInsert();
                        productSerialDataList.update();
                        this.da.end();
                        SyncSettingDataList syncSettingDataList = new SyncSettingDataList(this.da);
                        this.santa.syncSetting.setProdDateLastRead(new Timestamp(new Date().getTime()));
                        syncSettingDataList.getOriginalList().add((Object)this.santa.syncSetting);
                        syncSettingDataList.update();
                        this.resyncDone("");
                    }
                    catch (Exception exception) {
                        this.resyncDone(exception.getMessage());
                    }
                } else {
                    this.resyncDone("");
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                this.resyncDone(fullError);
            }
        }
        catch (Exception e) {
            this.resyncDone(e.getMessage());
        }
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return StockItemList.selectAutoComplete(searchString, this.da, false);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    @Override
    public void yes() {
    }

    public void resyncDone(String erString) {
        Platform.runLater(() -> {
            this.stackPane.getChildren().remove((Object)this.box);
            if (erString.isEmpty()) {
                this.stackPane.getChildren().remove((Object)this.progressContainer);
                this.SearchTF.setText("");
                this.populateSearch("");
                this.lblItemCount.setText(String.valueOf(this.stockItemList.getTotalRecord("StockItem")) + " Items available");
                this.mainPage.showNotification(NotificationType.Success, "Products Synchronized successfully", this);
            } else {
                this.mainPage.showNotification(NotificationType.Error, erString, this);
            }
        });
    }
}

