/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.ConnectionString;
import com.xputertechnologies.santa.DDL;
import com.xputertechnologies.santa.ObjectDb;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.SyncSetting;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.list.UserDataList;
import com.xputertechnologies.santa.ui.AnimationEnum;
import com.xputertechnologies.santa.ui.AppLoader;
import com.xputertechnologies.santa.ui.ConfigurationPageContainerPane;
import com.xputertechnologies.santa.ui.LoginPane;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.SalesReturnPane;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import com.xputertechnologies.santa.ui.UITitlePane;
import com.xputertechnologies.santa.ui.UpdatePage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.JDBCType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.concurrent.Task;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Duration;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.IDataSet;

public class Santa
extends Application {
    public static Float dialogWidth = Float.valueOf(1200.0f);
    public static Float dialogHeight = Float.valueOf(700.0f);
    public static boolean isDevelopment = false;
    public String errorPath;
    public static String payloadSale;
    public static String payloadAll;
    public static int connectionTimeOut;
    public static int socketTimeOut;
    public List<StockItemData> Products = new ArrayList<StockItemData>();
    public Stage stage;
    UITitlePane uITitlePane;
    public DataAccess da;
    public DataAccess daSync;
    public DataAccess daPreload;
    public Connection con;
    public Connection conSync;
    public Connection con2;
    private IDataSet dataSet;
    private DatabaseConnection dc;
    public User currentUser;
    public MainPage mainpage;
    public Company company;
    public ConnectionString connectionString = null;
    public Timer timer = new Timer();
    SyncData sd;
    public SyncSetting syncSetting;
    private static final int SINGLE_INSTANCE_LISTENER_PORT = 9999;
    private static final String SINGLE_INSTANCE_FOCUS_MESSAGE = "focus";
    private static final String instanceId;
    private StringProperty downloadStatus = new SimpleStringProperty();
    private static final int FOCUS_REQUEST_PAUSE_MILLIS = 500;
    private JasperReport jsrpt;
    private JasperReport CompiledJasperReportInvoice = null;
    private static JasperReport CompiledJasperReportDailySales;
    private static JasperReport CompiledJasperReportDailySalesSummary;
    private static JasperReport CompiledJasperReportStockList;
    private static JasperReport CompiledJasperReportSalesByCategory;
    private static JasperReport CompiledJasperReportCreditSales;
    private static JasperReport CompiledJasperReportDailySalesByAccount;
    private static JasperReport CompiledJasperReportSProductByCategory;
    private static JasperReport CompiledJasperReportReleaseTransfer;
    private static JasperReport CompiledJasperReportReleaseTransferBin;
    private static JasperReport CompiledJasperReportGITTransfer;
    private static JasperReport CompiledJasperReportPO;
    private static JasperReport CompiledJasperReportPOs;
    private static JasperReport CompiledJasperReportGRPO;
    private static JasperReport CompiledJasperReportStockBarCode;
    private static JasperReport CompiledJasperReportStockBarCodeItem;
    UpdatePage updatePage;
    String passed = "";
    static Double SceneWidth;
    static Double SceneHeight;
    private ArrayList<UIParent> scenes = new ArrayList();

    public static List<String> getWareHousesList() {
        ArrayList<String> WareHousesList = new ArrayList<String>();
        WareHousesList.add("Isolo");
        WareHousesList.add("Abuja");
        return WareHousesList;
    }

    public JasperReport getCompiledJasperReportReleaseTransfer() {
        try {
            if (CompiledJasperReportReleaseTransfer == null) {
                CompiledJasperReportReleaseTransfer = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("Transfer.jrxml"));
            }
            return CompiledJasperReportReleaseTransfer;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperReportReleaseTransferBin() {
        try {
            if (CompiledJasperReportReleaseTransferBin == null) {
                CompiledJasperReportReleaseTransferBin = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("TransferBin.jrxml"));
            }
            return CompiledJasperReportReleaseTransferBin;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperReportGITTransfer() {
        try {
            if (CompiledJasperReportGITTransfer == null) {
                CompiledJasperReportGITTransfer = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("PendingTransfer.jrxml"));
            }
            return CompiledJasperReportGITTransfer;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperReportPO() {
        try {
            if (CompiledJasperReportPO == null) {
                CompiledJasperReportPO = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("PurchaseOrder.jrxml"));
            }
            return CompiledJasperReportPO;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperReportPOs() {
        try {
            if (CompiledJasperReportPOs == null) {
                CompiledJasperReportPOs = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("PurchaseRequest.jrxml"));
            }
            return CompiledJasperReportPOs;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperReportGRPO() {
        try {
            if (CompiledJasperReportGRPO == null) {
                CompiledJasperReportGRPO = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("GRPurchaseOrder.jrxml"));
            }
            return CompiledJasperReportGRPO;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperReportStockItemBarCode() {
        try {
            if (CompiledJasperReportStockBarCode == null) {
                CompiledJasperReportStockBarCode = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("FullLabel.jrxml"));
            }
            return CompiledJasperReportStockBarCode;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperReportStockItemBarCodeItem() {
        try {
            if (CompiledJasperReportStockBarCodeItem == null) {
                CompiledJasperReportStockBarCodeItem = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("Label.jrxml"));
            }
            return CompiledJasperReportStockBarCodeItem;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperReportInvoice() {
        try {
            if (this.CompiledJasperReportInvoice == null) {
                this.CompiledJasperReportInvoice = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("Invoice.jrxml"));
            }
            return this.CompiledJasperReportInvoice;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static JasperReport getCompiledJasperReportDailySales() {
        return CompiledJasperReportDailySales;
    }

    public static JasperReport getCompiledJasperReportDailySalesSummary() {
        return CompiledJasperReportDailySalesSummary;
    }

    public JasperReport getCompiledJasperReportStockList() {
        try {
            if (CompiledJasperReportStockList == null) {
                CompiledJasperReportStockList = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("StockList.jrxml"));
            }
            return CompiledJasperReportStockList;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperSalesByCategory() {
        try {
            if (CompiledJasperReportSalesByCategory == null) {
                CompiledJasperReportSalesByCategory = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("SalesByCategory.jrxml"));
            }
            return CompiledJasperReportSalesByCategory;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperCreditSales() {
        try {
            if (CompiledJasperReportCreditSales == null) {
                CompiledJasperReportCreditSales = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("CreditSale.jrxml"));
            }
            return CompiledJasperReportCreditSales;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public JasperReport getCompiledJasperProductByCategory() {
        try {
            if (CompiledJasperReportSProductByCategory == null) {
                CompiledJasperReportSProductByCategory = JasperCompileManager.compileReport((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("ProductByCategory.jrxml"));
            }
            return CompiledJasperReportSProductByCategory;
        }
        catch (JRException ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static JasperReport getCompiledJasperReportDailySalesByAccount() {
        return CompiledJasperReportDailySalesByAccount;
    }

    public JasperReport getJsrpt() {
        return this.jsrpt;
    }

    public void checkStartDownload() {
        DownloadTask task = new DownloadTask(AppLoader.JarURL);
        task.messageProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                System.out.println(newValue);
                Santa.this.updatePage.lblMsgCounter.setText(newValue);
            }
        });
        this.updatePage.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
        Thread thread = new Thread((Runnable)((Object)task));
        thread.setDaemon(true);
        thread.start();
    }

    public void Login(Company cdl) {
        try {
            long curTime;
            long endTime;
            long diff;
            long datediff;
            ObjectDb objectDb;
            LoginPane loginPane = new LoginPane(this, this.passed);
            this.showScene(loginPane);
            this.sd = new SyncData(this, this.daSync, cdl);
            this.syncSetting = SyncSettingDataList.getSyncSetting(this.daSync);
            ObjectDb objectDb2 = objectDb = ObjectDb.loadLocalDb() == null ? new ObjectDb() : ObjectDb.loadLocalDb();
            if (objectDb.getLastlogdeletedate() == null) {
                objectDb.setLastlogdeletedate(new Date());
                objectDb.saveLocalDb();
            }
            if ((datediff = TimeUnit.DAYS.convert(diff = (endTime = new Date().getTime()) - (curTime = objectDb.getLastlogdeletedate().getTime()), TimeUnit.MILLISECONDS)) >= 5L) {
                StockItemList.deleteAll("Log", this.da);
                objectDb.setLastlogdeletedate(new Date());
                objectDb.saveLocalDb();
            }
            this.startSyncTimer();
        }
        catch (Exception ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void startSyncTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = new Timer();
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Santa.this.sd.Synchronize(Santa.this.syncSetting);
            }
        }, 0L, (long)(this.syncSetting.getSyncInterval() * 60000));
    }

    public static void setAnimation(Region child, Region parentNode, AnimationEnum slideFrom) {
        KeyValue keyValue;
        switch (slideFrom) {
            case TOP: {
                child.translateYProperty().set(-1.0 * parentNode.getHeight());
                keyValue = new KeyValue((WritableValue)child.translateYProperty(), (Object)0, Interpolator.EASE_IN);
                break;
            }
            case BOTOM: {
                child.translateYProperty().set(parentNode.getHeight());
                keyValue = new KeyValue((WritableValue)child.translateYProperty(), (Object)0, Interpolator.EASE_IN);
                break;
            }
            case LEFT: {
                child.translateYProperty().set(-1.0 * parentNode.getWidth());
                keyValue = new KeyValue((WritableValue)child.translateXProperty(), (Object)0, Interpolator.EASE_IN);
                break;
            }
            case RIGHT: {
                child.translateYProperty().set(parentNode.getWidth());
                keyValue = new KeyValue((WritableValue)child.translateXProperty(), (Object)0, Interpolator.EASE_IN);
            }
        }
        keyValue = new KeyValue((WritableValue)child.translateYProperty(), (Object)0, Interpolator.EASE_IN);
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{keyValue});
        Timeline timeline = new Timeline(new KeyFrame[]{keyFrame});
        timeline.play();
    }

    public static String decodeString(String str) {
        byte[] decodedBytes = Base64.getDecoder().decode(str);
        System.out.println("decodedBytes " + new String(decodedBytes));
        return new String(decodedBytes);
    }

    public static String encodeString(String str) {
        byte[] encodedBytes = Base64.getEncoder().encode(str.getBytes());
        System.out.println("encodedBytes " + new String(encodedBytes));
        return new String(encodedBytes);
    }

    public static String getUniqueId(String pefix) {
        Random rand = new Random();
        int resRandom = rand.nextInt(999900) + 10;
        return pefix + "-" + String.valueOf(resRandom);
    }

    String generateBarCode50() {
        Object result = "";
        String standard = "YUD140806007109";
        for (int i = 0; i < 50; ++i) {
            result = (String)result + standard + Integer.toString(i) + "\n";
        }
        System.out.println("50 Barcode " + (String)result);
        return result;
    }

    void setupLog() {
        if (!isDevelopment) {
            this.errorPath = System.getProperty("os.name").indexOf("Mac OS X") >= 0 ? File.separator + ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("Santa.jar", "errorLog.txt").substring(1) : ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("Santa.jar", "errorLog.txt").substring(1);
            File file = new File(this.errorPath);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void start(Stage stage) throws Exception {
        ConfigurationPageContainerPane cpcp = null;
        this.da = new DataAccess();
        this.daSync = new DataAccess();
        this.setupLog();
        this.runDatabaseActivityChange();
        CompanyDataList cdl = new CompanyDataList(this.da);
        if (this.da == null) {
            System.out.println("Data Access is Null");
        }
        try {
            cdl.selectAll();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        UserDataList userDataList = new UserDataList(this.da);
        this.stage = stage;
        stage.getIcons().add((Object)new Image("/com/xputertechnologies/santa/ui/Images/logo_pink.png"));
        if (cdl.getOriginalList().size() > 0) {
            this.company = (Company)cdl.getOriginalList().get(0);
            userDataList.selectAll("SELECT * From User where STATUS=?", new ParameterValue[]{new ParameterValue("Status", JDBCType.VARCHAR, "Active")}, this.da);
            if (userDataList.getOriginalList().size() > 0) {
                boolean need = false;
                if (!isDevelopment && AppLoader.needUpdateApp()) {
                    this.updatePage = new UpdatePage(this);
                    Scene scene = new Scene((Parent)this.updatePage, 420.0, 300.0);
                    stage.setTitle("Yuvend");
                    stage.setScene(scene);
                    stage.show();
                    this.checkStartDownload();
                } else {
                    this.Login((Company)cdl.getOriginalList().get(0));
                }
            } else {
                cpcp = new ConfigurationPageContainerPane(this);
                this.stage = stage;
                this.showScene(cpcp);
            }
        } else {
            cpcp = new ConfigurationPageContainerPane(this);
            this.stage = stage;
            this.showScene(cpcp);
        }
        stage.setOnCloseRequest(v -> {
            Platform.exit();
            System.exit(0);
        });
    }

    public void runDatabaseActivityChange() {
        ObjectDb objectDb = ObjectDb.loadLocalDb() == null ? new ObjectDb() : ObjectDb.loadLocalDb();
        ArrayList<String> keysNeddToKeepInDll = new ArrayList<String>();
        try {
            LinkedHashMap<String, String> qryNames = DDL.loadAllDll();
            for (String qryName : qryNames.keySet()) {
                if (objectDb.getDlls().indexOf(qryName) != -1) continue;
                try {
                    this.da.performTableDDLOperation(qryNames.get(qryName));
                    keysNeddToKeepInDll.add(qryName);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, e.getMessage());
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
        }
        objectDb.setOneTimeEndPointsLoaded(Boolean.FALSE);
        objectDb.getDlls().addAll(keysNeddToKeepInDll);
        objectDb.saveLocalDb();
    }

    public static File writePayLoadToFile(String payload) {
        try {
            File fileFormat = new File(payloadSale);
            BufferedWriter bf = new BufferedWriter(new FileWriter(fileFormat));
            bf.write(payload);
            bf.close();
            return fileFormat;
        }
        catch (Exception ex) {
            Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static File writePayLoadToFileAll(String payload) {
        try {
            File fileFormat = new File(payloadAll);
            BufferedWriter bf = new BufferedWriter(new FileWriter(fileFormat));
            bf.write(payload);
            bf.close();
            return fileFormat;
        }
        catch (Exception ex) {
            Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void logError(String errorMsg) {
        try {
            Date date = new Date();
            BufferedWriter bf = new BufferedWriter(new FileWriter(this.errorPath));
            bf.write("Date Logged:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
            bf.newLine();
            bf.write(errorMsg);
            bf.close();
        }
        catch (Exception ex) {
            Logger.getLogger(Santa.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void showScene(UIParent uiparent) {
        Screen screen = Screen.getPrimary();
        Scene scene = new Scene((Parent)uiparent);
        Rectangle2D bounds = screen.getVisualBounds();
        SceneWidth = bounds.getWidth();
        SceneHeight = bounds.getHeight();
        this.stage.setX(bounds.getMinX());
        this.stage.setY(bounds.getMinY());
        this.stage.setWidth(bounds.getWidth());
        this.stage.setHeight(bounds.getHeight());
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void setStage(UIParent uiparent) {
        Screen screen = Screen.getPrimary();
        Scene scene = new Scene((Parent)uiparent);
        Rectangle2D bounds = screen.getVisualBounds();
        this.stage.setX(bounds.getMinX());
        this.stage.setY(bounds.getMinY());
        this.stage.setWidth(bounds.getWidth());
        this.stage.setHeight(bounds.getHeight());
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void setScene(UIParent uiparent) {
        this.scenes.add(uiparent);
    }

    public void logOut() throws Exception {
        this.scenes.clear();
        LoginPane loginPane = new LoginPane(this, this.passed);
        this.stage = this.stage;
        this.showScene(loginPane);
    }

    public ArrayList<UIParent> getScenes() {
        return this.scenes;
    }

    public void setScenes(ArrayList<UIParent> scenes) {
        this.scenes = scenes;
    }

    public static void main(String[] args) {
        Santa.launch(Santa.class, (String[])args);
    }

    static {
        connectionTimeOut = 300000;
        socketTimeOut = 300000;
        instanceId = UUID.randomUUID().toString();
        CompiledJasperReportDailySales = null;
        CompiledJasperReportDailySalesSummary = null;
        CompiledJasperReportStockList = null;
        CompiledJasperReportSalesByCategory = null;
        CompiledJasperReportCreditSales = null;
        CompiledJasperReportDailySalesByAccount = null;
        CompiledJasperReportSProductByCategory = null;
        CompiledJasperReportReleaseTransfer = null;
        CompiledJasperReportReleaseTransferBin = null;
        CompiledJasperReportGITTransfer = null;
        CompiledJasperReportPO = null;
        CompiledJasperReportPOs = null;
        CompiledJasperReportGRPO = null;
        CompiledJasperReportStockBarCode = null;
        CompiledJasperReportStockBarCodeItem = null;
        SceneWidth = 0.0;
        SceneHeight = 0.0;
    }

    private class DownloadTask
    extends Task<Void> {
        private String url;

        public DownloadTask(String url) {
            this.url = url;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        protected Void call() throws Exception {
            File updateJarExist = AppLoader.getAppFile("Santa.jar.update");
            updateJarExist.delete();
            String ext = this.url.substring(this.url.lastIndexOf("."), AppLoader.JarURL.length());
            URLConnection connection = new URL(this.url).openConnection();
            long fileLength = connection.getContentLengthLong();
            try (InputStream is = connection.getInputStream();
                 OutputStream os = Files.newOutputStream(Paths.get("Santa.jar.update", new String[0]), new OpenOption[0]);){
                int n;
                long nread = 0L;
                byte[] buf = new byte[8192];
                while ((n = is.read(buf)) > 0) {
                    os.write(buf, 0, n);
                    int val = (int)((nread += (long)n) * 100L / fileLength);
                    this.updateMessage("Update is " + Integer.toString(val) + "% Done...");
                    this.updateProgress(nread, fileLength);
                }
                File updatePacked = AppLoader.getAppFile("Santa.jar.update");
                updatePacked.setLastModified(connection.getLastModified());
            }
            return null;
        }

        protected void failed() {
            System.out.println("failed");
        }

        protected void succeeded() {
            System.out.println("downloaded");
            File jar = AppLoader.getAppFile("Santa.jar");
            File updateJar = AppLoader.getAppFile("Santa.jar.update");
            if (updateJar.exists()) {
                try {
                    AppLoader.copyFile(updateJar, jar);
                    jar.setLastModified(updateJar.lastModified());
                    updateJar.delete();
                    ObjectDb objectDb = ObjectDb.loadLocalDb() == null ? new ObjectDb() : ObjectDb.loadLocalDb();
                    objectDb.setLastUpdateDate(new Date(jar.lastModified()));
                    objectDb.saveLocalDb();
                }
                catch (Exception ex) {
                    Santa.this.logError(ex.getMessage());
                    Logger.getLogger(AppLoader.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!jar.exists() || !jar.canRead()) {
                throw new RuntimeException("Main Jar not found!");
            }
        }
    }
}

