/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.Expenses;
import com.xputertechnologies.santa.ISaleCallBack;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.Replenishment;
import com.xputertechnologies.santa.RequestTypeEnum;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleAccountDetailResolver;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.ExpensesDataList;
import com.xputertechnologies.santa.list.ReplenishmentList;
import com.xputertechnologies.santa.list.SaleItemList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.ReprintInvoiceSearchDialog;
import com.xputertechnologies.santa.ui.SaleReprintItem;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesReturn;
import com.xputertechnologies.santa.ui.SalesReturnItem;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SerialView;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SalesReturnPane
extends UIParent {
    @FXML
    private StackPane stackPane;
    @FXML
    private JFXButton SearchButton;
    @FXML
    private JFXButton reprint;
    @FXML
    private JFXButton btnResyncSale;
    @FXML
    private JFXButton btnMark;
    @FXML
    private JFXButton btnPending;
    @FXML
    private DatePicker from;
    @FXML
    private DatePicker to;
    @FXML
    private Label lblTotal;
    @FXML
    private Label naira;
    @FXML
    private Label lblUsername;
    @FXML
    private Label lblPnum;
    @FXML
    private Label lblDate;
    @FXML
    private Label lblSap;
    @FXML
    private Label lblVoucherCode;
    @FXML
    private Label lblVoucherAmt;
    VBox progressContainer;
    @FXML
    private GridPane grid;
    @FXML
    private TableView<SaleAccountDetailResolver> tbPayment;
    @FXML
    private TableView<SaleItem> tbItem;
    @FXML
    private TableColumn<String, SaleItem> colItemCode;
    @FXML
    private TableColumn<String, SaleItem> colPrice;
    @FXML
    private TableColumn<String, SaleItem> colRet;
    @FXML
    private TableColumn<SaleItem, String> colDescription;
    @FXML
    private TableColumn<Float, SaleItem> colQty;
    @FXML
    private TableColumn<Float, SaleItem> colCnsQty;
    @FXML
    private TableColumn<Float, SaleItem> colDspQty;
    @FXML
    private TableColumn<Integer, SaleItem> colTotQty;
    @FXML
    private TableColumn<String, SaleAccountDetailResolver> colAccName;
    @FXML
    private TableColumn<String, SaleAccountDetailResolver> colAccNo;
    @FXML
    private TableColumn<String, SaleAccountDetailResolver> colAmount;
    @FXML
    private TableColumn<String, SaleAccountDetailResolver> colAccType;
    @FXML
    private TableColumn<String, SaleAccountDetailResolver> colpaycode;
    @FXML
    private TableColumn colSerial;
    @FXML
    private TableColumn colLineStatus;
    @FXML
    private TextField SearchTF;
    @FXML
    private ListView<Sale> listview;
    @FXML
    private MenuItem menuMyStore;
    @FXML
    private MenuItem menuOtherStore;
    private Sale sale = null;
    private SalesReturnItem salesReturnItemUI;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    private StockItemList stockItemList;
    private SaleList saleList;
    private Expenses expense;
    private ExpensesDataList expenseDataList;
    private Replenishment replenishment;
    private ReplenishmentList replenishmentDataList;
    private SaleItemList saleItemList;
    UnitDataList unitDataList;
    Customer currentCustomer;
    int i = 0;
    StoreDataList storeDataList;
    public Dialog dialog;

    public SalesReturnPane(Santa app) throws Exception {
        super("SalesReturnPane.fxml", app);
        this.title = "Sale Detail Page";
        this.unitDataList = new UnitDataList(this.da);
        this.unitDataList.SelectAll();
        this.stockItemList = new StockItemList(this.da);
        this.saleList = new SaleList(this.da);
        this.saleItemList = new SaleItemList(this.da);
        this.expense = new Expenses(this.da);
        this.expenseDataList = new ExpensesDataList(this.da);
        this.replenishmentDataList = new ReplenishmentList(this.da);
        this.replenishment = new Replenishment(this.da);
        this.from.setValue((Object)LocalDate.now());
        this.to.setValue((Object)LocalDate.now());
        this.grid.setVisible(false);
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll(this.da);
        Circle circle = new Circle(15.0, 15.0, 42.0);
        Tooltip tp = new Tooltip("Search by the following\nName\nPhone Number\nInvoice Number\nStaff");
        Tooltip.install((Node)circle, (Tooltip)tp);
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTF, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                SalesReturnPane.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        if (!UserType.valueOf(this.mainPage.currentUser.getRoleDescription()).equals((Object)UserType.Administrator)) {
            this.btnMark.setVisible(false);
        }
        this.listview.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.btnMark.setOnAction(x -> {
            if (this.listview.getSelectionModel().getSelectedItems() != null) {
                try {
                    this.listview.getSelectionModel().getSelectedItems().forEach(val -> {
                        if (val.getSyncFlag().booleanValue()) {
                            val.setSyncFlag(Boolean.FALSE);
                        } else {
                            val.setSyncFlag(Boolean.TRUE);
                        }
                        val.setSyncError("");
                    });
                    SaleList saleListHere = new SaleList(this.da);
                    saleListHere.getOriginalList().addAll((Collection)this.listview.getSelectionModel().getSelectedItems());
                    saleListHere.update();
                    this.listview.refresh();
                }
                catch (Exception ex) {
                    Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnPending.setOnAction(c -> {
            this.tempParamValue.clear();
            this.sale = new Sale(this.da);
            this.lblTotal.setText("0.0");
            this.tbItem.getItems().clear();
            this.tbPayment.getItems().clear();
            this.grid.setVisible(false);
            this.saleList = Sale.SearchSaleForSaleReturnNotSync(this.da);
            this.listview.getItems().clear();
            this.saleList.getOriginalList().forEach(val -> {
                String storeCode = val.getStoreCode() == null || val.getStoreCode().isEmpty() || val.getStoreCode().equals("NULL") ? this.currentUser.getParentCompany().getStoreCode() : val.getStoreCode();
                val.storeName = this.storeDataList.getOriginalList().stream().filter(x -> x.getCode().equals(storeCode)).findAny().get().getName();
            });
            this.listview.getItems().addAll(this.saleList.getOriginalList());
            if (this.saleList.getOriginalList().size() == 1) {
                this.listview.getSelectionModel().select(0);
                this.tbItem.setItems(((Sale)this.saleList.getOriginalList().get(0)).getSaleItemsList());
                this.tbItem.refresh();
                this.tbPayment.setItems(((Sale)this.saleList.getOriginalList().get(0)).getPayments().getOriginalList());
                this.tbPayment.refresh();
                this.setCustomerInfo((Sale)this.saleList.getOriginalList().get(0));
            }
            this.listview.refresh();
        });
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colDescription.setCellFactory(param -> {
            TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        SaleItem item = (SaleItem)this.getTableRow().getItem();
                        if (item != null) {
                            item.loadSerials();
                            Tooltip tooltip = new Tooltip(item.serialToolTipProperty());
                            lbl.setTooltip(tooltip);
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colRet.setCellValueFactory((Callback)new PropertyValueFactory("returnQty"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("sellingPrice"));
        this.colCnsQty.setCellValueFactory((Callback)new PropertyValueFactory("cnsQty"));
        this.colDspQty.setCellValueFactory((Callback)new PropertyValueFactory("dspQty"));
        this.colTotQty.setCellValueFactory((Callback)new PropertyValueFactory("totalQty"));
        this.colAccName.setCellValueFactory((Callback)new PropertyValueFactory("accountName"));
        this.colAccNo.setCellValueFactory((Callback)new PropertyValueFactory("accNumber"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountPaid"));
        this.colAccType.setCellValueFactory((Callback)new PropertyValueFactory("accType"));
        this.colpaycode.setCellValueFactory((Callback)new PropertyValueFactory("paymentCode"));
        this.SearchTF.setTooltip(tp);
        this.listview.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Sale>(){

            public void changed(ObservableValue<? extends Sale> observable, Sale oldValue, Sale newValue) {
                if (newValue != null) {
                    SalesReturnPane.this.lblTotal.setText(General.toNaira() + General.formatDecimalToMoneyString(newValue.getAmountPaid()));
                    if (newValue.getSyncFlag().booleanValue()) {
                        SalesReturnPane.this.btnMark.setText("Mark Unsync");
                    } else {
                        SalesReturnPane.this.btnMark.setText("Mark Sync");
                    }
                }
                SalesReturnPane.this.loadSaleItems();
            }
        });
        Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>> cellFactorycolLineStatus = new Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>>(){

            public TableCell call(TableColumn<SaleItem, String> param) {
                TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            SaleItem req = (SaleItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getLineStatus().isEmpty()) {
                                if (req.getLineStatus().equals("Invoiced")) {
                                    this.lbl.setStyle("-fx-background-color:#CCFFFF;-fx-font-size: 12.0px;");
                                } else {
                                    this.lbl.setStyle("-fx-background-color:#FC02DD;-fx-font-size: 12.0px;");
                                }
                                this.lbl.setText(req.getLineStatus());
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.setGraphic((Node)this.lbl);
                                this.setAlignment(Pos.CENTER);
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.setGraphic(null);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colLineStatus.setCellFactory((Callback)cellFactorycolLineStatus);
        Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>> cellFactoryVieSerial = new Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>>(){

            public TableCell call(TableColumn<SaleItem, String> param) {
                TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){
                    final JFXButton lbl = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            SaleItem req = (SaleItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getSerials().getOriginalList().isEmpty()) {
                                this.lbl.setPrefHeight(30.0);
                                this.lbl.setPrefWidth(30.0);
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.lbl.setGraphic((Node)SalesReturnPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.GREENYELLOW).size(15.0));
                                this.lbl.setOnAction(c -> {
                                    ObservableList observableList = FXCollections.observableArrayList();
                                    SalesReturnPane.this.i = 0;
                                    req.getSerials().getOriginalList().forEach(x -> {
                                        ++SalesReturnPane.this.i;
                                        NameValueObject valuePair = new NameValueObject(SalesReturnPane.this.da);
                                        valuePair.setKey(Integer.toString(SalesReturnPane.this.i));
                                        valuePair.setData(x.getSerial());
                                        observableList.add((Object)valuePair);
                                    });
                                    JFXDialog dialog = new JFXDialog();
                                    dialog.setDialogContainer(SalesReturnPane.this.stackPane);
                                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    dialog.setContent((Region)new SerialView(SalesReturnPane.this.santa, dialog, req.getItemName(), (ObservableList<NameValueObject>)observableList));
                                    dialog.setOverlayClose(false);
                                    dialog.show();
                                });
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.setGraphic(null);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colSerial.setCellFactory((Callback)cellFactoryVieSerial);
        this.listview.setCellFactory((Callback)new Callback<ListView<Sale>, ListCell<Sale>>(){

            public ListCell<Sale> call(ListView<Sale> param) {
                Label leadLbl = new Label();
                final Tooltip tooltip = new Tooltip();
                ListCell<Sale> cell = new ListCell<Sale>(){

                    public void updateItem(Sale sale, boolean empty) {
                        super.updateItem((Object)sale, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            JFXButton btnUpdate;
                            this.setText(null);
                            GridPane grid = new GridPane();
                            grid.setStyle("-fx-font-size: 11px; -fx-background-color:#ececf5;");
                            grid.setHgap(10.0);
                            grid.setVgap(4.0);
                            grid.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            Label icon = new Label();
                            if (sale.getSyncFlag().booleanValue()) {
                                icon.setGraphic((Node)SalesReturnPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.GREEN).size(20.0));
                            } else {
                                icon.setGraphic((Node)SalesReturnPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES_CIRCLE_ALT).color(Color.RED).size(20.0));
                            }
                            String cachelisticon = " -fx-text-fill: #444444;-fx-font: bold; -fx-effect: dropshadow( three-pass-box, rgba(0,0,0,0.4), 3, 0.0, 1, 1);";
                            icon.getStyleClass().add((Object)cachelisticon);
                            grid.add((Node)icon, 0, 0, 1, 2);
                            Label name = new Label("Invoice Number:" + sale.getHdInvoiceNo());
                            String cachelistname = "-fx-font-weight: bold;";
                            name.getStyleClass().add((Object)cachelistname);
                            grid.add((Node)name, 1, 0);
                            Label date = new Label("Transaction Date:" + new SimpleDateFormat("dd-MM-yyyy").format(sale.getTransactionDate()));
                            grid.add((Node)date, 1, 1);
                            Label dt = new Label((String)(sale.getSaleId().isEmpty() && sale.getSyncError().isEmpty() ? "Not Sync" : "Sale Id:" + sale.getSaleId()));
                            Object style = "-fx-font-weight: bold;";
                            if (sale.getIsManual().booleanValue()) {
                                style = (String)style + "-fx-background-color:#F6DDCC;";
                            }
                            dt.setStyle((String)style);
                            grid.add((Node)dt, 1, 2);
                            Label creditDescription = new Label((String)(sale.getCreditDescription().isEmpty() ? "Credit Description: No Credit" : "Credit Description: " + sale.getCreditDescription()));
                            grid.add((Node)creditDescription, 1, 3);
                            Label creditToken = new Label((String)(sale.getCreditToken().isEmpty() ? "Credit Token: No Token" : "Credit Token: " + sale.getCreditToken()));
                            grid.add((Node)creditToken, 1, 4);
                            if (!sale.getCreditToken().isEmpty()) {
                                creditToken.setStyle(cachelistname);
                            }
                            JFXButton btnReload = new JFXButton("Reload");
                            btnReload.setStyle("-fx-background-color: #B4B3C9 ;");
                            btnReload.setOnAction(eh -> {
                                try {
                                    SalesReturnPane.this.loadSale(new JSONObject().put("storeId", (Object)sale.getStoreCode()).put("invoiceNumber", (Object)String.valueOf(sale.getInvoiceNumber())), sale);
                                }
                                catch (JSONException ex) {
                                    Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            grid.add((Node)btnReload, 1, 5);
                            if (!sale.img.isEmpty()) {
                                JFXButton btnViewImage = new JFXButton("View Attachment");
                                btnViewImage.setStyle("-fx-background-color: #4FC4F6 ;");
                                grid.add((Node)btnViewImage, 1, 6);
                                btnViewImage.setOnAction(eh -> {
                                    FlowPane bp = new FlowPane();
                                    bp.setOrientation(Orientation.VERTICAL);
                                    sale.img.forEach(im -> {
                                        ImageView imgView = new ImageView();
                                        imgView.setFitWidth(300.0);
                                        imgView.setFitHeight(300.0);
                                        imgView.setPreserveRatio(true);
                                        imgView.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)im, null));
                                        bp.getChildren().add((Object)imgView);
                                    });
                                    SalesReturnPane.this.dialog = new Dialog();
                                    SalesReturnPane.this.dialog.initStyle(StageStyle.DECORATED);
                                    SalesReturnPane.this.dialog.initOwner((Window)SalesReturnPane.this.santa.stage);
                                    SalesReturnPane.this.dialog.setTitle("Files");
                                    SalesReturnPane.this.dialog.setResizable(true);
                                    SalesReturnPane.this.dialog.getDialogPane().setContent((Node)bp);
                                    SalesReturnPane.this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                                    SalesReturnPane.this.dialog.show();
                                });
                            }
                            if (sale.getSyncFlag().booleanValue() && sale.getSaleStatus().equals(SaleStatus.COMPLETED.name()) || sale.getSaleStatus().equals(SaleStatus.PENDINGRETURN.name()) || sale.getSaleStatus().equals(SaleStatus.RETURNAPPROVED.name())) {
                                JFXButton btnReturn = new JFXButton("Initiate Return  Approval");
                                btnReturn.setStyle("-fx-background-color: #7c4ff6;");
                                if (sale.getSaleStatus().equals(SaleStatus.PENDINGRETURN.name())) {
                                    btnReturn.setText("PENDING RETURN");
                                }
                                if (sale.getSaleStatus().equals(SaleStatus.RETURNAPPROVED.name())) {
                                    btnReturn.setText("RETURN");
                                }
                                btnReturn.setOnAction(eh -> {
                                    if (sale.getSaleStatus().equals(SaleStatus.PENDINGRETURN.name()) || sale.getSaleStatus().equals(SaleStatus.COMPLETED.name())) {
                                        SalesReturnPane.this.dialog = new Dialog();
                                        SalesReturnPane.this.dialog.initStyle(StageStyle.DECORATED);
                                        SalesReturnPane.this.dialog.initOwner((Window)SalesReturnPane.this.santa.stage);
                                        SalesReturnPane.this.dialog.setTitle("Return");
                                        SalesReturnPane.this.dialog.setResizable(true);
                                        SalesReturnPane.this.dialog.getDialogPane().setContent((Node)new SalesReturn(sale, SalesReturnPane.this));
                                        SalesReturnPane.this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                                        SalesReturnPane.this.dialog.show();
                                    }
                                    if (sale.getSaleStatus().equals(SaleStatus.RETURNAPPROVED.name())) {
                                        SalesReturnPane.this.returnSale(sale);
                                    }
                                });
                                grid.add((Node)btnReturn, 1, sale.img.isEmpty() ? 6 : 7);
                            }
                            Label salesResponsible = new Label((String)(sale.getSalesRep().isEmpty() ? "Sales Rep.: " : "Sales Responsible: " + sale.getSalesRep()));
                            grid.add((Node)salesResponsible, 1, grid.getRowCount() + 1);
                            if (!sale.getSyncFlag().booleanValue()) {
                                btnUpdate = new JFXButton("Sync");
                                btnUpdate.setStyle("-fx-background-color: #43C6B6;");
                                grid.add((Node)btnUpdate, 1, grid.getRowCount() + 1);
                                btnUpdate.setOnAction(eh -> SalesReturnPane.this.pushSales(sale, "salesorder/createSalesorder"));
                            }
                            if (SalesReturnPane.this.currentUser.getRoleDescription().equals(UserType.Administrator.name())) {
                                btnUpdate = new JFXButton("Update");
                                btnUpdate.setStyle("-fx-background-color: #73C6B6;");
                                grid.add((Node)btnUpdate, 1, grid.getRowCount() + 1);
                                btnUpdate.setOnAction(eh -> SalesReturnPane.this.pushSales(sale, "salesorder/updateSalesorderDetails"));
                            }
                            tooltip.setText(sale.getSyncError());
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)grid);
                        }
                    }
                };
                return cell;
            }
        });
        General.selectAll(this.SearchTF);
        this.reprint.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (SalesReturnPane.this.listview.getSelectionModel().getSelectedItem() != null) {
                    Dialog dialog = new Dialog();
                    dialog.initStyle(StageStyle.DECORATED);
                    dialog.initOwner((Window)SalesReturnPane.this.santa.stage);
                    dialog.setTitle("Duplicate Invoice");
                    dialog.setResizable(true);
                    try {
                        dialog.getDialogPane().setContent((Node)new ReportPane(SalesReturnPane.this.santa, ReportType.Invoice, (Sale)SalesReturnPane.this.listview.getSelectionModel().getSelectedItem()));
                    }
                    catch (JRException ex) {
                        Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                    dialog.show();
                }
            }
        });
        this.menuMyStore.setOnAction(it -> {
            if (this.listview.getSelectionModel().getSelectedItem() != null) {
                this.printInvoice((Sale)this.listview.getSelectionModel().getSelectedItem());
            }
        });
        this.menuOtherStore.setOnAction(it -> {
            this.dialog = new Dialog();
            this.dialog.initStyle(StageStyle.DECORATED);
            this.dialog.initOwner((Window)this.santa.stage);
            this.dialog.setTitle("Sale");
            this.dialog.setResizable(true);
            this.dialog.getDialogPane().setContent((Node)new ReprintInvoiceSearchDialog(this));
            this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
            this.dialog.show();
        });
        this.btnResyncSale.setOnAction(et -> this.pushSales(null, "salesorder/createSalesorder"));
    }

    void pushSales(final Sale s, final String url) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        new SyncData(SalesReturnPane.this.santa, SalesReturnPane.this.da, SalesReturnPane.this.currentUser.getParentCompany()).pushSales(SalesReturnPane.this.santa.syncSetting, s, url, new IWebCallBack(){

                            @Override
                            public void onSuccess(String data) {
                                SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                SalesReturnPane.this.mainPage.showNotification(NotificationType.Success, "Operation successful,Please reload the sale", SalesReturnPane.this);
                                SalesReturnPane.this.populateSearch(SalesReturnPane.this.SearchTF.getText());
                            }

                            @Override
                            public void onError(String data) {
                                SalesReturnPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesReturnPane.this);
                                SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                SalesReturnPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesReturnPane.this);
                                SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void showListviewDialog(ObservableList<Sale> sales) {
        final ListView list = new ListView();
        list.setPrefWidth(800.0);
        list.setPrefHeight(500.0);
        list.setItems(sales);
        list.setCellFactory((Callback)new Callback<ListView<Sale>, ListCell<Sale>>(){

            public ListCell<Sale> call(ListView<Sale> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<Sale> cell = new ListCell<Sale>(){

                    public void updateItem(Sale sale, boolean empty) {
                        super.updateItem((Object)sale, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            tooltip.setText(sale.getSyncError());
                            this.setTooltip(tooltip);
                            int index = list.getItems().indexOf((Object)sale);
                            SaleReprintItem srp = null;
                            srp = index == 0 ? new SaleReprintItem(sale, true, SalesReturnPane.this) : new SaleReprintItem(sale, false, SalesReturnPane.this);
                            this.setGraphic((Node)srp);
                        }
                    }
                };
                return cell;
            }
        });
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.DECORATED);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setTitle("Sale");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent((Node)list);
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.show();
    }

    public void returnSale(final Sale s) {
        if (this.dialog != null) {
            this.dialog.close();
        }
        if (s.getSaleStatus().equals(SaleStatus.COMPLETED.name())) {
            s.setReturnedBy(this.currentUser.getUserName());
        }
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        try {
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            JSONObject json = new JSONObject();
                            json.put("salesId", (Object)s.getSaleId());
                            json.put("invoiceNumber", (Object)s.getHdInvoiceNo());
                            json.put("storeId", (Object)s.getStoreCode());
                            json.put("returnComment", (Object)s.getReturnComment());
                            json.put("returnedBy", (Object)s.getReturnedBy());
                            JSONArray jsonArr = new JSONArray();
                            s.getSaleItemsList().forEach(item -> {
                                try {
                                    JSONObject jsonObj = new JSONObject();
                                    jsonObj.put("itemId", (Object)item.getItemCode());
                                    jsonObj.put("returnQty", (double)item.getQtyToreturnQty());
                                    jsonArr.put((Object)jsonObj);
                                }
                                catch (JSONException ex) {
                                    Platform.runLater(() -> {
                                        SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                        SalesReturnPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesReturnPane.this);
                                    });
                                }
                            });
                            json.put("lines", (Object)jsonArr);
                            System.out.println("payload:" + jsonArr.toString());
                            new WebRequest(WebRequest.SALES_RETURN, RequestTypeEnum.POST, json.toString(), null, new IWebCallBack(){

                                @Override
                                public void onSuccess(String data) {
                                    try {
                                        JSONArray jsonArr = new JSONArray(data);
                                        if (jsonArr.length() > 0) {
                                            Sale sale;
                                            JSONObject json = jsonArr.getJSONObject(0);
                                            s.setSaleStatus(json.getString("salesOrderStatus"));
                                            s.setSyncError(json.isNull("syncError") ? "" : json.getString("syncError"));
                                            SaleList sl = new SaleList(SalesReturnPane.this.da);
                                            StockItemList stockItemList = new StockItemList(SalesReturnPane.this.da);
                                            SaleItemList saleItemList = new SaleItemList(SalesReturnPane.this.da);
                                            if (s.getSyncError().isEmpty() && s.getSaleStatus().equals(SaleStatus.RETURNED.name())) {
                                                s.setSyncFlag(true);
                                                JSONArray salelines = json.getJSONArray("salesOrderLines");
                                                for (int j = 0; j < salelines.length(); ++j) {
                                                    JSONObject sljson = salelines.getJSONObject(j);
                                                    String itemCode = sljson.getString("itemId");
                                                    SaleItem item = s.getSaleItemsList().stream().filter(prdct -> prdct.getItemCode().equals(itemCode)).findAny().orElse(null);
                                                    item.setReturnQty(sljson.isNull("returnQty") ? 0.0f : (float)sljson.getInt("returnQty"));
                                                }
                                                s.getSaleItemsList().forEach(si -> {
                                                    if (si.getReturnQty() > 0.0f) {
                                                        if (SalesReturnPane.this.da == null) {
                                                            System.out.println("Da is null");
                                                        }
                                                        si.setDbAccess(SalesReturnPane.this.da);
                                                        si.getParentStockItem().setQuantity(si.getParentStockItem().getQuantity() + si.getReturnQty());
                                                        stockItemList.getOriginalList().add((Object)si.getParentStockItem());
                                                        saleItemList.getOriginalList().add(si);
                                                    }
                                                });
                                            }
                                            sl.getOriginalList().add((Object)s);
                                            sl.update();
                                            if (!stockItemList.getOriginalList().isEmpty()) {
                                                stockItemList.update();
                                            }
                                            if (!saleItemList.getOriginalList().isEmpty()) {
                                                saleItemList.update();
                                            }
                                            if ((sale = (Sale)SalesReturnPane.this.listview.getItems().stream().filter(prdct -> prdct.getInvoiceNumber() == s.getInvoiceNumber()).findAny().orElse(null)) != null) {
                                                sale.setSaleStatus(s.getSaleStatus());
                                                sale.setSyncFlag(s.getSyncFlag());
                                                sale.setSyncError(s.getSyncError());
                                                Platform.runLater(() -> {
                                                    System.out.println("status :" + s.getSaleStatus());
                                                    SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                                    SalesReturnPane.this.listview.refresh();
                                                    SalesReturnPane.this.mainPage.showNotification(NotificationType.Success, "Operation successful", SalesReturnPane.this);
                                                });
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        Platform.runLater(() -> {
                                            Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
                                            SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                            SalesReturnPane.this.mainPage.showNotification(NotificationType.Success, "Operation successful", SalesReturnPane.this);
                                        });
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                        SalesReturnPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesReturnPane.this);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                        SalesReturnPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesReturnPane.this);
                                    });
                                }
                            }).execute(false);
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        }
        catch (Exception ex) {
            this.stackPane.getChildren().remove((Object)box);
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadSale(final JSONObject js, final Sale s) {
        if (this.dialog != null) {
            this.dialog.close();
        }
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        try {
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            SyncData syncData = new SyncData(SalesReturnPane.this.santa, SalesReturnPane.this.da, SalesReturnPane.this.santa.currentUser.getParentCompany());
                            String url = "salesorder/getSalesorder?condition=" + js.toString();
                            syncData.getSale(url, SalesReturnPane.this.da, new ISaleCallBack(){

                                @Override
                                public void onSuccess(SaleList data) {
                                    System.out.println(data.toString());
                                    SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                    if (data.getOriginalList().size() > 0 && s == null) {
                                        if (data.getOriginalList().size() > 1) {
                                            SalesReturnPane.this.showListviewDialog(data.getOriginalList());
                                        } else {
                                            SalesReturnPane.this.printInvoice((Sale)data.getOriginalList().get(0));
                                        }
                                    } else if (data.getOriginalList().size() > 0 && s != null) {
                                        try {
                                            SaleList list = new SaleList(SalesReturnPane.this.da);
                                            SaleItemList lines = new SaleItemList(SalesReturnPane.this.da);
                                            Sale saleFromServer = (Sale)data.getOriginalList().get(0);
                                            saleFromServer.setState(ObjectState.Changed);
                                            saleFromServer.setTransactionDate(s.getTransactionDate());
                                            saleFromServer.setDbAccess(SalesReturnPane.this.da);
                                            saleFromServer.vClone = saleFromServer.Clone();
                                            list.getOriginalList().add((Object)saleFromServer);
                                            saleFromServer.getSaleItemsList().forEach(ret -> {
                                                ret.vclone = ret.clone();
                                                ret.setDbAccess(SalesReturnPane.this.da);
                                                ret.setState(ObjectState.Changed);
                                            });
                                            lines.getOriginalList().addAll(saleFromServer.getSaleItemsList());
                                            list.update();
                                            lines.update();
                                            saleFromServer.setPayments(s.getPayments());
                                            System.out.println("SaleId:" + saleFromServer.getSaleId());
                                            int index = SalesReturnPane.this.listview.getItems().indexOf((Object)s);
                                            SalesReturnPane.this.listview.getItems().remove(index);
                                            SalesReturnPane.this.listview.getItems().add(index, (Object)saleFromServer);
                                            SalesReturnPane.this.mainPage.showNotification(NotificationType.Success, "Sale with invoice  number " + s.getHdInvoiceNo() + " loaded successfully", SalesReturnPane.this);
                                            SalesReturnPane.this.listview.refresh();
                                        }
                                        catch (Exception ex) {
                                            SalesReturnPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesReturnPane.this);
                                        }
                                    } else {
                                        SalesReturnPane.this.mainPage.showNotification(NotificationType.Information, "No sale found", SalesReturnPane.this);
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    SalesReturnPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesReturnPane.this);
                                    SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    SalesReturnPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesReturnPane.this);
                                    SalesReturnPane.this.stackPane.getChildren().remove((Object)box);
                                }
                            });
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        }
        catch (Exception ex) {
            this.stackPane.getChildren().remove((Object)box);
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void printInvoice(Sale s) {
        if (this.dialog != null) {
            this.dialog.close();
        }
        Dialog dialog = new Dialog();
        dialog.initStyle(StageStyle.DECORATED);
        dialog.initOwner((Window)this.santa.stage);
        dialog.setTitle("Duplicate Invoice");
        dialog.setResizable(true);
        dialog.getDialogPane().setPrefHeight((double)Santa.dialogHeight.floatValue());
        dialog.getDialogPane().setPrefWidth((double)Santa.dialogWidth.floatValue());
        try {
            s.Reprint = "Duplicate";
            dialog.getDialogPane().setContent((Node)new ReportPane(this.santa, ReportType.Invoice, s));
        }
        catch (JRException ex) {
            Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SalesReturnPane.class.getName()).log(Level.SEVERE, null, ex);
        }
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        dialog.show();
    }

    void setCustomerInfo(Sale sale) {
        if (sale.getParentCustomer() != null) {
            this.grid.setVisible(true);
            this.lblUsername.setText(sale.getCustomerName());
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            String saleDateString = format.format(sale.getTransactionDate());
            this.lblDate.setText(saleDateString);
            this.lblPnum.setText(sale.getCustomerPhoneNumber());
            this.lblSap.setText(sale.getd365CustomerNo());
        } else {
            this.grid.setVisible(false);
        }
    }

    @Override
    public void populateSearch(String SearchValue) {
        this.tempParamValue.clear();
        this.sale = new Sale(this.da);
        this.lblTotal.setText("0.0");
        this.tbItem.getItems().clear();
        this.tbPayment.getItems().clear();
        this.grid.setVisible(false);
        this.saleList = Sale.SearchSaleItemForSaleReturn(SearchValue, this.from.getValue() != null ? Date.valueOf((LocalDate)this.from.getValue()) : null, this.to.getValue() != null ? Date.valueOf((LocalDate)this.to.getValue()) : null, this.da, this.currentUser);
        this.listview.getItems().clear();
        this.saleList.getOriginalList().forEach(val -> {
            String storeCode = val.getStoreCode() == null || val.getStoreCode().isEmpty() ? this.currentUser.getParentCompany().getStoreCode() : val.getStoreCode();
            val.storeName = this.storeDataList.getOriginalList().stream().filter(x -> x.getCode().equals(storeCode)).findAny().get().getName();
        });
        this.listview.getItems().addAll(this.saleList.getOriginalList());
        if (this.saleList.getOriginalList().size() == 1) {
            this.listview.getSelectionModel().select(0);
            this.tbItem.setItems(((Sale)this.saleList.getOriginalList().get(0)).getSaleItemsList());
            this.tbItem.refresh();
            this.tbPayment.setItems(((Sale)this.saleList.getOriginalList().get(0)).getPayments().getOriginalList());
            this.tbPayment.refresh();
            this.setCustomerInfo((Sale)this.saleList.getOriginalList().get(0));
        }
        this.listview.refresh();
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return SaleList.selectAutoComplete(searchString, this.da);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    @FXML
    private void SearchButtonOnAction(ActionEvent event) {
        this.populateSearch(this.SearchTF.getText());
    }

    @FXML
    private void RefreshButtonOnAction(ActionEvent event) {
        this.resetSalereturn();
    }

    private void resetSalereturn() {
    }

    private void returnItem() {
        try {
            if (this.listview.getItems().size() > 0 && this.needToSave()) {
                this.sale.setStaff(this.mainPage.currentUser);
                this.sale.returnSales();
                this.resetSalereturn();
                this.mainPage.showNotification(NotificationType.Information, "Operation Successful", this);
            }
        }
        catch (Exception e) {
            this.mainPage.showNotification(NotificationType.Error, e.getMessage(), this);
        }
    }

    private void loadSaleItems() {
        this.tempParamValue.clear();
        this.sale = (Sale)this.listview.getSelectionModel().getSelectedItem();
        if (this.sale != null) {
            this.tbItem.setItems(this.sale.getSaleItemsList());
            this.tbItem.refresh();
            this.tbPayment.setItems(this.sale.getPayments().getOriginalList());
            this.tbPayment.refresh();
            this.lblVoucherAmt.setText((String)(this.sale.getPromoVoucherAmt() > 0.0 ? General.toNaira() + General.formatDecimalToMoneyString(this.sale.getPromoVoucherAmt()) : ""));
            this.lblVoucherCode.setText(this.sale.getPromoVoucherAmt() > 0.0 ? this.sale.getPromoVoucher() : "");
            this.setCustomerInfo(this.sale);
        }
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        if (this.sale != null) {
            for (SaleItem sa : this.sale.getSaleItemsList()) {
                if (!(sa.getQuantity() > 0.0f)) continue;
                this.needToSave = true;
                break;
            }
        }
        if (this.needToSave) {
            if (this.sale.getSaleItemsList().size() == 0) {
                this.errorMessage = this.errorMessage + "No item to sell";
            }
            if (!this.errorMessage.equals("")) {
                this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
                return false;
            }
        }
        return true;
    }

    @Override
    boolean needToSave() {
        if (this.sale != null && (Sale)this.listview.getSelectionModel().getSelectedItem() != null) {
            for (SaleItem saleitem : ((Sale)this.listview.getSelectionModel().getSelectedItem()).getSaleItemsList()) {
                if (!(saleitem.qtyToreturnQtyProperty().get() > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void yes() {
        try {
            this.returnItem();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = true;
    }
}

