/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTabPane;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.RequestTypeEnum;
import com.xputertechnologies.santa.RequestitemSerial;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.RequestDataList;
import com.xputertechnologies.santa.list.RequestItemDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.report.CSVUtils;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.MenuControl;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.RequestItemRepeatingCart;
import com.xputertechnologies.santa.ui.SalesPaneB2B;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.TempRoleManagement;
import com.xputertechnologies.santa.ui.TransferPane;
import com.xputertechnologies.santa.ui.TransferReleaseScanSerial;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class NewRequestPane
extends UIParent {
    @FXML
    JFXTabPane tabPane;
    @FXML
    TextArea Comment;
    @FXML
    TextArea Comment1;
    @FXML
    private JFXButton btnRequest;
    @FXML
    private JFXButton btnRequest1;
    @FXML
    private JFXButton download;
    @FXML
    private JFXButton upload;
    @FXML
    private JFXButton download1;
    @FXML
    private JFXButton upload1;
    @FXML
    private JFXButton btnAvailQty1;
    @FXML
    private JFXButton btnAvailQty;
    @FXML
    private JFXButton btnAdd1;
    @FXML
    private JFXButton btnAdd;
    @FXML
    public VBox vbRepeatingRequested;
    @FXML
    public VBox vbRepeatingRequested1;
    @FXML
    public VBox vbWh;
    @FXML
    public VBox vbWh1;
    @FXML
    private JFXComboBox<Store> cmbToStore;
    @FXML
    private JFXComboBox<Store> cmbFromStore1;
    @FXML
    private JFXComboBox<Store> cmbTowareHouse1;
    @FXML
    private JFXComboBox<Store> cmbRequestStore;
    public Request request;
    StockItemList stockItemList;
    String requestCode;
    StoreDataList storeDataList;
    public TransferPane parent;
    @FXML
    private TextField SearchTextField;
    @FXML
    private TextField SearchTextField1;
    @FXML
    private StackPane stackPane;
    @FXML
    private StackPane stackPane1;
    VBox progressContainer;
    SyncSettingDataList syncSettingDataList = null;
    @FXML
    private Tab tabInbound;
    @FXML
    private Tab tabOubound;
    @FXML
    public JFXDialog dialog;
    VBox box;
    ArrayList<ParameterValue> ar = new ArrayList();
    String qry;
    public List<StockItemData> allProducts;
    String url = "";
    String payload = "";
    JSONObject ra = null;
    JSONArray arr = null;
    String reqCode = null;

    public NewRequestPane(Santa app, final TransferPane parent) {
        super("NewRequestPane.fxml", app);
        Store store;
        this.hasParent = true;
        this.santa = app;
        this.title = "New Request";
        this.upload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.UPLOAD).color(Color.WHITE).size(15.0));
        this.upload1.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.UPLOAD).color(Color.WHITE).size(15.0));
        this.download.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.DOWNLOAD).color(Color.WHITE).size(15.0));
        this.download1.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.DOWNLOAD).color(Color.WHITE).size(15.0));
        this.btnAvailQty1.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.SEARCH_PLUS).color(Color.WHITE).size(15.0));
        this.btnAvailQty.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.SEARCH_PLUS).color(Color.WHITE).size(15.0));
        General.selectAll(this.SearchTextField);
        this.tabOubound.setDisable(!TempRoleManagement.headOfficeOnly(UserType.valueOf(this.mainPage.currentUser.getRoleDescription())));
        this.request = new Request(this.da);
        this.request.setRequestType(RequestType.Inbound.name());
        this.request.setCode(Santa.getUniqueId(this.currentUser.getParentCompany().getStoreCode()));
        this.request.setFromStoreCode(app.currentUser.getParentCompany().getStoreCode());
        ObservableList options = FXCollections.observableArrayList();
        for (int i = 0; i < RequestType.values().length; ++i) {
            if (i == 0) continue;
            options.add((Object)RequestType.values()[i].name());
        }
        this.vbRepeatingRequested.setFillWidth(true);
        this.vbRepeatingRequested1.setPrefWidth(this.getPrefWidth());
        this.download.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NewRequestPane.this.download();
            }
        });
        this.download1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NewRequestPane.this.download();
            }
        });
        this.upload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NewRequestPane.this.upload();
            }
        });
        this.upload1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NewRequestPane.this.upload();
            }
        });
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> observable, Tab oldValue, Tab newValue) {
                if (NewRequestPane.this.tabInbound.equals(newValue)) {
                    NewRequestPane.this.ResetInterface(true);
                } else {
                    NewRequestPane.this.ResetInterface(false);
                }
            }
        });
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll(this.da);
        this.parent = parent;
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTextField, t -> {
            List<StockItemData> result = this.searchDataHere(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<StockItemData>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<StockItemData> event) {
                NewRequestPane.this.populate((StockItemData)event.getCompletion());
            }
        });
        autoCompletionBinding.setPrefWidth(550.0);
        AutoCompletionBinding autoCompletionBinding1 = TextFields.bindAutoCompletion((TextField)this.SearchTextField1, t -> {
            List<StockItemData> result = this.searchDataHere(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding1.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<StockItemData>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<StockItemData> event) {
                NewRequestPane.this.populate1((StockItemData)event.getCompletion());
            }
        });
        this.SearchTextField1.setOnAction(v -> {
            StockItemList itemList = new StockItemList(this.da);
            itemList.selectWithSerial(this.SearchTextField1.getText());
            if (itemList.getOriginalList().size() > 0) {
                RequestItem reqItem = this.request.getItems().stream().filter(x -> x.getItemCode().equals(((StockItem)itemList.getOriginalList().get(0)).getItemCode())).findAny().orElse(null);
                if (reqItem == null) {
                    reqItem = new RequestItem(this.da);
                    reqItem.setItemCode(((StockItem)itemList.getOriginalList().get(0)).getItemCode());
                    reqItem.setItemName(((StockItem)itemList.getOriginalList().get(0)).getName());
                    reqItem.setQuantity(1);
                    reqItem.setRequestCode(this.request.getCode());
                    RequestitemSerial serial = new RequestitemSerial(this.da);
                    serial.setItemCode(reqItem.getItemCode());
                    serial.setRequestItemCode(reqItem.getCode());
                    serial.setRequestCode(reqItem.getRequestCode());
                    serial.setSerial(this.SearchTextField1.getText().trim());
                    reqItem.getSerials().add((Object)serial);
                    reqItem.setQuantity(reqItem.getSerials().size());
                    this.request.getItems().add(this.request.getItems().size(), (Object)reqItem);
                    this.vbRepeatingRequested1.getChildren().add((Object)new RequestItemRepeatingCart(reqItem, this));
                } else if (reqItem.getSerials().stream().filter(z -> z.getSerial().equals(this.SearchTextField1.getText().trim())).count() == 0L) {
                    RequestitemSerial serial = new RequestitemSerial(this.da);
                    serial.setItemCode(reqItem.getItemCode());
                    serial.setRequestItemCode(reqItem.getCode());
                    serial.setRequestCode(reqItem.getRequestCode());
                    serial.setSerial(this.SearchTextField1.getText().trim());
                    reqItem.getSerials().add((Object)serial);
                    reqItem.setQuantity(reqItem.getSerials().size());
                    RequestItemRepeatingCart cart = this.vbRepeatingRequested1.getChildren().stream().filter(cat -> ((RequestItemRepeatingCart)cat).product.getItemCode().equals(((StockItem)itemList.getOriginalList().get(0)).getItemCode())).findAny().orElse(null);
                    cart.product.setQuantity(cart.product.getSerials().size());
                } else {
                    parent.mainPage.showNotification(NotificationType.Information, "Item with the same serial already scanned.", parent);
                }
                this.request.resetNumbering();
            } else {
                parent.mainPage.showNotification(NotificationType.Information, "No item found for Serial " + this.SearchTextField1.getText(), parent);
            }
            this.SearchTextField1.clear();
            this.SearchTextField1.requestFocus();
        });
        autoCompletionBinding1.setPrefWidth(550.0);
        this.vbWh.setDisable(!this.mainPage.currentUser.getRoleDescription().equals(UserType.RetailHead.name()) && !this.mainPage.currentUser.getRoleDescription().equals(UserType.Administrator.name()));
        this.vbWh1.setDisable(!this.mainPage.currentUser.getRoleDescription().equals(UserType.RetailHead.name()) && !this.mainPage.currentUser.getRoleDescription().equals(UserType.Administrator.name()));
        ObservableList stores = FXCollections.observableArrayList((Collection)this.storeDataList.getOriginalList().stream().filter(prdct -> prdct.getName() != null && !prdct.getName().isEmpty()).collect(Collectors.toList()));
        this.cmbRequestStore.setItems(stores);
        if (this.currentUser != null && this.currentUser.getParentCompany() != null && (store = (Store)this.cmbRequestStore.getItems().stream().filter(prdct -> prdct.getCode().equals(this.currentUser.getParentCompany().getStoreCode())).findAny().orElse(null)) != null) {
            this.cmbRequestStore.getSelectionModel().select((Object)store);
        }
        this.cmbTowareHouse1.setItems(stores);
        this.cmbTowareHouse1.getSelectionModel().select(0);
        this.cmbToStore.setItems(stores);
        this.cmbToStore.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue != null) {
                    NewRequestPane.this.request.setToStoreCode(((Store)newValue).getCode());
                    NewRequestPane.this.request.setToStoreName(((Store)newValue).getName());
                }
            }
        });
        this.cmbFromStore1.setItems(stores);
        this.cmbFromStore1.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue != null) {
                    NewRequestPane.this.request.setToStoreCode(((Store)newValue).getCode());
                }
            }
        });
        this.btnRequest.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.GREEN).size((double)MenuControl.iconSize));
        this.btnRequest1.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.GREEN).size((double)MenuControl.iconSize));
        this.btnRequest.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Object error = "";
                NewRequestPane.this.request.setReason(NewRequestPane.this.Comment.getText());
                if (NewRequestPane.this.vbRepeatingRequested.getChildren().size() == 0) {
                    error = "No item picked for Transfer \n";
                }
                if (NewRequestPane.this.request.getReason() == null || NewRequestPane.this.request.getReason().isEmpty()) {
                    error = (String)error + "Please select or type reason for this request \n";
                }
                if (NewRequestPane.this.request.getItems().size() == 0) {
                    error = (String)error + "Please add item(s) for for this request \n";
                }
                if (NewRequestPane.this.request.getItems().stream().filter(p -> p.getQuantity() == 0).findAny().orElse(null) != null) {
                    error = (String)error + "Please make sure you set quantity for all items \n";
                }
                if (NewRequestPane.this.request.getToStoreCode() == null || NewRequestPane.this.request.getToStoreCode().isEmpty()) {
                    error = (String)error + "Please make sure you select Destination store";
                }
                if (((String)error).isEmpty()) {
                    if (NewRequestPane.this.mainPage.currentUser.getRoleDescription().equals(UserType.RetailHead.name()) || NewRequestPane.this.mainPage.currentUser.getRoleDescription().equals(UserType.Administrator.name())) {
                        NewRequestPane.this.request.setFromStoreCode(((Store)NewRequestPane.this.cmbRequestStore.getSelectionModel().getSelectedItem()).getCode());
                    }
                    NewRequestPane.this.postRequest();
                } else {
                    parent.mainPage.showNotification(NotificationType.Error, (String)error, parent);
                }
            }
        });
        this.btnRequest1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Object error = "";
                NewRequestPane.this.request.setReason(NewRequestPane.this.Comment1.getText());
                if (NewRequestPane.this.vbRepeatingRequested1.getChildren().size() == 0) {
                    error = "No item picked for Transfer \n";
                }
                if (NewRequestPane.this.request.getReason() == null || NewRequestPane.this.request.getReason().isEmpty()) {
                    error = (String)error + "Please select or type reason for this request \n";
                }
                if (NewRequestPane.this.request.getItems().size() == 0) {
                    error = (String)error + "Please add item(s) for for this request \n";
                }
                if (NewRequestPane.this.request.getItems().stream().filter(p -> p.getQuantity() == 0).findAny().orElse(null) != null) {
                    error = (String)error + "Please make sure you set quantity for all items \n";
                }
                if (NewRequestPane.this.request.getToStoreCode() == null || NewRequestPane.this.request.getToStoreCode().isEmpty()) {
                    error = (String)error + "Please make sure you select Destination store";
                }
                if (((String)error).isEmpty()) {
                    if (NewRequestPane.this.mainPage.currentUser.getRoleDescription().equals(UserType.RetailHead.name()) || NewRequestPane.this.mainPage.currentUser.getRoleDescription().equals(UserType.Administrator.name())) {
                        NewRequestPane.this.request.setFromStoreCode(((Store)NewRequestPane.this.cmbTowareHouse1.getSelectionModel().getSelectedItem()).getCode());
                    }
                    NewRequestPane.this.postRequest();
                } else {
                    parent.mainPage.showNotification(NotificationType.Error, (String)error, parent);
                }
            }
        });
        this.btnAvailQty1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (NewRequestPane.this.request.getItems().size() > 0) {
                    if (NewRequestPane.this.mainPage.currentUser.getRoleDescription().equals(UserType.RetailHead.name()) || NewRequestPane.this.mainPage.currentUser.getRoleDescription().equals(UserType.Administrator.name())) {
                        NewRequestPane.this.request.setFromStoreCode(((Store)NewRequestPane.this.cmbRequestStore.getSelectionModel().getSelectedItem()).getCode());
                    }
                    NewRequestPane.this.checkRequestQty();
                } else {
                    parent.mainPage.showNotification(NotificationType.Error, "No item to check", parent);
                }
            }
        });
        this.btnAvailQty.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (NewRequestPane.this.request.getItems().size() > 0) {
                    if (NewRequestPane.this.cmbToStore.getSelectionModel().getSelectedItem() != null) {
                        NewRequestPane.this.checkRequestQty();
                    } else {
                        parent.mainPage.showNotification(NotificationType.Error, "Please select source store", parent);
                    }
                } else {
                    parent.mainPage.showNotification(NotificationType.Error, "No item to check", parent);
                }
            }
        });
        this.btnAdd1.setOnAction(val -> {
            if (!this.SearchTextField1.getText().isEmpty()) {
                JFXProgressBar progressIndicator = new JFXProgressBar();
                progressIndicator.setProgress(-1.0);
                this.box = new VBox(new Node[]{progressIndicator});
                this.box.setAlignment(Pos.CENTER);
                this.progressContainer = this.box;
                this.stackPane.getChildren().add((Object)this.box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                HttpGet httpget = null;
                                try {
                                    String url = NewRequestPane.this.santa.syncSetting.getBEURL();
                                    httpget = new HttpGet(url + "RProduct/GetSAPItemsByItemCode?itemCode=" + NewRequestPane.this.SearchTextField1.getText());
                                    CloseableHttpClient client = HttpClientBuilder.create().build();
                                    httpget.setHeader("Content-type", "application/json");
                                    HttpResponse response = client.execute((HttpUriRequest)httpget);
                                    if (response.getStatusLine().getStatusCode() == 200) {
                                        String output;
                                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                        StringBuilder stringBuilder = new StringBuilder();
                                        while ((output = br.readLine()) != null) {
                                            stringBuilder.append(output + "\n");
                                        }
                                        br.close();
                                        client.getConnectionManager().shutdown();
                                        String result = stringBuilder.toString();
                                        System.out.println("String " + result);
                                        JSONArray ra = new JSONArray(result);
                                        System.out.println("JSon " + ra.toString());
                                        if (ra.length() > 0) {
                                            ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                                            for (int i = 0; i < ra.length(); ++i) {
                                                JSONObject jo = ra.getJSONObject(i);
                                                StockItemData stkData = new StockItemData();
                                                stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                                                stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                                                list.add(stkData);
                                            }
                                            StockItemList.insertYudalaProduct(list, NewRequestPane.this.da);
                                            list.forEach(x -> NewRequestPane.this.santa.Products.removeIf(xy -> xy.getItemCode().equals(x.getItemCode())));
                                            NewRequestPane.this.santa.Products.addAll(list);
                                            Platform.runLater(() -> {
                                                RequestItem requestItem = NewRequestPane.this.request.getItems().stream().filter(si -> si.getItemCode().equals(((StockItemData)list.get(0)).getItemCode())).findAny().orElse(null);
                                                if (requestItem == null) {
                                                    requestItem = new RequestItem(NewRequestPane.this.da);
                                                    requestItem.setItemCode(((StockItemData)list.get(0)).getItemCode());
                                                    requestItem.setItemName(((StockItemData)list.get(0)).getDescription());
                                                    requestItem.setQuantity(1);
                                                    requestItem.setRequestCode(NewRequestPane.this.request.getCode());
                                                    NewRequestPane.this.request.getItems().add(NewRequestPane.this.request.getItems().size(), (Object)requestItem);
                                                    NewRequestPane.this.vbRepeatingRequested1.getChildren().add((Object)new RequestItemRepeatingCart(requestItem, NewRequestPane.this));
                                                } else {
                                                    RequestItemRepeatingCart cart = NewRequestPane.this.vbRepeatingRequested1.getChildren().stream().filter(cat -> ((RequestItemRepeatingCart)cat).product.getItemCode().equals(((StockItemData)list.get(0)).getItemCode())).findAny().orElse(null);
                                                    cart.product.setQuantity(cart.product.getQuantity() + 1);
                                                }
                                                NewRequestPane.this.request.resetNumbering();
                                                NewRequestPane.this.stackPane.getChildren().remove((Object)NewRequestPane.this.box);
                                            });
                                        } else {
                                            Platform.runLater(() -> {
                                                NewRequestPane.this.stackPane.getChildren().remove((Object)NewRequestPane.this.box);
                                                NewRequestPane.this.mainPage.showNotification(NotificationType.Information, "no result found", NewRequestPane.this);
                                            });
                                        }
                                    } else {
                                        String output;
                                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                        StringBuilder stringBuilder = new StringBuilder();
                                        while ((output = br.readLine()) != null) {
                                            System.out.println(output);
                                            stringBuilder.append(output + "\n");
                                        }
                                        br.close();
                                        String fullError = stringBuilder.toString();
                                        Platform.runLater(() -> {
                                            NewRequestPane.this.mainPage.showNotification(NotificationType.Error, fullError, NewRequestPane.this);
                                            NewRequestPane.this.stackPane.getChildren().remove((Object)NewRequestPane.this.box);
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    Platform.runLater(() -> {
                                        NewRequestPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), NewRequestPane.this);
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)NewRequestPane.this.box);
                                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
                                    });
                                }
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            } else {
                this.mainPage.showNotification(NotificationType.Information, "Please supply item code", this);
            }
        });
        this.btnAdd.setOnAction(val -> {
            if (!this.SearchTextField.getText().isEmpty()) {
                JFXProgressBar progressIndicator = new JFXProgressBar();
                progressIndicator.setProgress(-1.0);
                this.box = new VBox(new Node[]{progressIndicator});
                this.box.setAlignment(Pos.CENTER);
                this.progressContainer = this.box;
                this.stackPane.getChildren().add((Object)this.box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                JSONObject param = new JSONObject().put("itemIds", (Object)NewRequestPane.this.SearchTextField.getText().trim());
                                new SyncData(NewRequestPane.this.santa, NewRequestPane.this.da, NewRequestPane.this.currentUser.getParentCompany()).getITem(param, new IDBEntity<StockItem>(){

                                    @Override
                                    public void onSuccess(ObservableList<StockItem> data) {
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)NewRequestPane.this.box);
                                        if (data.isEmpty()) {
                                            NewRequestPane.this.mainPage.showNotification(NotificationType.Information, "No result found", NewRequestPane.this);
                                        } else {
                                            RequestItem requestItem = NewRequestPane.this.request.getItems().stream().filter(si -> si.getItemCode().equals(((StockItem)data.get(0)).getItemCode())).findAny().orElse(null);
                                            if (requestItem == null) {
                                                requestItem = new RequestItem(NewRequestPane.this.da);
                                                requestItem.setItemCode(((StockItem)data.get(0)).getItemCode());
                                                requestItem.setItemName(((StockItem)data.get(0)).getName());
                                                requestItem.setQuantity(1);
                                                requestItem.setNetWeight(((StockItem)data.get(0)).getNetWeight());
                                                requestItem.setRequestCode(NewRequestPane.this.request.getCode());
                                                NewRequestPane.this.request.getItems().add(NewRequestPane.this.request.getItems().size(), (Object)requestItem);
                                                NewRequestPane.this.vbRepeatingRequested.getChildren().add((Object)new RequestItemRepeatingCart(requestItem, NewRequestPane.this));
                                            } else {
                                                RequestItemRepeatingCart cart = NewRequestPane.this.vbRepeatingRequested.getChildren().stream().filter(cat -> ((RequestItemRepeatingCart)cat).product.getItemCode().equals(((StockItem)data.get(0)).getItemCode())).findAny().orElse(null);
                                                cart.product.setQuantity(cart.product.getQuantity() + 1);
                                            }
                                            NewRequestPane.this.SearchTextField.setText("");
                                            NewRequestPane.this.request.resetNumbering();
                                            NewRequestPane.this.stackPane.getChildren().remove((Object)NewRequestPane.this.box);
                                        }
                                    }

                                    @Override
                                    public void onError(String data) {
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)NewRequestPane.this.box);
                                        NewRequestPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, NewRequestPane.this);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)NewRequestPane.this.box);
                                        NewRequestPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", NewRequestPane.this);
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            } else {
                this.mainPage.showNotification(NotificationType.Information, "Please supply item code", this);
            }
        });
        this.allProducts = new ArrayList<StockItemData>();
        StockItemList localProducts = new StockItemList(this.da);
        localProducts.selectAll("Select * from StockItem", this.da.getEmptyParameterValues());
        localProducts.getOriginalList().forEach(pr -> {
            StockItemData stockData = new StockItemData(pr.getItemCode(), pr.getName());
            stockData.setNetWeight(Float.valueOf(pr.getNetWeight()));
            this.allProducts.add(stockData);
        });
    }

    boolean isJSonObject(String str) {
        try {
            new JSONObject(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void showDialog(RequestItem requestItem) {
        this.dialog = new JFXDialog();
        this.dialog.setDialogContainer(this.stackPane);
        this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
        this.dialog.setContent((Region)new TransferReleaseScanSerial(this.santa, this, requestItem));
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    void postRequest() {
        this.request.setOriginatedUser(this.santa.currentUser.getUserName());
        this.request.setStatus(RequestStatus.PENDING.name());
        this.request.setFromStoreCode(((Store)this.cmbRequestStore.getSelectionModel().getSelectedItem()).getCode());
        this.request.setFromStoreName(((Store)this.cmbRequestStore.getSelectionModel().getSelectedItem()).getName());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("recId", (Object)NewRequestPane.this.request.getCode());
                            job.put("requestReason", (Object)NewRequestPane.this.request.getReason());
                            job.put("status", (Object)NewRequestPane.this.request.getStatus());
                            job.put("requestReason", (Object)NewRequestPane.this.request.getReason());
                            job.put("fromLocationCode", (Object)NewRequestPane.this.request.getFromStoreCode().trim());
                            job.put("fromLocationName", (Object)NewRequestPane.this.request.getFromStoreName());
                            job.put("requesttype", (Object)NewRequestPane.this.request.getRequestType());
                            job.put("requestUser", (Object)NewRequestPane.this.request.getoriginatedUser());
                            job.put("toLocationCode", (Object)NewRequestPane.this.request.getToStoreCode().trim());
                            job.put("toLocationName", (Object)NewRequestPane.this.request.getToStoreName());
                            job.put("lastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("requestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            JSONArray jab = new JSONArray();
                            for (RequestItem requestItem : NewRequestPane.this.request.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("requestCode", (Object)NewRequestPane.this.request.getCode());
                                joItem.put("quantityTransfer", requestItem.getQuantity());
                                joItem.put("releasedQuantity", requestItem.getReleasedQuantity());
                                joItem.put("returnedQty", (Object)requestItem.getReturnedQty());
                                joItem.put("toStoreInitQty", (Object)requestItem.getToStoreInitQty());
                                joItem.put("acceptedQty", (Object)requestItem.getAcceptedQty());
                                joItem.put("approvedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("lineNumber", (Object)requestItem.getLineNumber());
                                joItem.put("netWeight", (double)requestItem.getNetWeight());
                                joItem.put("itemId", (Object)requestItem.getItemCode());
                                joItem.put("itemName", (Object)requestItem.getItemName());
                                joItem.put("code", (Object)requestItem.getCode());
                                JSONArray jsonSerials = new JSONArray();
                                for (RequestitemSerial serial : requestItem.getSerials()) {
                                    JSONObject jsSerial = new JSONObject();
                                    jsSerial.put("requestItemCode", (Object)serial.getRequestItemCode());
                                    jsSerial.put("serial", (Object)serial.getSerial());
                                    jsSerial.put("itemCode", (Object)serial.getItemCode());
                                    jsSerial.put("isAccepted", false);
                                    jsSerial.put("sysSerial", serial.getSysSerial());
                                    jsonSerials.put((Object)jsSerial);
                                }
                                joItem.put("Serials", (Object)jsonSerials);
                                jab.put((Object)joItem);
                            }
                            job.put("transferOrderLines", (Object)jab);
                            jSONArray.put((Object)job);
                            new WebRequest("transferorder/createTransferOrder", RequestTypeEnum.POST, jSONArray.toString(), null, new IWebCallBack(){

                                @Override
                                public void onSuccess(String data) {
                                    try {
                                        JSONObject reqJSONObject = new JSONObject(data);
                                        RequestItemDataList requestItemDataList = new RequestItemDataList(NewRequestPane.this.da);
                                        RequestDataList requestDataList = new RequestDataList(NewRequestPane.this.da);
                                        requestDataList.getOriginalList().add((Object)NewRequestPane.this.request);
                                        if (NewRequestPane.this.request.getRequestType().equals(RequestType.Outbound.name()) && NewRequestPane.this.request.getAutoRelease().booleanValue()) {
                                            NewRequestPane.this.request.setStatus(RequestStatus.RELEASED.name());
                                            NewRequestPane.this.request.setTransferId(reqJSONObject.getString("transferId"));
                                        }
                                        System.out.println(data);
                                        NewRequestPane.this.request.setSyncFlag(Boolean.TRUE);
                                        NewRequestPane.this.da.start();
                                        requestDataList.update();
                                        requestItemDataList.getOriginalList().addAll(NewRequestPane.this.request.getItems());
                                        requestItemDataList.update();
                                        NewRequestPane.this.currentUser.getParentCompany().setLastTransferCount(NewRequestPane.this.currentUser.getParentCompany().getLastTransferCount() + 1);
                                        CompanyDataList companyDataList = new CompanyDataList(NewRequestPane.this.da);
                                        companyDataList.getOriginalList().add((Object)NewRequestPane.this.currentUser.getParentCompany());
                                        companyDataList.update();
                                        NewRequestPane.this.da.end();
                                        Platform.runLater(() -> {
                                            NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                            if (NewRequestPane.this.request.getRequestType().equals(RequestType.Outbound.name()) && TempRoleManagement.canReleaseWithoutApproval(UserType.valueOf(NewRequestPane.this.mainPage.currentUser.getRoleDescription()))) {
                                                NewRequestPane.this.parent.mainPage.showNotification(NotificationType.Success, "Request released successfully", NewRequestPane.this.parent);
                                            } else {
                                                NewRequestPane.this.parent.mainPage.showNotification(NotificationType.Success, "Transfer request " + NewRequestPane.this.request.getCode() + " created successfully", NewRequestPane.this.parent);
                                            }
                                            NewRequestPane.this.ResetInterface(NewRequestPane.this.request.getRequestType().equals(RequestType.Inbound.name()));
                                        });
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                        Platform.runLater(() -> {
                                            NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                            NewRequestPane.this.parent.mainPage.showNotification(NotificationType.Error, ex.getMessage(), NewRequestPane.this.parent);
                                        });
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                        NewRequestPane.this.parent.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, NewRequestPane.this.parent);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                        NewRequestPane.this.parent.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", NewRequestPane.this.parent);
                                    });
                                }
                            }).execute(false);
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                NewRequestPane.this.parent.mainPage.showNotification(NotificationType.Error, ex.getMessage(), NewRequestPane.this.parent);
                            });
                            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void checkRequestQty() {
        try {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            try {
                                Object itemId = "";
                                for (RequestItem requestItem : NewRequestPane.this.request.getItems()) {
                                    itemId = (String)itemId + requestItem.getItemCode() + ",";
                                }
                                itemId = ((String)itemId).substring(0, ((String)itemId).length() - 1);
                                JSONObject param = new JSONObject().put("item_Id", itemId).put("locationId", (Object)((Store)NewRequestPane.this.cmbToStore.getSelectionModel().getSelectedItem()).getCode()).put("isRetailLocation", true);
                                new SyncData(NewRequestPane.this.santa, NewRequestPane.this.da, NewRequestPane.this.currentUser.getParentCompany()).getInventory(param, new IDBEntity<StockItem>(){

                                    @Override
                                    public void onSuccess(ObservableList<StockItem> data) {
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                        if (data.isEmpty()) {
                                            NewRequestPane.this.mainPage.showNotification(NotificationType.Information, "No result found", NewRequestPane.this);
                                        } else {
                                            data.forEach(ac -> {
                                                RequestItem requestItem = NewRequestPane.this.request.getItems().stream().filter(p -> p.getItemCode().equals(ac.getItemCode())).findAny().get();
                                                requestItem.availableQtyProperty().set((int)ac.getQuantity());
                                                requestItem.setToStoreInitQty((int)ac.getQuantity());
                                            });
                                            NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                            NewRequestPane.this.mainPage.showNotification(NotificationType.Success, "Quantity successfully loaded", NewRequestPane.this.parent);
                                        }
                                    }

                                    @Override
                                    public void onError(String data) {
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                        NewRequestPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, NewRequestPane.this);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                        NewRequestPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", NewRequestPane.this);
                                    }
                                });
                            }
                            catch (Exception ex) {
                                Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                Platform.runLater(() -> {
                                    NewRequestPane.this.stackPane.getChildren().remove((Object)box);
                                    NewRequestPane.this.parent.mainPage.showNotification(NotificationType.Error, ex.getMessage(), NewRequestPane.this.parent);
                                });
                            }
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this.parent);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void download() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Template");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        File file = fileChooser.showSaveDialog((Window)this.santa.stage);
        FileWriter fileWriter = null;
        try {
            if (file != null) {
                fileWriter = new FileWriter(file);
                CSVUtils.writeLine(fileWriter, Arrays.asList("Item Code", "Quantity"));
                fileWriter.flush();
                fileWriter.close();
                this.mainPage.showNotification(NotificationType.Information, "Template downloaded successfully", this);
            }
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void upload() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Template");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        String FieldDelimiter = ",";
        File file = fileChooser.showOpenDialog((Window)this.santa.stage);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            Object errors = "";
            ArrayList<RequestItem> requestItems = new ArrayList<RequestItem>();
            int count = 0;
            while ((line = br.readLine()) != null) {
                String[] fields = line.split(FieldDelimiter, -1);
                if (count > 0 && !fields[0].isEmpty() && !fields[1].isEmpty()) {
                    StockItemData data = this.santa.Products.stream().filter(v -> v.getItemCode().equals(fields[0].toUpperCase().trim())).findAny().orElse(null);
                    if (((String)errors).isEmpty()) {
                        errors = "The following item(s) not found: ";
                    }
                    if (data == null) {
                        errors = (String)errors + fields[0].toUpperCase().trim() + ",";
                    } else {
                        RequestItem requestItemExist = this.request.getItems().stream().filter(v -> v.getItemCode().equals(fields[0].toUpperCase().trim())).findAny().orElse(null);
                        if (requestItemExist == null) {
                            requestItemExist = requestItems.stream().filter(v -> v.getItemCode().equals(fields[0].toUpperCase().trim())).findAny().orElse(null);
                        }
                        if (requestItemExist == null) {
                            RequestItem requestItem = new RequestItem(this.da);
                            requestItem.setItemCode(fields[0].toUpperCase().trim());
                            requestItem.setItemName(data.getDescription());
                            requestItem.setQuantity(Integer.valueOf(fields[1]));
                            requestItem.setRequestCode(this.request.getCode());
                            requestItems.add(requestItem);
                        } else {
                            requestItemExist.setQuantity(requestItemExist.getQuantity() + Integer.valueOf(fields[1]));
                        }
                    }
                }
                ++count;
            }
            this.request.getItems().addAll(requestItems);
            this.request.resetNumbering();
            this.vbRepeatingRequested.getChildren().clear();
            this.vbRepeatingRequested1.getChildren().clear();
            this.request.getItems().forEach(v -> {
                if (this.request.getRequestType().equals(RequestType.Inbound.name())) {
                    this.vbRepeatingRequested.getChildren().add((Object)new RequestItemRepeatingCart((RequestItem)v, this));
                } else {
                    this.vbRepeatingRequested1.getChildren().add((Object)new RequestItemRepeatingCart((RequestItem)v, this));
                }
            });
            this.mainPage.showNotification(NotificationType.Information, (String)(((String)errors).isEmpty() ? "Data uploaded successfully" : errors), this);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void loadAllYudalaProduct() {
        ProgressBar progressIndicator = new ProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        HttpGet httpGet = new HttpGet(NewRequestPane.this.santa.syncSetting.getBEURL() + "rProduct/GetSAPItems");
                        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                        httpGet.setHeader("Content-type", "application/json");
                        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                        if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                            String output;
                            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                            StringBuilder stringBuilder = new StringBuilder();
                            System.out.println("Output from Server .... \n");
                            while ((output = br.readLine()) != null) {
                                System.out.println(output);
                                stringBuilder.append(output + "\n");
                            }
                            br.close();
                            httpClient.getConnectionManager().shutdown();
                            String result = stringBuilder.toString();
                            JSONArray jar = new JSONArray(result);
                            if (jar.length() > 0) {
                                ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                                for (int i = 0; i < jar.length(); ++i) {
                                    JSONObject jo = jar.getJSONObject(i);
                                    StockItemData stkData = new StockItemData();
                                    stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                                    stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                                    list.add(stkData);
                                }
                                StockItemList.insertAllYudalaProduct(list, NewRequestPane.this.da);
                                NewRequestPane.this.santa.Products.addAll(list);
                            } else {
                                NewRequestPane.this.mainPage.showNotification(NotificationType.Information, "Unable to load products", NewRequestPane.this);
                            }
                            Platform.runLater(() -> NewRequestPane.this.stackPane.getChildren().remove((Object)box));
                        } else {
                            String output;
                            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                            StringBuilder stringBuilder = new StringBuilder();
                            while ((output = br.readLine()) != null) {
                                System.out.println(output);
                                stringBuilder.append(output + "\n");
                            }
                            br.close();
                            String fullError = stringBuilder.toString();
                            NewRequestPane.this.mainPage.showNotification(NotificationType.Error, fullError, NewRequestPane.this);
                            Platform.runLater(() -> NewRequestPane.this.stackPane.getChildren().remove((Object)box));
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void ResetInterface(boolean isInbound) {
        if (isInbound) {
            Store store;
            this.vbRepeatingRequested.getChildren().clear();
            this.cmbToStore.getSelectionModel().clearSelection();
            this.SearchTextField.clear();
            this.Comment.clear();
            this.request = new Request(this.da);
            this.request.setRequestType(RequestType.Inbound.name());
            if (this.currentUser != null && this.currentUser.getParentCompany() != null && (store = this.cmbRequestStore.getItems().stream().filter(prdct -> prdct.getCode().equals(this.currentUser.getParentCompany().getStoreCode())).findAny().get()) != null) {
                this.cmbRequestStore.getSelectionModel().select((Object)store);
            }
            this.cmbTowareHouse1.getSelectionModel().select(0);
            this.request.setCode(Santa.getUniqueId(this.currentUser.getParentCompany().getStoreCode()));
            this.request.setFromStoreCode(this.santa.currentUser.getParentCompany().getStoreCode());
        } else {
            this.cmbRequestStore.getSelectionModel().select(0);
            this.cmbTowareHouse1.getSelectionModel().select(0);
            this.vbRepeatingRequested1.getChildren().clear();
            this.cmbFromStore1.getSelectionModel().clearSelection();
            this.SearchTextField1.clear();
            this.Comment1.clear();
            this.request = new Request(this.da);
            this.request.setRequestType(RequestType.Outbound.name());
            this.request.setCode(Santa.getUniqueId(this.currentUser.getParentCompany().getStoreCode()));
            this.request.setFromStoreCode(this.santa.currentUser.getParentCompany().getStoreCode());
        }
    }

    public void populate(StockItemData stockItemData) {
        if (stockItemData != null) {
            RequestItem requestItem = this.request.getItems().stream().filter(si -> si.getItemCode().equals(stockItemData.getItemCode())).findAny().orElse(null);
            if (requestItem == null) {
                requestItem = new RequestItem(this.da);
                requestItem.setItemCode(stockItemData.getItemCode());
                requestItem.setItemName(stockItemData.getDescription());
                requestItem.setNetWeight(stockItemData.getNetWeight().floatValue());
                requestItem.setQuantity(1);
                requestItem.setRequestCode(this.request.getCode());
                this.request.getItems().add(this.request.getItems().size(), (Object)requestItem);
                this.vbRepeatingRequested.getChildren().add((Object)new RequestItemRepeatingCart(requestItem, this));
            } else {
                RequestItemRepeatingCart cart = this.vbRepeatingRequested.getChildren().stream().filter(cat -> ((RequestItemRepeatingCart)cat).product.getItemCode().equals(stockItemData.getItemCode())).findAny().orElse(null);
                cart.product.setQuantity(cart.product.getQuantity() + 1);
            }
            this.request.resetNumbering();
        }
    }

    public void populate1(StockItemData stockItemData) {
        if (stockItemData != null) {
            RequestItem requestItem = this.request.getItems().stream().filter(si -> si.getItemCode().equals(stockItemData.getItemCode())).findAny().orElse(null);
            if (requestItem == null) {
                requestItem = new RequestItem(this.da);
                requestItem.setItemCode(stockItemData.getItemCode());
                requestItem.setItemName(stockItemData.getDescription());
                requestItem.setQuantity(1);
                requestItem.setNetWeight(stockItemData.getNetWeight().floatValue());
                requestItem.setRequestCode(this.request.getCode());
                this.request.getItems().add(this.request.getItems().size(), (Object)requestItem);
                this.vbRepeatingRequested1.getChildren().add((Object)new RequestItemRepeatingCart(requestItem, this));
            } else {
                RequestItemRepeatingCart cart = this.vbRepeatingRequested1.getChildren().stream().filter(cat -> ((RequestItemRepeatingCart)cat).product.getItemCode().equals(stockItemData.getItemCode())).findAny().orElse(null);
                cart.product.setQuantity(cart.product.getQuantity() + 1);
            }
            this.request.resetNumbering();
        }
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return StockItemList.selectAutoComplete(searchString, this.da, false);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPaneB2B.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    public List<StockItemData> searchDataHere(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<StockItemData>();
        }
        List result = this.allProducts.stream().filter(e -> e.getItemCode().toLowerCase().contains(searchString.toLowerCase()) || e.getDescription().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
        LinkedList searchResult = new LinkedList();
        searchResult.addAll(result.isEmpty() && result.size() > 0 ? this.allProducts : result);
        return searchResult.subList(0, searchResult.size());
    }
}

