/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.report.CSVUtils;
import com.xputertechnologies.santa.ui.NewProductDialog;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class NewProductPane
extends UIParent {
    @FXML
    private TextField SearchTextField;
    @FXML
    private TableView<StockItem> table;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnPost;
    @FXML
    private JFXButton btnUpload;
    @FXML
    private JFXButton btnDownload;
    @FXML
    private JFXButton btnClear;
    @FXML
    private JFXButton btnDownloadData;
    @FXML
    private JFXButton SearchButton;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPartNum;
    @FXML
    private TableColumn colgroup;
    @FXML
    private TableColumn colActive;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colHasSynced;
    @FXML
    private TableColumn colManufacturer;
    @FXML
    private TableColumn colItemUnit;
    JFXDialog dialog;
    StockItem selectedStock = null;
    public StockItemList stockList;

    public NewProductPane(Santa app) {
        super("NewProductPane.fxml", app);
        this.santa = app;
        this.title = "New Product";
        this.stockList = new StockItemList(this.da);
        this.stockList.selectAll("Select * from StockItem where syncFlag=?", new ParameterValue[]{new ParameterValue("", JDBCType.CHAR, false)});
        this.table.setItems(this.stockList.getOriginalList());
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colPartNum.setCellValueFactory((Callback)new PropertyValueFactory("barCode"));
        this.colgroup.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.colManufacturer.setCellValueFactory((Callback)new PropertyValueFactory("manufacture"));
        this.colItemUnit.setCellValueFactory((Callback)new PropertyValueFactory("itemUnit"));
        this.colActive.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colHasSynced.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.btnPost.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(Color.WHITE).size(15.0));
        this.btnUpload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.UPLOAD).color(Color.WHITE).size(15.0));
        this.btnDownload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.DOWNLOAD).color(Color.WHITE).size(15.0));
        this.btnDownloadData.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.DOWNLOAD).color(Color.WHITE).size(15.0));
        this.btnClear.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.WHITE).size(15.0));
        Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>> cellFactoryViewEdit = new Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>>(){

            public TableCell call(TableColumn<StockItem, String> param) {
                TableCell<StockItem, String> cell = new TableCell<StockItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)NewProductPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            StockItem req = (StockItem)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                NewProductPane.this.selectedStock = req;
                                NewProductPane.this.showDialog();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryViewEdit);
        Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>> cellFactoryViewActive = new Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>>(){

            public TableCell call(TableColumn<StockItem, String> param) {
                TableCell<StockItem, String> cell = new TableCell<StockItem, String>(){
                    final JFXCheckBox chk = new JFXCheckBox("Active");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            StockItem req = (StockItem)this.getTableView().getItems().get(this.getIndex());
                            this.chk.selectedProperty().bindBidirectional((Property)req.isActiveProperty());
                            this.setGraphic((Node)this.chk);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colActive.setCellFactory((Callback)cellFactoryViewActive);
        Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>> cellFactoryVieSync = new Callback<TableColumn<StockItem, String>, TableCell<StockItem, String>>(){

            public TableCell call(TableColumn<StockItem, String> param) {
                TableCell<StockItem, String> cell = new TableCell<StockItem, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            StockItem req = (StockItem)this.getTableView().getItems().get(this.getIndex());
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            if (req.getSyncFlag().booleanValue()) {
                                this.lbl.setText("Posted");
                                this.lbl.setStyle("-fx-background-color: #00A86B;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            } else {
                                this.lbl.setText("Not Posted");
                                this.lbl.setStyle("-fx-background-color: #FF0000;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            }
                            this.setTooltip(new Tooltip(req.getSyncError()));
                            this.setGraphic((Node)this.lbl);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colHasSynced.setCellFactory((Callback)cellFactoryVieSync);
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NewProductPane.this.selectedStock = null;
                NewProductPane.this.showDialog();
            }
        });
        this.SearchButton.setOnAction(x -> {
            if (!this.SearchTextField.getText().isEmpty()) {
                JFXProgressBar progressIndicator = new JFXProgressBar();
                progressIndicator.setProgress(-1.0);
                final VBox box = new VBox(new Node[]{progressIndicator});
                box.setAlignment(Pos.CENTER);
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                try {
                                    String url = NewProductPane.this.santa.syncSetting.getBEURL() + "RProduct/GetSAPItemsBySearch";
                                    HttpGet httpGet = new HttpGet(url);
                                    RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                    httpGet.setHeader("Content-type", "application/json");
                                    ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                                    BasicNameValuePair param1 = new BasicNameValuePair("searchString", NewProductPane.this.SearchTextField.getText().trim());
                                    listParam.add(param1);
                                    CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                    URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                                    httpGet.setURI(uri);
                                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                                    if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                        String output;
                                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                        StringBuilder stringBuilder = new StringBuilder();
                                        System.out.println("Output from Server .... \n");
                                        while ((output = br.readLine()) != null) {
                                            System.out.println(output);
                                            stringBuilder.append(output + "\n");
                                        }
                                        br.close();
                                        httpClient.getConnectionManager().shutdown();
                                        String result = stringBuilder.toString();
                                        JSONArray ra = new JSONArray(result);
                                        NewProductPane.this.stockList.getOriginalList().clear();
                                        if (ra.length() > 0) {
                                            for (int i = 0; i < ra.length(); ++i) {
                                                JSONObject jSONObject = ra.getJSONObject(i);
                                                StockItem stck = new StockItem(NewProductPane.this.da);
                                                stck.setItemCode(jSONObject.isNull("ItemCode") ? "" : jSONObject.getString("ItemCode"));
                                                stck.setName(jSONObject.isNull("ItemName") ? "" : jSONObject.getString("ItemName"));
                                                stck.setType(jSONObject.isNull("ItemGroup") ? "" : jSONObject.getString("ItemGroup"));
                                                stck.setManufacture(jSONObject.isNull("Manufacturer") ? "" : jSONObject.getString("Manufacturer"));
                                                stck.setItemUnit(jSONObject.isNull("ItemUnit") ? "" : jSONObject.getString("ItemUnit"));
                                                stck.setIsActive(jSONObject.isNull("IsActive") ? false : jSONObject.getBoolean("IsActive"));
                                                NewProductPane.this.stockList.getOriginalList().add((Object)stck);
                                            }
                                            Platform.runLater(() -> {
                                                NewProductPane.this.stackPane.getChildren().remove((Object)box);
                                                NewProductPane.this.stockList.resetNumbering();
                                                NewProductPane.this.table.setItems(NewProductPane.this.stockList.getOriginalList());
                                                NewProductPane.this.table.refresh();
                                                NewProductPane.this.SearchTextField.clear();
                                            });
                                        } else {
                                            Platform.runLater(() -> {
                                                NewProductPane.this.stackPane.getChildren().remove((Object)box);
                                                NewProductPane.this.table.getItems().clear();
                                                NewProductPane.this.table.refresh();
                                                NewProductPane.this.SearchTextField.clear();
                                                NewProductPane.this.mainPage.showNotification(NotificationType.Information, "No Request Found", NewProductPane.this);
                                            });
                                        }
                                    } else {
                                        String output;
                                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                        StringBuilder stringBuilder = new StringBuilder();
                                        while ((output = br.readLine()) != null) {
                                            System.out.println(output);
                                            stringBuilder.append(output + "\n");
                                        }
                                        br.close();
                                        String fullError = stringBuilder.toString();
                                        Platform.runLater(() -> {
                                            NewProductPane.this.stackPane.getChildren().remove((Object)box);
                                            NewProductPane.this.mainPage.showNotification(NotificationType.Error, fullError, NewProductPane.this);
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    Platform.runLater(() -> {
                                        NewProductPane.this.stackPane.getChildren().remove((Object)box);
                                        NewProductPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), NewProductPane.this);
                                    });
                                }
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
        });
        this.btnPost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (NewProductPane.this.stockList.getOriginalList().size() > 0) {
                    if (NewProductPane.this.stockList.getOriginalList().stream().filter(p -> p.getName().isEmpty() || p.getType().isEmpty()).count() == 0L) {
                        final String url = NewProductPane.this.santa.syncSetting.getBEURL() + "RProduct/CreateItems";
                        JFXProgressBar progressIndicator = new JFXProgressBar();
                        progressIndicator.setProgress(-1.0);
                        final VBox box = new VBox(new Node[]{progressIndicator});
                        box.setAlignment(Pos.CENTER);
                        VBox progressContainer = box;
                        NewProductPane.this.stackPane.getChildren().add((Object)box);
                        Service service = new Service(){

                            protected Task createTask() {
                                return new Task(){

                                    protected Object call() throws Exception {
                                        try {
                                            JSONArray jSONArray = new JSONArray();
                                            for (StockItem stockItem : NewProductPane.this.stockList.getOriginalList()) {
                                                JSONObject job = new JSONObject();
                                                job.put("ItemCode", (Object)stockItem.getItemCode());
                                                job.put("ItemName", (Object)stockItem.getName());
                                                job.put("Quantity", (double)stockItem.getQuantity());
                                                job.put("ItemGroup", (Object)stockItem.getType());
                                                job.put("Manufacturer", (Object)stockItem.getManufacture());
                                                job.put("ItemUnit", (Object)stockItem.getItemUnit());
                                                job.put("TempCode", stockItem.tempCodeProperty().get());
                                                System.out.println((String)stockItem.tempCodeProperty().get());
                                                job.put("IsActive", stockItem.getIsActive());
                                                jSONArray.put((Object)job);
                                            }
                                            HttpPost httpPost = new HttpPost(url);
                                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                            StringEntity stringEntity = new StringEntity(jSONArray.toString());
                                            httpPost.setEntity((HttpEntity)stringEntity);
                                            httpPost.setHeader("Content-type", "application/json");
                                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                                String output;
                                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                                StringBuilder stringBuilder = new StringBuilder();
                                                while ((output = br.readLine()) != null) {
                                                    stringBuilder.append(output + "\n");
                                                }
                                                br.close();
                                                httpClient.getConnectionManager().shutdown();
                                                String result = stringBuilder.toString();
                                                JSONArray ra = new JSONArray(result);
                                                Platform.runLater(() -> {
                                                    try {
                                                        for (int i = 0; i < ra.length(); ++i) {
                                                            JSONObject jSONObject = ra.getJSONObject(i);
                                                            String TempCode = jSONObject.getString("TempCode");
                                                            StockItem found = NewProductPane.this.stockList.getOriginalList().stream().filter(s -> ((String)s.tempCodeProperty().get()).equals(TempCode)).findAny().orElse(null);
                                                            if (found == null) continue;
                                                            found.setSyncError(jSONObject.isNull("SyncError") ? "" : jSONObject.getString("SyncError"));
                                                            found.setSyncFlag(found.getSyncError().isEmpty());
                                                            found.setItemCode(jSONObject.isNull("ItemCode") ? "" : jSONObject.getString("ItemCode"));
                                                        }
                                                        if (NewProductPane.this.stockList.getOriginalList().stream().filter(v -> !v.getSyncError().isEmpty()).findAny().orElse(null) == null) {
                                                            StockItemList.deleteAll("Delete  From StockItem where syncFlag=?", new ParameterValue[]{new ParameterValue("syncFlag", JDBCType.CHAR, false)}, NewProductPane.this.da);
                                                            NewProductPane.this.mainPage.showNotification(NotificationType.Success, "New Product posted successfully", NewProductPane.this);
                                                        } else {
                                                            NewProductPane.this.mainPage.showNotification(NotificationType.Information, "Some New Item(s) cannot be posted,please check the error message from the tooltip", NewProductPane.this);
                                                            List dataTosave = NewProductPane.this.stockList.getOriginalList().stream().filter(v -> !v.getSyncError().isEmpty()).collect(Collectors.toList());
                                                            StockItemList stockListdata = new StockItemList(NewProductPane.this.da);
                                                            stockListdata.getOriginalList().addAll(dataTosave);
                                                            stockListdata.update();
                                                        }
                                                        NewProductPane.this.table.refresh();
                                                        System.out.println("Table Refreshed");
                                                    }
                                                    catch (Exception ex) {
                                                        NewProductPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), NewProductPane.this);
                                                    }
                                                    NewProductPane.this.stackPane.getChildren().remove((Object)box);
                                                });
                                            } else {
                                                String output;
                                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                                StringBuilder stringBuilder = new StringBuilder();
                                                while ((output = br.readLine()) != null) {
                                                    System.out.println(output);
                                                    stringBuilder.append(output + "\n");
                                                }
                                                br.close();
                                                String fullError = stringBuilder.toString();
                                                Platform.runLater(() -> {
                                                    NewProductPane.this.stackPane.getChildren().remove((Object)box);
                                                    NewProductPane.this.mainPage.showNotification(NotificationType.Error, fullError, NewProductPane.this);
                                                });
                                            }
                                        }
                                        catch (Exception e) {
                                            Platform.runLater(() -> {
                                                NewProductPane.this.stackPane.getChildren().remove((Object)box);
                                                NewProductPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), NewProductPane.this);
                                            });
                                        }
                                        return null;
                                    }
                                };
                            }
                        };
                        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                        service.start();
                    } else {
                        NewProductPane.this.mainPage.showNotification(NotificationType.Error, "One or more products do not have Name or Group ", NewProductPane.this);
                    }
                } else {
                    NewProductPane.this.mainPage.showNotification(NotificationType.Error, "No Item to post ", NewProductPane.this);
                }
            }
        });
        this.btnDownload.setOnAction(v -> this.download());
        this.btnUpload.setOnAction(v -> this.upload());
        this.btnClear.setOnAction(v -> {
            try {
                this.stockList.getOriginalList().clear();
                this.table.getItems().clear();
                StockItemList.deleteAll("StockItem", this.da);
            }
            catch (Exception ex) {
                Logger.getLogger(NewProductPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnDownloadData.setOnAction(c -> this.downloadData());
    }

    void showDialog() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new NewProductDialog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    void download() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Template");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        File file = fileChooser.showSaveDialog((Window)this.santa.stage);
        FileWriter fileWriter = null;
        try {
            if (file != null) {
                fileWriter = new FileWriter(file);
                CSVUtils.writeLine(fileWriter, Arrays.asList("Part Number", "Item Name", "Item Group", "Manufacturer", "Item Unit", "Active(Y/N)"));
                fileWriter.flush();
                fileWriter.close();
                this.mainPage.showNotification(NotificationType.Information, "Template downloaded successfully", this);
            }
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void downloadData() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Data");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        File file = fileChooser.showSaveDialog((Window)this.santa.stage);
        FileWriter fileWriter = null;
        try {
            if (file != null) {
                fileWriter = new FileWriter(file);
                CSVUtils.writeLine(fileWriter, Arrays.asList("S/N", "Item Code", "Part Number", "Item Name", "Item Group", "Manufacturer", "Item Unit", "Active", "Synced"));
                int i = 0;
                for (StockItem stk : this.stockList.getOriginalList()) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(Integer.toString(++i));
                    list.add(stk.getItemCode());
                    list.add(stk.getName());
                    list.add(stk.getType());
                    list.add(stk.getManufacture());
                    list.add(stk.getItemUnit());
                    list.add(stk.getIsActive() ? "Yes" : "No");
                    list.add(stk.getSyncFlag() != false ? "Yes" : "No");
                    CSVUtils.writeLine(fileWriter, list);
                }
                fileWriter.flush();
                fileWriter.close();
                this.mainPage.showNotification(NotificationType.Information, "Data downloaded successfully", this);
            }
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void upload() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Template");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        File file = fileChooser.showOpenDialog((Window)this.santa.stage);
        try {
            if (file != null) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                ArrayList<StockItem> stockItemss = new ArrayList<StockItem>();
                int count = 0;
                while ((line = br.readLine()) != null) {
                    String[] fields = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
                    if (count > 0) {
                        if (count < 100) {
                            if (fields.length > 0) {
                                StockItem stockItemExist = this.stockList.getOriginalList().stream().filter(v -> v.getItemCode().equals(fields[0].trim())).findAny().orElse(null);
                                if (stockItemExist == null) {
                                    StockItem stockItem = new StockItem(this.da);
                                    if (!fields[1].isEmpty()) {
                                        String val = fields[1].trim();
                                        if (val.startsWith("\"")) {
                                            val = val.substring(1);
                                        }
                                        if (val.endsWith("\"")) {
                                            val = val.substring(0, val.length() - 1);
                                        }
                                        stockItem.setName(val);
                                    } else {
                                        stockItem.setName("");
                                    }
                                    stockItem.setType(fields[2].isEmpty() ? "" : fields[2].trim());
                                    stockItem.setManufacture(fields[3].isEmpty() ? "" : fields[3].trim());
                                    stockItem.setItemUnit(fields[4].isEmpty() ? "" : fields[4].trim());
                                    stockItem.setIsActive(fields[5].isEmpty() || fields[5].equalsIgnoreCase("y"));
                                    stockItem.setSyncFlag(false);
                                    stockItemss.add(stockItem);
                                } else {
                                    if (!fields[1].isEmpty()) {
                                        String val = fields[1].trim();
                                        if (val.startsWith("\"")) {
                                            val = val.substring(1);
                                        }
                                        if (val.endsWith("\"")) {
                                            val = val.substring(0, val.length() - 1);
                                        }
                                        stockItemExist.setName(val);
                                    } else {
                                        stockItemExist.setName("");
                                    }
                                    stockItemExist.setType(fields[2].isEmpty() ? "" : fields[2].trim());
                                    stockItemExist.setManufacture(fields[3].isEmpty() ? "" : fields[3].trim());
                                    stockItemExist.setItemUnit(fields[4].isEmpty() ? "" : fields[4].trim());
                                    stockItemExist.setIsActive(fields[5].isEmpty() || fields[5].equalsIgnoreCase("y"));
                                    stockItemExist.setSyncFlag(false);
                                }
                            }
                        } else {
                            this.mainPage.showNotification(NotificationType.Information, "Only 100 products is allowed per post", this);
                            break;
                        }
                    }
                    ++count;
                }
                this.stockList.getOriginalList().addAll(stockItemss);
                this.stockList.resetNumbering();
                this.table.setItems(this.stockList.getOriginalList());
                this.table.refresh();
                this.mainPage.showNotification(NotificationType.Information, "Data uploaded successfully", this);
            }
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void refreshTb() {
        this.table.refresh();
    }
}

