/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXChipView;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.json.JSONObject;

public class InventoryMovement
extends UIParent {
    @FXML
    private StackPane stackPane;
    @FXML
    private TextField SearchTextField;
    @FXML
    private JFXComboBox<Store> cmbLocation;
    @FXML
    private JFXButton btnSearch;
    public Dialog dialog;
    @FXML
    private DatePicker from;
    @FXML
    private DatePicker to;
    public StockItemList stockList;
    @FXML
    private Label lblItemId;
    @FXML
    private Label lblItemName;
    @FXML
    private TableView<com.xputertechnologies.santa.InventoryMovement> container;
    @FXML
    private TableColumn<com.xputertechnologies.santa.InventoryMovement, String> colTransactionType;
    @FXML
    private TableColumn<com.xputertechnologies.santa.InventoryMovement, String> colTransNo;
    @FXML
    private TableColumn<com.xputertechnologies.santa.InventoryMovement, String> colStatusIssue;
    @FXML
    private TableColumn<com.xputertechnologies.santa.InventoryMovement, String> colQty;
    @FXML
    private TableColumn<com.xputertechnologies.santa.InventoryMovement, String> colStatusReciept;
    @FXML
    private TableColumn<com.xputertechnologies.santa.InventoryMovement, String> colTransDate;
    VBox progressContainer;
    JFXChipView<StockItem> chipView;

    public InventoryMovement(Santa app) {
        super("InventoryMovement.fxml", app);
        this.santa = app;
        this.title = "Inventory Movement";
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTextField, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        this.from.setValue((Object)LocalDate.now());
        this.to.setValue((Object)LocalDate.now());
        this.SearchTextField.requestFocus();
        StoreDataList storeDataList = new StoreDataList(this.da);
        storeDataList.selectAll("Select *from store", this.da.getEmptyParameterValues());
        ObservableList stores = FXCollections.observableArrayList((Collection)storeDataList.getOriginalList().stream().filter(prdct -> prdct.getName() != null && !prdct.getName().isEmpty()).collect(Collectors.toList()));
        this.cmbLocation.setItems(stores);
        Store store = stores.stream().filter(f -> f.getCode().equals(this.santa.currentUser.getParentCompany().getStoreCode())).findAny().orElse(null);
        if (store != null) {
            this.cmbLocation.getSelectionModel().select((Object)store);
        }
        this.colTransactionType.setCellValueFactory((Callback)new PropertyValueFactory("transType"));
        this.colTransNo.setCellValueFactory((Callback)new PropertyValueFactory("transNo"));
        this.colStatusIssue.setCellValueFactory((Callback)new PropertyValueFactory("statusIssue"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colStatusReciept.setCellValueFactory((Callback)new PropertyValueFactory("statusReceipt"));
        this.colTransDate.setCellValueFactory((Callback)new PropertyValueFactory("transDate"));
        this.btnSearch.setOnAction(e -> {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            try {
                box.setAlignment(Pos.CENTER);
                this.progressContainer = box;
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData syncData = new SyncData(InventoryMovement.this.santa, InventoryMovement.this.da, InventoryMovement.this.santa.currentUser.getParentCompany());
                                SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");
                                LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)InventoryMovement.this.from.getValue()).getYear(), ((LocalDate)InventoryMovement.this.from.getValue()).getMonth().getValue(), ((LocalDate)InventoryMovement.this.from.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                                LocalDateTime Enddatetime = LocalDate.of(((LocalDate)InventoryMovement.this.to.getValue()).getYear(), ((LocalDate)InventoryMovement.this.to.getValue()).getMonth().getValue(), ((LocalDate)InventoryMovement.this.to.getValue()).getDayOfMonth()).atTime(23, 59, 0);
                                String fromDt = format.format(Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                String toDt = format.format(Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                JSONObject param = new JSONObject().put("itemId", (Object)InventoryMovement.this.SearchTextField.getText().trim()).put("locationId", (Object)((Store)InventoryMovement.this.cmbLocation.getSelectionModel().getSelectedItem()).getCode()).put("fromDateTime", (Object)fromDt).put("toDateTime", (Object)toDt);
                                syncData.getInventoryMovement(param.toString(), new IDBEntity<com.xputertechnologies.santa.InventoryMovement>(){

                                    @Override
                                    public void onSuccess(ObservableList<com.xputertechnologies.santa.InventoryMovement> data) {
                                        InventoryMovement.this.stackPane.getChildren().remove((Object)box);
                                        if (!data.isEmpty()) {
                                            InventoryMovement.this.container.setItems(data);
                                            InventoryMovement.this.container.refresh();
                                            InventoryMovement.this.lblItemName.setText(((com.xputertechnologies.santa.InventoryMovement)data.get(0)).getItemName());
                                            InventoryMovement.this.lblItemId.setText(((com.xputertechnologies.santa.InventoryMovement)data.get(0)).getItemId());
                                        } else {
                                            InventoryMovement.this.mainPage.showNotification(NotificationType.Information, "No sale found", InventoryMovement.this);
                                        }
                                    }

                                    @Override
                                    public void onError(String data) {
                                        InventoryMovement.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, InventoryMovement.this);
                                        InventoryMovement.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        InventoryMovement.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", InventoryMovement.this);
                                        InventoryMovement.this.stackPane.getChildren().remove((Object)box);
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
            catch (Exception ex) {
                this.stackPane.getChildren().remove((Object)box);
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return StockItemList.selectAutoComplete(searchString, this.da, true);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }
}

