/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.ui.IntegerNumberTextBox;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.scene.Node;
import javafx.scene.control.TableCell;

public class CustomEditableTableColumnNumberInteger<T extends DbEntity>
extends TableCell<T, Integer> {
    private IntegerNumberTextBox txtBox;
    UIParent notifyChange;
    int max;
    int min;

    public void setMax(int max) {
        this.max = max;
        this.txtBox.setMax(this.max);
    }

    CustomEditableTableColumnNumberInteger(UIParent notifyChange) {
        this.notifyChange = notifyChange;
    }

    CustomEditableTableColumnNumberInteger(UIParent notifyChange, int min, int max) {
        this.notifyChange = notifyChange;
        this.max = max;
        this.min = min;
    }

    CustomEditableTableColumnNumberInteger(UIParent notifyChange, int max) {
        this.notifyChange = notifyChange;
        this.max = max;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.txtBox);
            this.txtBox.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(Integer.toString((Integer)this.getItem()));
        this.setGraphic(null);
    }

    public void updateItem(Integer item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.txtBox != null) {
                this.txtBox.setText(Integer.toString(this.getValue()));
            }
            this.setText(null);
            this.setGraphic((Node)this.txtBox);
        } else {
            this.setText(Integer.toString(this.getValue()));
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.txtBox = new IntegerNumberTextBox(this.getValue());
        if (this.min > 0) {
            this.txtBox.setMin(0);
        }
        if (this.max > 0) {
            this.txtBox.setMin(this.max);
        }
        this.txtBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.txtBox.setOnAction(e -> this.commitEdit(Integer.parseInt(this.txtBox.getText())));
        this.txtBox.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                System.out.println("Commiting Integer " + this.txtBox.getText());
                this.commitEdit(Integer.valueOf(this.txtBox.getText()));
                this.notifyChange.propertyChange();
            }
        });
    }

    private Integer getValue() {
        return this.getItem() == null ? 0 : (Integer)this.getItem();
    }
}

