/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.SyncSetting;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.ui.ConfigurationPageContainerPane;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.IOException;
import java.sql.Connection;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import javafx.util.converter.BooleanStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.IDataSet;

public class CompanyPane
extends UIParent {
    private static DataAccess da;
    static Connection con;
    static IDataSet dataSet;
    static DatabaseConnection dc;
    Company company;
    @FXML
    JFXCheckBox chkHub;
    @FXML
    JFXTextField nameTextField;
    @FXML
    JFXTextField hubLocation;
    @FXML
    JFXTextField addressTextField;
    @FXML
    HBox hbUrlSAp;
    @FXML
    HBox hbUrlOMS;
    @FXML
    TextField serverNameTextField;
    @FXML
    TextField dwnloadUrl;
    @FXML
    JFXTextField numberOfReceiptTextField;
    @FXML
    JFXTextField endPoint;
    @FXML
    JFXTextField endPointOMS;
    @FXML
    JFXTextField costCenter;
    @FXML
    JFXTextField storeName;
    @FXML
    JFXTextField storeCode;
    @FXML
    JFXTextField locationCode;
    @FXML
    DatePicker appDate;
    @FXML
    Button doneButton;
    @FXML
    private JFXTextField lstInvoiceNo;
    public ConfigurationPageContainerPane parent;
    StringConverter<? extends Number> intconverter = new IntegerStringConverter();
    StringConverter<? extends Boolean> booleaConverter = new BooleanStringConverter();
    MainPage mainPage;
    boolean isFirstTime;

    public CompanyPane(ConfigurationPageContainerPane cpcp, Company cmpCompany, MainPage mainPage) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("CompanyPane.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            if (cpcp != null) {
                this.isFirstTime = true;
                this.santa = cpcp.santa;
                this.doneButton.setVisible(false);
            } else {
                this.santa = mainPage.santa;
                this.mainPage = mainPage;
                this.serverNameTextField.setEditable(false);
                if (!mainPage.currentUser.getParentCompany().getAllowDirectPurchase()) {
                    // empty if block
                }
                this.title = "Company Page";
                if (!mainPage.currentUser.getRoleDescription().equals(UserType.Administrator.name())) {
                    this.appDate.setVisible(false);
                    this.dwnloadUrl.setVisible(false);
                }
            }
            da = this.santa.da;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.company = cmpCompany == null ? mainPage.currentUser.getParentCompany() : cmpCompany;
        this.nameTextField.textProperty().bindBidirectional((Property)this.company.nameProperty());
        this.locationCode.textProperty().bindBidirectional((Property)this.company.locationCodeProperty());
        this.addressTextField.textProperty().bindBidirectional((Property)this.company.addressProperty());
        this.costCenter.textProperty().bindBidirectional((Property)this.company.costCenterProperty());
        this.endPoint.textProperty().bindBidirectional((Property)this.company.endPointProperty());
        this.endPointOMS.textProperty().bindBidirectional((Property)this.company.endPointOMSProperty());
        this.storeName.textProperty().bindBidirectional((Property)this.company.storeNameProperty());
        this.storeCode.textProperty().bindBidirectional((Property)this.company.storeCodeProperty());
        this.appDate.valueProperty().bindBidirectional(this.company.currentDayProperty());
        this.dwnloadUrl.textProperty().bindBidirectional((Property)this.company.downloadUrlProperty());
        this.chkHub.selectedProperty().bindBidirectional((Property)this.company.isMainHubProperty());
        this.hubLocation.textProperty().bindBidirectional((Property)this.company.hubLocationCodeProperty());
        if (!this.isFirstTime) {
            this.endPoint.setDisable(true);
            this.endPointOMS.setDisable(true);
        }
        this.serverNameTextField.setText(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("Santa.jar", "Db/SANTA.FDB").substring(1));
        this.numberOfReceiptTextField.textProperty().bindBidirectional((Property)this.company.numberOfReceiptProperty(), this.intconverter);
        this.lstInvoiceNo.textProperty().bindBidirectional((Property)this.company.lastInvoiceNumberProperty(), this.intconverter);
        this.doneButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CompanyPane.this.done();
            }
        });
    }

    private void done() {
        block7: {
            try {
                if (this.mainPage == null) {
                    this.santa.da = da = new DataAccess();
                    this.company.dataAccess = da;
                }
                if (this.validateControl()) {
                    CompanyDataList companyDataList = new CompanyDataList(da);
                    companyDataList.getOriginalList().add((Object)this.company);
                    companyDataList.update();
                    this.santa.company = this.company;
                    if (this.isFirstTime) {
                        SyncSetting syncSetting = new SyncSetting(da);
                        syncSetting.setBEURL(this.endPoint.getText());
                        syncSetting.setD365URL(this.endPointOMS.getText());
                        SyncSettingDataList syncSettingDataList = new SyncSettingDataList(da);
                        syncSettingDataList.getOriginalList().add((Object)syncSetting);
                        syncSettingDataList.update();
                        this.isFirstTime = false;
                    }
                    if (this.mainPage != null) {
                        this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
                    }
                } else {
                    this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
                }
            }
            catch (Exception ex) {
                if (this.mainPage == null) break block7;
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        }
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        if (this.mainPage != null) {
            this.needToSave = false;
            if (this.company != null && this.company.getState() == ObjectState.Changed) {
                this.needToSave = true;
            }
        }
        if (this.nameTextField.getText() == null || this.nameTextField.getText().isEmpty()) {
            this.errorMessage = this.errorMessage + "Company name must not be empty\n";
        }
        if (this.serverNameTextField.getText() == null || this.serverNameTextField.getText().isEmpty()) {
            this.errorMessage = this.errorMessage + "Server name must not be empty";
        }
        if (this.storeName.getText() == null || this.storeName.getText().isEmpty()) {
            this.errorMessage = this.errorMessage + "Store name must not be empty";
        }
        if (this.storeCode.getText() == null || this.storeName.getText().isEmpty()) {
            this.errorMessage = this.errorMessage + "Store code must not be empty";
        }
        return this.errorMessage.trim().isEmpty();
    }

    @Override
    void closeNotification() {
        if (this.mainPage != null) {
            this.mainPage.closeNotification();
        }
    }

    @Override
    void yes() {
        try {
            this.done();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        if (this.mainPage != null) {
            this.mainPage.isToMenu = false;
            this.mainPage.showNotification(NotificationType.Warning, "Do you want to save change(s)", this);
        } else {
            this.needToSave = true;
            this.done();
            this.closeNotification();
        }
    }
}

