/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.report;

import com.xputertechnologies.santa.report.StockItemBarCode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class JRStockItemBarCodeDataSource
implements JRDataSource {
    private ArrayList<StockItemBarCode> stockItemBarCodes = new ArrayList();
    int index = -1;

    public ArrayList<StockItemBarCode> getBarCodes() {
        return this.stockItemBarCodes;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.getBarCodes() != null && this.index < this.getBarCodes().size();
    }

    public Object getFieldValue(JRField jrf) throws JRException {
        StockItemBarCode f = this.getBarCodes().get(this.index);
        if (jrf.getName().equals("code")) {
            return f.code;
        }
        if (jrf.getName().equals("barCode")) {
            return f.barCode;
        }
        if (jrf.getName().equals("name")) {
            return f.name;
        }
        if (jrf.getName().equals("SN")) {
            return f.SN;
        }
        return null;
    }

    public void add(String code, BufferedImage barCode, String name, String SN) {
        try {
            ByteArrayInputStream fis = null;
            if (barCode != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)barCode, "png", os);
                fis = new ByteArrayInputStream(os.toByteArray());
            }
            this.getBarCodes().add(new StockItemBarCode(code, fis, name, SN));
        }
        catch (Exception ex) {
            Logger.getLogger(JRStockItemBarCodeDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String[] fieldNames() {
        String[] fieldNames = new String[]{"itemCode", "itemName", "qty", "amount"};
        return fieldNames;
    }
}

