/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SalesMode;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.SaleAccountDetailResolverDataList;
import com.xputertechnologies.santa.list.SaleItemList;
import com.xputertechnologies.santa.list.StockItemList;
import java.io.File;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class SaleList
extends DataList<Sale> {
    public DataAccess dataAccess;

    public SaleList(DataAccess dt) {
        this.dataAccess = dt;
        this.t = new Sale(dt);
    }

    public SaleList() {
    }

    @Override
    public void select() {
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            DataAccess dt = this.getDataAccess();
            this.getOriginalList().clear();
            ResultSet rslt = dt.select(query, param);
            if (rslt != null) {
                while (rslt.next()) {
                    Sale sale = new Sale(rslt.getString("salesRep"), rslt.getTimestamp("transactionDate"), rslt.getTimestamp("DATE"), rslt.getInt("invoiceNumber"), rslt.getDouble("totalAmount"), rslt.getDouble("amountPaid"), rslt.getDouble("discount"), rslt.getDouble("balance"), rslt.getDouble("priceFix"), SalesMode.valueOf(rslt.getString("modeType")), rslt.getString("companyName"), rslt.getString("customerName"), rslt.getString("sellingStaff"), rslt.getBoolean("returnAll"), rslt.getString("accountDetailNo"), rslt.getString("saleId"), rslt.getBoolean("isB2B"), rslt.getBoolean("syncFlag"), rslt.getDouble("shippingFee"), rslt.getString("storeCode"), rslt.getString("syncError"), rslt.getBoolean("isManual"), rslt.getString("saleComment"), rslt.getString("salesChannel"), rslt.getString("locationCode"), rslt.getString("costCenter"), rslt.getString("hdInvoiceNo"), rslt.getString("creditDescription"), rslt.getString("creditToken"), rslt.getString("promoVoucher"), rslt.getDouble("promoVoucherAmt"), rslt.getString("manualSaleStatus"), rslt.getString("customerPhoneNumber"), rslt.getString("customerEmail"), rslt.getString("approvals"), rslt.getString("salesRejectedBy"), rslt.getString("returnApprovals"), rslt.getString("returnedBy"), rslt.getString("actionComment"), rslt.getString("d365CustomerNo"), rslt.getString("saleStatus"), rslt.getString("paymentTerm"), rslt.getString("imageUrl"), rslt.getString("returnRejectedBy"), rslt.getString("returnComment"), rslt.getString("paymentTermDescription"), dt);
                    if (sale.getHdInvoiceNo() == null || sale.getHdInvoiceNo().isEmpty()) {
                        sale.setHdInvoiceNo(String.valueOf(sale.getInvoiceNumber()));
                    }
                    if (sale.getImageUrl() != null && !sale.getImageUrl().isEmpty()) {
                        String[] paths;
                        sale.img.clear();
                        for (String path : paths = sale.getImageUrl().split(",")) {
                            File file = new File(path);
                            if (!file.exists()) continue;
                            sale.img.add(ImageIO.read(file));
                        }
                    }
                    sale.vClone = sale.Clone();
                    this.getOriginalList().add((Object)sale);
                }
                rslt.close();
                dt.closeConnection();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static int selectLastInvoiceNumber(DataAccess dac) {
        try {
            ResultSet rslt = dac.select("SELECT Max(invoiceNumber) as highest FROM  SALE", dac.getEmptyParameterValues());
            if (rslt != null) {
                if (rslt.next()) {
                    return rslt.getInt("highest");
                }
                rslt.close();
                dac.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0;
    }

    public static int cehckIfTbExist(DataAccess dac, String qry) {
        try {
            ResultSet rslt = dac.select(qry, dac.getEmptyParameterValues());
            if (rslt != null) {
                if (rslt.next()) {
                    return rslt.getInt("found");
                }
                rslt.close();
                dac.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0;
    }

    public void selectAllFull(String query, ParameterValue[] param) {
        try {
            DataAccess dt = this.getDataAccess();
            SaleItemList saleItemList = new SaleItemList(dt);
            SaleAccountDetailResolverDataList saleAccountDetailResolverDataList = new SaleAccountDetailResolverDataList(dt);
            this.getOriginalList().clear();
            ResultSet rslt = dt.select(query, param);
            if (rslt != null) {
                while (rslt.next()) {
                    Sale sale = new Sale(rslt.getString("salesRep"), rslt.getTimestamp("transactionDate"), rslt.getTimestamp("DATE"), rslt.getInt("invoiceNumber"), rslt.getDouble("totalAmount"), rslt.getDouble("amountPaid"), rslt.getDouble("discount"), rslt.getDouble("balance"), rslt.getDouble("priceFix"), SalesMode.valueOf(rslt.getString("modeType")), rslt.getString("companyName"), rslt.getString("customerName"), rslt.getString("sellingStaff"), rslt.getBoolean("returnAll"), rslt.getString("accountDetailNo"), rslt.getString("saleId"), rslt.getBoolean("isB2B"), rslt.getBoolean("syncFlag"), rslt.getDouble("shippingFee"), rslt.getString("storeCode"), rslt.getString("syncError"), rslt.getBoolean("isManual"), rslt.getString("saleComment"), rslt.getString("salesChannel"), rslt.getString("locationCode"), rslt.getString("costCenter"), rslt.getString("hdInvoiceNo"), rslt.getString("creditDescription"), rslt.getString("creditToken"), rslt.getString("promoVoucher"), rslt.getDouble("promoVoucherAmt"), rslt.getString("manualSaleStatus"), rslt.getString("customerPhoneNumber"), rslt.getString("customerEmail"), rslt.getString("approvals"), rslt.getString("salesRejectedBy"), rslt.getString("returnApprovals"), rslt.getString("returnedBy"), rslt.getString("actionComment"), rslt.getString("d365CustomerNo"), rslt.getString("saleStatus"), rslt.getString("paymentTerm"), rslt.getString("imageUrl"), rslt.getString("returnRejectedBy"), rslt.getString("returnComment"), rslt.getString("paymentTermDescription"), dt);
                    if (sale.getHdInvoiceNo() == null || sale.getHdInvoiceNo().isEmpty()) {
                        sale.setHdInvoiceNo(String.valueOf(sale.getInvoiceNumber()));
                    }
                    if (sale.getImageUrl() != null && !sale.getImageUrl().isEmpty()) {
                        String[] paths;
                        sale.img.clear();
                        for (String path : paths = sale.getImageUrl().split(",")) {
                            File file = new File(path);
                            if (!file.exists()) continue;
                            sale.img.add(ImageIO.read(file));
                        }
                    }
                    sale.vClone = sale.Clone();
                    this.getOriginalList().add((Object)sale);
                }
                rslt.close();
                for (Sale sale : this.getOriginalList()) {
                    saleItemList.selectAll("Select * from SaleItem where saleinvoicenumber=?", new ParameterValue[]{new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
                    saleAccountDetailResolverDataList.selectAll("Select * From SaleAccountDetailResolver where invoiceNumber=?", new ParameterValue[]{new ParameterValue("invoiceNumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
                    sale.getSaleAccountDetailResolvers().addAll(saleAccountDetailResolverDataList.getOriginalList());
                    if (saleItemList.getOriginalList().size() <= 0) continue;
                    sale.getSaleItemsList().addAll(saleItemList.getOriginalList());
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        try {
            DataAccess dt = this.getDataAccess();
            if (reset) {
                this.currentPage = 0;
            }
            Object query = "Select  * From Sale Where ";
            for (ParameterValue pv : searchCondition.getParametersvalues()) {
                query = (String)query + pv.getParameterName() + " like ? or ";
            }
            query = ((String)query).substring(0, ((String)query).length() - 3);
            Objects.requireNonNull(this);
            query = (String)query + "order by invoiceNumber ASC Limit " + 50 + " Offset " + this.currentPage;
            ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
            ResultSet rslt = dt.select((String)query, parameterValue);
            if (rslt != null) {
                while (rslt.next()) {
                    try {
                        Sale sale = new Sale(rslt.getString("salesRep"), rslt.getTimestamp("transactionDate"), rslt.getTimestamp("DATE"), rslt.getInt("invoiceNumber"), rslt.getDouble("totalAmount"), rslt.getDouble("amountPaid"), rslt.getDouble("discount"), rslt.getDouble("balance"), rslt.getDouble("priceFix"), SalesMode.valueOf(rslt.getString("modeType")), rslt.getString("companyName"), rslt.getString("customerName"), rslt.getString("sellingStaff"), rslt.getBoolean("returnAll"), rslt.getString("accountDetailNo"), rslt.getString("saleId"), rslt.getBoolean("isB2B"), rslt.getBoolean("syncFlag"), rslt.getDouble("shippingFee"), rslt.getString("storeCode"), rslt.getString("syncError"), rslt.getBoolean("isManual"), rslt.getString("saleComment"), rslt.getString("salesChannel"), rslt.getString("locationCode"), rslt.getString("costCenter"), rslt.getString("hdInvoiceNo"), rslt.getString("creditDescription"), rslt.getString("creditToken"), rslt.getString("promoVoucher"), rslt.getDouble("promoVoucherAmt"), rslt.getString("manualSaleStatus"), rslt.getString("customerPhoneNumber"), rslt.getString("customerEmail"), rslt.getString("approvals"), rslt.getString("salesRejectedBy"), rslt.getString("returnApprovals"), rslt.getString("returnedBy"), rslt.getString("actionComment"), rslt.getString("d365CustomerNo"), rslt.getString("saleStatus"), rslt.getString("paymentTerm"), rslt.getString("imageUrl"), rslt.getString("returnRejectedBy"), rslt.getString("returnComment"), rslt.getString("paymentTermDescription"), dt);
                        if (sale.getHdInvoiceNo() == null || sale.getHdInvoiceNo().isEmpty()) {
                            sale.setHdInvoiceNo(String.valueOf(sale.getInvoiceNumber()));
                        }
                        if (sale.getImageUrl() != null && !sale.getImageUrl().isEmpty()) {
                            String[] paths;
                            sale.img.clear();
                            for (String path : paths = sale.getImageUrl().split(",")) {
                                File file = new File(path);
                                if (!file.exists()) continue;
                                sale.img.add(ImageIO.read(file));
                            }
                        }
                        sale.vClone = sale.Clone();
                        this.getOriginalList().add((Object)sale);
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                ++this.currentPage;
                rslt.close();
                dt.closeConnection();
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<SearchClass> selectAutoComplete(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("invoiceNumber", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("sellingStaff", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("PhoneNumber", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select  invoiceNumber,name From Sale join Customer on Sale.d365CustomerNo=Customer.d365Code Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by invoiceNumber ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new SearchClass(rs.getString("invoiceNumber"), rs.getString("name") + "[" + rs.getString("invoiceNumber") + "]"));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }
}

