/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.SaleAccountDetailResolver;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.SaleList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class SaleAccountDetailResolverDataList
extends DataList<SaleAccountDetailResolver> {
    public DataAccess dataAccess;

    public SaleAccountDetailResolverDataList() {
    }

    public SaleAccountDetailResolverDataList(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.t = new SaleAccountDetailResolver(dataAccess);
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    SaleAccountDetailResolver accountDetail = new SaleAccountDetailResolver(rs.getString("accNumber"), rs.getInt("invoiceNumber"), rs.getDouble("amountPaid"), rs.getTimestamp("transactionDate"), rs.getString("accType"), rs.getString("paymentCode"), rs.getString("accountName"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectAllMigrate(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    SaleAccountDetailResolver accountDetail = new SaleAccountDetailResolver(rs.getString("accNumber"), rs.getInt("invoiceNumber"), rs.getDouble("amountPaid"), rs.getTimestamp("transactionDate"), rs.getString("accType"), rs.getString("accountName"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "SELECT FIRST 50 SKIP " + 50 * this.currentPage + " Distinct * FROM SaleAccountDetailResolver WHERE ";
        for (ParameterValue p : searchCondition.getParametersvalues()) {
            query = (String)query + p.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        query = (String)query + " ORDER BY CODE ASC";
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        try {
            ResultSet rs = this.dataAccess.select((String)query, parameterValue);
            if (rs != null) {
                while (rs.next()) {
                    SaleAccountDetailResolver accountDetail = new SaleAccountDetailResolver(rs.getString("accNumber"), rs.getInt("invoiceNumber"), rs.getDouble("amountPaid"), rs.getTimestamp("transactionDate"), rs.getString("accType"), rs.getString("paymentCode"), rs.getString("accountName"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SaleAccountDetailResolverDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String getSapCode(DataAccess dac, int InvoiceNo) {
        try {
            ResultSet rslt = dac.select("Select Customer.d365Code from Customer JOIN SALE on Customer.PHONENUMBER= SALE.CustomerPhoneNumber where  SALE.INVOICENUMBER=?", new ParameterValue[]{new ParameterValue("InvoiceNo", JDBCType.INTEGER, InvoiceNo)});
            if (rslt != null) {
                if (rslt.next()) {
                    return rslt.getString("d365Code");
                }
                rslt.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    public static ObservableList<SaleAccountDetailResolver> selectDailySaleByAcct(String query, ParameterValue[] param, DataAccess dataAccess) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            ResultSet rs = dataAccess.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    SaleAccountDetailResolver accountDetail = new SaleAccountDetailResolver(dataAccess);
                    accountDetail.ComanyName = rs.getString("companyName");
                    accountDetail.StoreName = rs.getString("storeName");
                    accountDetail.setAccNumber(rs.getString("accNumber"));
                    accountDetail.setInvoiceNumber(rs.getInt("invoiceNumber"));
                    accountDetail.setAmountPaid(rs.getDouble("amountPaid"));
                    accountDetail.setTransactionDate(rs.getTimestamp("transactionDate"));
                    accountDetail.setAccType(rs.getString("accType"));
                    accountDetail.CustomerName = rs.getString("Name");
                    accountDetail.saleChannel = rs.getString("SALESCHANNEL");
                    accountDetail.FullAccountDetail = rs.getString("ACCNAME") + "(" + rs.getString("accNumber") + ")";
                    accountDetail.sellingStaff = rs.getString("SELLINGSTAFF");
                    accountDetail.setPaymentCode(rs.getString("PAYMENTCODE"));
                    accountDetail.vClone = accountDetail.clone();
                    accountDetail.CustomerCode = SaleAccountDetailResolverDataList.getSapCode(dataAccess, accountDetail.getInvoiceNumber());
                    list.add((Object)accountDetail);
                }
                rs.close();
                dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return list;
    }
}

