/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.AccountPaymentType;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.DataList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccountDetailDataList
extends DataList<AccountDetail> {
    public DataAccess dataAccess;

    public AccountDetailDataList() {
    }

    public AccountDetailDataList(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.t = new AccountDetail(dataAccess);
    }

    @Override
    public void select() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void selectMigrate(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    AccountDetail accountDetail = new AccountDetail(rs.getString("accNumber"), rs.getString("accName"), rs.getString("accType"), rs.getBoolean("isDefault"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    AccountDetail accountDetail = new AccountDetail(rs.getString("accNumber"), rs.getString("accName"), rs.getString("accType"), rs.getBoolean("isDefault"), rs.getBoolean("isDisable"), rs.getBoolean("isDeleted"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectAll() {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select("Select * From AccountDetail", this.dataAccess.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    AccountDetail accountDetail = new AccountDetail(rs.getString("accNumber"), rs.getString("accName"), rs.getString("accType"), rs.getBoolean("isDefault"), rs.getBoolean("isDisable"), rs.getBoolean("isDeleted"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectAllNotDeleted() {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select("Select * From AccountDetail where isDeleted=? or isDeleted is null or isDeleted='' ", new ParameterValue[]{new ParameterValue("isDeleted", JDBCType.CHAR, false)});
            if (rs != null) {
                while (rs.next()) {
                    AccountDetail accountDetail = new AccountDetail(rs.getString("accNumber"), rs.getString("accName"), rs.getString("accType"), rs.getBoolean("isDefault"), rs.getBoolean("isDisable"), rs.getBoolean("isDeleted"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectAllOnlyCash() {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select("Select * From AccountDetail where (isDeleted=? or isDeleted is null or isDeleted='') and accType=? ", new ParameterValue[]{new ParameterValue("isDeleted", JDBCType.CHAR, false), new ParameterValue("accType", JDBCType.VARCHAR, AccountPaymentType.Cash.name())});
            if (rs != null) {
                while (rs.next()) {
                    AccountDetail accountDetail = new AccountDetail(rs.getString("accNumber"), rs.getString("accName"), rs.getString("accType"), rs.getBoolean("isDefault"), rs.getBoolean("isDisable"), rs.getBoolean("isDeleted"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CompanyDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "SELECT FIRST 50 SKIP " + 50 * this.currentPage + " Distinct * FROM AccountDetail WHERE ";
        for (ParameterValue p : searchCondition.getParametersvalues()) {
            query = (String)query + p.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        query = (String)query + " ORDER BY CODE ASC";
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        try {
            ResultSet rs = this.dataAccess.select((String)query, parameterValue);
            if (rs != null) {
                while (rs.next()) {
                    AccountDetail accountDetail = new AccountDetail(rs.getString("accNumber"), rs.getString("accName"), rs.getString("accType"), rs.getBoolean("isDefault"), rs.getBoolean("isDisable"), rs.getBoolean("isDeleted"), this.dataAccess);
                    accountDetail.vClone = accountDetail.clone();
                    this.getOriginalList().add((Object)accountDetail);
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
            this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
        }
        catch (SQLException ex) {
            Logger.getLogger(AccountDetailDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void deleteAll(DataAccess da) throws Exception {
        da.performDbOperation("Delete From AccountDetail", da.getEmptyParameterValues());
    }
}

