/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Purchase;
import com.xputertechnologies.santa.Supplier;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.PurchaseList;
import com.xputertechnologies.santa.list.SupplierDataList;
import com.xputertechnologies.santa.list.SupplierPaymentDataList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class SupplierPayment
extends DbEntity {
    User parentUser;
    Purchase parentPurchase;
    Supplier parentSupplier;
    public SupplierPayment vclone;
    private boolean isclone;
    private ObjectProperty date = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private DoubleProperty amountPaid = new SimpleDoubleProperty();
    private String supplierName;
    private String purchaseCode;
    private DoubleProperty totalAmount = new SimpleDoubleProperty();
    StringProperty code = new SimpleStringProperty();
    StringProperty comment = new SimpleStringProperty();
    private String recievingStaff;

    public SupplierPayment(Double amountPaid, String code, Date date, String purchaseCode, String recievingStaff, String supplierName, Double totalAmount, String comment, DataAccess dbAccess) {
        super(dbAccess);
        this.isConstructor = true;
        this.date.set((Object)date);
        this.amountPaid.set(amountPaid.doubleValue());
        this.supplierName = supplierName;
        this.purchaseCode = purchaseCode;
        this.totalAmount.set(totalAmount.doubleValue());
        this.code.set((Object)code);
        this.recievingStaff = recievingStaff;
        this.comment.set((Object)comment);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.isConstructor = false;
        this.initializeListener();
        this.clone();
    }

    public SupplierPayment(DataAccess dbAccess) {
        super(dbAccess);
    }

    public Date getDate() {
        return (Date)this.date.get();
    }

    public void setDate(Date date) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.date.set((Object)date);
        this.changeObjectState();
    }

    public ObjectProperty dateProperty() {
        return this.date;
    }

    public double getAmountPaid() {
        return this.amountPaid.get();
    }

    public void setAmountPaid(double amountPaid) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.amountPaid.set(amountPaid);
        this.changeObjectState();
    }

    public DoubleProperty amountPaidProperty() {
        return this.amountPaid;
    }

    public double getTotalAmount() {
        return this.totalAmount.get();
    }

    public void setTotalAmount(double totalAmount) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.totalAmount.set(totalAmount);
        this.changeObjectState();
    }

    public DoubleProperty totalAmountProperty() {
        return this.totalAmount;
    }

    public String getCode() {
        return (String)this.code.get();
    }

    public void setCode(String code) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.code.set((Object)code);
        this.changeObjectState();
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public StringProperty commentProperty() {
        return this.comment;
    }

    public String getComment() {
        return (String)this.commentProperty().get();
    }

    public void setComment(String comment) {
        if (!this.isclone && this.isMustClone()) {
            this.vclone = this.clone();
        }
        this.changeObjectState();
        this.commentProperty().set((Object)comment);
    }

    public SupplierPayment clone() {
        SupplierPayment cloneTemp = new SupplierPayment(this.getDbAccess());
        cloneTemp.setMustClone(false);
        cloneTemp.amountPaid.set(this.amountPaid.get());
        cloneTemp.code.set((Object)((String)this.code.get()));
        cloneTemp.date.set(this.date.get());
        cloneTemp.setComment((String)this.comment.get());
        cloneTemp.purchaseCode = this.purchaseCode;
        cloneTemp.recievingStaff = this.recievingStaff;
        cloneTemp.supplierName = this.supplierName;
        cloneTemp.setMustClone(true);
        this.isclone = true;
        return cloneTemp;
    }

    public SupplierPayment outerClone() {
        SupplierPayment cloneTemp = new SupplierPayment(this.getDbAccess());
        cloneTemp.setMustClone(false);
        cloneTemp.amountPaid.set(this.amountPaid.get());
        cloneTemp.code.set((Object)((String)this.code.get()));
        cloneTemp.date.set(this.date.get());
        cloneTemp.setComment((String)this.comment.get());
        cloneTemp.purchaseCode = this.purchaseCode;
        cloneTemp.recievingStaff = this.recievingStaff;
        cloneTemp.supplierName = this.supplierName;
        cloneTemp.setMustClone(true);
        return cloneTemp;
    }

    private void rollBack() {
        this.amountPaid.set(this.vclone.amountPaid.get());
        this.code.set((Object)((String)this.vclone.code.get()));
        this.date.set(this.vclone.date.get());
        this.purchaseCode = this.vclone.purchaseCode;
        this.recievingStaff = this.vclone.recievingStaff;
        this.supplierName = this.vclone.supplierName;
        this.comment.set((Object)((String)this.vclone.comment.get()));
        this.setMustClone(true);
    }

    public void setParentUser(User user) {
        if (!this.isclone) {
            this.vclone = this.clone();
        }
        this.parentUser = user;
        this.recievingStaff = user == null ? "" : user.getUserName();
        this.changeObjectState();
    }

    public void loadParentUser() {
        UserDataList userList = new UserDataList(this.getDbAccess());
        String query = "Select * From User Where username=?";
        userList.selectAll(query, new ParameterValue[]{new ParameterValue("userame", JDBCType.VARCHAR, this.recievingStaff)});
        if (userList.getOriginalList().size() > 0) {
            this.parentUser = (User)userList.getOriginalList().get(0);
        }
    }

    public User getParentUser() {
        if (this.parentUser == null) {
            this.loadParentUser();
        }
        return this.parentUser;
    }

    public void setParentPurchase(Purchase purchase) {
        if (!this.isclone) {
            this.vclone = this.clone();
        }
        this.parentPurchase = purchase;
        this.purchaseCode = purchase == null ? "" : purchase.getPurchaseCode();
        this.changeObjectState();
    }

    public void loadParentPurchase() {
        PurchaseList purchaseList = new PurchaseList();
        String query = "Select * From Purchase Where purchaseCode=?";
        purchaseList.selectAll(query, new ParameterValue[]{new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode)});
        if (purchaseList.getOriginalList().size() > 0) {
            this.parentPurchase = (Purchase)purchaseList.getOriginalList().get(0);
        }
    }

    public Purchase getParentPurchase() {
        if (this.parentPurchase == null) {
            this.loadParentPurchase();
        }
        return this.parentPurchase;
    }

    public void setParentSupplier(Supplier sp) {
        if (!this.isclone) {
            this.vclone = this.clone();
        }
        this.parentSupplier = sp;
        this.supplierName = sp == null ? "" : sp.getName();
        this.changeObjectState();
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public void loadParentSupplier() {
        SupplierDataList supplierList = new SupplierDataList(this.getDbAccess());
        String query = "Select * From Supplier Where name=?";
        supplierList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.supplierName)});
        if (supplierList.getOriginalList().size() > 0) {
            this.parentSupplier = (Supplier)supplierList.getOriginalList().get(0);
        }
    }

    public Supplier getParentSupplier() {
        if (this.parentSupplier == null) {
            this.loadParentSupplier();
        }
        return this.parentSupplier;
    }

    public static SupplierPaymentDataList search(String qry, ParameterValue[] param, DataAccess dt) {
        SupplierPaymentDataList supplierPaymentDataList = new SupplierPaymentDataList(dt);
        supplierPaymentDataList.selectAll(qry, param);
        return supplierPaymentDataList;
    }

    @Override
    public void insert() throws Exception {
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("amountPaid", JDBCType.DOUBLE, this.amountPaid.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("\"date\"", JDBCType.DATE, this.date.get()), new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode), new ParameterValue("recievingStaff", JDBCType.VARCHAR, this.recievingStaff), new ParameterValue("supplierName", JDBCType.VARCHAR, this.supplierName), new ParameterValue("totalAmount", JDBCType.DOUBLE, this.totalAmount.get()), new ParameterValue("comment", JDBCType.VARCHAR, this.comment.get())};
            String query = "insert into SupplierPayment (amountPaid,code,\"date\",purchaseCode,recievingStaff,supplierName,totalAmount,comment) values(?,?,?,?,?,?,?,?)";
            this.getDbAccess().performDbOperation(query, paramValue);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            throw ex;
        }
    }

    @Override
    public void update() throws Exception {
        String query = "update SupplierPayment set amountPaid=?,code=?,\"date\"=?,purchaseCode=?,recievingStaff=?,supplierName=?,totalAmount=?,comment=? where purchaseCode=? and code=?";
        try {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("amountPaid", JDBCType.DOUBLE, this.amountPaid.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("\"date\"", JDBCType.DATE, this.date.get()), new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode), new ParameterValue("recievingStaff", JDBCType.VARCHAR, this.recievingStaff), new ParameterValue("supplierName", JDBCType.VARCHAR, this.supplierName), new ParameterValue("totalAmount", JDBCType.DOUBLE, this.totalAmount.get()), new ParameterValue("comment", JDBCType.VARCHAR, this.comment.get()), new ParameterValue("clonePurchaseCode", JDBCType.VARCHAR, this.vclone.purchaseCode), new ParameterValue("cloneCode", JDBCType.VARCHAR, this.vclone.getCode())};
            this.getDbAccess().performDbOperation(query, paramValue, true);
            this.vclone = this.clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isclone = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() {
        String query = "Delete from SupplierPayment where code=? ";
        try {
            this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get())});
        }
        catch (Exception ex) {
            Logger.getLogger(SupplierPayment.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        String[] parameters = new String[]{"amountPaid", "code", "\"date\"", "purchaseCode", "recievingStaff", "supplierName"};
        sb.setTableName("SupplierPayment");
        sb.setParameters(parameters);
        return sb;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
        this.amountPaid.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                SupplierPayment.this.setAmountPaid((Double)newValue);
            }
        });
        this.totalAmount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                SupplierPayment.this.setTotalAmount((Double)newValue);
            }
        });
        this.code.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                SupplierPayment.this.setCode(newValue);
            }
        });
    }
}

