/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Expenses;
import com.xputertechnologies.santa.Income;
import com.xputertechnologies.santa.Issue;
import com.xputertechnologies.santa.PurchaseItem;
import com.xputertechnologies.santa.Replenishment;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.Supplier;
import com.xputertechnologies.santa.SupplierPayment;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.OutstandingQtyGreaterException;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.ExpensesDataList;
import com.xputertechnologies.santa.list.IncomeDataList;
import com.xputertechnologies.santa.list.IssueDataList;
import com.xputertechnologies.santa.list.PurchaseItemList;
import com.xputertechnologies.santa.list.PurchaseList;
import com.xputertechnologies.santa.list.ReplenishmentList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.SupplierDataList;
import com.xputertechnologies.santa.list.SupplierPaymentDataList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.Date;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Purchase
extends DbEntity {
    public Purchase vClone;
    private boolean isCloned;
    public int lastPurchase;
    private int counter;
    private int serialNo;
    public String NewSerial;
    private Date currentDate;
    private String incomeExpenseCode;
    Company c = new Company();
    DataAccess dt = this.getDbAccess();
    private BooleanProperty modified = new SimpleBooleanProperty();
    public double incomeTot = 0.0;
    private StringProperty comment = new SimpleStringProperty();
    private Supplier supplier;
    private DoubleProperty amountPaid = new SimpleDoubleProperty();
    private ObservableList<PurchaseItem> purchaseItems = FXCollections.observableArrayList();
    private ObservableList<PurchaseItem> oldPurchaseItems = FXCollections.observableArrayList();
    IntegerProperty tracker = new SimpleIntegerProperty();
    public double keepBal;
    public StringBinding totalAmountBindingCorrection = new StringBinding(){

        protected String computeValue() {
            double res = 0.0;
            if (Purchase.this.purchaseItems.size() == 0) {
                Purchase.this.amountPaid.set(0.0);
                Purchase.this.balance.set(0.0);
                Purchase.this.totalAmount.set(0.0);
                return "0.0";
            }
            if (!Purchase.this.doNotEnterAmtBinding) {
                for (PurchaseItem purchaseItem : Purchase.this.purchaseItems) {
                    if (!purchaseItem.getIsCheck() || !(purchaseItem.getQuantity() > 0.0f) && !(purchaseItem.getOutStandingQty() > 0.0f)) continue;
                    if (purchaseItem.getParentStockItem().getParentUnit().getName().equals(purchaseItem.getUnit()) && purchaseItem.getParentStockItem().getCostPrice() == purchaseItem.getCostPrice()) {
                        res += (double)(purchaseItem.getQuantity() + purchaseItem.getOutStandingQty()) * purchaseItem.getCostPrice();
                        purchaseItem.prevOutstandingQty = purchaseItem.getParentUnit().getQuantity();
                        continue;
                    }
                    if (purchaseItem.getParentStockItem().getParentUnit().getName().equals(purchaseItem.getUnit()) && purchaseItem.getParentStockItem().getCostPrice() != purchaseItem.getCostPrice() && !purchaseItem.isFromDb) {
                        purchaseItem.setCostPrice(purchaseItem.getCostPrice() * (purchaseItem.prevOutstandingQty > 0.0f ? (double)purchaseItem.getParentUnit().convertUnit(purchaseItem.prevOutstandingQty) : 1.0));
                        res += (double)(purchaseItem.getQuantity() + purchaseItem.getOutStandingQty()) * purchaseItem.getCostPrice();
                        purchaseItem.prevOutstandingQty = purchaseItem.getParentUnit().getQuantity();
                        continue;
                    }
                    if (!purchaseItem.getParentStockItem().getParentUnit().getName().equals(purchaseItem.getUnit()) && purchaseItem.getParentStockItem().getCostPrice() == purchaseItem.getCostPrice() && !purchaseItem.isFromDb) {
                        if (purchaseItem.prevOutstandingQty != purchaseItem.getParentUnit().getQuantity()) {
                            purchaseItem.setCostPrice(purchaseItem.getParentStockItem().getCostPrice() * (double)purchaseItem.getParentUnit().convertUnit(purchaseItem.getParentStockItem().getParentUnit()));
                        }
                        res += (double)(purchaseItem.getQuantity() + purchaseItem.getOutStandingQty()) * purchaseItem.getCostPrice();
                        purchaseItem.prevOutstandingQty = purchaseItem.getParentUnit().getQuantity();
                        continue;
                    }
                    if (purchaseItem.getParentStockItem().getParentUnit().getName().equals(purchaseItem.getUnit()) || purchaseItem.getParentStockItem().getCostPrice() == purchaseItem.getCostPrice() || purchaseItem.isFromDb) continue;
                    purchaseItem.setCostPrice(purchaseItem.getCostPrice() * (double)(purchaseItem.prevOutstandingQty > 0.0f ? purchaseItem.getParentUnit().convertUnit(purchaseItem.prevOutstandingQty) : 1.0f));
                    res += (double)(purchaseItem.getQuantity() + purchaseItem.getOutStandingQty()) * purchaseItem.getCostPrice();
                    purchaseItem.prevOutstandingQty = purchaseItem.getParentUnit().getQuantity();
                }
                Purchase.this.totalAmount.set(res);
                if (Purchase.this.totalAmount.get() > Purchase.this.amountPaid.get()) {
                    Purchase.this.balance.set(Purchase.this.totalAmount.get() - Purchase.this.amountPaid.get());
                }
            } else {
                res = Purchase.this.totalAmount.get();
                Purchase.this.amountPaid.set(res - Purchase.this.balanceProperty().get());
            }
            return String.valueOf(res);
        }
    };
    public boolean doNotEnterAmtBinding = false;
    public StringBinding totalAmountBinding = new StringBinding(){

        protected String computeValue() {
            double res = 0.0;
            if (Purchase.this.purchaseItems.size() == 0) {
                Purchase.this.amountPaid.set(0.0);
                Purchase.this.balance.set(0.0);
                Purchase.this.totalAmount.set(0.0);
                return "0.0";
            }
            if (!Purchase.this.doNotEnterAmtBinding) {
                for (PurchaseItem purchaseItem : Purchase.this.purchaseItems) {
                    if (!purchaseItem.getIsCheck() || !(purchaseItem.getQuantity() > 0.0f) && !(purchaseItem.getOutStandingQty() > 0.0f)) continue;
                    if (purchaseItem.getParentStockItem().getParentUnit().getName().equals(purchaseItem.getUnit()) && purchaseItem.getParentStockItem().getCostPrice() == purchaseItem.getCostPrice()) {
                        res += (double)(purchaseItem.getQuantity() + purchaseItem.getOutStandingQty()) * purchaseItem.getCostPrice();
                        purchaseItem.prevOutstandingQty = purchaseItem.getParentUnit().getQuantity();
                        continue;
                    }
                    if (purchaseItem.getParentStockItem().getParentUnit().getName().equals(purchaseItem.getUnit()) && purchaseItem.getParentStockItem().getCostPrice() != purchaseItem.getCostPrice() && !purchaseItem.isFromDb) {
                        purchaseItem.setCostPrice(purchaseItem.getCostPrice() * (double)(purchaseItem.prevOutstandingQty > 0.0f ? purchaseItem.getParentUnit().convertUnit(purchaseItem.prevOutstandingQty) : 1.0f));
                        res += (double)(purchaseItem.getQuantity() + purchaseItem.getOutStandingQty()) * purchaseItem.getCostPrice();
                        purchaseItem.prevOutstandingQty = purchaseItem.getParentUnit().getQuantity();
                        continue;
                    }
                    if (!purchaseItem.getParentStockItem().getParentUnit().getName().equals(purchaseItem.getUnit()) && purchaseItem.getParentStockItem().getCostPrice() == purchaseItem.getCostPrice() && !purchaseItem.isFromDb) {
                        if (purchaseItem.prevOutstandingQty != purchaseItem.getParentUnit().getQuantity()) {
                            purchaseItem.setCostPrice(purchaseItem.getParentStockItem().getCostPrice() * (double)purchaseItem.getParentUnit().convertUnit(purchaseItem.getParentStockItem().getParentUnit()));
                        }
                        res += (double)(purchaseItem.getQuantity() + purchaseItem.getOutStandingQty()) * purchaseItem.getCostPrice();
                        purchaseItem.prevOutstandingQty = purchaseItem.getParentUnit().getQuantity();
                        continue;
                    }
                    if (purchaseItem.getParentStockItem().getParentUnit().getName().equals(purchaseItem.getUnit()) || purchaseItem.getParentStockItem().getCostPrice() == purchaseItem.getCostPrice() || purchaseItem.isFromDb) continue;
                    purchaseItem.setCostPrice(purchaseItem.getCostPrice() * (double)(purchaseItem.prevOutstandingQty > 0.0f ? purchaseItem.getParentUnit().convertUnit(purchaseItem.prevOutstandingQty) : 1.0f));
                    res += (double)(purchaseItem.getQuantity() + purchaseItem.getOutStandingQty()) * purchaseItem.getCostPrice();
                    purchaseItem.prevOutstandingQty = purchaseItem.getParentUnit().getQuantity();
                }
                Purchase.this.amountPaid.set(res);
                Purchase.this.totalAmount.set(res);
            } else {
                res = Purchase.this.totalAmount.get();
                Purchase.this.amountPaid.set(res - Purchase.this.balanceProperty().get());
            }
            return String.valueOf(res);
        }
    };
    private ObjectProperty<Date> newDate = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private DoubleProperty totalAmount = new SimpleDoubleProperty();
    private DoubleProperty balance = new SimpleDoubleProperty();
    public String companyName;
    private StringProperty mainPurchase = new SimpleStringProperty();
    private String supplierName;
    private User user;
    private StringProperty purchaseCode = new SimpleStringProperty();
    private StringProperty purchasingOfficer = new SimpleStringProperty();
    public Company parentCompany;
    private Supplier parentSupplierName;
    private User parentUser;
    PurchaseItemList purchaseList = null;
    ReplenishmentList replenishmentList = null;
    StockItemList stockItemList = null;
    SupplierPaymentDataList supplierPaymentList = null;
    PurchaseItemList purchaseItemList = null;
    SupplierPayment supplierPayment;
    boolean Tempexist = false;
    Purchase oldpPurchase;
    Purchase newpurchase = null;
    IssueDataList issueList = null;
    IncomeDataList incomeList = null;
    ExpensesDataList expensesList = null;
    float expenseTotal;
    float incomeTotal;

    public Boolean getModified() {
        return this.modified.get();
    }

    public void setModified(Boolean modified) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.modified.set(modified.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty modifiedProperty() {
        return this.modified;
    }

    public String getComment() {
        return (String)this.comment.get();
    }

    public void setCommment(String comment) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.comment.set((Object)comment);
        this.changeObjectState();
    }

    public StringProperty commentProperty() {
        return this.comment;
    }

    public Supplier getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier supplier) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.supplier = supplier;
        this.changeObjectState();
    }

    public double getAmountPaid() {
        return this.amountPaid.get();
    }

    public void setAmountPaid(double amountPaid) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.amountPaid.set(amountPaid);
        this.changeObjectState();
    }

    public DoubleProperty amountPaidProperty() {
        return this.amountPaid;
    }

    public ObservableList<PurchaseItem> getOldPurchaseItems() {
        return this.oldPurchaseItems;
    }

    public void setOldPurchaseItems(ObservableList<PurchaseItem> oldPurchaseItems) {
        this.oldPurchaseItems = oldPurchaseItems;
    }

    public ObservableList<PurchaseItem> getPurchaseItemsList() {
        return this.purchaseItems;
    }

    public void setPurchaseItemsList(ObservableList<PurchaseItem> purchaseItems) {
        this.purchaseItems = purchaseItems;
    }

    public Date getNewDate() {
        return (Date)this.newDate.get();
    }

    public void setNewDate(Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.newDate.set((Object)date);
        this.changeObjectState();
    }

    public ObjectProperty<Date> dateProperty() {
        return this.newDate;
    }

    public double getTotalAmount() {
        return this.totalAmount.get();
    }

    public void setTotalAmount(double totalAmount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.totalAmount.set(totalAmount);
        this.changeObjectState();
    }

    public DoubleProperty totalAmountProperty() {
        return this.totalAmount;
    }

    public double getBalance() {
        return this.balance.get();
    }

    public void setBalance(double balance) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.balance.set(balance);
        this.changeObjectState();
    }

    public DoubleProperty balanceProperty() {
        return this.balance;
    }

    public String getMainPurchase() {
        return (String)this.mainPurchase.get();
    }

    public void setMainPurchase(String mainPurchase) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.mainPurchase.set((Object)mainPurchase);
        this.changeObjectState();
    }

    public StringProperty mainPurchaseProperty() {
        return this.mainPurchase;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.user = user;
        this.changeObjectState();
    }

    public String getPurchaseCode() {
        return (String)this.purchaseCode.get();
    }

    public void setPurchaseCode(String purchaseCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.purchaseCode.set((Object)purchaseCode);
        this.changeObjectState();
    }

    public StringProperty purchaseCodeProperty() {
        return this.purchaseCode;
    }

    public String getPurchasingOfficer() {
        return (String)this.purchasingOfficer.get();
    }

    public void setPurchasingOfficer(String PurchasingOfficer) {
        if (!this.isCloned && !this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.purchasingOfficer.set((Object)PurchasingOfficer);
        this.changeObjectState();
    }

    public StringProperty PurchasingOfficerProperty() {
        return this.purchasingOfficer;
    }

    public void setParentCompanyName(Company cp) {
        this.parentCompany = cp;
        this.companyName = cp == null ? "" : cp.getName();
        this.changeObjectState();
    }

    private void loadParentCompanyName() {
        CompanyDataList compList = new CompanyDataList(this.dt);
        String query = "Select * From Company where name=? ";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.companyName)});
        if (compList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)compList.getOriginalList().get(0);
        }
    }

    public Company getParentCompanyName() {
        if (this.parentCompany == null) {
            this.loadParentCompanyName();
        }
        return this.parentCompany;
    }

    public void setParentSupplierName(Supplier sp) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.parentSupplierName = sp;
        this.supplierName = sp == null ? "" : sp.getName();
        this.changeObjectState();
    }

    private void loadParentSupplierName() {
        SupplierDataList suppList = new SupplierDataList(this.getDbAccess());
        String query = "Select * From Supplier Where name=?";
        suppList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.supplierName)});
        if (suppList.getOriginalList().size() > 0) {
            this.parentSupplierName = (Supplier)suppList.getOriginalList().get(0);
        }
    }

    public String getSupplierName() {
        return this.supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Supplier getParentSupplier() {
        if (this.parentSupplierName == null) {
            this.loadParentSupplierName();
        }
        return this.parentSupplierName;
    }

    public void setParentUser(User use) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.parentUser = use;
        this.purchasingOfficer.set((Object)(use == null ? "" : use.getUserName()));
        this.changeObjectState();
    }

    public void loadParentUser() {
        UserDataList userList = new UserDataList();
        String query = "Select * From User Where userName=?";
        userList.selectAll(query, new ParameterValue[]{new ParameterValue("userName", JDBCType.VARCHAR, this.purchasingOfficer)});
        if (userList.getOriginalList().size() > 0) {
            this.parentUser = (User)userList.getOriginalList().get(0);
        }
    }

    public User getParentUser() {
        if (this.parentUser == null) {
            this.loadParentUser();
        }
        return this.parentUser;
    }

    public Purchase(Double balance, String supplierName, String companyName, Double totalAmount, String purchaseCode, String purchasingOfficer, Date date, String mainPurchase, String comment, Boolean modified, DataAccess de) {
        super(de);
        this.supplierName = supplierName;
        this.totalAmount.set(totalAmount.doubleValue());
        this.balance.set(balance.doubleValue());
        this.companyName = companyName;
        this.purchaseCode.set((Object)purchaseCode);
        this.purchasingOfficer.set((Object)purchasingOfficer);
        this.newDate.set((Object)date);
        this.mainPurchase.set((Object)mainPurchase);
        this.comment.set((Object)comment);
        this.modified.set(modified.booleanValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
        this.vClone = this.Clone();
    }

    public Purchase() {
    }

    public Purchase(DataAccess dbAccess) {
        super(dbAccess);
    }

    public Purchase Clone() {
        Purchase chase = new Purchase(this.dt);
        this.setMustClone(false);
        chase.balance.set(this.balance.get());
        chase.companyName = this.companyName;
        chase.totalAmount.set(this.totalAmount.get());
        chase.supplierName = this.supplierName;
        chase.purchaseCode.set((Object)((String)this.purchaseCode.get()));
        chase.purchasingOfficer.set((Object)((String)this.purchasingOfficer.get()));
        chase.newDate.set((Object)((Date)this.newDate.get()));
        chase.mainPurchase.set((Object)((String)this.mainPurchase.get()));
        chase.comment.set((Object)((String)this.comment.get()));
        chase.modified.set(this.modified.get());
        this.isCloned = true;
        return chase;
    }

    public Purchase outerClone() {
        Purchase chase = new Purchase(this.dt);
        this.setMustClone(false);
        chase.balance.set(this.balance.get());
        chase.companyName = this.companyName;
        chase.totalAmount.set(this.totalAmount.get());
        chase.supplierName = this.supplierName;
        chase.purchaseCode.set((Object)((String)this.purchaseCode.get()));
        chase.purchasingOfficer.set((Object)((String)this.purchasingOfficer.get()));
        chase.newDate.set((Object)((Date)this.newDate.get()));
        chase.mainPurchase.set((Object)((String)this.mainPurchase.get()));
        chase.comment.set((Object)((String)this.comment.get()));
        chase.modified.set(this.modified.get());
        this.isCloned = true;
        if (this.purchaseItems.size() > 0) {
            for (PurchaseItem purchaseItem : this.purchaseItems) {
                chase.getPurchaseItemsList().add((Object)purchaseItem.outerClone());
            }
        }
        this.setMustClone(true);
        return chase;
    }

    public void rollBack() {
        this.setBalance(this.vClone.getBalance());
        this.companyName = this.vClone.companyName;
        this.newDate.set((Object)((Date)this.vClone.newDate.get()));
        this.purchaseCode = this.vClone.purchaseCode;
        this.purchasingOfficer.set((Object)((String)this.vClone.purchasingOfficer.get()));
        this.supplierName = this.vClone.supplierName;
        this.totalAmount.set(this.vClone.totalAmount.get());
        this.mainPurchase.set((Object)((String)this.vClone.mainPurchase.get()));
        this.comment.set((Object)((String)this.vClone.comment.get()));
        this.modified.set(this.vClone.modified.get());
        this.setMustClone(true);
    }

    private void addPurchaseItemReplenishmentStockItem(PurchaseItem purchaseItem1, boolean setDirectPurchase) {
        Replenishment replenishment = new Replenishment(this.getDbAccess());
        purchaseItem1.getParentStockItem().setPrevBalaceBfQty(purchaseItem1.getParentStockItem().getQuantity());
        purchaseItem1.setParentPurchase(this);
        replenishment.quantityProperty().set(purchaseItem1.getQuantity() * purchaseItem1.getParentUnit().getQuantity());
        purchaseItem1.getParentStockItem().quantityProperty().set((float)((double)(purchaseItem1.getParentStockItem().getQuantity() + purchaseItem1.getQuantity() * purchaseItem1.getParentUnit().getQuantity()) - purchaseItem1.getParentStockItem().directPurchaseQtyProperty().get()));
        if (setDirectPurchase) {
            purchaseItem1.getParentStockItem().directPurchaseQtyProperty().set(0.0);
        }
        if (purchaseItem1.getParentStockItem().getCostPrice() != purchaseItem1.getCostPrice()) {
            purchaseItem1.getParentStockItem().costPriceProperty().set(purchaseItem1.getCostPrice());
            purchaseItem1.getParentStockItem().setParentUnit(purchaseItem1.getParentUnit());
        }
        purchaseItem1.getParentStockItem().sellingPriceProperty().set((double)((float)purchaseItem1.getSellingPrice()));
        this.stockItemList.getOriginalList().add((Object)purchaseItem1.getParentStockItem());
        replenishment.setParentPurchase(this);
        replenishment.setParentStockItem(purchaseItem1.getParentStockItem());
        replenishment.commentProperty().set((Object)("Replenishment for " + purchaseItem1.getParentStockItem().getName() + " with purchase Code " + this.getPurchaseCode()));
        replenishment.balanceBfProperty().set(purchaseItem1.getParentStockItem().getPrevBalaceBfQty());
        replenishment.dateProperty().set((Object)((Date)this.dateProperty().get()));
        this.replenishmentList.getOriginalList().add((Object)replenishment);
    }

    public void makePurchase(User currentUser) throws OutstandingQtyGreaterException, Exception {
        this.getDbAccess().start();
        Expenses e = new Expenses(this.getDbAccess());
        ExpensesDataList expensesDataList = new ExpensesDataList(this.getDbAccess());
        this.stockItemList = new StockItemList(this.getDbAccess());
        this.replenishmentList = new ReplenishmentList(this.getDbAccess());
        this.purchaseItemList = new PurchaseItemList(this.getDbAccess());
        this.supplierPayment = new SupplierPayment(this.getDbAccess());
        PurchaseList purchaseList = new PurchaseList(this.getDbAccess());
        this.setParentCompanyName(currentUser.getParentCompany());
        this.setPurchasingOfficer(currentUser.getUserName());
        this.dateProperty().set((Object)Date.valueOf(currentUser.getParentCompany().getCurrentDay()));
        this.setParentCompanyName(currentUser.getParentCompany());
        try {
            purchaseList.getOriginalList().add((Object)this);
            purchaseList.update();
        }
        catch (Exception ex) {
            Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
        }
        e.amountProperty().set(this.getAmountPaid());
        e.dateProperty().set((Object)Date.valueOf(this.getParentCompanyName().getCurrentDay()));
        e.setParentCompany(this.getParentCompanyName());
        e.descriptionProperty().set((Object)("Expense for purchase " + this.getPurchaseCode()));
        e.userNameProperty().set((Object)this.getPurchasingOfficer());
        expensesDataList.getOriginalList().add((Object)e);
        try {
            expensesDataList.update();
        }
        catch (Exception ex) {
            Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (PurchaseItem purchaseItem : this.getPurchaseItemsList()) {
            if (purchaseItem.getQuantity() > 0.0f && purchaseItem.getCostPrice() > 0.0) {
                if (purchaseItem.getParentStockItem().getDirectPurchaseQty() <= (double)(purchaseItem.getQuantity() * purchaseItem.getParentUnit().getQuantity())) {
                    if (purchaseItem.getParentStockItem().getDirectPurchaseQty() > 0.0) {
                        this.addPurchaseItemReplenishmentStockItem(purchaseItem, true);
                        continue;
                    }
                    this.addPurchaseItemReplenishmentStockItem(purchaseItem, false);
                    continue;
                }
                throw new OutstandingQtyGreaterException("Quantity comming in must not less than Outsatnding Qty");
            }
            Exception exception = new Exception("Make sure you set quantity and cost price for all item(s) to be sold");
            throw exception;
        }
        try {
            this.saveList(currentUser);
            this.getDbAccess().end();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearUnselectedItem() {
        this.getPurchaseItemsList().removeIf((Predicate)new Predicate<PurchaseItem>(){

            @Override
            public boolean test(PurchaseItem t) {
                return !t.getIsCheck() || t.getQuantity() < 0.0f || t.getSellingPrice() < 0.0;
            }
        });
    }

    private void saveList(User user) {
        this.supplierPaymentList = new SupplierPaymentDataList(this.getDbAccess());
        this.supplierPayment.setParentPurchase(this);
        this.supplierPayment.amountPaidProperty().set(this.getAmountPaid());
        this.supplierPayment.totalAmountProperty().set(this.getAmountPaid() + this.getBalance());
        this.supplierPayment.dateProperty().set((Object)this.getParentCompanyName().getCurrentDay());
        this.supplierPayment.setParentSupplier(this.getParentSupplier());
        this.supplierPayment.codeProperty().set((Object)UUID.randomUUID().toString());
        this.supplierPayment.setParentUser(user);
        this.supplierPayment.setComment("Payment for purchase " + this.getPurchaseCode() + "(" + this.supplierPayment.getAmountPaid() + " out of " + this.supplierPayment.getTotalAmount() + ")");
        this.supplierPaymentList.getOriginalList().add((Object)this.supplierPayment);
        try {
            this.supplierPaymentList.update();
        }
        catch (Exception ex) {
            Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.getPurchaseItemsList().size() > 0) {
            this.purchaseItemList.getOriginalList().addAll(this.getPurchaseItemsList());
            for (PurchaseItem purParameterValue : this.purchaseItemList.getOriginalList()) {
                purParameterValue.quantityProperty().set(purParameterValue.getParentUnit().getQuantity() * purParameterValue.quantityProperty().get());
                purParameterValue.outStandingQtyProperty().set(purParameterValue.getParentUnit().getQuantity() * purParameterValue.outStandingQtyProperty().get());
            }
            try {
                this.purchaseItemList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.stockItemList.getOriginalList().size() > 0) {
            try {
                this.stockItemList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.replenishmentList.getOriginalList().size() > 0) {
            try {
                this.replenishmentList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public PurchaseList searchPurchaseUmodified(String searString, DataAccess da) {
        PurchaseList purchaseList = new PurchaseList(da);
        PurchaseList tempPurchaseList = new PurchaseList(da);
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("purchaseCode", JDBCType.VARCHAR, "%" + searString + "%"));
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searString + "%"));
        tempParamValue.add(new ParameterValue("supplierName", JDBCType.VARCHAR, "%" + searString + "%"));
        tempParamValue.add(new ParameterValue("mainPurchase", JDBCType.VARCHAR, "%" + searString + "%"));
        tempParamValue.add(new ParameterValue("purchasingOfficer", JDBCType.VARCHAR, "%" + searString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        tempPurchaseList.select(searchCondition, true, false);
        if (tempPurchaseList.getOriginalList().size() > 0) {
            tempPurchaseList.getOriginalList().removeIf((Predicate)new Predicate<Purchase>(){

                @Override
                public boolean test(Purchase t) {
                    return t.getModified();
                }
            });
            for (Purchase ttpurchase : tempPurchaseList.getOriginalList()) {
                purchaseList.getOriginalList().add((Object)ttpurchase);
            }
        }
        return purchaseList;
    }

    private void saveListForCorrection(User currentUser) {
        this.doNotEnterAmtBinding = true;
        this.supplierPayment = new SupplierPayment(this.getDbAccess());
        this.supplierPaymentList = new SupplierPaymentDataList(this.getDbAccess());
        if (!this.newpurchase.getPurchaseCode().equals("")) {
            if (this.oldpPurchase != null) {
                for (PurchaseItem purchItm : this.oldpPurchase.getPurchaseItemsList()) {
                    this.Tempexist = false;
                    for (PurchaseItem purchaseItem : this.newpurchase.getPurchaseItemsList()) {
                        if (!purchaseItem.getParentStockItem().getItemCode().equals(purchItm.getParentStockItem().getItemCode())) continue;
                        this.Tempexist = true;
                        break;
                    }
                    if (this.Tempexist) continue;
                    PurchaseItem tempUrch = this.buildNewPurchaseItem(purchItm);
                    tempUrch.setParentPurchase(this.newpurchase);
                    this.newpurchase.getPurchaseItemsList().add((Object)tempUrch);
                }
            }
            this.purchaseItemList.getOriginalList().addAll(this.newpurchase.getPurchaseItemsList());
            for (PurchaseItem purchaseItem : this.purchaseItemList.getOriginalList()) {
                purchaseItem.quantityProperty().set(purchaseItem.getQuantity() * purchaseItem.getParentUnit().getQuantity());
                purchaseItem.setOutStandingQty(purchaseItem.getOutStandingQty() * purchaseItem.getParentUnit().getQuantity());
            }
            try {
                this.purchaseItemList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.stockItemList.getOriginalList().size() > 0) {
                try {
                    this.stockItemList.update();
                }
                catch (Exception ex) {
                    Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.replenishmentList.getOriginalList().size() > 0) {
                try {
                    this.replenishmentList.update();
                }
                catch (Exception ex) {
                    Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.issueList.getOriginalList().size() > 0) {
                try {
                    this.issueList.update();
                }
                catch (Exception ex) {
                    Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.expenseTotal > 0.0f) {
                Expenses expenses = new Expenses(this.getDbAccess());
                expenses.setAmount(this.expenseTotal);
                expenses.setParentCompany(this.newpurchase.getParentCompanyName());
                expenses.setDate(Date.valueOf(this.newpurchase.getParentCompanyName().getCurrentDay()));
                expenses.setDescription("Expense for purchase modification from purchaseCode " + this.getPurchaseCode() + " to " + this.newpurchase.getPurchaseCode());
                expenses.setUserName(this.newpurchase.getPurchasingOfficer());
                this.expensesList.getOriginalList().add((Object)expenses);
                try {
                    this.expensesList.update();
                }
                catch (Exception ex) {
                    Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.incomeTotal > 0.0f) {
                Income income = new Income(this.getDbAccess());
                income.setAmount(this.incomeTotal);
                income.setParentCompany(this.newpurchase.getParentCompanyName());
                income.setDate(Date.valueOf(this.newpurchase.getParentCompanyName().getCurrentDay()));
                income.setDescription("Income for purchase modification from purchaseCode " + this.getPurchaseCode() + "to " + this.newpurchase.getPurchaseCode());
                income.setUserName(this.newpurchase.getPurchasingOfficer());
                this.incomeList.getOriginalList().add((Object)income);
                try {
                    this.incomeList.update();
                }
                catch (Exception ex) {
                    Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.supplierPayment.setParentPurchase(this.newpurchase);
            this.supplierPayment.setAmountPaid(this.newpurchase.getAmountPaid());
            this.supplierPayment.setTotalAmount(this.newpurchase.getTotalAmount());
            this.supplierPayment.setCode(UUID.randomUUID().toString());
            this.supplierPayment.setDate(Date.valueOf(this.getParentCompanyName().getCurrentDay()));
            this.supplierPayment.setSupplierName(this.getSupplierName());
            this.supplierPayment.setParentUser(currentUser);
            this.supplierPaymentList.getOriginalList().add((Object)this.supplierPayment);
            try {
                this.supplierPaymentList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void addIncomeIssueStock(PurchaseItem oldPurchaseItem, PurchaseItem nePurchaseItem, boolean isDirectpurchase) {
        this.incomeTotal = (float)((double)this.incomeTotal + ((double)(oldPurchaseItem.getQuantity() + oldPurchaseItem.getOutStandingQty()) * oldPurchaseItem.getCostPrice() - (double)(nePurchaseItem.getQuantity() + nePurchaseItem.getOutStandingQty()) * nePurchaseItem.getCostPrice()));
        Issue issue = new Issue(this.getDbAccess());
        issue.commentProperty().set((Object)("Reduction in quantity for purchase item " + nePurchaseItem.getParentStockItem().getName() + "(" + nePurchaseItem.getParentStockItem().getItemCode() + ") with purchaseCode " + this.newpurchase.getPurchaseCode()));
        issue.setParentStockItem(nePurchaseItem.getParentStockItem());
        issue.quantityProperty().set(oldPurchaseItem.getQuantity() - nePurchaseItem.getQuantity());
        this.issueList.getOriginalList().add((Object)issue);
        nePurchaseItem.setParentPurchase(this.newpurchase);
        nePurchaseItem.getParentStockItem();
        if (isDirectpurchase) {
            nePurchaseItem.getParentStockItem().directPurchaseQtyProperty().set(0.0);
        }
        if (oldPurchaseItem.getQuantity() < nePurchaseItem.getQuantity()) {
            nePurchaseItem.getParentStockItem().quantityProperty().set(oldPurchaseItem.getParentStockItem().getQuantity() + (nePurchaseItem.getQuantity() - oldPurchaseItem.getQuantity()));
        } else if (oldPurchaseItem.getQuantity() > nePurchaseItem.getQuantity()) {
            nePurchaseItem.getParentStockItem().quantityProperty().set(oldPurchaseItem.getParentStockItem().getQuantity() - (oldPurchaseItem.getQuantity() - nePurchaseItem.getQuantity()));
        }
        if (nePurchaseItem.getParentStockItem().getCostPrice() != nePurchaseItem.getCostPrice()) {
            nePurchaseItem.getParentStockItem().costPriceProperty().set(nePurchaseItem.getCostPrice());
        }
        this.stockItemList.getOriginalList().add((Object)nePurchaseItem.getParentStockItem());
        this.newpurchase.getPurchaseItemsList().add((Object)nePurchaseItem);
    }

    private PurchaseItem buildNewPurchaseItem(PurchaseItem oldPurchaseItem) {
        PurchaseItem retPurchaseItem = new PurchaseItem(oldPurchaseItem.getDbAccess());
        oldPurchaseItem.prevDIv = true;
        retPurchaseItem.sellingPriceProperty().set(oldPurchaseItem.getSellingPrice());
        retPurchaseItem.setParentPurchase(oldPurchaseItem.getParentPurchase());
        retPurchaseItem.setParentUnit(oldPurchaseItem.getParentUnit());
        retPurchaseItem.setParentStockItem(oldPurchaseItem.getParentStockItem());
        retPurchaseItem.outStandingQtyProperty().set(oldPurchaseItem.getOutStandingQty());
        retPurchaseItem.quantityProperty().set(oldPurchaseItem.getQuantity());
        retPurchaseItem.costPriceProperty().set(oldPurchaseItem.getCostPrice());
        oldPurchaseItem.prevDIv = true;
        return retPurchaseItem;
    }

    private void saveOldNewPurchase(Purchase purchaseNew, User currentUser) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        PurchaseList tempPurchaseList = new PurchaseList(this.getDbAccess());
        purchaseNew.totalAmountProperty().set(this.getTotalAmount());
        purchaseNew.setMainPurchase(this.getPurchaseCode());
        purchaseNew.amountPaidProperty().set(this.getAmountPaid());
        purchaseNew.balanceProperty().set(this.getBalance());
        purchaseNew.commentProperty().set((Object)this.getComment());
        purchaseNew.modifiedProperty().set(false);
        purchaseNew.setParentCompanyName(this.getParentCompanyName());
        purchaseNew.dateProperty().set((Object)Date.valueOf(this.getParentCompanyName().getCurrentDay()));
        purchaseNew.setParentUser(currentUser);
        purchaseNew.setSupplierName(this.getSupplierName());
        this.setModified(true);
        tempParamValue.add(new ParameterValue("purchaseCode", JDBCType.VARCHAR, "%" + this.getPurchaseCode() + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        tempPurchaseList.select(searchCondition, true, false);
        this.oldpPurchase = (Purchase)tempPurchaseList.getOriginalList().get(0);
        this.oldpPurchase.setModified(true);
        tempPurchaseList.getOriginalList().clear();
        tempPurchaseList.getOriginalList().add((Object)purchaseNew);
        tempPurchaseList.getOriginalList().add((Object)this.oldpPurchase);
        try {
            tempPurchaseList.update();
        }
        catch (Exception ex) {
            Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addExpenseReplenishStock(PurchaseItem oldPurchaseItem, PurchaseItem nePurchaseItem, boolean isDirectpurchase) {
        this.expenseTotal = (float)((double)this.expenseTotal + ((double)(oldPurchaseItem.getQuantity() + oldPurchaseItem.getOutStandingQty()) * oldPurchaseItem.getCostPrice() - (double)(nePurchaseItem.getQuantity() + nePurchaseItem.getOutStandingQty()) * nePurchaseItem.getCostPrice()));
        this.expenseTotal = Math.abs(this.expenseTotal);
        if (oldPurchaseItem.getQuantity() < nePurchaseItem.getQuantity() || oldPurchaseItem.getParentUnit().getQuantity() < nePurchaseItem.getParentUnit().getQuantity()) {
            Replenishment replenishment = new Replenishment(this.getDbAccess());
            replenishment.setParentPurchase(this.newpurchase);
            replenishment.quantityProperty().set(nePurchaseItem.getQuantity() - oldPurchaseItem.getQuantity());
            replenishment.setParentStockItem(nePurchaseItem.getParentStockItem());
            replenishment.commentProperty().set((Object)("Replenishment for " + nePurchaseItem.getParentStockItem().getName() + " with purchase Code " + this.getPurchaseCode()));
            replenishment.balanceBfProperty().set(oldPurchaseItem.getParentStockItem().getQuantity());
            replenishment.dateProperty().set((Object)Date.valueOf(nePurchaseItem.getParentStockItem().getParentCompany().getCurrentDay()));
            this.replenishmentList.getOriginalList().add((Object)replenishment);
        }
        nePurchaseItem.setParentPurchase(this.newpurchase);
        if (isDirectpurchase) {
            nePurchaseItem.getParentStockItem().directPurchaseQtyProperty().set(0.0);
        }
        if (oldPurchaseItem.getQuantity() < nePurchaseItem.getQuantity()) {
            nePurchaseItem.getParentStockItem().quantityProperty().set(oldPurchaseItem.getParentStockItem().getQuantity() + (nePurchaseItem.getQuantity() - oldPurchaseItem.getQuantity()));
        } else if (oldPurchaseItem.getQuantity() > nePurchaseItem.getQuantity()) {
            nePurchaseItem.getParentStockItem().quantityProperty().set(oldPurchaseItem.getParentStockItem().getQuantity() - (oldPurchaseItem.getQuantity() - nePurchaseItem.getQuantity()));
        }
        if (nePurchaseItem.getParentStockItem().getCostPrice() != nePurchaseItem.getCostPrice()) {
            nePurchaseItem.getParentStockItem().costPriceProperty().set(nePurchaseItem.getCostPrice());
        }
        this.stockItemList.getOriginalList().add((Object)nePurchaseItem.getParentStockItem());
        this.newpurchase.getPurchaseItemsList().add((Object)nePurchaseItem);
    }

    public void makeCorrection(ObservableList<PurchaseItem> duplicatePurchaseItemsList, User currentUser) {
        this.purchaseItemList = new PurchaseItemList(this.getDbAccess());
        this.newpurchase = new Purchase(this.getDbAccess());
        this.stockItemList = new StockItemList(this.getDbAccess());
        this.replenishmentList = new ReplenishmentList(this.getDbAccess());
        this.issueList = new IssueDataList(this.getDbAccess());
        this.incomeList = new IncomeDataList(this.getDbAccess());
        this.expensesList = new ExpensesDataList(this.getDbAccess());
        boolean purchaseDone = false;
        this.expenseTotal = 0.0f;
        this.incomeTotal = 0.0f;
        if (this.getPurchaseItemsList().size() > 0 && duplicatePurchaseItemsList.size() > 0) {
            this.getDbAccess().start();
            block2: for (int i = 0; i < duplicatePurchaseItemsList.size(); ++i) {
                for (int j = 0; j < this.getPurchaseItemsList().size(); ++j) {
                    if (!((PurchaseItem)duplicatePurchaseItemsList.get(i)).equals(this.getPurchaseItemsList().get(j))) continue;
                    if (this.getState() == ObjectState.Changed) {
                        if (!purchaseDone) {
                            this.saveOldNewPurchase(this.newpurchase, currentUser);
                            purchaseDone = true;
                        }
                        if (!(((PurchaseItem)this.getPurchaseItemsList().get(j)).getQuantity() > 0.0f)) continue;
                        if (((PurchaseItem)this.getPurchaseItemsList().get(j)).getParentStockItem().getDirectPurchaseQty() <= (double)((PurchaseItem)this.getPurchaseItemsList().get(j)).getQuantity()) {
                            PurchaseItem newItem;
                            if (((PurchaseItem)this.getPurchaseItemsList().get(j)).getParentStockItem().getDirectPurchaseQty() > 0.0) {
                                if (((PurchaseItem)this.getPurchaseItemsList().get(j)).getQuantity() > ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getQuantity() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getOutStandingQty() > ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getOutStandingQty() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getCostPrice() > ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getCostPrice() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getParentUnit().getQuantity() > ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getParentUnit().getQuantity()) {
                                    this.addExpenseReplenishStock((PurchaseItem)duplicatePurchaseItemsList.get(i), this.buildNewPurchaseItem((PurchaseItem)this.getPurchaseItemsList().get(j)), true);
                                    continue block2;
                                }
                                if (((PurchaseItem)this.getPurchaseItemsList().get(j)).getQuantity() < ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getQuantity() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getOutStandingQty() < ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getOutStandingQty() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getCostPrice() < ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getCostPrice() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getParentUnit().getQuantity() < ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getParentUnit().getQuantity()) {
                                    this.addIncomeIssueStock((PurchaseItem)duplicatePurchaseItemsList.get(i), this.buildNewPurchaseItem((PurchaseItem)this.getPurchaseItemsList().get(j)), true);
                                    continue block2;
                                }
                                if ((((PurchaseItem)this.getPurchaseItemsList().get(j)).getSellingPrice() == ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getSellingPrice() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getQuantity() != ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getQuantity()) && ((PurchaseItem)this.getPurchaseItemsList().get(j)).getOutStandingQty() != ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getOutStandingQty() && ((PurchaseItem)this.getPurchaseItemsList().get(j)).getCostPrice() != ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getCostPrice() && ((PurchaseItem)this.getPurchaseItemsList().get(j)).getParentUnit().getQuantity() != ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getParentUnit().getQuantity()) continue;
                                newItem = this.buildNewPurchaseItem((PurchaseItem)this.getPurchaseItemsList().get(j));
                                newItem.setParentPurchase(this.newpurchase);
                                this.newpurchase.getPurchaseItemsList().add((Object)newItem);
                                continue;
                            }
                            if (((PurchaseItem)this.getPurchaseItemsList().get(j)).getQuantity() > ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getQuantity() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getOutStandingQty() > ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getOutStandingQty() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getCostPrice() > ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getCostPrice() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getParentUnit().getQuantity() > ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getParentUnit().getQuantity()) {
                                this.addExpenseReplenishStock((PurchaseItem)duplicatePurchaseItemsList.get(i), this.buildNewPurchaseItem((PurchaseItem)this.getPurchaseItemsList().get(j)), false);
                                continue block2;
                            }
                            if (((PurchaseItem)this.getPurchaseItemsList().get(j)).getQuantity() < ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getQuantity() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getOutStandingQty() < ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getOutStandingQty() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getCostPrice() < ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getCostPrice() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getParentUnit().getQuantity() < ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getParentUnit().getQuantity()) {
                                this.addIncomeIssueStock((PurchaseItem)duplicatePurchaseItemsList.get(i), this.buildNewPurchaseItem((PurchaseItem)this.getPurchaseItemsList().get(j)), false);
                                continue block2;
                            }
                            if ((((PurchaseItem)this.getPurchaseItemsList().get(j)).getSellingPrice() == ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getSellingPrice() || ((PurchaseItem)this.getPurchaseItemsList().get(j)).getQuantity() != ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getQuantity()) && ((PurchaseItem)this.getPurchaseItemsList().get(j)).getOutStandingQty() != ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getOutStandingQty() && ((PurchaseItem)this.getPurchaseItemsList().get(j)).getCostPrice() != ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getCostPrice() && ((PurchaseItem)this.getPurchaseItemsList().get(j)).getParentUnit().getQuantity() != ((PurchaseItem)duplicatePurchaseItemsList.get(i)).getParentUnit().getQuantity()) continue;
                            newItem = this.buildNewPurchaseItem((PurchaseItem)this.getPurchaseItemsList().get(j));
                            newItem.setParentPurchase(this.newpurchase);
                            this.newpurchase.getPurchaseItemsList().add((Object)newItem);
                            continue;
                        }
                        try {
                            throw new OutstandingQtyGreaterException("Quantity comming in must not less than Outsatnding Qty");
                        }
                        catch (OutstandingQtyGreaterException ex) {
                            Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
                            continue;
                        }
                    }
                    this.getDbAccess().end();
                    return;
                }
            }
            if (this.oldpPurchase != null) {
                this.oldpPurchase.getPurchaseItemsList().addAll(duplicatePurchaseItemsList);
            }
            this.saveListForCorrection(currentUser);
            this.getDbAccess().end();
        }
    }

    public static PurchaseList searchOutstanding(String searchString, DataAccess da) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        PurchaseList finalPurchaseItemList = new PurchaseList(da);
        PurchaseList tempPurchaseList = new PurchaseList(da);
        tempParamValue.add(new ParameterValue("purchaseCode", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("companyName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("supplierName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("mainPurchase", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("purchasingOfficer", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        tempPurchaseList.select(searchCondition, true, false);
        tempParamValue.clear();
        if (tempPurchaseList.getOriginalList().size() > 0) {
            tempPurchaseList.getOriginalList().removeIf((Predicate)new Predicate<Purchase>(){

                @Override
                public boolean test(Purchase t) {
                    return t.getModified();
                }
            });
            for (Purchase purchaseValue : tempPurchaseList.getOriginalList()) {
                tempParamValue.add(new ParameterValue("purchaseCode", JDBCType.VARCHAR, "%" + purchaseValue.getPurchaseCode() + "%"));
                searchCondition = new SearchCondition();
                searchCondition.setParametersvalues(tempParamValue);
                PurchaseItemList tempPurchaseItemList = new PurchaseItemList(da);
                tempPurchaseItemList.select(searchCondition, true, false);
                if (tempPurchaseItemList.getOriginalList().size() > 0) {
                    for (PurchaseItem PI : tempPurchaseItemList.getOriginalList()) {
                        if (!(PI.getOutStandingQty() > 0.0f)) continue;
                        PI.isCheckProperty().set(true);
                        purchaseValue.getPurchaseItemsList().add((Object)PI);
                    }
                }
                tempParamValue.clear();
            }
            ObservableList duplicatePurchaseItemsList = FXCollections.observableArrayList();
            block2: for (Purchase purch : tempPurchaseList.getOriginalList()) {
                for (PurchaseItem purchItem : purch.getPurchaseItemsList()) {
                    if (!(purchItem.getOutStandingQty() > 0.0f)) continue;
                    finalPurchaseItemList.getOriginalList().add((Object)purch);
                    duplicatePurchaseItemsList.add((Object)purchItem);
                    continue block2;
                }
            }
        }
        return finalPurchaseItemList;
    }

    public void clearOustandingPurchase() {
        this.getDbAccess().start();
        this.purchaseItemList = new PurchaseItemList(this.getDbAccess());
        this.stockItemList = new StockItemList(this.getDbAccess());
        IncomeDataList incomeList = new IncomeDataList(this.getDbAccess());
        ReplenishmentList replenishmentList = new ReplenishmentList(this.getDbAccess());
        try {
            for (Object purchaseItemval : this.getPurchaseItemsList()) {
                ((PurchaseItem)purchaseItemval).setQuantity(((PurchaseItem)purchaseItemval).getQuantity() * ((PurchaseItem)purchaseItemval).getParentUnit().getQuantity());
                ((PurchaseItem)purchaseItemval).setOutStandingQty(((PurchaseItem)purchaseItemval).getOutStandingQty() * ((PurchaseItem)purchaseItemval).getParentUnit().getQuantity());
                this.purchaseItemList.getOriginalList().add(purchaseItemval);
                this.stockItemList.getOriginalList().add((Object)((PurchaseItem)purchaseItemval).getParentStockItem());
                this.incomeTot = ((PurchaseItem)purchaseItemval).incomeTot;
                if (((PurchaseItem)purchaseItemval).replenishments.size() <= 0) continue;
                replenishmentList.getOriginalList().addAll(((PurchaseItem)purchaseItemval).replenishments);
            }
            this.purchaseItemList.update();
        }
        catch (Exception ex) {
            Logger.getLogger(PurchaseItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.stockItemList.update();
        }
        catch (Exception ex) {
            Logger.getLogger(PurchaseItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.incomeTot > 0.0) {
            try {
                Income income = new Income(this.getDbAccess());
                income.setAmount(this.incomeTot);
                income.setParentCompany(this.getParentCompanyName());
                income.setDate(Date.valueOf(this.getParentCompanyName().getCurrentDay()));
                income.setDescription("Income for item(s) to cash with purchaseCode " + this.getPurchaseCode());
                income.setUserName(this.getPurchasingOfficer());
                incomeList.getOriginalList().add((Object)income);
                incomeList.update();
                for (PurchaseItem purchaseItem : this.purchaseItemList.getOriginalList()) {
                    purchaseItem.incomeTot = 0.0;
                }
                this.incomeTot = 0.0;
            }
            catch (Exception ex) {
                Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            if (replenishmentList.getOriginalList().size() > 0) {
                replenishmentList.update();
                for (PurchaseItem purchaseItem : this.purchaseItemList.getOriginalList()) {
                    purchaseItem.replenishments.clear();
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PurchaseItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.getDbAccess().end();
    }

    public static PurchaseList search(String qry, ParameterValue[] param, DataAccess dt) {
        PurchaseList purchaseList = new PurchaseList(dt);
        purchaseList.selectAll(qry, param);
        return purchaseList;
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO Purchase (balance,companyName,totalAmount,supplierName,purchaseCode,purchasingOfficer,\"date\",mainPurchase,comment,modified) VALUES(?,?,?,?,?,?,?,?,?,?)";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("balance", JDBCType.DOUBLE, this.balance.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("totalAmount", JDBCType.DOUBLE, this.totalAmount.get()), new ParameterValue("supplierName", JDBCType.VARCHAR, this.supplierName), new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode.get()), new ParameterValue("purchasingOfficer", JDBCType.VARCHAR, this.purchasingOfficer.get()), new ParameterValue("date", JDBCType.DATE, this.newDate.get()), new ParameterValue("mainPurchase", JDBCType.VARCHAR, this.mainPurchase.get()), new ParameterValue("comment", JDBCType.VARCHAR, this.comment.get()), new ParameterValue("modified", JDBCType.CHAR, this.modified.get())});
            this.vClone = this.Clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isCloned = false;
            throw ex;
        }
    }

    @Override
    public void update() throws ConsequentialConcurrencyException, Exception {
        try {
            String query = "UPDATE Purchase set balance=?,companyName=?,totalAmount=?,supplierName=?,purchaseCode=?,purchasingOfficer=?,\"date\"=?,mainPurchase=?,comment=?,modified=? where purchaseCode=?";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("balance", JDBCType.DOUBLE, this.balance.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("totalAmount", JDBCType.DOUBLE, this.totalAmount.get()), new ParameterValue("supplierName", JDBCType.VARCHAR, this.supplierName), new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode.get()), new ParameterValue("purchasingOfficer", JDBCType.VARCHAR, this.purchasingOfficer.get()), new ParameterValue("date", JDBCType.DATE, this.newDate.get()), new ParameterValue("mainPurchase", JDBCType.VARCHAR, this.mainPurchase.get()), new ParameterValue("comment", JDBCType.VARCHAR, this.comment.get()), new ParameterValue("modified", JDBCType.CHAR, this.modified.get()), new ParameterValue("clonePurchaseCode", JDBCType.VARCHAR, this.vClone.purchaseCode.get())});
            this.vClone = this.Clone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isCloned = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() throws Exception {
        String query = "Delete FROM Purchase where purchaseCode=?";
        this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode)});
    }

    @Override
    public void beforeInsert() {
        this.parentCompany.setLastPurchaseCode(this.parentCompany.getLastPurchaseCode() + 1);
        this.purchaseCode.set((Object)(String.valueOf(this.parentCompany.getCurrentDay()) + "/" + String.valueOf(this.parentCompany.getLastPurchaseCode())));
        try {
            this.parentCompany.update();
        }
        catch (Exception ex) {
            Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ObservableList<PurchaseItem> getpurchaseItems(ObservableList<StockItem> items) {
        ObservableList purchaseItems = FXCollections.observableArrayList();
        for (StockItem stockItem : items) {
            purchaseItems.add((Object)new PurchaseItem(stockItem, this.getDbAccess(), this));
        }
        return purchaseItems;
    }

    public void getpurchaseItems() {
        this.purchaseItems.clear();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("purchaseCode", JDBCType.VARCHAR, "%" + this.getPurchaseCode() + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        PurchaseItemList tempPurchaseItemList = new PurchaseItemList(this.getDbAccess());
        tempPurchaseItemList.select(searchCondition, true, false);
        if (tempPurchaseItemList.getOriginalList().size() > 0) {
            for (PurchaseItem pi : tempPurchaseItemList.getOriginalList()) {
                pi.setParentPurchase(this);
                pi.getParentStockItem().setParentCompany(this.getParentCompanyName());
                pi.isFromDb = true;
                pi.setState(ObjectState.Unchanged);
                this.purchaseItems.add((Object)pi);
            }
        }
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        sb.setTableName("Purchase");
        String[] parameter = new String[]{"balance", "companyName", "totalAmount", "supplierName", "purchaseCode", "purchasingOfficer", "\"date\"", "mainPurchase"};
        sb.setParameters(parameter);
        return sb;
    }

    public String toString() {
        return this.getPurchaseCode();
    }

    @Override
    public void initializeListener() {
        this.comment.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Purchase.this.setCommment(newValue);
            }
        });
        this.amountPaid.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Purchase.this.setAmountPaid((Double)newValue);
            }
        });
        this.newDate.addListener((ChangeListener)new ChangeListener<Date>(){

            public void changed(ObservableValue<? extends Date> observable, Date oldValue, Date newValue) {
                Purchase.this.setNewDate(newValue);
            }
        });
        this.totalAmount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Purchase.this.setTotalAmount((Double)newValue);
            }
        });
        this.balance.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Purchase.this.setBalance((Double)newValue);
            }
        });
        this.mainPurchase.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Purchase.this.setMainPurchase(newValue);
            }
        });
        this.purchaseCode.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Purchase.this.setPurchaseCode(newValue);
            }
        });
        this.purchasingOfficer.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Purchase.this.setPurchasingOfficer(newValue);
            }
        });
    }
}

