/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Purchase;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import java.sql.JDBCType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class Issue
extends DbEntity {
    public Issue vClone;
    private boolean isCloned;
    private DataAccess dataAccess = this.getDbAccess();
    private StockItem parentStockItem;
    private FloatProperty balance = new SimpleFloatProperty();
    private FloatProperty quantity = new SimpleFloatProperty();
    private IntegerProperty transactionCount = new SimpleIntegerProperty();
    private Sale parentSale;
    private StringProperty comment = new SimpleStringProperty();
    private String stockItemBarcode;
    private IntegerProperty saleInvoiceNumber = new SimpleIntegerProperty();

    public Issue(DataAccess dbAccess) {
        super(dbAccess);
    }

    public Issue(float balance, float quantity, int transactionCount, String comment, String stockItemBarcode, int saleInvoiceNumber, DataAccess dbAccess) {
        super(dbAccess);
        this.isConstructor = true;
        this.balanceProperty().set(balance);
        this.quantityProperty().set(quantity);
        this.transactionCountProperty().set(transactionCount);
        this.commentProperty().set((Object)comment);
        this.stockItemBarcode = stockItemBarcode;
        this.saleInvoiceNumberProperty().set(saleInvoiceNumber);
        this.setMustClone(true);
        this.setState(ObjectState.Unchanged);
        this.isConstructor = false;
        this.initializeListener();
    }

    public void setParentStockItem(StockItem stockItem) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.parentStockItem = stockItem;
        this.stockItemBarcode = stockItem == null ? "" : stockItem.getItemCode();
        this.changeObjectState();
    }

    public void loadParentStockItem() {
        StockItemList stockItemList = new StockItemList(this.getDbAccess());
        String query = "Select * From STOCKITEM Where barCode =?";
        stockItemList.selectAll(query, new ParameterValue[]{new ParameterValue("barCode", JDBCType.VARCHAR, this.stockItemBarcode)});
        if (stockItemList.getOriginalList().size() > 0) {
            this.parentStockItem = (StockItem)stockItemList.getOriginalList().get(0);
        }
    }

    public StockItem getParentStockItem() {
        if (this.parentStockItem == null) {
            this.loadParentStockItem();
        }
        return this.parentStockItem;
    }

    public FloatProperty balanceProperty() {
        return this.balance;
    }

    public float getBalance() {
        return this.balanceProperty().get();
    }

    public void setBalance(float balance) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.balanceProperty().set(balance);
    }

    public FloatProperty quantityProperty() {
        return this.quantity;
    }

    public float getQuantity() {
        return this.quantityProperty().get();
    }

    public void setQuantity(float quantity) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.quantityProperty().set(quantity);
    }

    public IntegerProperty transactionCountProperty() {
        return this.transactionCount;
    }

    public int getTransactionCount() {
        return this.transactionCountProperty().get();
    }

    public void setTransactionCount(int transactionCount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.transactionCountProperty().set(transactionCount);
    }

    public void setParentSale(Sale sale) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.saleInvoiceNumberProperty().set(sale == null ? 0 : sale.getInvoiceNumber());
    }

    public void loadParentSale() {
        SaleList saleList = new SaleList();
        String query = "Select * From Sale Where invoiceNumber =?";
        saleList.selectAll(query, new ParameterValue[]{new ParameterValue("invoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumberProperty().get())});
        if (saleList.getOriginalList().size() > 0) {
            this.parentSale = (Sale)saleList.getOriginalList().get(0);
        }
    }

    public Sale getParentSale() {
        if (this.parentSale == null) {
            this.loadParentSale();
        }
        return this.parentSale;
    }

    public StringProperty commentProperty() {
        return this.comment;
    }

    public String getComment() {
        return (String)this.commentProperty().get();
    }

    public void setComment(String comment) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.commentProperty().set((Object)comment);
    }

    public IntegerProperty saleInvoiceNumberProperty() {
        return this.saleInvoiceNumber;
    }

    public int getSaleInvoiceNumber() {
        return this.saleInvoiceNumberProperty().get();
    }

    public void setSaleInvoiceNumber(int saleInvoiceNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.saleInvoiceNumberProperty().set(saleInvoiceNumber);
    }

    public Issue clone() {
        Issue issue = new Issue(this.dataAccess);
        issue.setMustClone(false);
        issue.balance.set(this.balance.get());
        issue.comment.set((Object)((String)this.comment.get()));
        issue.quantity.set(this.quantity.get());
        issue.saleInvoiceNumber.set(this.saleInvoiceNumber.get());
        issue.stockItemBarcode = this.stockItemBarcode;
        issue.transactionCount.set(this.transactionCount.get());
        this.setMustClone(true);
        this.isCloned = true;
        return issue;
    }

    protected void rollBack() {
        this.balance.set(this.vClone.balance.get());
        this.comment.set((Object)((String)this.vClone.comment.get()));
        this.quantity.set(this.vClone.quantity.get());
        this.saleInvoiceNumber.set(this.vClone.saleInvoiceNumber.get());
        this.stockItemBarcode = this.vClone.stockItemBarcode;
        this.transactionCount.set(this.vClone.transactionCount.get());
        this.setMustClone(true);
    }

    @Override
    public void insert() {
        try {
            String query = "INSERT INTO ISSUE( balance, quantity, transactionCount, comment,stockItemBarcode, saleInvoiceNumber) Values(?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("balance", JDBCType.FLOAT, Float.valueOf(this.balance.get())), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("transactionCount", JDBCType.INTEGER, this.transactionCount.get()), new ParameterValue("comment", JDBCType.VARCHAR, this.comment.get()), new ParameterValue("stockItemBarcode", JDBCType.VARCHAR, this.stockItemBarcode), new ParameterValue("saleInvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumber.get())};
            this.dataAccess.performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            try {
                throw e;
            }
            catch (Exception ex) {
                Logger.getLogger(Issue.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void update() throws ConsequentialConcurrencyException, Exception {
        try {
            String query = "UPDATE ISSUE SET   balance=?, quantity=?, transactionCount=?, comment=?,stockItemBarcode=?, saleInvoiceNumber=? WHERE transactionCount=? ";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("balance", JDBCType.FLOAT, Float.valueOf(this.balance.get())), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("transactionCount", JDBCType.INTEGER, this.transactionCount.get()), new ParameterValue("comment", JDBCType.VARCHAR, this.comment.get()), new ParameterValue("stockItemBarcode", JDBCType.VARCHAR, this.stockItemBarcode), new ParameterValue("saleInvoiceNumber", JDBCType.INTEGER, this.saleInvoiceNumber.get()), new ParameterValue("cloneTransactionCount", JDBCType.INTEGER, this.vClone.transactionCount.get())};
            this.dataAccess.performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        try {
            String query = "DELETE FROM ISSUE WHERE transactionCount=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("cloneTransactionCount", JDBCType.INTEGER, this.transactionCount.get())};
            this.dataAccess.performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Issue.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable searchable = new Searchable();
        searchable.setTableName("Issue");
        String[] parameters = new String[]{"balance", "quantity", "transactionCount", "comment", "stockItemBarcode", "saleInvoiceNumber"};
        searchable.setParameters(parameters);
        return searchable;
    }

    @Override
    public void beforeInsert() {
        try {
            this.parentStockItem.getParentCompany().setLastTransactionCount(this.parentStockItem.getParentCompany().getLastTransactionCount() + 1);
            this.transactionCountProperty().set(this.parentStockItem.getParentCompany().getLastTransactionCount());
            this.parentStockItem.getParentCompany().update();
        }
        catch (Exception ex) {
            Logger.getLogger(Purchase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void initializeListener() {
        this.saleInvoiceNumber.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Issue.this.setSaleInvoiceNumber((Integer)newValue);
            }
        });
        this.comment.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Issue.this.setComment(newValue);
            }
        });
        this.transactionCount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Issue.this.setTransactionCount((Integer)newValue);
            }
        });
        this.quantity.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Issue.this.setQuantity(((Float)newValue).floatValue());
            }
        });
        this.balance.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Issue.this.setBalance(((Float)newValue).floatValue());
            }
        });
    }
}

