/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import java.sql.JDBCType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Account
extends DbEntity {
    private StringProperty name = new SimpleStringProperty();
    private StringProperty accNumber = new SimpleStringProperty();
    public Account vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private int sn;

    public String getAccNumber() {
        return (String)this.accNumber.get();
    }

    public void setAccNumber(String accNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.accNumber.set((Object)accNumber);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.name.set((Object)name);
    }

    public Account(DataAccess dt) {
        super(dt);
    }

    public Account(String accNumber, String name, DataAccess dbAccess) {
        super(dbAccess);
        this.accNumber.set((Object)accNumber);
        this.name.set((Object)name);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public Account clone() {
        Account employee = new Account(this.dt);
        this.setMustClone(false);
        employee.accNumber.set((Object)((String)this.accNumber.get()));
        employee.name.set((Object)((String)this.name.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return employee;
    }

    protected void rollBack() {
        this.accNumber.set((Object)((String)this.vClone.accNumber.get()));
        this.name.set((Object)((String)this.vClone.name.get()));
        this.setMustClone(true);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO Account (accNumber,name) Values(?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("accNumber", JDBCType.VARCHAR, this.accNumber.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get())};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE Account SET accNumber=?, name=? WHERE accNumber=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("accNumber", JDBCType.VARCHAR, this.accNumber.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("accNumber", JDBCType.VARCHAR, this.vClone.accNumber.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM Account WHERE accNumber=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("accNumber", JDBCType.VARCHAR, this.accNumber.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
    }

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public String toString() {
        return String.valueOf(this.name.get());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Account store = (Account)object;
        return ((String)this.accNumber.get()).equals(store.accNumber.get()) && ((String)this.name.get()).equals(store.name.get());
    }
}

