/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Status;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.UserDataList;
import com.xputertechnologies.santa.ui.ConfigurationPageContainerPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.RoleContainer;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.IDataSet;

public class User
extends UIParent {
    private static Connection con;
    private static DatabaseConnection dc;
    private static IDataSet dataSet;
    private static DataAccess da;
    @FXML
    private PasswordField cpasswordtxt;
    @FXML
    private Button btnAddnew;
    @FXML
    private Label cpL;
    @FXML
    private Label usernameLab;
    @FXML
    private Button doneButton;
    @FXML
    private TextField firstnametxt;
    @FXML
    private TextField lastnametxt;
    @FXML
    private PasswordField passwordtxt;
    @FXML
    private RadioButton rbActive;
    @FXML
    private RadioButton rbDisable;
    @FXML
    private RadioButton rbGone;
    @FXML
    HBox stastusContainer;
    @FXML
    private TextField usernametxt;
    RoleContainer roleContainer;
    ConfigurationPageContainerPane pareContainerPane;
    com.xputertechnologies.santa.User user = null;
    ToggleGroup radioGroup = new ToggleGroup();
    boolean isEdit;
    String errorMsg;

    public User(RoleContainer roleContainer, final com.xputertechnologies.santa.User user) {
        super("User.fxml", roleContainer.rolePane.santa);
        this.roleContainer = roleContainer;
        this.user = user;
        this.firstnametxt.textProperty().bindBidirectional((Property)this.user.firstNameProperty());
        this.lastnametxt.textProperty().bindBidirectional((Property)this.user.lastNameProperty());
        this.usernametxt.textProperty().bindBidirectional((Property)this.user.userNameProperty());
        this.passwordtxt.textProperty().bindBidirectional((Property)this.user.passwordProperty());
        if (this.passwordtxt.getText() != null && !this.passwordtxt.getText().isEmpty()) {
            this.cpasswordtxt.setText(this.passwordtxt.getText());
            this.isEdit = true;
            if (roleContainer.rolePane.cpcp == null && roleContainer.rolePane.currentUser.getRoleDescription().equals(UserType.SalesPerson.name())) {
                this.stastusContainer.setVisible(false);
                this.btnAddnew.setVisible(false);
            }
            this.usernametxt.setEditable(false);
        }
        this.rbActive.setToggleGroup(this.radioGroup);
        this.rbDisable.setToggleGroup(this.radioGroup);
        this.rbGone.setToggleGroup(this.radioGroup);
        this.rbActive.setUserData((Object)this.rbActive.getText());
        this.rbDisable.setUserData((Object)this.rbDisable.getText());
        this.rbGone.setUserData((Object)this.rbGone.getText());
        if (this.user.getStatus() != null && !this.user.getStatus().trim().isEmpty()) {
            this.radioGroup.setUserData((Object)this.user.getStatus());
        } else if (this.user.getStatus() == null || this.user.getStatus().trim().isEmpty()) {
            this.user.setStatus("Active");
        }
        if (!this.user.getRoleDescription().isEmpty()) {
            this.radioGroup.setUserData((Object)this.user.getRoleDescription());
        }
        this.radioGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (User.this.radioGroup.getSelectedToggle() != null) {
                    User.this.radioGroup.getSelectedToggle().getUserData().toString();
                    user.statusProperty().setValue(User.this.radioGroup.getSelectedToggle().getUserData().toString());
                }
            }
        });
        this.doneButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    User.this.addNewUser(false);
                }
                catch (Exception ex) {
                    Logger.getLogger(User.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnAddnew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    User.this.addNewUser(true);
                }
                catch (Exception ex) {
                    Logger.getLogger(User.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void addNewUser(boolean yes) throws CloneNotSupportedException {
        block10: {
            if (this.validateControl()) {
                try {
                    UserDataList users = new UserDataList(this.roleContainer.rolePane.da);
                    users.getOriginalList().add((Object)this.user);
                    users.update();
                    com.xputertechnologies.santa.User userU = this.user.clone();
                    userU.setParentCompany(this.user.getParentCompany());
                    userU.setRoleDescription(this.roleContainer.titledPane.getText());
                    userU.setState(ObjectState.Unchanged);
                    this.roleContainer.addUser(userU);
                    if (this.roleContainer.rolePane.parentContainerPane != null) {
                        this.roleContainer.rolePane.parentContainerPane.btnNext.setVisible(true);
                    }
                    if (yes) {
                        this.createNewUser();
                        break block10;
                    }
                    this.roleContainer.dialog.close();
                    this.roleContainer.dialog = null;
                    this.roleContainer.setExpanded(true);
                }
                catch (Exception ex) {
                    if (this.roleContainer.rolePane.mainPage != null) {
                        this.roleContainer.rolePane.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this.roleContainer.rolePane);
                    } else {
                        this.roleContainer.rolePane.cpcp.Notification(NotificationType.Error, ex.getMessage(), this.roleContainer.rolePane);
                    }
                    Logger.getLogger(User.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (this.roleContainer.rolePane.mainPage != null) {
                this.roleContainer.rolePane.mainPage.showNotification(NotificationType.Error, this.errorMsg, this.roleContainer.rolePane);
            } else {
                this.roleContainer.rolePane.cpcp.Notification(NotificationType.Error, this.errorMsg, this.roleContainer.rolePane);
            }
        }
    }

    public void createNewUser() {
        this.isEdit = false;
        this.usernametxt.setEditable(true);
        this.user = new com.xputertechnologies.santa.User(this.roleContainer.rolePane.da);
        this.firstnametxt.textProperty().unbind();
        this.firstnametxt.textProperty().bindBidirectional((Property)this.user.firstNameProperty());
        this.lastnametxt.textProperty().unbind();
        this.lastnametxt.textProperty().bindBidirectional((Property)this.user.lastNameProperty());
        this.usernametxt.textProperty().unbind();
        this.usernametxt.textProperty().bindBidirectional((Property)this.user.userNameProperty());
        this.passwordtxt.textProperty().unbind();
        this.passwordtxt.textProperty().bindBidirectional((Property)this.user.passwordProperty());
        this.cpasswordtxt.setText("");
        this.rbActive.setSelected(true);
        this.user.setStatus("Active");
        this.user.setRoleDescription(this.roleContainer.titledPane.getText());
        this.user.setParentCompany(this.roleContainer.rolePane.cpcp != null ? this.roleContainer.rolePane.cpcp.company : this.roleContainer.rolePane.currentUser.getParentCompany());
    }

    private void cancel() {
    }

    private ObservableList<String> UserTypes() {
        ObservableList tList = FXCollections.observableArrayList();
        for (UserType object : UserType.values()) {
            tList.add((Object)((Object)((Object)object)).toString());
        }
        return tList;
    }

    private ObservableList<String> Statuses() {
        ObservableList tList = FXCollections.observableArrayList();
        for (Status object : Status.values()) {
            tList.add((Object)((Object)((Object)object)).toString());
        }
        return tList;
    }

    private void checkControlToValidate() {
        this.errorMsg = "";
        if (this.usernametxt.getText() == null || this.usernametxt.getText().trim().isEmpty()) {
            this.errorMsg = this.errorMsg + "Username must not be empty\n";
        }
        if (this.passwordtxt.getText() == null || this.passwordtxt.getText().trim().isEmpty()) {
            this.errorMsg = this.errorMsg + "Password must not be empty\n";
        }
        if (this.cpasswordtxt.getText() == null || this.usernametxt.getText() == null || !this.cpasswordtxt.getText().equals(this.passwordtxt.getText())) {
            this.errorMsg = this.errorMsg + "confirm Password must not be empty and must be the same as password ";
        }
    }

    @Override
    boolean validateControl() {
        this.checkControlToValidate();
        if (this.errorMsg.trim().isEmpty()) {
            return true;
        }
        if (this.roleContainer.rolePane.cpcp != null) {
            this.roleContainer.rolePane.cpcp.Notification(NotificationType.Error, this.errorMsg, this);
        } else {
            this.roleContainer.rolePane.mainPage.showNotification(NotificationType.Error, this.errorMsg, this);
        }
        return false;
    }

    @Override
    void completeControl() {
        try {
            this.addNewUser(false);
        }
        catch (Exception ex) {
            Logger.getLogger(User.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

