/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestitemSerial;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.Duration;

public class TransferReleaseScanSerial
extends UIParent {
    @FXML
    private Label errorLbl;
    @FXML
    private HBox hbox;
    @FXML
    private TextField TFscan;
    @FXML
    private JFXButton btnAdd;
    @FXML
    private Label lblName;
    @FXML
    private ListView<RequestitemSerial> listview;
    @FXML
    private JFXButton btnClose;
    Timeline timeline;

    public TransferReleaseScanSerial(Santa app, NewRequestPane newRequestPane, final RequestItem requestItem) {
        super("TransferReleaseScanSerial.fxml", app);
        this.title = "Scan Serial";
        this.btnAdd.setVisible(false);
        this.errorLbl.setVisible(false);
        this.lblName.setText(requestItem.getItemName());
        this.TFscan.setOnAction(v -> {
            if (requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText().trim())).findAny().orElse(null) == null) {
                RequestitemSerial serial = new RequestitemSerial(this.da);
                serial.setItemCode(requestItem.getItemCode());
                serial.setRequestItemCode(requestItem.getCode());
                serial.setRequestCode(requestItem.getRequestCode());
                serial.setSerial(this.TFscan.getText().trim());
                requestItem.getSerials().add((Object)serial);
                requestItem.setQuantity(requestItem.getSerials().size());
            } else {
                this.showNotif(false, "Item with the same serial " + this.TFscan.getText() + " already exist");
                this.listview.getSelectionModel().select((Object)requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText().trim())).findAny().get());
            }
            this.TFscan.clear();
            this.TFscan.requestFocus();
        });
        this.btnClose.setOnAction(v -> newRequestPane.dialog.close());
        this.btnAdd.setOnAction(val -> {
            if (requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText().trim())).findAny().orElse(null) == null) {
                RequestitemSerial serial = new RequestitemSerial(this.da);
                serial.setItemCode(requestItem.getItemCode());
                serial.setRequestItemCode(requestItem.getCode());
                serial.setRequestCode(requestItem.getRequestCode());
                serial.setSerial(this.TFscan.getText().trim());
                requestItem.getSerials().add((Object)serial);
                requestItem.setQuantity(requestItem.getSerials().size());
            } else {
                this.showNotif(false, "Item with the same serial " + this.TFscan.getText() + " already exist");
                this.listview.getSelectionModel().select((Object)requestItem.getSerials().stream().filter(p -> p.getSerial().equals(this.TFscan.getText().trim())).findAny().get());
            }
            this.TFscan.clear();
            this.TFscan.requestFocus();
        });
        this.listview.setCellFactory((Callback)new Callback<ListView<RequestitemSerial>, ListCell<RequestitemSerial>>(){

            public ListCell<RequestitemSerial> call(ListView<RequestitemSerial> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<RequestitemSerial> cell = new ListCell<RequestitemSerial>(){

                    public void updateItem(final RequestitemSerial requstSerial, boolean empty) {
                        super.updateItem((Object)requstSerial, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            GridPane grid = new GridPane();
                            grid.setHgap(10.0);
                            grid.setVgap(4.0);
                            grid.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            Label lblSerial = new Label();
                            lblSerial.setText(requstSerial.getSerial());
                            String cachelistname = "-fx-font-weight: bold;";
                            lblSerial.setStyle(cachelistname);
                            grid.add((Node)lblSerial, 0, 0);
                            ImageView btnRemove = new ImageView();
                            btnRemove.setFitHeight(20.0);
                            btnRemove.setFitWidth(20.0);
                            btnRemove.setImage(new Image("/com/xputertechnologies/santa/ui/Images/decline.png"));
                            grid.add((Node)btnRemove, 1, 0);
                            btnRemove.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    event.consume();
                                    requestItem.getSerials().remove((Object)requstSerial);
                                    requestItem.setQuantity(requestItem.getQuantity() - 1);
                                }
                            });
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)grid);
                        }
                    }
                };
                return cell;
            }
        });
        this.listview.setItems(requestItem.getSerials());
        this.TFscan.requestFocus();
    }

    @Override
    public void propertyChange(DbEntity data) {
    }

    void showNotif(boolean iswarning, String msg) {
        int notificationTimeInSecond = 10;
        if (iswarning) {
            this.btnAdd.setVisible(true);
        }
        this.errorLbl.setText(msg);
        this.errorLbl.setVisible(true);
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)notificationTimeInSecond), ae -> {
            this.btnAdd.setVisible(false);
            this.errorLbl.setVisible(false);
        }, new KeyValue[0])});
        this.timeline.play();
    }
}

