/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestItemBin;
import com.xputertechnologies.santa.ui.TransferReleaseItemCard;
import com.xputertechnologies.santa.ui.TransferReleasePlanItemCard;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.controlsfx.glyphfont.FontAwesome;

public class TransferReleasePlanCard
extends UIParent {
    @FXML
    private Label lblCode;
    @FXML
    private Label lblItemName;
    @FXML
    private VBox vb;
    @FXML
    private Label lblTotalQty;
    @FXML
    private Label lblQtyrelease;
    @FXML
    private JFXButton btnDone;
    @FXML
    private JFXButton btnCancel;
    ObservableList<RequestItemBin> requestItemBinsKeep = FXCollections.observableArrayList();
    int releaseQty = 0;

    public TransferReleasePlanCard(TransferReleaseItemCard parent, RequestItem requestItem, boolean isCompleted) {
        super("TransferReleasePlanCard.fxml", null);
        this.requestItemBinsKeep.clear();
        this.keepOriginal(requestItem);
        this.lblCode.setText(requestItem.getItemCode());
        this.lblItemName.setText(requestItem.getItemName());
        this.lblQtyrelease.setText(String.valueOf(requestItem.getApprovedQty()));
        this.lblTotalQty.textProperty().bind((ObservableValue)requestItem.totalQtyBinding);
        this.vb.setDisable(isCompleted);
        requestItem.getRequestItemBins().forEach(val -> {
            val.parenRequestItem = requestItem;
            this.vb.getChildren().add((Object)new TransferReleasePlanItemCard((RequestItemBin)val));
        });
        this.btnDone.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.WHITE).size(13.0));
        this.btnCancel.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES).color(Color.WHITE).size(13.0));
        this.btnDone.setOnAction(v -> parent.dialog.close());
        this.btnCancel.setOnAction(v -> {
            if (!isCompleted) {
                requestItem.getRequestItemBins().clear();
                requestItem.getRequestItemBins().addAll(this.requestItemBinsKeep);
                if (!isCompleted) {
                    requestItem.setReleasedQuantity(this.releaseQty);
                }
            }
            parent.dialog.close();
        });
    }

    void keepOriginal(RequestItem requestItem) {
        requestItem.getRequestItemBins().forEach(x -> {
            RequestItemBin bin = new RequestItemBin(x.getCode(), x.getItemCode(), x.getRequestCode(), x.getQuantity(), x.getAvailableQty(), x.getDbAccess());
            this.requestItemBinsKeep.add((Object)bin);
        });
        this.releaseQty = requestItem.getReleasedQuantity();
    }
}

