/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.ui.UIParent;
import java.text.SimpleDateFormat;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class TransferReleaseCard
extends UIParent {
    VBox root;
    @FXML
    private Text lblTransferCode;
    @FXML
    private Text lblDate;
    @FXML
    private Text lblOriginatedStore;
    @FXML
    private Text lblTargetStore;
    @FXML
    private Text lblOriginatedUser;
    @FXML
    private Text lblStatus;
    @FXML
    private JFXButton btnPrint;
    @FXML
    private JFXButton btnReload;

    public TransferReleaseCard(Request request) {
        super("TransferReleaseCard.fxml", null);
        this.lblTransferCode.setText(request.getCode());
        this.lblOriginatedStore.setText(request.getFromStoreName());
        this.lblTargetStore.setText((String)request.fromStoreNameProperty().get());
        this.lblOriginatedUser.setText((String)request.originatedUserProperty().get());
        this.lblStatus.textProperty().bind((ObservableValue)request.statusProperty());
        this.lblDate.setText(new SimpleDateFormat("dd-MM-yyyy hh:mm").format(request.getRequestDate()));
        this.btnPrint.setOnAction(val -> {});
        this.btnReload.setOnAction(val -> {});
    }

    public TransferReleaseCard() {
        super("TransferReleaseCard.fxml", null);
        this.btnPrint.setOnAction(val -> {});
        this.btnReload.setOnAction(val -> {});
    }

    public void setData(Request request) {
        this.lblTransferCode.setText(request.getCode());
        this.lblOriginatedStore.setText(request.getFromStoreName());
        this.lblTargetStore.setText((String)request.fromStoreNameProperty().get());
        this.lblOriginatedUser.setText((String)request.originatedUserProperty().get());
        this.lblStatus.textProperty().bind((ObservableValue)request.statusProperty());
        this.lblDate.setText(new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").format(request.getRequestDate()));
    }
}

