/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.RequestTypeEnum;
import com.xputertechnologies.santa.RequestitemSerial;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.RequestDataList;
import com.xputertechnologies.santa.list.RequestItemDataList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.NewRequestPaneB2B;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.TransferCardB2B;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class TransferPaneB2B
extends UIParent {
    @FXML
    private TextField searchBox;
    @FXML
    JFXComboBox cmbReqType;
    @FXML
    private ImageView imgPending;
    @FXML
    private ImageView imgClosed;
    @FXML
    private ImageView imgDecline;
    @FXML
    private ImageView imgCancelled;
    @FXML
    private ImageView imgRelease;
    @FXML
    private ImageView imgAccepted;
    @FXML
    private Label lblPending;
    @FXML
    private Label lblClose;
    @FXML
    private Label lblDecline;
    @FXML
    private Label lblGranted;
    @FXML
    private Label lblRelease;
    @FXML
    private Label lblAccepted;
    @FXML
    JFXButton btnNew;
    @FXML
    JFXButton btnReload;
    @FXML
    JFXButton btnSearch;
    @FXML
    private JFXDatePicker from;
    @FXML
    private JFXDatePicker to;
    @FXML
    private FlowPane fp;
    @FXML
    StackPane stackPane;
    Button accptRelease;
    VBox progressContainer;
    RequestDataList requestItemDataList;
    RequestDataList requestDataList;
    StoreDataList storeDataList;
    Request temp;
    Dialog dialog;
    String searchRequest;

    public TransferPaneB2B(Santa app) {
        super("TransferPaneB2B.fxml", app);
        this.requestItemDataList = new RequestDataList(this.da);
        this.requestDataList = new RequestDataList(this.da);
        this.temp = null;
        this.dialog = null;
        this.searchRequest = "";
        this.santa = app;
        this.title = "Transfer B2B";
        this.from.setValue((Object)LocalDate.now().minusDays(5L));
        this.to.setValue((Object)LocalDate.now());
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.btnReload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.imgPending.setImage(new Image("/com/xputertechnologies/santa/ui/Images/pending.png"));
        this.imgClosed.setImage(new Image("/com/xputertechnologies/santa/ui/Images/complete.png"));
        this.imgDecline.setImage(new Image("/com/xputertechnologies/santa/ui/Images/decline.png"));
        this.imgCancelled.setImage(new Image("/com/xputertechnologies/santa/ui/Images/approve.png"));
        this.imgRelease.setImage(new Image("/com/xputertechnologies/santa/ui/Images/release.png"));
        this.imgAccepted.setImage(new Image("/com/xputertechnologies/santa/ui/Images/accept.png"));
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll("Select *from store", this.da.getEmptyParameterValues());
        ObservableList options = FXCollections.observableArrayList();
        for (int i = 0; i < RequestType.values().length; ++i) {
            options.add((Object)RequestType.values()[i].name());
        }
        double width = Math.abs(Santa.SceneWidth);
        this.fp.setPrefWrapLength(Santa.SceneWidth.doubleValue());
        this.cmbReqType.setItems(options);
        this.cmbReqType.getSelectionModel().select(0);
        this.cmbReqType.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue != null) {
                    if (newValue.toString().equals("All")) {
                        TransferPaneB2B.this.searchBox.clear();
                        TransferPaneB2B.this.loadRequests();
                    } else if (TransferPaneB2B.this.requestItemDataList.getOriginalList().size() > 0) {
                        ObservableList requestList = FXCollections.observableArrayList();
                        if (newValue.toString().equals(RequestType.Inbound.name())) {
                            requestList.addAll((Collection)TransferPaneB2B.this.requestItemDataList.getOriginalList().stream().filter(p -> p.getRequestType().equals(RequestType.Inbound.name())).collect(Collectors.toList()));
                        } else {
                            requestList.addAll((Collection)TransferPaneB2B.this.requestItemDataList.getOriginalList().stream().filter(p -> p.getRequestType().equals(RequestType.Outbound.name())).collect(Collectors.toList()));
                        }
                        TransferPaneB2B.this.setRequestControl((ObservableList<Request>)requestList);
                    }
                }
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TransferPaneB2B.this.NewRequest();
            }
        });
        this.loadRequests();
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.searchBox, t -> {
            List<Request> result = this.searchResult(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<Request>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<Request> event) {
                TransferPaneB2B.this.populateResult((Request)event.getCompletion());
            }
        });
        autoCompletionBinding.setPrefWidth(200.0);
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TransferPaneB2B.this.reloadUnsync();
            }
        });
        this.btnSearch.setOnAction(c -> {
            if (!this.searchBox.getText().isEmpty()) {
                this.search();
            } else {
                this.requestDataList.getOriginalList().clear();
                this.loadRequests();
            }
        });
        if (!UserType.valueOf(this.mainPage.currentUser.getRoleDescription()).equals((Object)UserType.Administrator)) {
            // empty if block
        }
    }

    boolean isAcceptedQtyGreaterThanReleaseQty(Request req) {
        return req.getItems().stream().filter(c -> c.editableAccptQtyProperty().get() + c.getAcceptedQty() > c.getReleasedQuantity() && !c.hasAccepted).count() > 0L;
    }

    public List<Request> searchResult(String searchString) {
        LinkedList<Request> searchResult = new LinkedList<Request>();
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<Request>();
        }
        try {
            List result = RequestDataList.searchRequest(searchString, this.da, this.mainPage.currentUser.getParentCompany().getB2bLocationCode()).stream().filter(e -> e.getCode().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
            searchResult.addAll((Collection<Request>)(result.isEmpty() ? this.requestItemDataList.getOriginalList() : result));
            return searchResult.subList(0, searchResult.size());
        }
        catch (SQLException ex) {
            Logger.getLogger(TransferPaneB2B.class.getName()).log(Level.SEVERE, null, ex);
            return searchResult;
        }
    }

    public void populateResult(Request data) {
        ObservableList lsit = FXCollections.observableArrayList();
        lsit.add((Object)data);
        this.fp.getChildren().clear();
        lsit.forEach(reqs -> this.fp.getChildren().add((Object)new TransferCardB2B((Request)reqs, this)));
        this.cmbReqType.getSelectionModel().clearSelection();
    }

    void setRequestControl(ObservableList<Request> requestList) {
        this.fp.getChildren().clear();
        if (requestList != null) {
            requestList.forEach(reqs -> this.fp.getChildren().add((Object)new TransferCardB2B((Request)reqs, this)));
        } else {
            this.requestItemDataList.getOriginalList().forEach(reqs -> this.fp.getChildren().add((Object)new TransferCardB2B((Request)reqs, this)));
        }
    }

    public void resendMail(final Request req) {
        this.dialog.close();
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        String url = WebRequest.SENDAPPROVAL_TRANSFERS_MAIL + "/" + req.getCode();
                        new WebRequest(url, RequestTypeEnum.GET, null, null, new IWebCallBack(){

                            @Override
                            public void onSuccess(String data) {
                                Platform.runLater(() -> {
                                    TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    TransferPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Mail sent", TransferPaneB2B.this);
                                });
                            }

                            @Override
                            public void onError(String data) {
                                Platform.runLater(() -> {
                                    TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, TransferPaneB2B.this);
                                });
                            }

                            @Override
                            public void onTimeOut(String data) {
                                Platform.runLater(() -> {
                                    TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", TransferPaneB2B.this);
                                });
                            }
                        }).execute(false);
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void reloadUnsync() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(TransferPaneB2B.this.santa, TransferPaneB2B.this.da, TransferPaneB2B.this.santa.currentUser.getParentCompany());
                        StoreDataList stores = new StoreDataList(TransferPaneB2B.this.da);
                        stores.selectAll(TransferPaneB2B.this.da);
                        stores.getOriginalList().add(0, (Object)new Store(TransferPaneB2B.this.currentUser.getParentCompany().getStoreName() + " Bulk Warehouse", TransferPaneB2B.this.currentUser.getParentCompany().getB2bLocationCode(), "", "", "", TransferPaneB2B.this.da));
                        String myStoreName = "";
                        Store store = stores.getOriginalList().stream().filter(prdct -> prdct.getCode().equals(TransferPaneB2B.this.currentUser.getParentCompany().getB2bLocationCode())).findAny().orElse(null);
                        if (store != null) {
                            myStoreName = store.getName();
                            System.out.println(myStoreName);
                        }
                        String url = WebRequest.GET_LASTSYNC_TRANSFERS + "/" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(TransferPaneB2B.this.santa.syncSetting.getTransferLastDateRead()) + "/" + TransferPaneB2B.this.currentUser.getParentCompany().getB2bLocationCode() + "/" + myStoreName;
                        syncData.getRequest(TransferPaneB2B.this.santa.syncSetting, url, true, new IDBEntity<Request>(){

                            @Override
                            public void onSuccess(ObservableList<Request> data) {
                                if (data.isEmpty()) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Information, "No Request Found", TransferPaneB2B.this);
                                    });
                                } else {
                                    try {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.requestDataList.getOriginalList().clear();
                                        TransferPaneB2B.this.loadRequests();
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Request reloaded successfully", TransferPaneB2B.this);
                                    }
                                    catch (Exception ex) {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                                    }
                                }
                            }

                            @Override
                            public void onError(String data) {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, TransferPaneB2B.this);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", TransferPaneB2B.this);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void reloadRequest(final Request request1) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(TransferPaneB2B.this.santa, TransferPaneB2B.this.da, TransferPaneB2B.this.santa.currentUser.getParentCompany());
                        JSONObject param = new JSONObject().put("recId", (Object)request1.getCode());
                        String url = WebRequest.GET_TRANSFERS + "?condition=" + param.toString();
                        syncData.getRequest(TransferPaneB2B.this.santa.syncSetting, url, true, new IDBEntity<Request>(){

                            @Override
                            public void onSuccess(ObservableList<Request> data) {
                                if (data.isEmpty()) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Information, "No Request Found", TransferPaneB2B.this);
                                    });
                                } else {
                                    try {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.requestDataList.getOriginalList().clear();
                                        TransferPaneB2B.this.loadRequests();
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Request reloaded successfully", TransferPaneB2B.this);
                                    }
                                    catch (Exception ex) {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                                    }
                                }
                            }

                            @Override
                            public void onError(String data) {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, TransferPaneB2B.this);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", TransferPaneB2B.this);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void search() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(TransferPaneB2B.this.santa, TransferPaneB2B.this.da, TransferPaneB2B.this.santa.currentUser.getParentCompany());
                        JSONObject param = new JSONObject().put("recId", (Object)TransferPaneB2B.this.searchBox.getText().trim());
                        String url = WebRequest.GET_TRANSFERS + "?condition=" + param.toString();
                        syncData.getRequest(TransferPaneB2B.this.santa.syncSetting, url, true, new IDBEntity<Request>(){

                            @Override
                            public void onSuccess(ObservableList<Request> data) {
                                if (data.isEmpty()) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Information, "No Request Found", TransferPaneB2B.this);
                                    });
                                } else {
                                    try {
                                        TransferPaneB2B.this.searchBox.clear();
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.requestDataList.getOriginalList().clear();
                                        TransferPaneB2B.this.loadRequests();
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Request reloaded successfully", TransferPaneB2B.this);
                                    }
                                    catch (Exception ex) {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                                    }
                                }
                            }

                            @Override
                            public void onError(String data) {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, TransferPaneB2B.this);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", TransferPaneB2B.this);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void deleteRequest(final Request request) {
        if (request.getStatus().equals(RequestStatus.PENDING.name()) || request.getStatus().equals(RequestStatus.APPROVED.name())) {
            request.setReleasingUser(this.currentUser.getUserName());
            request.setReleaseDate(new Date());
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            new WebRequest("transferorder/deleteTransferorder/" + request.getCode(), RequestTypeEnum.DELETE, null, null, new IWebCallBack(){

                                @Override
                                public void onSuccess(String data) {
                                    try {
                                        Platform.runLater(() -> {
                                            try {
                                                String rem = request.getCode();
                                                RequestDataList requestDataList = new RequestDataList(TransferPaneB2B.this.da);
                                                request.setState(ObjectState.Removed);
                                                requestDataList.getOriginalList().add((Object)request);
                                                requestDataList.update();
                                                TransferPaneB2B.this.requestItemDataList.getOriginalList().remove((Object)request);
                                                TransferPaneB2B.this.setRequestControl(null);
                                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Request " + rem + " Removed successfully", TransferPaneB2B.this);
                                            }
                                            catch (Exception ex) {
                                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                                                Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                            TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        });
                                    }
                                    catch (Exception ex) {
                                        Platform.runLater(() -> {
                                            TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                                            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                            TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        });
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, TransferPaneB2B.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, data);
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", TransferPaneB2B.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, data);
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    });
                                }
                            }).execute(false);
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        } else {
            this.mainPage.showNotification(NotificationType.Error, "Request cannot be deleted after Released", this);
        }
    }

    public void Release(final Request request) {
        request.setReleasingUser(this.currentUser.getUserName());
        request.setReleaseDate(new Date());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("recId", (Object)request.getCode());
                            job.put("requestReason", (Object)request.getReason());
                            job.put("status", (Object)request.getStatus());
                            job.put("requestReason", (Object)request.getReason());
                            job.put("fromLocationCode", (Object)request.getFromStoreCode());
                            job.put("fromLocationName", (Object)request.getFromStoreName());
                            job.put("isRecall", request.getIsRecall());
                            job.put("requesttype", (Object)request.getRequestType());
                            job.put("requestUser", (Object)request.getoriginatedUser());
                            job.put("toLocationCode", (Object)request.getToStoreCode());
                            job.put("toLocationName", (Object)request.getToStoreName());
                            job.put("isB2B", request.getIsB2B());
                            job.put("lastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("requestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            JSONArray jab = new JSONArray();
                            for (RequestItem requestItem : request.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("requestCode", (Object)request.getCode());
                                joItem.put("netWeight", (double)requestItem.getNetWeight());
                                joItem.put("quantityTransfer", requestItem.getQuantity());
                                joItem.put("releasedQuantity", requestItem.getReleasedQuantity());
                                joItem.put("returnedQty", (Object)requestItem.getReturnedQty());
                                joItem.put("toStoreInitQty", (Object)requestItem.getToStoreInitQty());
                                joItem.put("acceptedQty", (Object)requestItem.getAcceptedQty());
                                joItem.put("approvedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("lineNumber", (Object)requestItem.getLineNumber());
                                joItem.put("currentQuantity", (Object)requestItem.getTempQty());
                                joItem.put("itemId", (Object)requestItem.getItemCode());
                                joItem.put("itemName", (Object)requestItem.getItemName());
                                joItem.put("code", (Object)requestItem.getCode());
                                JSONArray jsonSerials = new JSONArray();
                                for (RequestitemSerial serial : requestItem.getSerials()) {
                                    JSONObject jsSerial = new JSONObject();
                                    jsSerial.put("requestItemCode", (Object)serial.getRequestItemCode());
                                    jsSerial.put("serial", (Object)serial.getSerial());
                                    jsSerial.put("itemCode", (Object)serial.getItemCode());
                                    jsSerial.put("isAccepted", false);
                                    jsSerial.put("sysSerial", serial.getSysSerial());
                                    jsonSerials.put((Object)jsSerial);
                                }
                                joItem.put("Serials", (Object)jsonSerials);
                                jab.put((Object)joItem);
                            }
                            job.put("transferOrderLines", (Object)jab);
                            jSONArray.put((Object)job);
                            new WebRequest("transferorder/releaseTransferorder", RequestTypeEnum.POST, jSONArray.toString(), null, new IWebCallBack(){

                                @Override
                                public void onSuccess(String data) {
                                    try {
                                        System.out.println(data);
                                        JSONObject jsono = new JSONArray(data).getJSONObject(0);
                                        request.setTransferId(jsono.getString("transferId"));
                                        request.setStatus(jsono.getString("status"));
                                        for (int i = 0; i < jsono.getJSONArray("transferOrderLines").length(); ++i) {
                                            JSONObject js = jsono.getJSONArray("transferOrderLines").getJSONObject(i);
                                            String itemCode = js.getString("itemId");
                                            RequestItem item = request.getItems().stream().filter(prdct -> prdct.getItemCode().equals(itemCode)).findAny().orElse(null);
                                            if (item == null) continue;
                                            item.setReleasedQuantity(js.getInt("releasedQuantity"));
                                        }
                                        RequestDataList requestDataList1 = new RequestDataList(TransferPaneB2B.this.da);
                                        requestDataList1.getOriginalList().add((Object)request);
                                        requestDataList1.update();
                                        RequestItemDataList requestItemDataList1 = new RequestItemDataList(TransferPaneB2B.this.da);
                                        requestItemDataList1.getOriginalList().addAll(request.getItems());
                                        requestItemDataList1.update();
                                        Platform.runLater(() -> {
                                            TransferPaneB2B.this.accptRelease.setVisible(false);
                                            TransferPaneB2B.this.labelStatus();
                                            TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                            TransferPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Request " + request.getCode() + " Successfully Released", TransferPaneB2B.this);
                                        });
                                    }
                                    catch (Exception ex) {
                                        Platform.runLater(() -> {
                                            TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data, TransferPaneB2B.this);
                                            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                            TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        });
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, TransferPaneB2B.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, data);
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", TransferPaneB2B.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, data);
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    });
                                }
                            }).execute(false);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                            Platform.runLater(() -> {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void Accept(final Request request) {
        request.setAcceptingUser(this.currentUser.getUserName());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("recId", (Object)request.getCode());
                            job.put("requestReason", (Object)request.getReason());
                            job.put("status", (Object)request.getStatus());
                            job.put("requestReason", (Object)request.getReason());
                            job.put("fromLocationCode", (Object)request.getFromStoreCode());
                            job.put("fromLocationName", (Object)request.getFromStoreName());
                            job.put("isB2B", request.getIsB2B());
                            job.put("requesttype", (Object)request.getRequestType());
                            job.put("requestUser", (Object)request.getoriginatedUser());
                            job.put("toLocationCode", (Object)request.getToStoreCode());
                            job.put("toLocationName", (Object)request.getToStoreName());
                            job.put("lastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("requestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            JSONArray jab = new JSONArray();
                            for (RequestItem requestItem : request.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("requestCode", (Object)request.getCode());
                                joItem.put("quantityTransfer", requestItem.getQuantity());
                                joItem.put("releasedQuantity", requestItem.getReleasedQuantity());
                                joItem.put("returnedQty", (Object)requestItem.getReturnedQty());
                                joItem.put("toStoreInitQty", (Object)requestItem.getToStoreInitQty());
                                joItem.put("acceptedQty", (Object)requestItem.getAcceptedQty());
                                joItem.put("approvedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("lineNumber", (Object)requestItem.getLineNumber());
                                joItem.put("currentQuantity", requestItem.hasAccepted ? 0 : requestItem.getTempQty());
                                joItem.put("netWeight", (double)requestItem.getNetWeight());
                                joItem.put("itemId", (Object)requestItem.getItemCode());
                                joItem.put("itemName", (Object)requestItem.getItemName());
                                joItem.put("code", (Object)requestItem.getCode());
                                JSONArray jsonSerials = new JSONArray();
                                for (RequestitemSerial serial : requestItem.getSerials()) {
                                    JSONObject jsSerial = new JSONObject();
                                    jsSerial.put("requestItemCode", (Object)serial.getRequestItemCode());
                                    jsSerial.put("serial", (Object)serial.getSerial());
                                    jsSerial.put("itemCode", (Object)serial.getItemCode());
                                    jsSerial.put("isAccepted", false);
                                    jsSerial.put("sysSerial", serial.getSysSerial());
                                    jsonSerials.put((Object)jsSerial);
                                }
                                joItem.put("Serials", (Object)jsonSerials);
                                jab.put((Object)joItem);
                            }
                            job.put("transferOrderLines", (Object)jab);
                            jSONArray.put((Object)job);
                            new WebRequest("transferorder/acceptTransferorder", RequestTypeEnum.POST, jSONArray.toString(), null, new IWebCallBack(){

                                @Override
                                public void onSuccess(String data) {
                                    try {
                                        System.out.println(data);
                                        JSONObject jsono = new JSONArray(data).getJSONObject(0);
                                        request.setTransferId(jsono.getString("transferId"));
                                        request.setStatus(jsono.getString("status"));
                                        for (int i = 0; i < jsono.getJSONArray("transferOrderLines").length(); ++i) {
                                            JSONObject js = jsono.getJSONArray("transferOrderLines").getJSONObject(i);
                                            String itemCode = js.getString("itemId");
                                            RequestItem item = request.getItems().stream().filter(prdct -> prdct.getItemCode().equals(itemCode)).findAny().orElse(null);
                                            if (item != null) {
                                                item.setAcceptedQty(js.getInt("acceptedQty"));
                                            }
                                            item.setTempQty(0);
                                        }
                                        RequestDataList requestDataList1 = new RequestDataList(TransferPaneB2B.this.da);
                                        requestDataList1.getOriginalList().add((Object)request);
                                        requestDataList1.update();
                                        RequestItemDataList requestItemDataList1 = new RequestItemDataList(TransferPaneB2B.this.da);
                                        requestItemDataList1.getOriginalList().addAll(request.getItems());
                                        requestItemDataList1.update();
                                        Platform.runLater(() -> {
                                            TransferPaneB2B.this.accptRelease.setVisible(false);
                                            TransferPaneB2B.this.setRequestControl(null);
                                            TransferPaneB2B.this.labelStatus();
                                            TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                            TransferPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Request " + request.getCode() + " Successfully Accepted", TransferPaneB2B.this);
                                        });
                                    }
                                    catch (Exception ex) {
                                        Platform.runLater(() -> {
                                            TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data, TransferPaneB2B.this);
                                            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                            TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        });
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, TransferPaneB2B.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, data);
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", TransferPaneB2B.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, data);
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    });
                                }
                            }).execute(false);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                            Platform.runLater(() -> {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void Return(final Request request) {
        request.setReturningUser(this.currentUser.getUserName());
        request.setReturnDate(new Date());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            BufferedReader br;
                            Object url = TransferPaneB2B.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RRequest/ReturnRequestItems";
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("Code", (Object)request.getCode());
                            job.put("Reason", (Object)request.getReason());
                            job.put("Status", (Object)RequestStatus.RELEASED.name());
                            job.put("Reason", (Object)request.getReason());
                            job.put("StoreCode", (Object)request.getFromStoreCode());
                            job.put("ReturningUser", (Object)request.getReturningUser());
                            job.put("ReturningComment", (Object)request.getReturningComment());
                            job.put("ReturnDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("DocEntry", request.getDocEntry());
                            job.put("DateAccepted", (Object)request.getDateAccept());
                            job.put("ReleaseComment", (Object)request.getReleaseComment());
                            job.put("ReleasingUser", (Object)request.getReleasingUser());
                            job.put("ApprovalComment", (Object)request.getApprovalComment());
                            job.put("AcceptComment", (Object)request.getAcceptedComment());
                            job.put("AcceptingUser", (Object)request.getAcceptingUser());
                            job.put("ApprovingUser", (Object)request.getApprovingUser());
                            job.put("RequestType", (Object)request.getRequestType());
                            job.put("OriginatingUser", (Object)request.getoriginatedUser());
                            job.put("DestinationStore", (Object)request.getToStoreCode());
                            job.put("LastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            job.put("RequestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(request.getRequestDate()));
                            JSONArray jab = new JSONArray();
                            if (request.getItems().isEmpty()) {
                                TransferPaneB2B.this.loadRequestItem(request);
                            }
                            for (RequestItem requestItem : request.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("RequestCode", (Object)request.getCode());
                                joItem.put("Quantity", requestItem.getQuantity());
                                joItem.put("DestinationStore", (Object)request.getToStoreCode());
                                joItem.put("ReleasedQty", requestItem.getReleasedQuantity());
                                joItem.put("ApprovedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("AcceptedQty", (Object)requestItem.getAcceptedQty());
                                joItem.put("netWeight", (double)requestItem.getNetWeight());
                                if (requestItem.getReleasedQuantity() - requestItem.getAcceptedQty() == 0) continue;
                                joItem.put("ReturnedQty", requestItem.getReleasedQuantity() - requestItem.getAcceptedQty());
                                joItem.put("ItemCode", (Object)requestItem.getItemCode());
                                joItem.put("ItemName", (Object)requestItem.getItemName());
                                joItem.put("Code", (Object)requestItem.getCode());
                                JSONArray jsonSerials = new JSONArray();
                                for (RequestitemSerial serial : requestItem.getSerials()) {
                                    JSONObject jsSerial = new JSONObject();
                                    jsSerial.put("RequestItemCode", (Object)serial.getRequestItemCode());
                                    jsSerial.put("Serial", (Object)serial.getSerial());
                                    jsSerial.put("ItemCode", (Object)serial.getItemCode());
                                    jsSerial.put("IsAccepted", false);
                                    jsSerial.put("SysSerial", serial.getSysSerial());
                                    jsonSerials.put((Object)jsSerial);
                                }
                                joItem.put("Serials", (Object)jsonSerials);
                                jab.put((Object)joItem);
                            }
                            job.put("RequestItems", (Object)jab);
                            jSONArray.put((Object)job);
                            HttpPost httpPost = new HttpPost((String)url);
                            if (request.getRequestType().equals(RequestType.Outbound.name()) && Santa.getWareHousesList().contains(request.getFromStoreCode()) || request.getRequestType().equals(RequestType.Inbound.name()) && Santa.getWareHousesList().contains(request.getToStoreCode())) {
                                System.out.println("Request Type:" + request.getRequestType() + " From Store" + request.getFromStoreCode() + ",To store:" + request.getToStoreCode());
                                ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                                BasicNameValuePair param1 = new BasicNameValuePair("returnOutwards", "true");
                                listParam.add(param1);
                                URI uri = new URIBuilder(httpPost.getURI()).addParameters(listParam).build();
                                httpPost.setURI(uri);
                            }
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            File f = Santa.writePayLoadToFileAll(jSONArray.toString());
                            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                            httpPost.setEntity(reqEntity);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONObject ra = new JSONObject(result);
                                Platform.runLater(() -> {
                                    try {
                                        if (ra.getString("Message").equals("Success")) {
                                            if (request.getRequestType().equals(RequestType.Outbound.name()) && Santa.getWareHousesList().contains(request.getFromStoreCode()) || request.getRequestType().equals(RequestType.Inbound.name()) && Santa.getWareHousesList().contains(request.getToStoreCode())) {
                                                System.out.println("Request Type:2 " + request.getRequestType() + " From Store" + request.getToStoreCode() + ",To store:" + request.getToStoreCode());
                                                request.setStatus(RequestStatus.RETURNED.name());
                                            } else {
                                                request.setStatus(RequestStatus.COMPLETED.name());
                                            }
                                            RequestDataList requestDataList1 = new RequestDataList(TransferPaneB2B.this.da);
                                            requestDataList1.getOriginalList().add((Object)request);
                                            request.getItems().forEach(val -> val.setReturnedQty(val.getReleasedQuantity() - val.getAcceptedQty()));
                                            RequestItemDataList requestItemDataList1 = new RequestItemDataList(TransferPaneB2B.this.da);
                                            requestItemDataList1.getOriginalList().addAll(request.getItems());
                                            requestDataList1.update();
                                            requestItemDataList1.update();
                                            TransferPaneB2B.this.setRequestControl(null);
                                            TransferPaneB2B.this.labelStatus();
                                            TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                            TransferPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", TransferPaneB2B.this);
                                        } else {
                                            JSONArray jSONArray1 = ra.getJSONArray("Responses");
                                            TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                            TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, jSONArray1.getJSONObject(0).getString("Message"), TransferPaneB2B.this);
                                        }
                                    }
                                    catch (Exception ex) {
                                        TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                                        Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                });
                            } else {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, fullError, TransferPaneB2B.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                TransferPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                TransferPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), TransferPaneB2B.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void loadRequestItem(Request req) {
        if (req.getItems().isEmpty()) {
            RequestItemDataList requestItemDataList1 = new RequestItemDataList(this.da);
            requestItemDataList1.selectAll("Select * from RequestItem where requestCode=?", new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, req.getCode())});
            req.getItems().addAll(requestItemDataList1.getOriginalList());
        }
    }

    public void loadItems(Request request) {
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setTitle("Transfer Item(s)");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent((Node)new com.xputertechnologies.santa.ui.RequestItem(this.santa, request, this));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.show();
    }

    private void NewRequest() {
        NewRequestPaneB2B requestPane = new NewRequestPaneB2B(this.santa, this);
        this.mainPage.showChild(requestPane);
    }

    void labelStatus() {
        this.lblGranted.setText(String.valueOf(this.requestItemDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(RequestStatus.APPROVED.name())).count()));
        this.lblClose.setText(String.valueOf(this.requestItemDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(RequestStatus.COMPLETED.name())).count()));
        this.lblDecline.setText(String.valueOf(this.requestItemDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(RequestStatus.DECLINED.name())).count()));
        this.lblPending.setText(String.valueOf(this.requestItemDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(RequestStatus.PENDING.name())).count()));
        this.lblRelease.setText(String.valueOf(this.requestItemDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(RequestStatus.RELEASED.name())).count()));
        this.lblAccepted.setText(String.valueOf(this.requestItemDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(RequestStatus.ACCEPTED.name())).count()));
    }

    private void loadRequests() {
        Object sRequest;
        this.requestItemDataList.selectAllByDateWithNotCompleted(java.sql.Date.valueOf((LocalDate)this.from.getValue()), java.sql.Date.valueOf((LocalDate)this.to.getValue()), this.da, this.santa.currentUser.getParentCompany().getB2bLocationCode());
        if (!this.searchRequest.isEmpty() && (sRequest = (Request)this.requestItemDataList.getOriginalList().stream().filter(v -> v.getCode().equals(this.searchRequest)).findAny().orElse(null)) != null) {
            this.requestItemDataList.getOriginalList().removeIf(arg_0 -> TransferPaneB2B.lambda$loadRequests$14((Request)sRequest, arg_0));
            this.requestItemDataList.getOriginalList().add(0, sRequest);
        }
        this.searchRequest = "";
        if (this.requestDataList.getOriginalList().size() > 0) {
            this.requestItemDataList.getOriginalList().remove(this.requestDataList.getOriginalList().get(0));
            this.requestItemDataList.getOriginalList().add(0, (Object)((Request)this.requestDataList.getOriginalList().get(0)));
        }
        this.setRequestControl(null);
        this.labelStatus();
        try {
            for (Request req : this.requestItemDataList.getOriginalList()) {
                req.setIsNew(false);
            }
            this.mainPage.showNotificationRequest();
        }
        catch (Exception ex) {
            Logger.getLogger(TransferPaneB2B.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void backFromChild() {
        this.loadRequests();
    }

    @Override
    public void yes() {
        this.Return(this.temp);
    }

    private static /* synthetic */ boolean lambda$loadRequests$14(Request sRequest, Request v) {
        return v.getCode().equals(sRequest.getCode());
    }
}

