/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.Supplier;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.SupplierPane;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;

public class SupplierDailog
extends UIParent {
    @FXML
    private JFXTextField tbName;
    @FXML
    private JFXTextField tbAddress;
    @FXML
    private JFXTextField tbEmail;
    @FXML
    private JFXTextField tbPhone;
    @FXML
    private JFXTextField tbAccNo;
    @FXML
    private JFXTextField tbAccName;
    @FXML
    private JFXTextField tbCreditLimit;
    @FXML
    private JFXComboBox<NameValueObject> cmbBankName;
    @FXML
    private JFXComboBox<NameValueObject> cmbPayTerm;
    @FXML
    private JFXComboBox<NameValueObject> cmbCurrency;
    @FXML
    private JFXButton btnSave;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnCancel;
    Supplier supplier;
    SupplierPane parent;
    protected StringConverter<? extends Number> dConverter = new DoubleStringConverter(){

        public String toString(Double object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object);
            }
            return null;
        }

        public Double fromString(String string) {
            Double d = 0.0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Double.parseDouble(string);
            }
            return d;
        }
    };

    public SupplierDailog(final SupplierPane parent) {
        super("SupplierDailog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Supplier";
        this.parent = parent;
        ObservableList<NameValueObject> paymentTerms = NameValueObject.select(NameValueObjectType.PaymentTerm.name(), this.da);
        ObservableList<NameValueObject> banksNames = NameValueObject.select(NameValueObjectType.Banks.name(), this.da);
        ObservableList<NameValueObject> currencies = NameValueObject.select(NameValueObjectType.Currencies.name(), this.da);
        this.cmbBankName.setItems(banksNames);
        this.cmbBankName.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                SupplierDailog.this.supplier.setBankName(newValue.getData());
            }
        });
        this.cmbPayTerm.setItems(paymentTerms);
        this.cmbPayTerm.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                SupplierDailog.this.supplier.setPaymentTerm(newValue.getData());
            }
        });
        this.cmbCurrency.setItems(currencies);
        this.cmbCurrency.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                SupplierDailog.this.supplier.setCurrency(newValue.getData());
            }
        });
        if (parent.selectedSupplier == null) {
            this.supplier = new Supplier(this.da);
            this.supplier.setSn(parent.supplierDataList.getOriginalList().size() + 1);
        } else {
            this.supplier = parent.selectedSupplier;
            if (this.supplier.getBankName() != null && !this.supplier.getBankName().isEmpty()) {
                this.cmbBankName.getSelectionModel().select((Object)banksNames.stream().filter(k -> k.getData().equals(this.supplier.getBankName())).findAny().get());
            }
            if (this.supplier.getCurrency() != null && !this.supplier.getCurrency().isEmpty()) {
                this.cmbCurrency.getSelectionModel().select((Object)currencies.stream().filter(k -> k.getData().equals(this.supplier.getCurrency())).findAny().get());
            }
            if (this.supplier.getPaymentTerm() != null && !this.supplier.getPaymentTerm().isEmpty()) {
                this.cmbPayTerm.getSelectionModel().select((Object)paymentTerms.stream().filter(k -> k.getData().equals(this.supplier.getPaymentTerm())).findAny().get());
            }
            if (this.supplier.getSyncFlag().booleanValue()) {
                this.tbEmail.setDisable(true);
            }
        }
        this.tbName.setTextFormatter(new TextFormatter(change -> {
            change.setText(change.getText().toUpperCase());
            return change;
        }));
        this.tbAccName.setTextFormatter(new TextFormatter(change -> {
            change.setText(change.getText().toUpperCase());
            return change;
        }));
        this.tbCreditLimit.textProperty().bindBidirectional((Property)this.supplier.creditLimitProperty(), this.dConverter);
        this.tbName.textProperty().bindBidirectional((Property)this.supplier.nameProperty());
        this.tbAddress.textProperty().bindBidirectional((Property)this.supplier.addressProperty());
        this.tbEmail.textProperty().bindBidirectional((Property)this.supplier.emailProperty());
        this.tbPhone.textProperty().bindBidirectional((Property)this.supplier.phoneNumberProperty());
        this.tbAccNo.textProperty().bindBidirectional((Property)this.supplier.accountNumberProperty());
        this.tbAccName.textProperty().bindBidirectional((Property)this.supplier.accountNameProperty());
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.dialog.close();
            }
        });
        this.btnSave.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.selectedSupplier == null || !parent.selectedSupplier.getEmail().equals(SupplierDailog.this.supplier.getEmail())) {
                    parent.supplierDataList.getOriginalList().add((Object)SupplierDailog.this.supplier);
                }
                parent.dialog.close();
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SupplierDailog.this.rebind();
            }
        });
    }

    public void rebind() {
        this.tbName.textProperty().unbindBidirectional((Property)this.supplier.nameProperty());
        this.tbAddress.textProperty().unbindBidirectional((Property)this.supplier.addressProperty());
        this.tbEmail.textProperty().unbindBidirectional((Property)this.supplier.emailProperty());
        this.tbPhone.textProperty().unbindBidirectional((Property)this.supplier.phoneNumberProperty());
        this.tbAccNo.textProperty().unbindBidirectional((Property)this.supplier.accountNumberProperty());
        this.tbAccName.textProperty().unbindBidirectional((Property)this.supplier.accountNameProperty());
        this.tbCreditLimit.textProperty().unbindBidirectional((Object)this.supplier.creditLimitProperty());
        this.cmbBankName.getSelectionModel().clearSelection();
        this.cmbCurrency.getSelectionModel().clearSelection();
        this.cmbPayTerm.getSelectionModel().clearSelection();
        if (this.parent.selectedSupplier == null || !this.parent.selectedSupplier.getEmail().equals(this.supplier.getEmail())) {
            this.parent.supplierDataList.getOriginalList().add((Object)this.supplier);
        }
        this.supplier = new Supplier(this.da);
        this.supplier.setSn(this.parent.supplierDataList.getOriginalList().size() + 1);
        this.tbEmail.setDisable(false);
        this.tbCreditLimit.textProperty().bindBidirectional((Property)this.supplier.creditLimitProperty(), this.dConverter);
        this.tbName.textProperty().bindBidirectional((Property)this.supplier.nameProperty());
        this.tbAddress.textProperty().bindBidirectional((Property)this.supplier.addressProperty());
        this.tbEmail.textProperty().bindBidirectional((Property)this.supplier.emailProperty());
        this.tbPhone.textProperty().bindBidirectional((Property)this.supplier.phoneNumberProperty());
        this.tbAccNo.textProperty().bindBidirectional((Property)this.supplier.accountNumberProperty());
        this.tbAccName.textProperty().bindBidirectional((Property)this.supplier.accountNameProperty());
    }
}

