/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class StoreListPane
extends UIParent {
    @FXML
    private TableView<Store> tbStore;
    @FXML
    private JFXButton btnSyncStore;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableColumn<Store, String> colSn;
    @FXML
    private TableColumn<Store, String> colName;
    @FXML
    private TableColumn<Store, String> colAddress;
    @FXML
    private TableColumn<Store, String> colPhoneNum;
    @FXML
    private TableColumn<Store, String> colEmail;
    @FXML
    private TableColumn<Store, String> colCode;

    public StoreListPane(Santa app) {
        super("StoreListPane.fxml", app);
        this.santa = app;
        this.title = "Store List";
        this.prefWidthProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.widthProperty());
        this.tbStore.prefHeightProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.heightProperty());
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("Sn"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colPhoneNum.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.colEmail.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.colAddress.setCellValueFactory((Callback)new PropertyValueFactory("address"));
        this.colCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.btnSyncStore.setOnAction(it -> this.syncStore());
        this.loadStores();
    }

    private void loadStores() {
        StoreDataList storeDataList = new StoreDataList(this.da);
        storeDataList.selectAll(this.da);
        this.tbStore.setItems(storeDataList.getOriginalList());
    }

    private void syncStore() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        try {
            box.setAlignment(Pos.CENTER);
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            SyncData syncData = new SyncData(StoreListPane.this.santa, StoreListPane.this.da, StoreListPane.this.santa.currentUser.getParentCompany());
                            syncData.getLocations(StoreListPane.this.da, new IDBEntity<Store>(){

                                @Override
                                public void onError(String data) {
                                    StoreListPane.this.mainPage.showNotification(NotificationType.Error, data, StoreListPane.this);
                                    StoreListPane.this.stackPane.getChildren().remove((Object)box);
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    StoreListPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", StoreListPane.this);
                                    StoreListPane.this.stackPane.getChildren().remove((Object)box);
                                }

                                @Override
                                public void onSuccess(ObservableList<Store> data) {
                                    StoreListPane.this.stackPane.getChildren().remove((Object)box);
                                    if (data.size() > 0) {
                                        StoreListPane.this.tbStore.setItems(data);
                                        StoreListPane.this.tbStore.refresh();
                                    } else {
                                        StoreListPane.this.mainPage.showNotification(NotificationType.Information, "No sale found", StoreListPane.this);
                                    }
                                }
                            });
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        }
        catch (Exception ex) {
            this.stackPane.getChildren().remove((Object)box);
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

