/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.ui.AutoCompleteTextField;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.StockItemContainer;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;

public class StockItemPane
extends UIParent {
    @FXML
    private Button Search;
    @FXML
    private ScrollPane scrollContainer;
    @FXML
    private AutoCompleteTextField SearchField;
    @FXML
    public Button btnNew;
    @FXML
    private Button btnSave;
    @FXML
    private Label lblItemCount;
    @FXML
    public VBox vbRepeatingCntrl;
    public ObservableList<StockItem> stockList = FXCollections.observableArrayList();
    public StockItemList stockItemList;
    public StockItemList cartStockItemList;
    public boolean one = false;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    private Santa santa;
    public UnitDataList unitList;
    StockItem si;
    boolean isSearching = false;
    Image image = null;

    public StockItemPane(Santa santa) throws Exception {
        super("StockItemPane.fxml", santa);
        this.title = "Stock Item Page";
        this.SearchField.container = this;
        this.stockItemList = new StockItemList(this.da);
        this.lblItemCount.setText(String.valueOf(this.stockItemList.getTotalRecord("StockItem")) + " Items available");
        this.populateSearch(this.SearchField.getText().toString());
        this.SearchField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    try {
                        if (!StockItemPane.this.SearchField.getText().toString().isEmpty()) {
                            StockItemPane.this.populateSearch(StockItemPane.this.SearchField.getText().toString());
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.Search.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    if (!StockItemPane.this.SearchField.getText().toString().isEmpty()) {
                        // empty if block
                    }
                    StockItemPane.this.stockItemList.getOriginalList().clear();
                    StockItemPane.this.vbRepeatingCntrl.getChildren().clear();
                    StockItemPane.this.stockItemList.currentPage = 0;
                    StockItemPane.this.stockItemList.getOriginalList().addAll(StockItem.searchStock(StockItemPane.this.SearchField.getText().toString(), StockItemPane.this.da).getOriginalList());
                    for (StockItem stock : StockItemPane.this.stockItemList.getOriginalList()) {
                        try {
                            stock.isEdit = true;
                            StockItemPane.this.isSearching = true;
                            StockItemContainer si = new StockItemContainer(stock, StockItemPane.this);
                            StockItemPane.this.vbRepeatingCntrl.getChildren().addAll((Object[])new Node[]{si});
                        }
                        catch (Exception ex) {
                            Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    StockItemPane.this.NewItem();
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnSave.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    StockItemPane.this.done();
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.scrollContainer.vvalueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue.doubleValue() == StockItemPane.this.scrollContainer.getHmax() && StockItemPane.this.vbRepeatingCntrl.getChildren().size() < StockItemPane.this.stockItemList.getTotalRecord("StockItem") && StockItemPane.this.SearchField.getText().toString().isEmpty()) {
                    ++StockItemPane.this.stockItemList.currentPage;
                    StockItemPane.this.populateSearch(StockItemPane.this.SearchField.getText().toString());
                }
            }
        });
    }

    public void NewItem() throws Exception {
        StockItemContainer stockItemView = new StockItemContainer(null, this);
    }

    public void done() {
        if (this.validateControl() && this.needToSave) {
            try {
                this.stockItemList.update();
                this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
            }
            catch (Exception ex) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        }
    }

    @Override
    public void populateSearch(String SearchValue) {
        this.vbRepeatingCntrl.getChildren().clear();
        if (!SearchValue.isEmpty()) {
            this.stockItemList.currentPage = 0;
            this.stockItemList.searPrecise(SearchValue);
        } else {
            this.stockItemList.searchStock(SearchValue);
        }
        ArrayList<StockItemContainer> children = new ArrayList<StockItemContainer>();
        for (StockItem stock : this.stockItemList.getOriginalList()) {
            try {
                stock.isEdit = true;
                this.isSearching = true;
                StockItemContainer si = new StockItemContainer(stock, this);
                children.add(si);
            }
            catch (Exception ex) {
                Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.vbRepeatingCntrl.getChildren().addAll(children);
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return StockItemList.selectAutoComplete(searchString, this.da, false);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        for (StockItem sa : this.stockItemList.getOriginalList()) {
            if (sa.getState() != ObjectState.Changed && sa.getState() != ObjectState.New) continue;
            this.needToSave = true;
            break;
        }
        return true;
    }

    @Override
    void yes() {
        try {
            this.done();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to save change(s)", this);
    }
}

