/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItemB2B;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.StockItemB2BList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.StockItemPane;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONObject;

public class StockItemListPaneB2B
extends UIParent {
    @FXML
    private TextField SearchTF;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableView<StockItemB2B> tbItems;
    @FXML
    private TableColumn<StockItemB2B, String> colItemCode;
    @FXML
    private TableColumn<StockItemB2B, String> colItemName;
    @FXML
    private TableColumn<StockItemB2B, String> colGroup;
    @FXML
    private TableColumn<StockItemB2B, Integer> sn;
    @FXML
    private TableColumn<StockItemB2B, Double> colPrice;
    @FXML
    private TableColumn<StockItemB2B, Float> colQty;
    @FXML
    private TableColumn<StockItemB2B, Float> colWeight;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton resync;
    @FXML
    private JFXButton btnAddINewtem;
    @FXML
    private JFXButton btnAddItemTransfer;
    public StockItemB2BList stockItemList;
    @FXML
    private Label lblItemCount;
    VBox progressContainer;
    VBox box;
    SyncSettingDataList syncSettingDataList = null;
    int i = 0;

    public StockItemListPaneB2B(Santa app) {
        super("StockItemListPaneB2B.fxml", app);
        this.title = "Stock Item List B2B";
        this.syncSettingDataList = new SyncSettingDataList(this.da);
        this.syncSettingDataList.selectAll("Select * From SyncSetting", this.da);
        this.stockItemList = new StockItemB2BList(this.da);
        this.lblItemCount.setText(String.valueOf(this.stockItemList.getTotalRecord("StockItemB2B")) + " Items available");
        this.resync.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.btnAddINewtem.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.resync.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ProgressBar progressIndicator = new ProgressBar();
                progressIndicator.setProgress(-1.0);
                StockItemListPaneB2B.this.box = new VBox(new Node[]{progressIndicator});
                StockItemListPaneB2B.this.box.setAlignment(Pos.CENTER);
                StockItemListPaneB2B.this.progressContainer = StockItemListPaneB2B.this.box;
                StockItemListPaneB2B.this.stackPane.getChildren().add((Object)StockItemListPaneB2B.this.box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData sync = new SyncData(StockItemListPaneB2B.this.santa, StockItemListPaneB2B.this.da, StockItemListPaneB2B.this.currentUser.getParentCompany());
                                JSONObject param = new JSONObject().put("item_Id", (Object)"").put("locationId", (Object)StockItemListPaneB2B.this.currentUser.getParentCompany().getB2bLocationCode()).put("isRetailLocation", false);
                                sync.getInventoryB2B(param, new IDBEntity<StockItemB2B>(){

                                    @Override
                                    public void onSuccess(ObservableList<StockItemB2B> data) {
                                        try {
                                            StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.box);
                                            StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.progressContainer);
                                            StockItemListPaneB2B.this.SearchTF.setText("");
                                            StockItemListPaneB2B.this.populateSearch("");
                                            StockItemListPaneB2B.this.stockItemList.getOriginalList().clear();
                                            StockItemListPaneB2B.this.stockItemList.getOriginalList().addAll(data);
                                            if (data.size() > 0) {
                                                StockItemB2BList.deleteAll(StockItemListPaneB2B.this.da);
                                                StockItemListPaneB2B.this.stockItemList.BatchInsert();
                                            }
                                            StockItemListPaneB2B.this.tbItems.refresh();
                                            StockItemListPaneB2B.this.lblItemCount.setText(String.valueOf(StockItemListPaneB2B.this.stockItemList.getOriginalList().size()) + " Items available");
                                            StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Products Synchronized successfully", StockItemListPaneB2B.this);
                                        }
                                        catch (Exception ex) {
                                            Logger.getLogger(StockItemListPaneB2B.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }

                                    @Override
                                    public void onError(String data) {
                                        StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Error, data, StockItemListPaneB2B.this);
                                        StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.box);
                                        StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.progressContainer);
                                        StockItemListPaneB2B.this.SearchTF.setText("");
                                        StockItemListPaneB2B.this.populateSearch("");
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Error, data, StockItemListPaneB2B.this);
                                        StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.box);
                                        StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.progressContainer);
                                        StockItemListPaneB2B.this.SearchTF.setText("");
                                        StockItemListPaneB2B.this.populateSearch("");
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
        });
        this.btnAddINewtem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (StockItemListPaneB2B.this.SearchTF.getText().isEmpty()) {
                    StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Please supply item code and try again", StockItemListPaneB2B.this);
                } else {
                    StockItemB2BList temp = new StockItemB2BList(StockItemListPaneB2B.this.da);
                    temp.searPrecise(StockItemListPaneB2B.this.SearchTF.getText());
                    if (temp.getOriginalList().size() == 0) {
                        ProgressBar progressIndicator = new ProgressBar();
                        progressIndicator.setProgress(-1.0);
                        StockItemListPaneB2B.this.box = new VBox(new Node[]{progressIndicator});
                        StockItemListPaneB2B.this.box.setAlignment(Pos.CENTER);
                        StockItemListPaneB2B.this.progressContainer = StockItemListPaneB2B.this.box;
                        StockItemListPaneB2B.this.stackPane.getChildren().add((Object)StockItemListPaneB2B.this.box);
                        Service service = new Service(){

                            protected Task createTask() {
                                return new Task(){

                                    protected Object call() throws Exception {
                                        JSONObject param = new JSONObject().put("itemIds", (Object)StockItemListPaneB2B.this.SearchTF.getText().trim());
                                        new SyncData(StockItemListPaneB2B.this.santa, StockItemListPaneB2B.this.da, StockItemListPaneB2B.this.currentUser.getParentCompany()).getITemB2B(param, new IDBEntity<StockItemB2B>(){

                                            @Override
                                            public void onSuccess(ObservableList<StockItemB2B> data) {
                                                StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.box);
                                                if (data.isEmpty()) {
                                                    StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Information, "No result found", StockItemListPaneB2B.this);
                                                } else {
                                                    try {
                                                        StockItemB2BList lst = new StockItemB2BList(StockItemListPaneB2B.this.da);
                                                        data.forEach(dat -> {
                                                            dat.setState(ObjectState.New);
                                                            dat.setDbAccess(StockItemListPaneB2B.this.da);
                                                        });
                                                        StockItemB2BList.deleteAll("delete from StockItemB2B where ItemCode=?", new ParameterValue[]{new ParameterValue("ItemCode", JDBCType.VARCHAR, StockItemListPaneB2B.this.SearchTF.getText().trim())}, StockItemListPaneB2B.this.da);
                                                        lst.getOriginalList().addAll(data);
                                                        lst.update();
                                                    }
                                                    catch (Exception ex) {
                                                        StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), StockItemListPaneB2B.this);
                                                    }
                                                    StockItemListPaneB2B.this.SearchTF.setText("");
                                                    StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.box);
                                                    StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Item added to your inventory", StockItemListPaneB2B.this);
                                                }
                                            }

                                            @Override
                                            public void onError(String data) {
                                                StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.box);
                                                StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, StockItemListPaneB2B.this);
                                            }

                                            @Override
                                            public void onTimeOut(String data) {
                                                StockItemListPaneB2B.this.stackPane.getChildren().remove((Object)StockItemListPaneB2B.this.box);
                                                StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", StockItemListPaneB2B.this);
                                            }
                                        });
                                        return null;
                                    }
                                };
                            }
                        };
                        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                        service.start();
                    } else {
                        StockItemListPaneB2B.this.mainPage.showNotification(NotificationType.Information, "Product already exist in your store", StockItemListPaneB2B.this);
                    }
                }
            }
        });
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTF, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                StockItemListPaneB2B.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        autoCompletionBinding.setPrefWidth(400.0);
        this.populateSearch(this.SearchTF.getText().toString());
        this.btnSearch.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    if (!StockItemListPaneB2B.this.SearchTF.getText().toString().isEmpty()) {
                        // empty if block
                    }
                    StockItemListPaneB2B.this.populateSearch(StockItemListPaneB2B.this.SearchTF.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.sn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colWeight.setCellValueFactory((Callback)new PropertyValueFactory("netWeight"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colItemName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colGroup.setCellValueFactory((Callback)new PropertyValueFactory("make"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.prefWidthProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.widthProperty());
        this.tbItems.prefHeightProperty().bind((ObservableValue)this.santa.mainpage.hbCenter.heightProperty());
        this.sn.setCellFactory(param -> {
            TableCell<StockItemB2B, Integer> cell = new TableCell<StockItemB2B, Integer>(){

                public void updateItem(Integer value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(Integer.toString(value));
                        StockItemB2B item = (StockItemB2B)this.getTableRow().getItem();
                        if (item != null && (item.getQuantity() == 0.0f || item.getPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colQty.setCellFactory(param -> {
            TableCell<StockItemB2B, Float> cell = new TableCell<StockItemB2B, Float>(){

                public void updateItem(Float value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(Integer.toString(Math.round(value.floatValue())));
                        StockItemB2B item = (StockItemB2B)this.getTableRow().getItem();
                        if (item != null && (item.getQuantity() == 0.0f || item.getPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colItemCode.setCellFactory(param -> {
            TableCell<StockItemB2B, String> cell = new TableCell<StockItemB2B, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        StockItemB2B item = (StockItemB2B)this.getTableRow().getItem();
                        if (item != null && (item.getQuantity() == 0.0f || item.getPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colItemName.setCellFactory(param -> {
            TableCell<StockItemB2B, String> cell = new TableCell<StockItemB2B, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        StockItemB2B item = (StockItemB2B)this.getTableRow().getItem();
                        if (item != null && (item.getQuantity() == 0.0f || item.getPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colGroup.setCellFactory(param -> {
            TableCell<StockItemB2B, String> cell = new TableCell<StockItemB2B, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        StockItemB2B item = (StockItemB2B)this.getTableRow().getItem();
                        if (item != null && (item.getQuantity() == 0.0f || item.getPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colPrice.setCellFactory(param -> {
            TableCell<StockItemB2B, Double> cell = new TableCell<StockItemB2B, Double>(){

                public void updateItem(Double value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(General.formatDecimalToMoneyString((double)value));
                        StockItemB2B item = (StockItemB2B)this.getTableRow().getItem();
                        if (item != null && (item.getQuantity() == 0.0f || item.getPrice() == 0.0)) {
                            lbl.setTextFill((Paint)Color.web((String)"#ff0000"));
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
    }

    @Override
    public void populateSearch(String SearchValue) {
        if (!SearchValue.isEmpty()) {
            this.stockItemList.currentPage = 0;
            this.stockItemList.searPrecise(SearchValue);
        } else {
            this.stockItemList.searchStock(SearchValue);
        }
        this.tbItems.setItems(this.stockItemList.getOriginalList());
        this.tbItems.refresh();
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return StockItemB2BList.selectAutoComplete(searchString, this.da);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    @Override
    public void yes() {
    }

    public void resyncDone(String erString) {
        Platform.runLater(() -> {
            this.stackPane.getChildren().remove((Object)this.box);
            if (erString.isEmpty()) {
                this.stackPane.getChildren().remove((Object)this.progressContainer);
                this.SearchTF.setText("");
                this.populateSearch("");
                this.lblItemCount.setText(String.valueOf(this.stockItemList.getTotalRecord("StockItemB2B")) + " Items available");
                this.mainPage.showNotification(NotificationType.Success, "Products Synchronized successfully", this);
            } else {
                this.mainPage.showNotification(NotificationType.Error, erString, this);
            }
        });
    }
}

