/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Unit;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.ui.CompanyPane;
import com.xputertechnologies.santa.ui.Customer;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.StockItemContainer;
import com.xputertechnologies.santa.ui.StockItemPane;
import com.xputertechnologies.santa.ui.UIParent;
import com.xputertechnologies.santa.ui.User;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;
import javax.imageio.ImageIO;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.IDataSet;

public class StockItem
extends UIParent {
    private static Connection con;
    private static DatabaseConnection dc;
    private static IDataSet dataSet;
    com.xputertechnologies.santa.StockItem stockItemSanta;
    StockItemPane s;
    public AnchorPane anchorPane;
    @FXML
    private VBox stockInput;
    @FXML
    public Button Cancelbttn;
    @FXML
    public DecimalNumberTextBox sellingPriceFld;
    @FXML
    public DecimalNumberTextBox costPriceFld;
    @FXML
    private Button btnAddnew;
    @FXML
    public ComboBox<Unit> stockUnitFld;
    @FXML
    public TextField typeFld;
    @FXML
    public TextField sizeFld;
    @FXML
    public TextField nameFld;
    @FXML
    public TextField barCodeFld;
    @FXML
    public TextField makerFld;
    @FXML
    public TextField displayQtyFld;
    @FXML
    public Label DisplayQtyLabel;
    @FXML
    public Label QtyLabel;
    private static DataAccess da;
    Santa ui = new Santa();
    double display = 0.0;
    @FXML
    private ImageView logpfield;
    @FXML
    private Button btnBrws;
    Image image = null;
    StringConverter<? extends Number> fconverter = new FloatStringConverter();
    StringConverter<? extends Number> dconverter = new DoubleStringConverter();
    private UnitDataList unitList = null;
    MainPage mainPage;
    StockItemContainer stockItem = null;

    public StockItem(StockItemContainer stockItem, final com.xputertechnologies.santa.StockItem stockItemSanta) throws Exception {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("StockItem.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            this.santa = stockItem.mainPage.santa;
            this.mainPage = stockItem.mainPage;
            this.stockItem = stockItem;
            da = this.mainPage.santa.da;
            this.mainParent = stockItem.stockItemPane;
            this.hasParent = true;
            this.stockItemSanta = stockItemSanta;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        if (this.stockItemSanta.getImage() != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(this.stockItemSanta.getImage()));
                if (bufferedImage != null) {
                    this.image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
                    this.logpfield.setImage(this.image);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CompanyPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.nameFld.textProperty().bindBidirectional((Property)this.stockItemSanta.nameProperty());
        this.makerFld.textProperty().bindBidirectional((Property)this.stockItemSanta.makerProperty());
        this.sizeFld.textProperty().bindBidirectional((Property)this.stockItemSanta.sizeProperty());
        this.typeFld.textProperty().bindBidirectional((Property)this.stockItemSanta.typeProperty());
        this.sellingPriceFld.textProperty().bindBidirectional((Property)this.stockItemSanta.sellingPriceProperty(), this.fconverter);
        this.costPriceFld.textProperty().bindBidirectional((Property)this.stockItemSanta.costPriceProperty(), this.fconverter);
        this.displayQtyFld.textProperty().bindBidirectional((Property)this.stockItemSanta.displayQuantityProperty());
        this.unitList = new UnitDataList(da);
        this.unitList.selectAll("Select * from Unit", da.getEmptyParameterValues());
        this.stockUnitFld.setItems(this.unitList.getOriginalList());
        if (this.unitList.getOriginalList().size() > 0) {
            if (this.stockItemSanta.getStockUnit() == null) {
                this.stockUnitFld.setValue((Object)((Unit)this.stockUnitFld.getItems().get(Unit.getPiecesIndex(this.unitList))));
                stockItemSanta.setParentUnit((Unit)this.stockUnitFld.getItems().get(Unit.getPiecesIndex(this.unitList)));
            } else {
                this.stockUnitFld.setValue((Object)this.stockItemSanta.getParentUnit());
            }
        }
        this.stockUnitFld.valueProperty().addListener((ChangeListener)new ChangeListener<Unit>(){

            public void changed(ObservableValue<? extends Unit> observable, Unit oldValue, Unit newValue) {
                stockItemSanta.setParentUnit(newValue);
                double quantity = stockItemSanta.getQuantity();
                double unD = stockItemSanta.getParentUnit().getQuantity();
                StockItem.this.display = quantity * unD;
                StockItem.this.displayQtyFld.setText("" + StockItem.this.display);
            }
        });
        this.logpfield.imageProperty().addListener((ChangeListener)new ChangeListener<Image>(){

            public void changed(ObservableValue<? extends Image> observable, Image oldValue, Image newValue) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)StockItem.this.image, null), "png", byteArrayOutputStream);
                }
                catch (IOException ex) {
                    Logger.getLogger(CompanyPane.class.getName()).log(Level.SEVERE, null, ex);
                }
                stockItemSanta.setImage(byteArrayOutputStream.toByteArray());
            }
        });
        this.btnBrws.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    StockItem.this.loadImage();
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItemPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnAddnew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    StockItem.this.addNewUser();
                }
                catch (Exception ex) {
                    Logger.getLogger(User.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.Cancelbttn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    StockItem.this.cancel();
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItem.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        General.selectAll(this.sellingPriceFld);
        General.selectAll(this.costPriceFld);
        this.mainPage.hbCenter.setContent((Node)this);
        this.mainPage.hbBottom.setVisible(true);
    }

    private void addNewUser() {
        if (this.stockItemSanta.nameProperty().get() != null && this.stockItemSanta.itemCodeProperty().get() != null && this.stockItemSanta.costPriceProperty().get() != 0.0 && !this.stockItemSanta.isEdit) {
            this.stockItemSanta.isEdit = true;
            this.stockItemSanta.setParentCompany(this.mainPage.currentUser.getParentCompany());
            this.stockItem.stockItemPane.stockItemList.getOriginalList().add((Object)this.stockItemSanta);
            this.stockItem.s = this.stockItemSanta;
            this.stockItem.stockItemPane.vbRepeatingCntrl.getChildren().add((Object)this.stockItem);
            try {
                this.stockItem.stockItemPane.NewItem();
            }
            catch (Exception ex) {
                Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.validateControl()) {
            this.s.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
        }
    }

    private void loadImage() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extensionFilterJpg = new FileChooser.ExtensionFilter("JPG files (*.jpg)", new String[]{"*.JPG"});
        FileChooser.ExtensionFilter extensionFilterJpeg = new FileChooser.ExtensionFilter("JPEG files (*.jpeg)", new String[]{"*.JPEG"});
        FileChooser.ExtensionFilter extensionFilterPng = new FileChooser.ExtensionFilter("PNG files (*.png)", new String[]{"*.PNG"});
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{extensionFilterJpeg, extensionFilterJpg, extensionFilterPng});
        File file = fileChooser.showOpenDialog(null);
        if (file != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                this.image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
                this.logpfield.setImage(this.image);
            }
            catch (IOException ex) {
                Logger.getLogger(CompanyPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void reBind() {
        this.nameFld.textProperty().unbindBidirectional((Property)this.stockItemSanta.nameProperty());
        this.nameFld.textProperty().bindBidirectional((Property)this.stockItemSanta.nameProperty());
        this.makerFld.textProperty().unbindBidirectional((Property)this.stockItemSanta.makerProperty());
        this.makerFld.textProperty().bindBidirectional((Property)this.stockItemSanta.makerProperty());
        this.sizeFld.textProperty().unbindBidirectional((Property)this.stockItemSanta.sizeProperty());
        this.sizeFld.textProperty().bindBidirectional((Property)this.stockItemSanta.sizeProperty());
        this.typeFld.textProperty().unbindBidirectional((Property)this.stockItemSanta.typeProperty());
        this.typeFld.textProperty().bindBidirectional((Property)this.stockItemSanta.typeProperty());
        this.sellingPriceFld.textProperty().unbindBidirectional((Object)this.stockItemSanta.sellingPriceProperty());
        this.sellingPriceFld.textProperty().bindBidirectional((Property)this.stockItemSanta.sellingPriceProperty(), this.fconverter);
        this.costPriceFld.textProperty().unbindBidirectional((Object)this.stockItemSanta.costPriceProperty());
        this.costPriceFld.textProperty().bindBidirectional((Property)this.stockItemSanta.costPriceProperty(), this.fconverter);
        this.displayQtyFld.textProperty().unbindBidirectional((Property)this.stockItemSanta.displayQuantityProperty());
        this.displayQtyFld.textProperty().bindBidirectional((Property)this.stockItemSanta.displayQuantityProperty());
    }

    private void cancel() {
        if (this.stockItemSanta.vclone != null) {
            this.stockItemSanta = this.stockItemSanta.vclone.clone();
            this.stockItemSanta.vclone = this.stockItemSanta.clone();
            this.stockItemSanta.setParentCompany(this.mainPage.currentUser.getParentCompany());
            this.stockItemSanta.setState(ObjectState.Unchanged);
            this.reBind();
        }
        this.closeNotification();
        this.stockItem.stockItemPane.mainPage.hbCenter.setContent((Node)this.mainParent);
        this.stockItem.stockItemPane.closeNotification();
    }

    public void DoneItem() throws Exception {
        if (this.stockItemSanta.nameProperty().get() != null && this.stockItemSanta.itemCodeProperty().get() != null && this.stockItemSanta.costPriceProperty().get() != 0.0 && !this.stockItemSanta.isEdit) {
            this.stockItemSanta.isEdit = true;
            this.stockItem.stockItemPane.stockItemList.getOriginalList().add((Object)this.stockItemSanta);
            StockItemContainer st = new StockItemContainer(this.stockItemSanta, this.stockItem.stockItemPane);
            this.stockItem.stockItemPane.vbRepeatingCntrl.getChildren().add((Object)st);
        } else if (!this.validateControl()) {
            this.stockItem.stockItemPane.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
        }
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        if (this.nameFld.getText() == null || this.nameFld.getText().trim().isEmpty()) {
            this.errorMessage = this.errorMessage + "Item Name must not be empty\n";
        }
        if (this.barCodeFld.getText() == null || this.barCodeFld.getText().trim().isEmpty()) {
            this.errorMessage = this.errorMessage + "Barcode must not be empty\n";
        }
        if (this.costPriceFld.getText() == null) {
            this.errorMessage = this.errorMessage + "cost price must not be empty\n";
        }
        if ((this.costPriceFld.getText() != null || this.sellingPriceFld.getText() != null) && Double.valueOf(this.costPriceFld.getText()) > Double.valueOf(this.sellingPriceFld.getText())) {
            this.errorMessage = this.errorMessage + "Cost Price must not greater than Selling Price ";
        }
        return this.errorMessage.equals("");
    }

    @Override
    void completeControl() {
        try {
            this.DoneItem();
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

