/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.ui.Customer;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SaleListItem;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesPaneB2B;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;

public class SearchCustomerPane
extends UIParent {
    @FXML
    private TableColumn<com.xputertechnologies.santa.Customer, String> addressColumn;
    @FXML
    private TableColumn<com.xputertechnologies.santa.Customer, String> nameColumn;
    @FXML
    private TableColumn<com.xputertechnologies.santa.Customer, String> emailColumn;
    @FXML
    private TableColumn<com.xputertechnologies.santa.Customer, String> pnumColumn;
    @FXML
    private Button searchBtn;
    @FXML
    private Button btnAdd;
    @FXML
    private TextField searchBox;
    @FXML
    private Button btnNewCustomer;
    @FXML
    private TableView<com.xputertechnologies.santa.Customer> tableCustomer;

    public SearchCustomerPane(final ISalePane sp, String seaString) {
        super("SearchCustomerPane.fxml", sp.getSanta());
        if (seaString != null) {
            this.populateSearch(seaString);
        }
        this.searchBtn.setOnAction(event -> sp.searchCustomer(this.searchBox.getText()));
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.searchBox, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                SearchCustomerPane.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        autoCompletionBinding.setPrefWidth(340.0);
        this.tableCustomer.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                if (SearchCustomerPane.this.tableCustomer.getSelectionModel().getSelectedItem() != null) {
                    sp.getSale().setParentCustomer((com.xputertechnologies.santa.Customer)SearchCustomerPane.this.tableCustomer.getSelectionModel().getSelectedItem());
                    if (SearchCustomerPane.this.tableCustomer.getItems().size() == 1) {
                        Sale newSale = new Sale(SearchCustomerPane.this.da);
                        if (sp.getPendingSale().getSales().stream().filter(x -> x.getDescription().equals("New Sale")).findAny().orElse(null) == null) {
                            sp.getPendingSale().getSales().add((Object)newSale);
                            sp.getHbSales().getChildren().add((Object)new SaleListItem(newSale, sp, false));
                        }
                        sp.getDialog().close();
                    }
                }
            }
        });
        this.addressColumn.setCellValueFactory((Callback)new PropertyValueFactory("address"));
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.emailColumn.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.pnumColumn.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.btnAdd.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.WHITE).size(20.0));
        this.btnAdd.setOnAction(event -> {
            if (this.tableCustomer.getSelectionModel().getSelectedItem() != null) {
                Sale newSale = new Sale(this.da);
                if (sp.getPendingSale().getSales().stream().filter(x -> x.getDescription().equals("New Sale")).findAny().orElse(null) == null) {
                    sp.getPendingSale().getSales().add((Object)newSale);
                    sp.getHbSales().getChildren().add((Object)new SaleListItem(newSale, sp, false));
                }
                sp.getDialog().close();
            } else {
                sp.getMainPage().showNotification(NotificationType.Error, "please select customer or create new customer", sp instanceof SalesPane ? (SalesPane)sp : (SalesPaneB2B)sp);
            }
        });
        this.btnNewCustomer.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS_CIRCLE).color(Color.WHITE).size(20.0));
        this.btnNewCustomer.setOnAction(event -> {
            try {
                sp.getDialog().setTitle("New Customer");
                sp.getDialog().getDialogPane().setContent((Node)new Customer(null, sp, new com.xputertechnologies.santa.Customer(this.da)));
            }
            catch (Exception ex) {
                Logger.getLogger(SearchCustomerPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    @Override
    public void populateSearch(String SearchValue) {
        this.tableCustomer.setItems(com.xputertechnologies.santa.Customer.SearchCustomers(SearchValue, this.da).getOriginalList());
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return CustomerDataList.selectAutoComplete(searchString, this.da);
        }
        catch (SQLException ex) {
            Logger.getLogger(SearchCustomerPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }
}

