/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.SalesReturnPane;
import com.xputertechnologies.santa.ui.UIControlBase;
import java.util.ArrayList;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.util.StringConverter;
import javafx.util.converter.FloatStringConverter;

public class SalesReturnItem
extends UIControlBase {
    @FXML
    private Label QtyBoughtTF;
    @FXML
    private DecimalNumberTextBox QtyReturnTF;
    @FXML
    private Label lblTotalQtyBought;
    @FXML
    private Label lblDescription;
    @FXML
    private Label qtrlbl;
    @FXML
    private Label lblPrice;
    @FXML
    private Label stockId;
    @FXML
    private Label naira;
    @FXML
    private Label ReturnedQtyLabel;
    private UnitDataList unitDataList;
    private static DataAccess da;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    StringConverter<? extends Number> fConverter = new FloatStringConverter();
    private SaleItem saleItem;

    public SaleItem getSaleItem() {
        return this.saleItem;
    }

    public SalesReturnItem(final SaleItem saleItem, DataAccess da, SalesReturnPane salesReturnPane) {
        this.saleItem = saleItem;
        this.lblDescription.setText(saleItem.getParentStockItem().getName() + " (" + saleItem.getParentStockItem().getType() + ")");
        this.naira.setText(General.toNaira());
        this.ReturnedQtyLabel.textProperty().bindBidirectional((Property)saleItem.returnDisplayQuantityProperty());
        this.lblPrice.setText(General.formatDecimalToMoneyString(saleItem.getSellingPrice()));
        this.stockId.setText(saleItem.getParentStockItem().getItemCode());
        this.lblTotalQtyBought.textProperty().bindBidirectional((Property)saleItem.totalQuantityBoughtProperty());
        this.QtyBoughtTF.textProperty().bindBidirectional((Property)saleItem.quantityBoughtProperty());
        this.QtyReturnTF.textProperty().bindBidirectional((Property)saleItem.qtyToreturnQtyProperty(), this.fConverter);
        this.QtyReturnTF.setVisible(false);
        this.QtyReturnTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (Float.valueOf(SalesReturnItem.this.QtyReturnTF.getText()).floatValue() > saleItem.getQuantity()) {
                    SalesReturnItem.this.QtyReturnTF.setText(String.valueOf(saleItem.getQuantity()));
                }
            }
        });
    }
}

