/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.CustomerPayment;
import com.xputertechnologies.santa.Employee;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.ISaleCallBack;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.ManualPendingStatus;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.PendingSales;
import com.xputertechnologies.santa.RequestTypeEnum;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleItemSerial;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.core.NotEnoughQtyException;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.list.CustomerPaymentDataList;
import com.xputertechnologies.santa.list.EmployeeDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.AccountDetailItemPane;
import com.xputertechnologies.santa.ui.AnimationEnum;
import com.xputertechnologies.santa.ui.DlgInterface;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PaymentOptionPane;
import com.xputertechnologies.santa.ui.PendingManualSaleItem;
import com.xputertechnologies.santa.ui.PromoVoucher;
import com.xputertechnologies.santa.ui.PromptDialog;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.SaleItem;
import com.xputertechnologies.santa.ui.SaleItemCart;
import com.xputertechnologies.santa.ui.SaleListItem;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SearchCustomerPane;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SalesPane
extends UIParent
implements ISalePane {
    @FXML
    public StackPane stackPane;
    @FXML
    public VBox RepeatingVB;
    @FXML
    public VBox RepeatingVBAdded;
    @FXML
    private JFXButton btnUpload;
    @FXML
    private JFXButton brnRemoveUpload;
    @FXML
    private JFXButton btnViewUplaod;
    @FXML
    private TextField SearchTextField;
    @FXML
    private TextField cbSalesResponsible;
    VBox progressContainer;
    @FXML
    private JFXTextField tbCreditToken;
    @FXML
    private JFXComboBox<String> cbCreditSale;
    @FXML
    JFXComboBox<NameValueObject> cbPaymentTerm;
    @FXML
    private Label TotalAmtTF;
    @FXML
    private Label nairaTotal;
    @FXML
    public HBox hbSales;
    @FXML
    public HBox searchHbdivider;
    @FXML
    public HBox hbUpload;
    @FXML
    public HBox hbPayTerm;
    @FXML
    private Button MakeSaleButton;
    @FXML
    private JFXButton btnSMS;
    @FXML
    private ScrollPane container;
    @FXML
    private TextArea txtComment;
    @FXML
    public JFXListView<Sale> listManualSales;
    private SaleItem saleItemUI;
    public Sale sale;
    public StockItemList stockItemList;
    public StockItemList cartStockItemList;
    private CustomerDataList customerDataList;
    private CustomerPayment customerPayment;
    private CustomerPaymentDataList cpdl;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    StringConverter<? extends Number> fConverter = new FloatStringConverter();
    StringConverter<? extends Number> dConverter = new DoubleStringConverter();
    public PendingSales pendingSales;
    AccountDetailDataList lst;
    public Dialog dialog;
    ObservableList<NameValueObject> channnels = FXCollections.observableArrayList();
    ObservableList<NameValueObject> paymentTerms = FXCollections.observableArrayList();
    final String CHEQUE_TEXT = "Upload Cheque";
    EmployeeDataList salesResponsibles;
    boolean isResetSale = false;
    Double keepAmnthPaid = 0.0;

    public SalesPane(Santa app) throws Exception {
        super("SalesPane.fxml", app);
        this.title = "Sale Page";
        this.sale = new Sale(this.da);
        this.btnViewUplaod.setVisible(false);
        this.brnRemoveUpload.setVisible(false);
        this.btnUpload.setOnAction(eh -> this.uploadImage());
        List<NameValueObject> paymentModes = StockItemList.selectAllNameValue(this.da, "PaymentTerm", "PaymentTerm", "Description");
        ObservableList obPT = FXCollections.observableArrayList(paymentModes);
        this.cbPaymentTerm.setItems(obPT);
        this.btnUpload.setText("Upload Cheque");
        this.btnViewUplaod.setOnAction(eh -> {
            FlowPane bp = new FlowPane();
            bp.setOrientation(Orientation.VERTICAL);
            this.sale.img.forEach(im -> {
                ImageView imgView = new ImageView();
                imgView.setFitWidth(300.0);
                imgView.setFitHeight(300.0);
                imgView.setPreserveRatio(true);
                imgView.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)im, null));
                bp.getChildren().add((Object)imgView);
            });
            this.dialog = new Dialog();
            this.dialog.initStyle(StageStyle.DECORATED);
            this.dialog.initOwner((Window)this.santa.stage);
            this.dialog.setTitle("Upload Cheque");
            this.dialog.setResizable(true);
            this.dialog.getDialogPane().setContent((Node)bp);
            this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
            this.dialog.show();
        });
        this.cbSalesResponsible.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.isEmpty() && !this.sale.saleCreated) {
                this.sale.setSalesRep("");
            }
        });
        this.brnRemoveUpload.setOnAction(eh -> {
            this.sale.img = null;
            this.brnRemoveUpload.setVisible(false);
            this.btnViewUplaod.setVisible(false);
            this.btnUpload.setText("Upload Cheque");
        });
        this.stockItemList = new StockItemList(this.da);
        this.customerDataList = new CustomerDataList(this.da);
        this.cpdl = new CustomerPaymentDataList(this.da);
        this.customerPayment = new CustomerPayment(this.da);
        this.nairaTotal.setText(General.toNaira());
        this.channnels.addAll(StockItemList.selectAllChannels(this.da));
        this.mainPage.manualSaleList.getOriginalList().forEach(s -> {
            s.setAllowClose(true);
            s.saleCreated = true;
            s.setDescription(s.getCustomerName());
            s.getSaleItemsList().forEach(si -> si.setVariablePrice(si.getSellingPrice()));
        });
        this.btnSMS.setOnAction(eh -> this.sendSMS());
        this.cbCreditSale.setItems(General.getCredits());
        this.cbCreditSale.getSelectionModel().select(0);
        this.tbCreditToken.setVisible(this.cbCreditSale.getSelectionModel().getSelectedIndex() != 0);
        this.hbPayTerm.setVisible(false);
        this.cbPaymentTerm.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    SalesPane.this.sale.setPaymentTerm(newValue.getKey());
                    SalesPane.this.sale.setPaymentTermDescription(newValue.getData());
                }
            }
        });
        this.cbCreditSale.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.equals("No Credit")) {
                    if (newValue.equals("Others")) {
                        SalesPane.this.tbCreditToken.setVisible(false);
                        SalesPane.this.hbPayTerm.setVisible(true);
                    } else {
                        SalesPane.this.tbCreditToken.setVisible(true);
                        SalesPane.this.hbPayTerm.setVisible(false);
                        SalesPane.this.cbPaymentTerm.getSelectionModel().clearSelection();
                        SalesPane.this.sale.setPaymentTerm("");
                        SalesPane.this.sale.setPaymentTermDescription("");
                    }
                    SalesPane.this.sale.setIsManual(true);
                } else {
                    SalesPane.this.hbPayTerm.setVisible(false);
                    SalesPane.this.tbCreditToken.clear();
                    SalesPane.this.tbCreditToken.setVisible(false);
                    SalesPane.this.cbPaymentTerm.getSelectionModel().clearSelection();
                    SalesPane.this.sale.setPaymentTerm("");
                    SalesPane.this.sale.setPaymentTermDescription("");
                    if (SalesPane.this.sale.getSaleItemsList().stream().anyMatch(prdct -> prdct.getIsManual())) {
                        SalesPane.this.sale.setIsManual(true);
                    } else {
                        SalesPane.this.sale.setIsManual(false);
                    }
                }
            }
        });
        this.SearchTextField.requestFocus();
        this.pendingSales = new PendingSales();
        this.pendingSales.getSales().add((Object)this.sale);
        this.hbSales.getChildren().add((Object)new SaleListItem(this.sale, this, false));
        this.TotalAmtTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.isEmpty()) {
                    SalesPane.this.sale.amountPaidProperty().set(Double.valueOf(newValue.replace(",", "")).doubleValue());
                }
            }
        });
        this.txtComment.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.isEmpty()) {
                    SalesPane.this.sale.setSaleComment(newValue);
                }
            }
        });
        this.customerDataList.SelectAll();
        AutoCompletionBinding autoCompletionBindingSalesRes = TextFields.bindAutoCompletion((TextField)this.cbSalesResponsible, t -> {
            List<Employee> result = this.searchDataSalesRep(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBindingSalesRes.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<Employee>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<Employee> event) {
                SalesPane.this.sale.setSalesRep(((Employee)event.getCompletion()).getEmpName() + "(" + ((Employee)event.getCompletion()).getEmpId() + ")");
            }
        });
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTextField, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                SalesPane.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        autoCompletionBinding.setPrefWidth(550.0);
        this.MakeSaleButton.setOnAction(ev -> {
            try {
                if (this.sale.saleCreated) {
                    this.mainPage.showNotification(NotificationType.Information, "Sale requires approval", this);
                } else {
                    this.makeSale();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
        this.TotalAmtTF.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(20));
        General.selectAll(this.SearchTextField);
        this.SearchTextField.setOnAction(v -> {
            this.sale.manualEnt = false;
            String saleMode = this.currentUser.getParentCompany().getSalesMode();
            this.stockItemList.searPrecise(this.SearchTextField.getText());
            if (this.stockItemList.getOriginalList().size() > 0) {
                if (this.getCartStockItemList() == null) {
                    this.setCartStockItemList(new StockItemList(this.da));
                }
                com.xputertechnologies.santa.SaleItem saleItem1 = this.sale.getSaleItemsList().stream().filter(si -> si.getParentStockItem().getItemCode().equals(((StockItem)this.stockItemList.getOriginalList().get(0)).getItemCode())).findAny().orElse(null);
                if (((StockItem)this.stockItemList.getOriginalList().get(0)).getQuantity() > 0.0f) {
                    if (saleItem1 == null) {
                        com.xputertechnologies.santa.SaleItem saleItem2 = ((com.xputertechnologies.santa.SaleItem)this.sale.getSaleItems(this.stockItemList.getOriginalList()).get(0)).duplicate();
                        this.sale.getSaleItemsList().add(this.sale.getSaleItemsList().size(), (Object)saleItem2);
                        this.getRepeatingVBAdded().getChildren().add((Object)new SaleItemCart(saleItem2, this));
                    } else {
                        SaleItemCart cart = this.getRepeatingVBAdded().getChildren().stream().filter(cat -> ((SaleItemCart)cat).saleItem.getParentStockItem().getItemCode().equals(saleItem1.getParentStockItem().getItemCode())).findAny().orElse(null);
                        if (cart.saleItem.getQuantity() + 1.0f <= ((StockItem)this.stockItemList.getOriginalList().get(0)).getQuantity()) {
                            cart.saleItem.setQuantity(cart.saleItem.getQuantity() + 1.0f);
                        } else {
                            this.mainPage.showNotification(NotificationType.Information, "Not enough quantity to add for item " + this.SearchTextField.getText(), this);
                        }
                    }
                } else {
                    this.mainPage.showNotification(NotificationType.Information, "Not enough quantity to add for item " + this.SearchTextField.getText(), this);
                }
            } else {
                this.mainPage.showNotification(NotificationType.Information, "No item found for " + this.SearchTextField.getText(), this);
            }
            this.SearchTextField.clear();
            this.SearchTextField.requestFocus();
        });
        this.listManualSales.setItems(this.mainPage.manualSaleList.getOriginalList());
        this.listManualSales.setCellFactory((Callback)new Callback<ListView<Sale>, ListCell<Sale>>(){

            public ListCell<Sale> call(ListView<Sale> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<Sale> cell = new ListCell<Sale>(){

                    public void updateItem(Sale s, boolean empty) {
                        super.updateItem((Object)s, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            PendingManualSaleItem node = new PendingManualSaleItem(SalesPane.this.santa, s, SalesPane.this);
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)node);
                        }
                    }
                };
                return cell;
            }
        });
        final SalesPane sp = this;
        this.listManualSales.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Sale>(){

            public void changed(ObservableValue<? extends Sale> observable, Sale oldValue, Sale newValue) {
                if (newValue != null && SalesPane.this.hbSales.getChildren().stream().filter(s -> s.getClass() == SaleListItem.class && ((SaleListItem)s).sale.getInvoiceNumber() == newValue.getInvoiceNumber()).count() == 0L) {
                    SalesPane.this.sale = newValue;
                    SalesPane.this.hbSales.getChildren().add((Object)new SaleListItem(SalesPane.this.sale, sp, true));
                    SalesPane.this.saleSelectionChanged();
                }
            }
        });
    }

    static BufferedImage resizeImage(BufferedImage originalImage, int type) {
        int IMG_WIDTH = 200;
        int IMG_CLAHEIGHT = 200;
        BufferedImage resizedImage = new BufferedImage(IMG_WIDTH, IMG_CLAHEIGHT, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, IMG_WIDTH, IMG_CLAHEIGHT, null);
        g.dispose();
        return resizedImage;
    }

    void uploadImage() {
        FileChooser fc = new FileChooser();
        FileChooser.ExtensionFilter ext1 = new FileChooser.ExtensionFilter("JPG files(*.jpg)", new String[]{"*.JPG"});
        FileChooser.ExtensionFilter ext2 = new FileChooser.ExtensionFilter("PNG files(*.png)", new String[]{"*.PNG"});
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{ext1, ext2});
        List files = fc.showOpenMultipleDialog((Window)this.santa.stage);
        try {
            this.sale.img.clear();
            for (File file : files) {
                BufferedImage bf = ImageIO.read(file);
                int type = bf.getType() == 0 ? 2 : bf.getType();
                bf = SalesPane.resizeImage(bf, type);
                this.sale.img.add(bf);
                this.btnViewUplaod.setVisible(true);
                this.brnRemoveUpload.setVisible(true);
                this.btnUpload.setText("Edit Cheque");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendSMS() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(SalesPane.this.santa, SalesPane.this.da, SalesPane.this.santa.currentUser.getParentCompany());
                        syncData.sendSMS("", new IDBEntity<String>(){

                            @Override
                            public void onError(String data) {
                                SalesPane.this.mainPage.showNotification(NotificationType.Error, data, SalesPane.this);
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                SalesPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", SalesPane.this);
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onSuccess(ObservableList<String> data) {
                                SalesPane.this.mainPage.showNotification(NotificationType.Success, "Message Sent", SalesPane.this);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void resendManualSaleMail(final Sale s) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(SalesPane.this.santa, SalesPane.this.da, SalesPane.this.santa.currentUser.getParentCompany());
                        syncData.resendManualSaleMail(SalesPane.this.currentUser.getParentCompany().getStoreCode(), s.getHdInvoiceNo(), new IDBEntity<String>(){

                            @Override
                            public void onError(String data) {
                                SalesPane.this.mainPage.showNotification(NotificationType.Error, data, SalesPane.this);
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                SalesPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", SalesPane.this);
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onSuccess(ObservableList<String> data) {
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                                SalesPane.this.mainPage.showNotification(NotificationType.Success, "Sale with invoice number " + s.getHdInvoiceNo() + " resent for approval", SalesPane.this);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void removeSale(final PendingManualSaleItem pm) {
        new PromptDialog(this.santa, "Remove Sale", "Are you sure you want to delete this sale? ", this.stackPane, new DlgInterface(){

            @Override
            public void ok() {
                try {
                    pm.sale.setSaleComment(SalesPane.this.currentUser.getUserName() + " removed sale");
                    pm.sale.setSaleStatus(SaleStatus.CANCELLED.name());
                    pm.sale.setSyncFlag(true);
                    pm.sale.setManualSaleStatus(ManualPendingStatus.Completed.name());
                    SalesPane.this.saveAndRemove(pm);
                }
                catch (Exception ex) {
                    SalesPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesPane.this);
                }
            }

            @Override
            public void cancel() {
            }
        });
    }

    private void searchSerial() {
        this.sale.manualEnt = false;
        String saleMode = this.currentUser.getParentCompany().getSalesMode();
        this.stockItemList.selectWithSerial(this.SearchTextField.getText());
        if (this.stockItemList.getOriginalList().size() > 0) {
            com.xputertechnologies.santa.SaleItem saleItem1;
            if (this.getCartStockItemList() == null) {
                this.setCartStockItemList(new StockItemList(this.da));
            }
            if ((saleItem1 = (com.xputertechnologies.santa.SaleItem)this.sale.getSaleItemsList().stream().filter(si -> si.getParentStockItem().getItemCode().equals(((StockItem)this.stockItemList.getOriginalList().get(0)).getItemCode())).findAny().orElse(null)) == null) {
                com.xputertechnologies.santa.SaleItem saleItem2 = ((com.xputertechnologies.santa.SaleItem)this.sale.getSaleItems(this.stockItemList.getOriginalList()).get(0)).duplicate();
                SaleItemSerial serial = new SaleItemSerial(this.da);
                serial.setItemCode(saleItem2.getItemCode());
                serial.setQuantity(1);
                serial.setSaleItemCode(saleItem2.getCode());
                serial.setStatus(((StockItem)this.stockItemList.getOriginalList().get((int)0)).status);
                serial.setSysSerial(((StockItem)this.stockItemList.getOriginalList().get((int)0)).sysSerial);
                serial.setWhscode(((StockItem)this.stockItemList.getOriginalList().get((int)0)).whsCode);
                if (serial.getWhscode().equals("02")) {
                    serial.cnsProperty().set(true);
                } else if (serial.getWhscode().equals("07")) {
                    serial.dspProperty().set(true);
                } else {
                    serial.actProperty().set(true);
                }
                serial.setSerial(((StockItem)this.stockItemList.getOriginalList().get((int)0)).serial);
                saleItem2.getSerials().getOriginalList().add((Object)serial);
                this.sale.getSaleItemsList().add(this.sale.getSaleItemsList().size(), (Object)saleItem2);
                this.getRepeatingVBAdded().getChildren().add((Object)new SaleItemCart(saleItem2, this));
            } else {
                SaleItemCart cart = this.getRepeatingVBAdded().getChildren().stream().filter(cat -> ((SaleItemCart)cat).saleItem.getParentStockItem().getItemCode().equals(saleItem1.getParentStockItem().getItemCode())).findAny().orElse(null);
                if (cart.saleItem.getSerials().getOriginalList().stream().filter(p -> p.getSerial().equals(((StockItem)this.stockItemList.getOriginalList().get((int)0)).serial)).findAny().orElse(null) == null) {
                    SaleItemSerial serial = new SaleItemSerial(this.da);
                    serial.setItemCode(cart.saleItem.getItemCode());
                    serial.setQuantity(1);
                    serial.setSaleItemCode(cart.saleItem.getCode());
                    serial.setStatus(((StockItem)this.stockItemList.getOriginalList().get((int)0)).status);
                    serial.setSysSerial(((StockItem)this.stockItemList.getOriginalList().get((int)0)).sysSerial);
                    serial.setWhscode(((StockItem)this.stockItemList.getOriginalList().get((int)0)).whsCode);
                    serial.setSerial(((StockItem)this.stockItemList.getOriginalList().get((int)0)).serial);
                    if (serial.getWhscode().equals("02")) {
                        serial.cnsProperty().set(true);
                    } else if (serial.getWhscode().equals("07")) {
                        serial.dspProperty().set(true);
                    } else {
                        serial.actProperty().set(true);
                    }
                    cart.saleItem.getSerials().getOriginalList().add((Object)serial);
                    cart.saleItem.setQuantity(cart.saleItem.getQuantity() + 1.0f);
                } else {
                    this.mainPage.showNotification(NotificationType.Information, "Item with the same serial " + this.SearchTextField.getText() + " already exist", this);
                }
            }
        } else {
            this.mainPage.showNotification(NotificationType.Information, "No item found for " + this.SearchTextField.getText(), this);
        }
        this.SearchTextField.clear();
        this.SearchTextField.requestFocus();
    }

    public void searchAll() {
        this.populateSearch("");
    }

    @Override
    public void populateSearch(String SearchValue) {
        this.sale.manualEnt = false;
        String saleMode = this.currentUser.getParentCompany().getSalesMode();
        if (SearchValue.isEmpty()) {
            this.stockItemList.selectAll("Select * From StockItem", this.da.getEmptyParameterValues());
        } else {
            this.stockItemList = StockItem.searchStock(SearchValue, this.da);
        }
        this.RepeatingVB.getChildren().clear();
        ArrayList<SaleItem> children = new ArrayList<SaleItem>();
        if (this.stockItemList.getOriginalList().size() > 0) {
            this.RepeatingVB.getChildren().clear();
            ObservableList<com.xputertechnologies.santa.SaleItem> saleItemsss = this.sale.getSaleItems(this.stockItemList.getOriginalList());
            for (com.xputertechnologies.santa.SaleItem saleItem : saleItemsss) {
                saleItem.hasQtyProperty().set(saleItem.getParentStockItem().getQuantity() > 0.0f);
                int serial = this.sale.getSaleItems(this.stockItemList.getOriginalList()).indexOf((Object)saleItem) + 1;
                this.saleItemUI = new SaleItem(saleItem, this, saleMode, serial);
                Santa.setAnimation((Region)this.saleItemUI, (Region)this.RepeatingVB, AnimationEnum.BOTOM);
                children.add(this.saleItemUI);
            }
            this.RepeatingVB.getChildren().addAll(children);
        } else {
            this.mainPage.showNotification(NotificationType.Information, "No item found", this);
        }
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return StockItemList.selectAutoComplete(searchString, this.da, false);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    public List<Employee> searchDataSalesRep(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<Employee>();
        }
        try {
            EmployeeDataList salesRep = new EmployeeDataList(this.da);
            return EmployeeDataList.selectAutoCompleteSalesRep(searchString, this.da, false);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<Employee>();
        }
    }

    @Override
    public void saleSelectionChanged() {
        if (this.hbSales.getChildren().size() > 2 || this.sale.saleCreated) {
            this.TotalAmtTF.textProperty().unbind();
            this.RepeatingVB.getChildren().clear();
            this.RepeatingVBAdded.getChildren().clear();
            this.txtComment.setText(this.sale.getSaleComment());
            this.sale.isMakingSale = false;
            this.hbPayTerm.setVisible(false);
            this.tbCreditToken.setVisible(false);
            this.cbSalesResponsible.setText(this.sale.getSalesRep());
            for (com.xputertechnologies.santa.SaleItem saleItem : this.sale.getSaleItemsList()) {
                this.RepeatingVBAdded.getChildren().add((Object)new SaleItemCart(saleItem, this));
            }
            if (!this.sale.getPaymentTerm().isEmpty()) {
                this.hbPayTerm.setVisible(true);
                this.cbPaymentTerm.getSelectionModel().select((Object)this.cbPaymentTerm.getItems().stream().filter(prdct -> prdct.getKey().equals(this.sale.getPaymentTerm())).findAny().orElse(null));
            }
            if (!this.sale.getCreditToken().isEmpty()) {
                this.tbCreditToken.setVisible(true);
                this.tbCreditToken.setText(this.sale.getCreditToken());
                this.cbCreditSale.getSelectionModel().select((Object)this.cbCreditSale.getItems().stream().filter(prdct -> prdct.equals(this.sale.getCreditDescription())).findAny().orElse(null));
            } else {
                this.cbCreditSale.getSelectionModel().select(0);
            }
            this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
            if (this.sale.saleCreated) {
                this.txtComment.setEditable(false);
                this.cbSalesResponsible.setEditable(false);
            } else {
                this.txtComment.setEditable(true);
                this.cbSalesResponsible.setEditable(true);
            }
        }
    }

    @FXML
    private void SearchButtonOnAction(ActionEvent event) {
        if (!this.SearchTextField.getText().isEmpty()) {
            this.populateSearch(this.SearchTextField.getText());
        }
    }

    public void saveAndRemove(PendingManualSaleItem pm) {
        try {
            pm.sale.setState(ObjectState.Changed);
            SaleList sl = new SaleList(this.da);
            sl.getOriginalList().add((Object)pm.sale);
            sl.update();
            this.mainPage.manualSaleList.getOriginalList().remove((Object)pm.sale);
            this.listManualSales.refresh();
            this.resetSale();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pushSale(final Sale s) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(SalesPane.this.santa, SalesPane.this.da, SalesPane.this.santa.currentUser.getParentCompany());
                        syncData.pushSales(null, s, "salesorder/createSalesorder", new IWebCallBack(){

                            @Override
                            public void onSuccess(String data) {
                                try {
                                    s.setManualSaleStatus(ManualPendingStatus.Pending.name());
                                    s.setState(ObjectState.Changed);
                                    SaleList saleList = new SaleList(SalesPane.this.da);
                                    saleList.getOriginalList().add((Object)s);
                                    saleList.update();
                                    SalesPane.this.listManualSales.refresh();
                                    SalesPane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", SalesPane.this);
                                    SalesPane.this.stackPane.getChildren().remove((Object)box);
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }

                            @Override
                            public void onError(String data) {
                                SalesPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPane.this);
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                SalesPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPane.this);
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void loadSale(final Sale s) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        try {
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            SyncData syncData = new SyncData(SalesPane.this.santa, SalesPane.this.da, SalesPane.this.santa.currentUser.getParentCompany());
                            JSONObject jSONObject = new JSONObject().put("storeId", (Object)s.getStoreCode().trim()).put("invoiceNumber", (Object)String.valueOf(s.getInvoiceNumber()));
                            String url = "salesorder/getSalesorder?condition=" + jSONObject.toString();
                            syncData.getSale(url, SalesPane.this.da, new ISaleCallBack(){

                                @Override
                                public void onSuccess(SaleList data) {
                                    SalesPane.this.stackPane.getChildren().remove((Object)box);
                                    if (data.getOriginalList().size() > 0) {
                                        SalesPane.this.replaceManualSaleAndUpdate(s, (Sale)data.getOriginalList().get(0));
                                    } else {
                                        SalesPane.this.mainPage.showNotification(NotificationType.Information, String.valueOf(s.getInvoiceNumber()) + " not found", SalesPane.this);
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    SalesPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPane.this);
                                    SalesPane.this.stackPane.getChildren().remove((Object)box);
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    SalesPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPane.this);
                                    SalesPane.this.stackPane.getChildren().remove((Object)box);
                                }
                            });
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        }
        catch (Exception ex) {
            this.stackPane.getChildren().remove((Object)box);
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void replaceManualSaleAndUpdate(Sale OldSale, Sale newSale) {
        try {
            OldSale.setApprovals(newSale.getApprovals());
            OldSale.setSalesRejectedBy(newSale.getSalesRejectedBy());
            OldSale.setSaleId(newSale.getSaleId());
            OldSale.setManualSaleStatus(newSale.getManualSaleStatus());
            OldSale.setSaleStatus(newSale.getSaleStatus());
            OldSale.setSyncFlag(newSale.getSyncFlag());
            OldSale.setState(ObjectState.Changed);
            SaleList saleList = new SaleList(this.da);
            saleList.getOriginalList().add((Object)OldSale);
            saleList.update();
            ArrayList<Sale> arr = new ArrayList<Sale>();
            arr.add(OldSale);
            this.mainPage.updateSalesList(arr);
            this.listManualSales.refresh();
        }
        catch (Exception ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void ValidateVoucher(final String code) {
        this.dialog.close();
        this.sale.setPromoVoucherAmt(0.0);
        this.sale.setPromoVoucher("");
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            new WebRequest(WebRequest.VALIDATE_PROMOVOUCHER + "/" + code, RequestTypeEnum.GET, null, null, new IWebCallBack(){

                                @Override
                                public void onSuccess(String data) {
                                    try {
                                        JSONArray ra = new JSONArray(data);
                                        if (ra.length() > 0) {
                                            System.out.println("JSon " + ra.toString());
                                            SalesPane.this.sale.setPromoVoucherAmt(ra.getJSONObject(0).getDouble("promoVoucherAmt"));
                                            SalesPane.this.sale.setPromoVoucher(ra.getJSONObject(0).getString("code"));
                                            SalesPane.this.sale.minAmount = ra.getJSONObject(0).getDouble("minAmt");
                                            Platform.runLater(() -> {
                                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                                                if (SalesPane.this.sale.getAmountPaid() >= SalesPane.this.sale.minAmount) {
                                                    SalesPane.this.showPayment(true);
                                                } else {
                                                    SalesPane.this.sale.setPromoVoucherAmt(0.0);
                                                    SalesPane.this.sale.setPromoVoucher("");
                                                    SalesPane.this.mainPage.showNotification(NotificationType.Error, "Sorry,voucher applicable to sale of " + General.toNaira() + General.formatDecimalToMoneyString(SalesPane.this.sale.minAmount) + " and above", SalesPane.this);
                                                    SalesPane.this.showPayment(false);
                                                }
                                            });
                                        } else {
                                            Platform.runLater(() -> {
                                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                                                SalesPane.this.mainPage.showNotification(NotificationType.Error, "Invalid Voucher", SalesPane.this);
                                                SalesPane.this.showPayment(false);
                                            });
                                        }
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(PromoVoucher.class.getName()).log(Level.SEVERE, null, ex);
                                        Platform.runLater(() -> {
                                            SalesPane.this.showPayment(false);
                                            SalesPane.this.stackPane.getChildren().remove((Object)box);
                                            SalesPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesPane.this);
                                        });
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        SalesPane.this.showPayment(false);
                                        SalesPane.this.stackPane.getChildren().remove((Object)box);
                                        SalesPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPane.this);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        SalesPane.this.showPayment(false);
                                        SalesPane.this.stackPane.getChildren().remove((Object)box);
                                        SalesPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPane.this);
                                    });
                                }
                            }).execute(false);
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                SalesPane.this.showPayment(false);
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                                SalesPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), SalesPane.this);
                                Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    @Override
    public void MarkVoucherUsed() {
        try {
            int val = SaleList.selectLastInvoiceNumber(this.da);
            val = val > 0 ? ++val : this.currentUser.getParentCompany().getLastInvoiceNumber() + 1;
            JSONObject json = new JSONObject().put("invoiceNumber", val).put("dateUsed", (Object)new Timestamp(new Date().getTime())).put("isUsed", true).put("code", (Object)this.sale.getPromoVoucher()).put("storeName", (Object)this.currentUser.getParentCompany().getStoreName()).put("customerName", (Object)this.sale.getParentCustomer().getName()).put("customerCode", (Object)this.sale.getParentCustomer().getPhoneNumber()).put("storeUser", (Object)this.currentUser.getUserName());
            new WebRequest(WebRequest.MARK_PROMOVOUCHER, RequestTypeEnum.PUT, json.toString(), null, new IWebCallBack(){

                @Override
                public void onSuccess(String data) {
                    Platform.runLater(() -> SalesPane.this.done(1));
                }

                @Override
                public void onError(String data) {
                    Platform.runLater(() -> SalesPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPane.this));
                }

                @Override
                public void onTimeOut(String data) {
                    Platform.runLater(() -> SalesPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPane.this));
                }
            }).execute(false);
        }
        catch (Exception ex) {
            Platform.runLater(() -> {
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            });
        }
    }

    @Override
    public void resetSale() {
        this.cbPaymentTerm.getSelectionModel().select(-1);
        this.hbPayTerm.setVisible(false);
        this.brnRemoveUpload.setVisible(false);
        this.btnViewUplaod.setVisible(false);
        this.btnUpload.setText("Upload Cheque");
        this.RepeatingVBAdded.getChildren().clear();
        if (this.pendingSales.getSales().stream().filter(x -> x.getDescription().equals("New Sale")).findAny().orElse(null) == null) {
            this.sale = new Sale(this.da);
            this.pendingSales.getSales().add((Object)this.sale);
            this.hbSales.getChildren().add((Object)new SaleListItem(this.sale, this, true));
            this.cbCreditSale.getSelectionModel().select(0);
            this.tbCreditToken.setText("");
            this.txtComment.setEditable(true);
            this.cbSalesResponsible.setEditable(true);
        } else {
            this.sale = this.pendingSales.getSales().stream().filter(x -> x.getDescription().equals("New Sale")).findAny().orElse(null);
            if (!this.sale.getCreditToken().isEmpty()) {
                this.tbCreditToken.setText(this.sale.getCreditToken());
                this.cbCreditSale.getSelectionModel().select((Object)this.sale.getCreditDescription());
            } else {
                this.cbCreditSale.getSelectionModel().select(0);
            }
            this.tbCreditToken.setVisible(this.cbCreditSale.getSelectionModel().getSelectedIndex() != 0);
            if (!this.sale.getPaymentTerm().isEmpty()) {
                this.cbPaymentTerm.getSelectionModel().select((Object)new NameValueObject(this.sale.getPaymentTerm(), this.sale.getPaymentTermDescription(), this.da));
                this.hbPayTerm.setVisible(true);
            } else {
                this.hbPayTerm.setVisible(false);
            }
            if (!this.sale.img.isEmpty()) {
                this.brnRemoveUpload.setVisible(true);
                this.btnViewUplaod.setVisible(true);
                this.btnUpload.setText("Upload Cheque");
            }
        }
        this.cbSalesResponsible.setText(this.sale.getSalesRep());
        this.txtComment.setText(this.sale.getSaleComment());
        this.sale.isMakingSale = false;
        this.TotalAmtTF.textProperty().unbind();
        this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
        this.stockItemList = new StockItemList(this.da);
        this.RepeatingVB.getChildren().clear();
        this.SearchTextField.setText("");
    }

    public void showPayment(boolean iscallback) {
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.DECORATED);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setTitle("Payment Option");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent((Node)new PaymentOptionPane(this, iscallback));
        ButtonType cancelBtn = new ButtonType("Cancel");
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{cancelBtn});
        Optional result = this.dialog.showAndWait();
        if (result.isPresent() && result.get() == cancelBtn && this.sale.getApprovals().equals("automatic")) {
            this.sale.setApprovals("");
            this.sale.setApprovingComment("");
            this.sale.setSaleStatus(SaleStatus.PENDING.name());
            this.sale.setManualSaleStatus(ManualPendingStatus.Created.name());
        }
    }

    public void makeSale() throws Exception {
        this.mainPage.isToMenu = false;
        if (this.validateControl()) {
            if ((!this.sale.getIsManual().booleanValue() || this.isManualWithoutApproval()) && this.sale.getPaymentTerm().isEmpty() && (this.tbCreditToken.getText().isEmpty() || ((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("Voucher"))) {
                if (this.isManualWithoutApproval()) {
                    this.sale.setApprovals("automatic");
                    this.sale.setApprovingComment("Since price sold is  greater than selling price, sale does not need approval.");
                    this.sale.setSaleStatus(SaleStatus.APPROVED.name());
                    this.sale.setManualSaleStatus(ManualPendingStatus.Completed.name());
                }
                this.showPayment(false);
            } else {
                this.done(1);
            }
        }
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    public void searchCustomer(final String text) {
        this.dialog.close();
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String serachText = text.charAt(0) == '0' ? text.substring(1) : text;
                            new SyncData(SalesPane.this.santa, SalesPane.this.da, SalesPane.this.currentUser.getParentCompany()).getCustomer(serachText, new IDBEntity<Customer>(){

                                @Override
                                public void onSuccess(ObservableList<Customer> data) {
                                    Platform.runLater(() -> {
                                        if (data.isEmpty()) {
                                            SalesPane.this.showDialog(null);
                                            SalesPane.this.mainPage.showNotification(NotificationType.Information, "No cutomer found", SalesPane.this);
                                        } else {
                                            SalesPane.this.showDialog(text);
                                        }
                                        SalesPane.this.stackPane.getChildren().remove((Object)box);
                                    });
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        SalesPane.this.showDialog(null);
                                        SalesPane.this.stackPane.getChildren().remove((Object)box);
                                        SalesPane.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPane.this);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        SalesPane.this.showDialog(null);
                                        SalesPane.this.stackPane.getChildren().remove((Object)box);
                                        SalesPane.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPane.this);
                                    });
                                }
                            });
                        }
                        catch (JSONException ex) {
                            Platform.runLater(() -> {
                                SalesPane.this.showDialog(null);
                                SalesPane.this.stackPane.getChildren().remove((Object)box);
                                SalesPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    @Override
    public void showDialog(String cust) {
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setTitle("Search Customer");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent((Node)new SearchCustomerPane(this, cust));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.show();
    }

    public void printInvoice(Sale ss) {
        try {
            this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
            this.dialog = new Dialog();
            this.dialog.initStyle(StageStyle.DECORATED);
            this.dialog.initOwner((Window)this.santa.stage);
            this.dialog.setTitle("Invoice");
            this.dialog.setResizable(true);
            this.dialog.getDialogPane().setPrefHeight((double)Santa.dialogHeight.floatValue());
            this.dialog.getDialogPane().setPrefWidth((double)Santa.dialogWidth.floatValue());
            this.dialog.getDialogPane().setContent((Node)new ReportPane(this.santa, ReportType.Invoice, ss, null, null, null));
            this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
            this.dialog.show();
        }
        catch (JRException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void removeSaleFromTopSaleList() {
        this.hbSales.getChildren().remove(this.hbSales.getChildren().stream().filter(prdct -> prdct instanceof SaleListItem && (this.sale.getInvoiceNumber() == 0 ? ((SaleListItem)prdct).sale.getCustomerName().equals(this.sale.getCustomerName()) : ((SaleListItem)prdct).sale.getInvoiceNumber() == this.sale.getInvoiceNumber())).findAny().orElse(null));
    }

    @Override
    public void done(int flag) {
        if (flag == 1) {
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.close();
            }
            this.container.setDisable(true);
            try {
                this.sale.setSalesChannel("Retail");
                this.sale.setStoreCode(this.santa.currentUser.getParentCompany().getStoreCode());
                this.sale.storeName = this.santa.currentUser.getParentCompany().getStoreName();
                LocalDateTime date = LocalDateTime.now();
                if (this.sale.getIsManual().booleanValue() && !this.sale.saleCreated || !this.sale.getIsManual().booleanValue()) {
                    if (this.cbSalesResponsible.getText().isEmpty()) {
                        this.sale.setSalesRep("");
                    }
                    this.sale.setTransactionDate(Timestamp.valueOf(this.santa.currentUser.getParentCompany().getCurrentDay().atTime(date.getHour(), date.getMinute(), date.getHour())));
                }
                this.sale.setCostCenter(this.santa.currentUser.getParentCompany().getCostCenter());
                this.sale.setParentCompany(this.currentUser.getParentCompany());
                this.sale.setLocationCode(this.santa.currentUser.getParentCompany().getLocationCode());
                if (!((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("No Credit")) {
                    this.sale.setCreditDescription((String)this.cbCreditSale.getSelectionModel().getSelectedItem());
                    this.sale.setCreditToken(this.tbCreditToken.getText());
                    this.sale.setIsManual(true);
                }
                this.sale.makeSale(this.currentUser);
                if (this.sale.getHdInvoiceNo().isEmpty()) {
                    this.sale.setHdInvoiceNo(String.valueOf(this.sale.getInvoiceNumber()));
                }
                Sale saleForRpt = this.sale.CloneForInvoice();
                saleForRpt.setDbAccess(this.da);
                saleForRpt.setSaleItemsList(this.sale.getSaleItemsList());
                this.pendingSales.getSales().remove((Object)this.sale);
                this.removeSaleFromTopSaleList();
                if (this.sale.getIsManual().booleanValue() && !this.sale.saleCreated && !this.isManualWithoutApproval()) {
                    this.sale.saleCreated = true;
                    this.mainPage.manualSaleList.getOriginalList().add(0, (Object)this.sale);
                    this.listManualSales.refresh();
                    this.resetSale();
                } else {
                    if (this.sale.getIsManual().booleanValue() && this.sale.saleCreated) {
                        this.mainPage.manualSaleList.getOriginalList().remove((Object)this.sale);
                        this.listManualSales.refresh();
                    }
                    this.resetSale();
                    this.printInvoice(saleForRpt);
                }
            }
            catch (Exception e) {
                if (NotEnoughQtyException.class == e.getClass()) {
                    this.mainPage.showNotification(NotificationType.Error, "Maximum days set for direct purchase Exceeded", this);
                }
                this.mainPage.showNotification(NotificationType.Error, e.getMessage(), this);
            }
            this.container.setDisable(false);
        }
    }

    public boolean isManualWithoutApproval() {
        return this.sale.getSaleItemsList().stream().filter(sf -> sf.getTotalQty() != sf.getParentStockItem().totalQty || sf.getVariablePrice() < sf.getParentStockItem().getSellingPrice()).count() == 0L && this.sale.getIsManual() != false && this.tbCreditToken.getText().isEmpty();
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        if (this.mainPage.isToMenu) {
            return true;
        }
        if (this.sale.getSaleItemsList().isEmpty()) {
            this.errorMessage = this.errorMessage + "No item selected to sell \n";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getSalesRep().isEmpty()) {
            this.errorMessage = this.errorMessage + "Please select sales responsible";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getSaleItemsList().stream().filter(p -> p.getSerials().getOriginalList().size() > 0 && p.getSerials().getOriginalList().size() != p.getTotalQty()).findAny().orElse(null) != null) {
            this.errorMessage = this.errorMessage + "One or more item(s) has serial(s) less than the quantity";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getIsManual().booleanValue() && (this.sale.getSaleComment() == null || this.sale.getSaleComment().isEmpty())) {
            this.errorMessage = this.errorMessage + "Please enter reason(s) for manual sale \n";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getParentCustomer() == null) {
            this.errorMessage = this.errorMessage + "Please select customer \n";
        }
        if (this.cbCreditSale.getSelectionModel().getSelectedIndex() > 0 && !((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("Others") && this.tbCreditToken.getText().isEmpty()) {
            this.errorMessage = this.errorMessage + "Please supply token for credit/voucher sale \n";
        }
        if (((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("Others") && this.sale.getPaymentTerm().isEmpty()) {
            this.errorMessage = this.errorMessage + "Please select payment term for the sale \n";
        }
        if (Double.valueOf(this.TotalAmtTF.getText().replace(",", "")) == 0.0 || Double.valueOf(this.TotalAmtTF.getText().replace(",", "")) < 0.0) {
            this.errorMessage = this.errorMessage + "Please specify amount recieved from the customer";
        }
        if (!this.errorMessage.equals("")) {
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        return true;
    }

    @Override
    void yes() {
        try {
            this.makeSale();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to make sale for the selected item(s)", this);
    }

    private void loadAccountDetails() {
        this.lst = new AccountDetailDataList(this.da);
        this.lst.selectAll("Select * From AccountDetail ", this.da.getEmptyParameterValues());
        ArrayList<AccountDetailItemPane> children = new ArrayList<AccountDetailItemPane>();
        for (AccountDetail accountDetail : this.lst.getOriginalList()) {
            children.add(new AccountDetailItemPane(accountDetail));
        }
    }

    @Override
    public Santa getSanta() {
        return this.santa;
    }

    @Override
    public Sale getSale() {
        return this.sale;
    }

    @Override
    public HBox getHbSales() {
        return this.hbSales;
    }

    @Override
    public void setSale(Sale s) {
        this.sale = s;
    }

    @Override
    public Dialog getDialog() {
        return this.dialog;
    }

    @Override
    public MainPage getMainPage() {
        return this.mainPage;
    }

    @Override
    public PendingSales getPendingSale() {
        return this.pendingSales;
    }

    @Override
    public StockItemList getCartStockItemList() {
        return this.cartStockItemList;
    }

    @Override
    public void setCartStockItemList(StockItemList stckLst) {
        this.cartStockItemList = stckLst;
    }

    @Override
    public VBox getRepeatingVBAdded() {
        return this.RepeatingVBAdded;
    }

    @Override
    public StackPane getStackPane() {
        return this.stackPane;
    }
}

