/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.ui.AnimationEnum;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SaleItemCart;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesPaneB2B;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIControlBase;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;

public class SaleItem
extends UIControlBase {
    @FXML
    private HBox hbRow2;
    @FXML
    private ImageView btnAdd;
    @FXML
    private HBox hbRow1;
    @FXML
    private CheckBox chkManual;
    @FXML
    private Label nairaB2B;
    @FXML
    private Label lblSku;
    @FXML
    private Label naira;
    @FXML
    private Label lblItemCode;
    @FXML
    private Label lblCns;
    @FXML
    private Label lblDsp;
    @FXML
    private TextField PriceTF;
    @FXML
    private TextField PriceTFB2B;
    @FXML
    private TextField lblStockQty;
    private static DataAccess da;
    private com.xputertechnologies.santa.SaleItem saleItem;
    @FXML
    private Label lblName;
    private UnitDataList unitDataList;

    public com.xputertechnologies.santa.SaleItem getSaleItem() {
        return this.saleItem;
    }

    public SaleItem(final com.xputertechnologies.santa.SaleItem saleItem, final ISalePane sp, String Mode, int pos) {
        da = sp.getSanta().da;
        this.btnAdd.setImage(new Image("/com/xputertechnologies/santa/ui/Images/cart-add.png"));
        if (pos % 2 == 0) {
            this.setStyle("-fx-background-color:#F5F5F5");
            String style = "-fx-background-color:#F3F3F3;-fx-background-radius:0px;-fx-padding:0,0,0,0;-fx-border-radius:0px;-fx-border-color:#F3F3F3;-fx-focus-color:transparent";
            this.PriceTF.setStyle(style + "-fx-text-fill: #ff0000;-fx-background-color:#F5F5F5");
            this.PriceTFB2B.setStyle(style + "-fx-text-fill: #ff00b6;-fx-background-color:#F5F5F5");
            this.lblStockQty.setStyle(style);
        }
        this.PriceTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!(newValue.equals("0.0") || newValue.equals("0") || (SaleItem.this.lblStockQty.getText().equals("0.0") || SaleItem.this.lblStockQty.getText().equals("0")) && saleItem.getTotalQty() <= 0)) {
                    SaleItem.this.btnAdd.setVisible(true);
                } else {
                    SaleItem.this.btnAdd.setVisible(false);
                }
            }
        });
        this.lblStockQty.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!((newValue.equals("0.0") || newValue.equals("0")) && saleItem.getTotalQty() <= 0 || SaleItem.this.PriceTF.getText().equals("0.0") || SaleItem.this.PriceTF.getText().equals("0"))) {
                    SaleItem.this.btnAdd.setVisible(true);
                } else {
                    SaleItem.this.btnAdd.setVisible(false);
                }
            }
        });
        if (saleItem.getParentStockItem().getTotalQty() == 0 || saleItem.getParentStockItem().getSellingPrice() == 0.0) {
            this.btnAdd.setVisible(false);
        } else {
            this.btnAdd.setVisible(true);
        }
        TextFormatter priceFormater = new TextFormatter(this.dConverter, (Object)saleItem.sellingPriceProperty().get());
        TextFormatter priceB2BFormater = new TextFormatter(this.dConverter, (Object)saleItem.priceB2BProperty().get());
        this.PriceTF.textProperty().bindBidirectional((Property)saleItem.sellingPriceProperty(), this.dConverter);
        this.PriceTF.setTextFormatter(priceFormater);
        this.PriceTFB2B.textProperty().bindBidirectional((Property)saleItem.priceB2BProperty(), this.dConverter);
        this.PriceTFB2B.setTextFormatter(priceB2BFormater);
        this.lblStockQty.textProperty().bindBidirectional((Property)saleItem.quantityProperty(), this.fConverter);
        this.chkManual.selectedProperty().bindBidirectional((Property)saleItem.isManualProperty());
        this.lblCns.setText(Integer.toString(saleItem.getParentStockItem().getCnsQty()));
        this.lblDsp.setText(Integer.toString(saleItem.getParentStockItem().getDspQty()));
        this.PriceTF.editableProperty().bindBidirectional((Property)saleItem.isManualProperty());
        this.PriceTFB2B.editableProperty().bindBidirectional((Property)saleItem.isManualProperty());
        this.lblStockQty.editableProperty().bindBidirectional((Property)saleItem.isManualProperty());
        this.btnAdd.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!sp.getSale().saleCreated) {
                    com.xputertechnologies.santa.SaleItem saleItem1;
                    if (sp.getCartStockItemList() == null) {
                        sp.setCartStockItemList(new StockItemList(sp.getSanta().da));
                    }
                    if ((saleItem1 = (com.xputertechnologies.santa.SaleItem)sp.getSale().getSaleItemsList().stream().filter(si -> si.getParentStockItem().getItemCode().equals(saleItem.getParentStockItem().getItemCode())).findAny().orElse(null)) == null) {
                        com.xputertechnologies.santa.SaleItem saleItem2 = saleItem.duplicate();
                        sp.getSale().getSaleItemsList().add(sp.getSale().getSaleItemsList().size(), (Object)saleItem2);
                        if (sp.getSale().getSaleItemsList().stream().filter(f -> f.getIsManual()).collect(Collectors.toList()).size() > 0) {
                            sp.getSale().setIsManual(true);
                        }
                        SaleItemCart cartItem = new SaleItemCart(saleItem2, sp);
                        try {
                            Santa.setAnimation((Region)cartItem, (Region)sp.getRepeatingVBAdded(), AnimationEnum.BOTOM);
                        }
                        catch (Exception ex) {
                            System.err.println(ex.getMessage());
                        }
                        sp.getRepeatingVBAdded().getChildren().add((Object)cartItem);
                    } else {
                        SaleItemCart cart = sp.getRepeatingVBAdded().getChildren().stream().filter(cat -> ((SaleItemCart)cat).saleItem.getParentStockItem().getItemCode().equals(saleItem.getParentStockItem().getItemCode())).findAny().orElse(null);
                        if (cart != null && cart.saleItem.getQuantity() < saleItem.getQuantity()) {
                            cart.saleItem.setQuantity(cart.saleItem.getQuantity() + 1.0f);
                        }
                    }
                }
            }
        });
        this.lblItemCode.setText(saleItem.getParentStockItem().getItemCode());
        saleItem.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("quantity") && ((com.xputertechnologies.santa.SaleItem)evt.getSource()).getParentStockItem().getSellingPrice() == 0.0 && Float.valueOf(evt.getOldValue().toString()).floatValue() > 0.0f) {
                sp.getMainPage().showNotification(NotificationType.Error, "Item without price can not be sold", sp instanceof SalesPane ? (SalesPane)sp : (SalesPaneB2B)sp);
            }
        });
        this.lblName.setText(saleItem.getParentStockItem().getName());
        this.unitDataList = new UnitDataList(da);
        this.unitDataList.SelectAll();
        this.saleItem = saleItem;
        this.naira.setText(General.toNaira());
        this.nairaB2B.setText(General.toNaira());
        this.nairaB2B.visibleProperty().bind((ObservableValue)this.PriceTFB2B.visibleProperty());
        if (sp instanceof SalesPane) {
            this.PriceTFB2B.setVisible(false);
        }
    }
}

