/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseType;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.PurchaseDeliveryNotePane;
import com.xputertechnologies.santa.ui.UIParent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public class PurchaseOrderDialog
extends UIParent {
    @FXML
    private VBox vbox;
    @FXML
    private GridPane grid;
    @FXML
    private JFXTextField tbDescription;
    @FXML
    private JFXTextField tbItemCode;
    @FXML
    private JFXTextField tbPrice;
    @FXML
    private JFXTextField tbQty;
    @FXML
    private JFXComboBox cmbCostCenter;
    @FXML
    private JFXComboBox cmbTaxCode;
    @FXML
    private JFXButton btnDone;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnCancel;
    @FXML
    private JFXButton btnSearch;
    PurchaseLineItem product;
    IPurchasePane parent;
    protected StringConverter<? extends Number> dConverter = new DoubleStringConverter(){

        public String toString(Double object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object);
            }
            return null;
        }

        public Double fromString(String string) {
            Double d = 0.0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Double.parseDouble(string);
            }
            return d;
        }
    };
    protected StringConverter<? extends Number> intConverter = new IntegerStringConverter(){

        public String toString(Integer object) {
            if (object != null) {
                return Integer.toString(object);
            }
            return null;
        }

        public Integer fromString(String string) {
            Integer d = 0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Integer.parseInt(string);
            }
            return d;
        }
    };
    ObservableList<NameValueObject> costcenters;
    ObservableList<NameValueObject> taxCodes;

    public PurchaseOrderDialog(final IPurchasePane parent) {
        super("PurchaseOrderDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Product";
        this.parent = parent;
        this.costcenters = NameValueObject.select(NameValueObjectType.CostCentre.name(), this.da);
        this.taxCodes = NameValueObject.select(NameValueObjectType.TaxCodes.name(), this.da);
        if (parent.purchaseOrder.getPurchaseType().equals(PurchaseType.Service.name())) {
            this.vbox.getChildren().remove((Object)this.grid);
        } else {
            this.tbDescription.setDisable(true);
        }
        this.cmbCostCenter.setItems(this.costcenters);
        this.confiGInterface();
        if (parent.selectedStock == null) {
            this.product = new PurchaseLineItem(this.da);
            this.product.setTaxCode("EX");
            if (!parent.purchaseOrder.getCostCenter().isEmpty()) {
                this.product.setCostCenter(parent.purchaseOrder.getCostCenter());
            }
            this.product.setSn(parent.purchaseOrder.getItems().size() + 1);
            this.product.setParentCode(parent.purchaseOrder.getCode());
            this.product.setParentPurchase(parent.purchaseOrder);
        } else {
            this.product = parent.selectedStock;
        }
        this.btnSearch.setOnAction(x -> {
            if (!this.tbItemCode.getText().isEmpty()) {
                parent.loadProduct(this.tbItemCode.getText(), this);
            }
        });
        if (!this.product.getCostCenter().isEmpty()) {
            this.cmbCostCenter.getSelectionModel().select((Object)this.costcenters.stream().filter(k -> k.getKey().equals(this.product.getCostCenter())).findAny().get());
        }
        this.cmbTaxCode.getSelectionModel().select((Object)this.taxCodes.stream().filter(k -> k.getKey().equals(this.product.getTaxCode())).findAny().get());
        this.cmbCostCenter.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    PurchaseOrderDialog.this.product.setCostCenter(newValue.getKey());
                }
            }
        });
        this.cmbTaxCode.setItems(this.taxCodes);
        this.cmbTaxCode.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    PurchaseOrderDialog.this.product.setTaxCode(newValue.getKey());
                }
            }
        });
        this.tbDescription.textProperty().bindBidirectional((Property)this.product.itemNameProperty());
        this.tbDescription.textProperty().addListener((observable, oldValue, newValue) -> {});
        if (parent.purchaseOrder.getPurchaseType().equals(PurchaseType.Item.name())) {
            this.tbItemCode.textProperty().bindBidirectional((Property)this.product.itemCodeProperty());
            if (parent.purchaseOrder.getSapCode().isEmpty()) {
                this.tbQty.textProperty().bindBidirectional((Property)this.product.quantityProperty(), this.intConverter);
            } else {
                this.tbQty.textProperty().bindBidirectional((Property)this.product.editQtyProperty(), this.intConverter);
            }
        }
        if (parent.purchaseOrder.getSapCode().isEmpty()) {
            this.tbPrice.textProperty().bindBidirectional((Property)this.product.priceProperty(), this.dConverter);
        } else {
            this.tbPrice.textProperty().bindBidirectional((Property)this.product.editPriceProperty(), this.dConverter);
        }
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent instanceof PurchaseDeliveryNotePane) {
                    parent.dialog.close();
                    ((PurchaseDeliveryNotePane)parent).showDialogEdit();
                } else {
                    parent.dialog.close();
                }
            }
        });
        this.btnDone.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.selectedStock == null || !parent.selectedStock.getCode().equals(PurchaseOrderDialog.this.product.getCode())) {
                    parent.purchaseOrder.getItems().add((Object)PurchaseOrderDialog.this.product);
                    parent.purchaseOrder.recalculateTotal();
                }
                if (parent instanceof PurchaseDeliveryNotePane) {
                    parent.dialog.close();
                    ((PurchaseDeliveryNotePane)parent).showDialogEdit();
                } else {
                    parent.dialog.close();
                }
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PurchaseOrderDialog.this.rebind();
            }
        });
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.tbItemCode, t -> {
            List<StockItemData> result = this.searchResult(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<StockItemData>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<StockItemData> event) {
                PurchaseOrderDialog.this.populateResult((StockItemData)event.getCompletion());
            }
        });
        autoCompletionBinding.setPrefWidth(550.0);
    }

    public List<StockItemData> searchResult(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<StockItemData>();
        }
        List result = this.santa.Products.stream().filter(e -> e.getItemCode().toLowerCase().contains(searchString.toLowerCase()) || e.getDescription().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
        LinkedList searchResult = new LinkedList();
        searchResult.addAll(result.isEmpty() ? this.santa.Products : result);
        return searchResult.subList(0, searchResult.size());
    }

    public void populateResult(StockItemData data) {
        this.tbItemCode.setText(data.getItemCode());
        this.tbDescription.setText(data.getDescription());
    }

    public void rebind() {
        this.tbDescription.textProperty().unbindBidirectional((Property)this.product.itemNameProperty());
        this.tbQty.textProperty().unbindBidirectional((Object)this.product.quantityProperty());
        if (this.parent.purchaseOrder.getPurchaseType().equals(PurchaseType.Item.name())) {
            this.tbItemCode.textProperty().unbindBidirectional((Property)this.product.itemCodeProperty());
            if (this.parent.purchaseOrder.getSapCode().isEmpty()) {
                this.tbQty.textProperty().unbindBidirectional((Object)this.product.quantityProperty());
            } else {
                this.tbQty.textProperty().unbindBidirectional((Object)this.product.editQtyProperty());
            }
        }
        if (this.parent.purchaseOrder.getSapCode().isEmpty()) {
            this.tbPrice.textProperty().unbindBidirectional((Object)this.product.priceProperty());
        } else {
            this.tbPrice.textProperty().unbindBidirectional((Object)this.product.editPriceProperty());
        }
        this.cmbCostCenter.getSelectionModel().clearSelection();
        this.cmbTaxCode.getSelectionModel().clearSelection();
        this.cmbCostCenter.getSelectionModel().clearSelection();
        if (this.parent.selectedStock == null || !this.parent.selectedStock.getCode().equals(this.product.getCode())) {
            this.parent.purchaseOrder.getItems().add((Object)this.product);
            this.parent.purchaseOrder.recalculateTotal();
        }
        this.product = new PurchaseLineItem(this.santa.da);
        this.product.setTaxCode("EX");
        this.product.setSn(this.parent.purchaseOrder.getItems().size() + 1);
        this.product.setParentCode(this.parent.purchaseOrder.getCode());
        this.product.setParentPurchase(this.parent.purchaseOrder);
        if (!this.parent.purchaseOrder.getCostCenter().isEmpty()) {
            this.parent.purchaseOrder.setCostCenter(this.parent.purchaseOrder.getCostCenter());
            this.cmbCostCenter.getSelectionModel().select((Object)this.costcenters.stream().filter(k -> k.getKey().equals(this.product.getCostCenter())).findAny().get());
        }
        this.cmbTaxCode.getSelectionModel().select((Object)this.taxCodes.stream().filter(k -> k.getKey().equals(this.product.getTaxCode())).findAny().get());
        this.tbDescription.textProperty().bindBidirectional((Property)this.product.itemNameProperty());
        if (this.parent.purchaseOrder.getPurchaseType().equals(PurchaseType.Item.name())) {
            this.tbItemCode.textProperty().bindBidirectional((Property)this.product.itemCodeProperty());
            if (this.parent.purchaseOrder.getSapCode().isEmpty()) {
                this.tbQty.textProperty().bindBidirectional((Property)this.product.quantityProperty(), this.intConverter);
            } else {
                this.tbQty.textProperty().bindBidirectional((Property)this.product.editQtyProperty(), this.intConverter);
            }
        }
        if (this.parent.purchaseOrder.getSapCode().isEmpty()) {
            this.tbPrice.textProperty().bindBidirectional((Property)this.product.priceProperty(), this.dConverter);
        } else {
            this.tbPrice.textProperty().bindBidirectional((Property)this.product.editPriceProperty(), this.dConverter);
        }
    }

    void confiGInterface() {
        switch (this.parent.purchaseTypeEnum) {
            case PO: {
                break;
            }
            case PDN: {
                break;
            }
        }
    }
}

