/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.ui.AccountDetailItemPane;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesPaneAdmin;
import com.xputertechnologies.santa.ui.SalesPaneB2B;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;

public class PaymentOptionPane
extends UIParent {
    AccountDetailDataList lst;
    @FXML
    private Accordion accordion;
    @FXML
    private Button btnSale;
    @FXML
    private Button btnApplyCode;
    @FXML
    private Label lblTotal;
    @FXML
    private Label lblAmt;
    @FXML
    private Label lblNaira;
    @FXML
    private TextField tbVocher;
    ISalePane sp;
    StringConverter<? extends Number> dConverter = new DoubleStringConverter();
    int i = 0;

    public PaymentOptionPane(ISalePane sp, boolean iscallback) {
        super("PaymentOptionPane.fxml", sp.getSanta());
        this.sp = sp;
        if (sp instanceof SalesPaneAdmin) {
            ((SalesPaneAdmin)sp).accountDetailDataList.getOriginalList().forEach(x -> x.setAmount(0.0));
            this.loadAccounts(((SalesPaneAdmin)sp).accountDetailDataList, iscallback);
        } else {
            this.loadAccounts(null, iscallback);
        }
        this.lblNaira.setText(General.toNaira());
        this.tbVocher.setText(sp.getSale().getPromoVoucher());
        sp.getSale().trackerAmountDetail.set(sp.getSale().trackerAmountDetail.get() + 1);
        this.lblTotal.textProperty().bind((ObservableValue)sp.getSale().totalAmountDetailBinding);
        this.btnSale.setOnAction(ev -> {
            if (sp.getSale().totalAmountDetailBinding.get().equals(sp.getSale().totalAmountBinding.get()) || sp.getSale().getCreditDescription().equals("Easy Buy") || sp.getSanta().company.getIsMainHub()) {
                sp.getSale().getAccountDetailList().removeIf(p -> p.amountProperty().get() == 0.0);
                if (this.sp.getSale() != null && this.sp.getSale().getPromoVoucherAmt() > 0.0 && (this.sp instanceof SalesPane || this.sp instanceof SalesPaneB2B)) {
                    this.sp.MarkVoucherUsed();
                } else {
                    this.sp.done(1);
                }
            } else {
                sp.getMainPage().showNotification(NotificationType.Error, "Total amount must be equal to item(s) total\n You must select Payment type for all account with value", sp instanceof SalesPane ? (SalesPane)sp : (SalesPaneB2B)sp);
            }
        });
        this.btnApplyCode.setOnAction(va -> this.sp.ValidateVoucher(this.tbVocher.getText()));
        this.accordion.setExpandedPane((TitledPane)this.accordion.getPanes().get(0));
    }

    public boolean validatedTrueAcctype() {
        for (Node object : this.accordion.getPanes()) {
            AccountDetail acc = ((AccountDetailItemPane)((TitledPane)object).getContent()).accountDetail;
            if (acc == null || !(acc.getAmount() > 0.0) || acc.getAccType() != null && !acc.getAccType().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void loadAccounts(AccountDetailDataList lst, boolean iscallback) {
        if (lst == null) {
            lst = new AccountDetailDataList(this.sp.getSanta().da);
            lst.selectAll("Select * From AccountDetail where isDisable=? and isDeleted=?", new ParameterValue[]{new ParameterValue("isDisable", JDBCType.CHAR, Boolean.FALSE), new ParameterValue("isDeleted", JDBCType.CHAR, Boolean.FALSE)});
        }
        Comparator<AccountDetail> comparator = Comparator.comparingInt(AccountDetail::getPosition);
        comparator = comparator.reversed();
        FXCollections.sort(lst.getOriginalList(), comparator);
        ArrayList children = new ArrayList();
        lst.getOriginalList().forEach(ac -> {
            ac.setParentSale(this.sp.getSale());
            if (this.i == 0) {
                if (iscallback && this.sp.getSale().getPromoVoucherAmt() > 0.0) {
                    ac.amountProperty().set(this.sp.getSale().getTotalAmount() - this.sp.getSale().getPromoVoucherAmt());
                } else {
                    ac.amountProperty().set(this.sp.getSale().getTotalAmount());
                }
            }
            if (this.accordion.getPanes().stream().filter(prdct -> prdct.getId().equals(ac.getAccNumber())).count() == 0L) {
                Label lbl = new Label("Account Number:" + ac.getAccNumber());
                VBox vb = new VBox(new Node[]{lbl});
                vb.getChildren().add((Object)new AccountDetailItemPane((AccountDetail)ac));
                vb.setSpacing(5.0);
                TitledPane Tpane = new TitledPane(ac.getAccName(), (Node)vb);
                Tpane.setId(ac.getAccNumber());
                this.accordion.getPanes().add((Object)Tpane);
            } else {
                Node Tpane = this.accordion.getPanes().stream().filter(prdct -> prdct.getId().equals(ac.getAccNumber())).findAny().orElse(null);
                ((VBox)((TitledPane)Tpane).getContent()).getChildren().add((Object)new AccountDetailItemPane((AccountDetail)ac));
            }
            ++this.i;
        });
        this.sp.getSale().setAccountDetailList(lst.getOriginalList());
        if (this.sp.getSale().getPromoVoucherAmt() > 0.0 && iscallback) {
            this.lblAmt.setText(General.toNaira() + General.formatDecimalToMoneyString(this.sp.getSale().getPromoVoucherAmt()));
            this.tbVocher.setDisable(true);
            this.btnApplyCode.setDisable(true);
        } else {
            this.sp.getSale().setPromoVoucher("");
            this.sp.getSale().setPromoVoucherAmt(0.0);
            this.sp.getSale().minAmount = 0.0;
        }
    }
}

