/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXListView;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class POHistoryView
extends UIParent {
    @FXML
    private JFXButton btnCancel;
    @FXML
    private TableView<PurchaseLineItem> table;
    @FXML
    JFXListView<PurchaseOrder> list;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colQty;
    IPurchasePane parent;

    public POHistoryView(IPurchasePane parent) {
        super("POHistoryView.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Product";
        this.parent = parent;
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.list.setItems(parent.purchaseOrder.getPOHistory());
        this.list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PurchaseOrder>(){

            public void changed(ObservableValue<? extends PurchaseOrder> observable, PurchaseOrder oldValue, PurchaseOrder newValue) {
                if (newValue != null) {
                    newValue.resetNumbering();
                    POHistoryView.this.table.setItems(newValue.getItems());
                }
            }
        });
        this.list.setCellFactory((Callback)new Callback<ListView<PurchaseOrder>, ListCell<PurchaseOrder>>(){

            public ListCell<PurchaseOrder> call(ListView<PurchaseOrder> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<PurchaseOrder> cell = new ListCell<PurchaseOrder>(){

                    public void updateItem(PurchaseOrder po, boolean empty) {
                        super.updateItem((Object)po, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label code = new Label();
                            code.setText(po.getSapCode());
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)code);
                        }
                    }
                };
                return cell;
            }
        });
        this.btnCancel.setOnAction(v -> parent.dialog.close());
    }
}

