/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.POActionMap;
import com.xputertechnologies.santa.POActionMapEnum;
import com.xputertechnologies.santa.list.POActionMapDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.POActionMapRepeatingItem;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONObject;

public class POActionMapPane
extends UIParent {
    @FXML
    public VBox vbox;
    POActionMapDataList pOActionMapDataList;
    @FXML
    private JFXButton btnPost;
    @FXML
    private StackPane stackPane;
    @FXML
    private JFXButton btnReload;

    public POActionMapPane(Santa app) {
        super("POActionMapPane.fxml", app);
        this.title = "Template Mapping";
        this.pOActionMapDataList = new POActionMapDataList(this.da);
        this.btnPost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                POActionMapPane.this.post();
            }
        });
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                POActionMapPane.this.load();
            }
        });
        this.load();
    }

    void showMapping() {
        this.vbox.getChildren().clear();
        if (this.pOActionMapDataList.getOriginalList().isEmpty()) {
            int i = 0;
            for (POActionMapEnum value : POActionMapEnum.values()) {
                POActionMap poMap = new POActionMap(this.da);
                poMap.setRequestAction(value.name());
                poMap.setSn(++i);
                this.pOActionMapDataList.getOriginalList().add((Object)poMap);
            }
        }
        this.pOActionMapDataList.getOriginalList().forEach(c -> this.vbox.getChildren().add((Object)new POActionMapRepeatingItem(this, (POActionMap)c)));
    }

    void load() {
        final String url = this.santa.syncSetting.getBEURL() + "RApprovalTemplate/GetActionMaps";
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                if (ra.length() > 0) {
                                    POActionMapPane.this.pOActionMapDataList.getOriginalList().clear();
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        POActionMap poMap = new POActionMap(POActionMapPane.this.da);
                                        poMap.setSn(i + 1);
                                        poMap.setRequestAction(jSONObject.isNull("RequestAction") ? "" : jSONObject.getString("RequestAction"));
                                        poMap.setTemplateDescription(jSONObject.isNull("TemplateDescription") ? "" : jSONObject.getString("TemplateDescription"));
                                        POActionMapPane.this.pOActionMapDataList.getOriginalList().add((Object)poMap);
                                    }
                                }
                                Platform.runLater(() -> {
                                    try {
                                        POActionMapPane.this.stackPane.getChildren().remove((Object)box);
                                        POActionMapPane.this.showMapping();
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(POActionMapPane.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                });
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    POActionMapPane.this.stackPane.getChildren().remove((Object)box);
                                    POActionMapPane.this.mainPage.showNotification(NotificationType.Error, fullError, POActionMapPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                POActionMapPane.this.stackPane.getChildren().remove((Object)box);
                                POActionMapPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), POActionMapPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void post() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            Object url = POActionMapPane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RApprovalTemplate/CreateActionMap";
                            JSONArray jSONArray = new JSONArray();
                            for (POActionMap pOActionMap : POActionMapPane.this.pOActionMapDataList.getOriginalList()) {
                                JSONObject job = new JSONObject();
                                job.put("RequestAction", (Object)pOActionMap.getRequestAction());
                                job.put("TemplateDescription", (Object)pOActionMap.getTemplateDescription());
                                jSONArray.put((Object)job);
                            }
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            StringEntity stringEntity = new StringEntity(jSONArray.toString());
                            httpPost.setEntity((HttpEntity)stringEntity);
                            httpPost.setHeader("Content-type", "application/json");
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                Platform.runLater(() -> {
                                    POActionMapPane.this.stackPane.getChildren().remove((Object)box);
                                    POActionMapPane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", POActionMapPane.this);
                                });
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    POActionMapPane.this.stackPane.getChildren().remove((Object)box);
                                    POActionMapPane.this.mainPage.showNotification(NotificationType.Error, fullError, POActionMapPane.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                POActionMapPane.this.stackPane.getChildren().remove((Object)box);
                                POActionMapPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), POActionMapPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }
}

