/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXListView;
import com.xputertechnologies.santa.PurchaseDeliveryNote;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.PurchaseDeliveryNotePane;
import com.xputertechnologies.santa.ui.PurchaseOrderPaneViewerPane;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import org.controlsfx.glyphfont.FontAwesome;

public class PDNViewDialog
extends UIParent {
    @FXML
    private Label lblUser;
    @FXML
    private Label lblTotal;
    @FXML
    private JFXButton btnCancel;
    @FXML
    private TableView<PurchaseLineItem> table;
    @FXML
    JFXListView<PurchaseDeliveryNote> list;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colQty;
    @FXML
    private TableColumn colOpenQty;
    @FXML
    private TableColumn colTax;
    @FXML
    private TableColumn colTotal;
    IPurchasePane parent;

    public PDNViewDialog(final IPurchasePane parent) {
        super("PDNViewDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Product";
        this.parent = parent;
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colOpenQty.setCellValueFactory((Callback)new PropertyValueFactory("openQty"));
        this.colTax.setCellValueFactory((Callback)new PropertyValueFactory("tax"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("lineTotalWithTax"));
        this.list.setItems(parent.purchaseOrder.getDeleveryNotes());
        this.list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PurchaseDeliveryNote>(){

            public void changed(ObservableValue<? extends PurchaseDeliveryNote> observable, PurchaseDeliveryNote oldValue, PurchaseDeliveryNote newValue) {
                if (newValue != null) {
                    newValue.resetNumbering();
                    PDNViewDialog.this.table.setItems(newValue.getItems());
                    PDNViewDialog.this.lblUser.setText((String)newValue.createdByProperty().get());
                    PDNViewDialog.this.lblTotal.setText(General.formatDecimalToMoneyString(newValue.getTotal()));
                }
            }
        });
        this.list.setCellFactory((Callback)new Callback<ListView<PurchaseDeliveryNote>, ListCell<PurchaseDeliveryNote>>(){

            public ListCell<PurchaseDeliveryNote> call(ListView<PurchaseDeliveryNote> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<PurchaseDeliveryNote> cell = new ListCell<PurchaseDeliveryNote>(){

                    public void updateItem(PurchaseDeliveryNote po, boolean empty) {
                        super.updateItem((Object)po, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label code = new Label();
                            code.setText(po.getSapCode());
                            HBox hBoxRight = new HBox(10.0);
                            hBoxRight.setMinSize(-1.0, -1.0);
                            hBoxRight.setAlignment(Pos.CENTER);
                            JFXButton print = new JFXButton();
                            print.setButtonType(JFXButton.ButtonType.RAISED);
                            print.setStyle("-fx-background-color: #4FC4F6;");
                            print.setGraphic((Node)PDNViewDialog.this.fontAwesome.create((Enum)FontAwesome.Glyph.PRINT).color(Color.WHITE).size(15.0));
                            print.setOnAction(v -> {
                                try {
                                    JFXDialog dialog = new JFXDialog();
                                    if (parent instanceof PurchaseDeliveryNotePane) {
                                        dialog.setDialogContainer(((PurchaseDeliveryNotePane)parent).stackPane);
                                    } else {
                                        dialog.setDialogContainer(((PurchaseOrderPaneViewerPane)parent).stackPane);
                                    }
                                    po.setParentCode(parent.purchaseOrder.getCode());
                                    po.parentPO = parent.purchaseOrder;
                                    dialog.setContent((Region)new ReportPane(PDNViewDialog.this.santa, dialog, po));
                                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    dialog.setOverlayClose(false);
                                    dialog.show();
                                }
                                catch (JRException ex) {
                                    Logger.getLogger(PDNViewDialog.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(PDNViewDialog.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            Pane spacer = new Pane();
                            spacer.setMinSize(10.0, 1.0);
                            HBox root = new HBox();
                            root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                            code.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                            hBoxRight.getChildren().addAll((Object[])new Node[]{print});
                            root.getChildren().addAll((Object[])new Node[]{code, spacer, hBoxRight});
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)root);
                        }
                    }
                };
                return cell;
            }
        });
        this.btnCancel.setOnAction(v -> parent.dialog.close());
    }
}

