/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import javafx.scene.control.TextField;

public class IntegerNumberTextBox
extends TextField {
    private int max = Integer.MAX_VALUE;
    private int min = 0;

    public IntegerNumberTextBox() {
        this.setPromptText("0");
    }

    public IntegerNumberTextBox(int value) {
        super(Integer.toString(value));
    }

    public void replaceText(int i, int il, String str) {
        if (!str.matches("[A-Za-z]") && !str.matches("[\\\\!\"#$%&()*+,/:;<=>?@\\[\\]^_{|}~]+") && (str.isEmpty() || this.valid(Integer.parseInt(str)))) {
            super.replaceText(i, il, str);
        }
    }

    public void replaceSelection(String str) {
        if (!str.matches("[A-Za-z]") && !str.matches("[\\\\!\"#$%&()*+,/:;<=>?@\\[\\]^_{|}~]+")) {
            super.replaceSelection(str);
        }
    }

    private boolean valid(int text) {
        return text >= this.min && text <= this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }
}

