/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.ExcelReportObject;
import com.xputertechnologies.santa.report.CSVUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;

public class General {
    StringConverter<? extends Number> fConverter = new FloatStringConverter(){

        public String toString(Float object) {
            if (object != null) {
                return Integer.toString(Math.round(object.floatValue()));
            }
            return null;
        }

        public Float fromString(String string) {
            string = string.replace(",", "");
            Float d = Float.valueOf(Float.parseFloat(string));
            return d;
        }
    };
    StringConverter<? extends Number> dConverter = new DoubleStringConverter(){

        public String toString(Double object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object);
            }
            return null;
        }

        public Double fromString(String string) {
            string = string.replace(",", "");
            Double d = Double.parseDouble(string);
            return d;
        }
    };

    public static ObservableList<String> getCredits() {
        ObservableList result = FXCollections.observableArrayList();
        result.add((Object)"No Credit");
        result.add((Object)"Baines Credit");
        result.add((Object)"Easy Buy");
        result.add((Object)"Ren Money");
        result.add((Object)"Access Bank DF.");
        result.add((Object)"Carbon");
        result.add((Object)"Others");
        return result;
    }

    public static boolean writeToExcel(Stage parentStage, ExcelReportObject reportObject) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save File");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV Document", Arrays.asList("*.csv", "*.CSV")));
        File file = fileChooser.showSaveDialog((Window)parentStage);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            CSVUtils.writeLine(fileWriter, reportObject.getHeaders());
            boolean i = false;
            for (List<String> rpt : reportObject.getValues()) {
                CSVUtils.writeLine(fileWriter, rpt);
            }
            fileWriter.flush();
            fileWriter.close();
            System.out.println("csv");
            return true;
        }
        catch (Exception ex) {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException ex1) {
                    Logger.getLogger(General.class.getName()).log(Level.SEVERE, null, ex1);
                }
            }
            System.err.println(ex.getMessage());
            return false;
        }
    }

    public static String formatDecimalToMoneyString(Double value) {
        DecimalFormat df = new DecimalFormat("#,###.##");
        return df.format(value);
    }

    public HashMap<String, Object> reportParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String str = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("Santa.jar", "yudala.png").substring(1);
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResourceAsStream("/com/xputertechnologies/santa/ui/rptLogo.png"));
        }
        catch (IOException ex) {
            Logger.getLogger(General.class.getName()).log(Level.SEVERE, null, ex);
        }
        params.put("logoPath", image);
        return params;
    }

    public JasperReport getJsrpt(String ReportName) {
        try {
            return JasperCompileManager.compileReport((InputStream)this.getClass().getResourceAsStream(ReportName + ".jrxml"));
        }
        catch (JRException ex) {
            Logger.getLogger(General.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIntConnection() {
        boolean status = false;
        Socket sock = new Socket();
        InetSocketAddress address = new InetSocketAddress("www.google.com", 80);
        try {
            sock.connect(address, 3000);
            if (sock.isConnected()) {
                status = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                sock.close();
            }
            catch (Exception exception) {}
        }
        return status;
    }

    public static String toNaira() {
        return "\u20a6";
    }

    public static EventHandler<KeyEvent> letter_Validation(final Integer max_Lengh) {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                TextField txt_TextField = (TextField)e.getSource();
                if (txt_TextField.getText().length() >= max_Lengh) {
                    e.consume();
                }
                if (!e.getCharacter().matches("[A-Za-z]")) {
                    e.consume();
                }
            }
        };
    }

    public static void selectAll(final TextField txf) {
        txf.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean t, Boolean t1) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (txf.getText() != null && txf.isFocused() && !txf.getText().isEmpty()) {
                            txf.selectAll();
                        }
                    }
                });
            }
        });
    }

    public static EventHandler<KeyEvent> numeric_Validation(final Integer max_Lengh) {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                TextField txt_TextField = (TextField)e.getSource();
                if (txt_TextField.getText().length() >= max_Lengh) {
                    e.consume();
                }
                if (e.getCharacter().matches("[0-9.]")) {
                    e.consume();
                }
            }
        };
    }

    public static EventHandler<KeyEvent> decimal_validation() {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (!e.getCharacter().matches("[0-9.]")) {
                    e.consume();
                }
            }
        };
    }

    public static EventHandler<KeyEvent> vaalidateTextBoxInput(double max) {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                TextField txt_TextField = (TextField)e.getSource();
                if (txt_TextField.getText().equals("")) {
                    txt_TextField.setText("0.0");
                    e.consume();
                }
            }
        };
    }

    public static EventHandler<KeyEvent> vaalidateTextBoxInput() {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                TextField txt_TextField = (TextField)e.getSource();
                if (txt_TextField.getText().equals("")) {
                    txt_TextField.setText("0.0");
                    e.consume();
                }
            }
        };
    }

    public static ObservableList<String> TransferReasons() {
        ObservableList results = FXCollections.observableArrayList();
        results.add((Object)"For Sale");
        results.add((Object)"For To Transfer");
        return results;
    }
}

