/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.ui.CustomerPane;
import com.xputertechnologies.santa.ui.ICustomerContainer;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SaleListItem;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesPaneB2B;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.StockItem;
import com.xputertechnologies.santa.ui.UIParent;
import com.xputertechnologies.santa.ui.User;
import java.sql.JDBCType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;

public class Customer
extends UIParent {
    CustomerPane cm;
    @FXML
    private JFXButton btnAddnew;
    @FXML
    public JFXTextField addressFld;
    @FXML
    public JFXTextField phoneNoFld;
    @FXML
    public JFXTextField nameFld;
    @FXML
    public JFXTextField email;
    @FXML
    public JFXTextField codeFld;
    @FXML
    public JFXButton Cancelbttn;
    @FXML
    public JFXButton btnDone;
    MainPage mainPage;
    CustomerDataList cdt;
    Santa santa;
    CustomerPane customerPane;
    com.xputertechnologies.santa.Customer customer;
    ICustomerContainer container;
    ISalePane sp;
    boolean isNew;

    public Customer(final ICustomerContainer container, ISalePane sp, final com.xputertechnologies.santa.Customer customer) throws Exception {
        super("Customer.fxml", sp == null ? container.getSanta() : sp.getSanta());
        this.cdt = new CustomerDataList(this.da);
        this.customerPane = null;
        this.customer = null;
        if (container != null) {
            this.mainParent = (UIParent)((Object)container);
            this.hasParent = true;
            if (container.getDialog().getTitle().equals("Edit Customer")) {
                this.btnAddnew.setVisible(false);
            }
            this.container = container;
            if (customer.getState() == ObjectState.New) {
                this.isNew = true;
            }
            this.phoneNoFld.setDisable(!this.isNew);
            this.btnDone.setOnAction(e -> {
                if (this.validated()) {
                    try {
                        this.save();
                        if (this.isNew) {
                            container.getCustomerDataList().getOriginalList().add((Object)customer);
                        }
                        container.updateOtherParam();
                        container.getDialog().close();
                    }
                    catch (Exception ex) {
                        container.getSanta().mainpage.showNotification(NotificationType.Error, ex.getMessage(), (UIParent)((Object)((Object)container)));
                    }
                } else {
                    ((UIParent)((Object)((Object)container))).mainPage.showNotification(NotificationType.Error, "please fill all customer's data", (UIParent)((Object)((Object)container)));
                }
            });
        } else {
            this.btnAddnew.setVisible(false);
            this.Cancelbttn.setVisible(false);
            this.sp = sp;
            this.btnDone.setOnAction(e -> {
                if (this.validated()) {
                    try {
                        this.save();
                        sp.getSale().setParentCustomer(customer);
                        Sale newSale = new Sale(this.da);
                        sp.getPendingSale().getSales().add((Object)newSale);
                        sp.getHbSales().getChildren().add((Object)new SaleListItem(newSale, sp, true));
                        sp.getDialog().close();
                    }
                    catch (Exception ex) {
                        sp.getMainPage().showNotification(NotificationType.Error, ex.getMessage(), sp instanceof SalesPane ? (SalesPane)sp : (SalesPaneB2B)sp);
                    }
                } else {
                    sp.getMainPage().showNotification(NotificationType.Error, "please fill all customer's data", sp instanceof SalesPane ? (SalesPane)sp : (SalesPaneB2B)sp);
                }
            });
        }
        this.customer = customer;
        this.email.textProperty().bindBidirectional((Property)this.customer.emailProperty());
        this.nameFld.textProperty().bindBidirectional((Property)this.customer.nameProperty());
        this.addressFld.textProperty().bindBidirectional((Property)this.customer.addressProperty());
        this.phoneNoFld.textProperty().bindBidirectional((Property)this.customer.phoneNumberProperty());
        this.Cancelbttn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    Customer.this.cancel();
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItem.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.btnAddnew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    if (container != null) {
                        Customer.this.addNewUser();
                    } else {
                        CustomerDataList customerList = new CustomerDataList(customer.getDbAccess());
                        customerList.update();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(User.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    public boolean validated() {
        return this.customer.nameProperty().get() != null && this.customer.phoneNumberProperty().get() != null && !this.customer.isEdit;
    }

    void save() throws Exception {
        CustomerDataList customerList = new CustomerDataList(this.customer.getDbAccess());
        if (this.container != null && this.customer.getState() == ObjectState.New) {
            this.customer.setSn(this.container.getCustomerDataList().getOriginalList().size() + 1);
        }
        this.customer.setParentCompanyName(this.sp == null ? this.container.getSanta().currentUser.getParentCompany() : this.sp.getSanta().currentUser.getParentCompany());
        if (this.customer.getState() == ObjectState.New) {
            customerList.selectAll("Select *from Customer where phoneNumber=?", new ParameterValue[]{new ParameterValue("phoneNumber", JDBCType.VARCHAR, this.customer.getPhoneNumber().trim())});
            if (customerList.getOriginalList().size() > 0) {
                throw new Exception("Phone Number already exist");
            }
            this.customer.setPhoneNumber(this.customer.getPhoneNumber().trim());
        }
        customerList.getOriginalList().add((Object)this.customer);
        customerList.update();
    }

    public void DoneCustomer1() throws Exception {
        if (this.customer.nameProperty().get() != null && this.customer.phoneNumberProperty().get() != null && !this.customer.isEdit) {
            this.customer.addressProperty().set((Object)(this.customer.addressProperty().get() == null ? "" : (String)this.customer.addressProperty().get()));
            this.customer.setParentCompanyName(this.mainParent.mainPage.currentUser.getParentCompany());
            this.customer.isEdit = true;
            if (this.container != null) {
                this.container.done();
            }
        }
    }

    private void cancel() {
        if (this.container != null) {
            this.container.getDialog().close();
        }
    }

    private void addNewUser() {
        if (this.validateControl() && this.customer.nameProperty().get() != null && this.customer.phoneNumberProperty().get() != null && !this.customer.isEdit) {
            try {
                this.customer.setParentCompanyName(this.mainParent.mainPage.currentUser.getParentCompany());
                this.container.getCustomerDataList().getOriginalList().add((Object)this.customer);
                this.save();
                this.container.updateOtherParam();
                this.customer = new com.xputertechnologies.santa.Customer(this.container.getDataAccess());
                this.email.textProperty().bindBidirectional((Property)this.customer.emailProperty());
                this.nameFld.textProperty().bindBidirectional((Property)this.customer.nameProperty());
                this.addressFld.textProperty().bindBidirectional((Property)this.customer.addressProperty());
                this.phoneNoFld.textProperty().bindBidirectional((Property)this.customer.phoneNumberProperty());
            }
            catch (Exception ex) {
                ((UIParent)((Object)this.container)).mainPage.showNotification(NotificationType.Error, ex.getMessage(), (UIParent)((Object)this.container));
                Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    void completeControl() {
        try {
            this.DoneCustomer1();
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

