/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.StockItemData;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public class CustomEditableTableColumnsSaleItemItemCodeAutocomplete<T extends DbEntity>
extends TableCell<T, String> {
    private TextField textField;
    List<StockItemData> source = new ArrayList<StockItemData>();
    String storeCode;

    CustomEditableTableColumnsSaleItemItemCodeAutocomplete(List<StockItemData> source) {
        this.source = source;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(item);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.setOnAction(e -> this.commitEdit(this.textField.getText()));
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.textField, t -> {
            List<StockItemData> result = this.searchData(t.getUserText());
            return result.size() > 30 ? result.subList(0, 29) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<StockItemData>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<StockItemData> event) {
                CustomEditableTableColumnsSaleItemItemCodeAutocomplete.this.textField.setText(((StockItemData)event.getCompletion()).getItemCode());
                SaleItem req = (SaleItem)CustomEditableTableColumnsSaleItemItemCodeAutocomplete.this.getTableView().getItems().get(CustomEditableTableColumnsSaleItemItemCodeAutocomplete.this.getIndex());
                req.setItemName(((StockItemData)event.getCompletion()).getDescription());
                req.setItemCode(((StockItemData)event.getCompletion()).getItemCode());
            }
        });
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                System.out.println("Commiting " + this.textField.getText());
                this.commitEdit(this.textField.getText());
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }

    public List<StockItemData> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<StockItemData>();
        }
        List result = this.source.stream().filter(e -> e.getItemCode().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
        LinkedList searchResult = new LinkedList();
        searchResult.addAll(result.isEmpty() && result.size() > 0 ? this.source : result);
        return searchResult.subList(0, searchResult.size());
    }
}

