/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.CrossDockItem;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.ui.CrossDockPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public class CrossDockItemDialog
extends UIParent {
    @FXML
    private JFXTextField tbQty;
    @FXML
    private JFXTextField tbItemCode;
    @FXML
    private JFXTextField tbName;
    @FXML
    private JFXButton btnSave;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnCancel;
    CrossDockItem product;
    CrossDockPane parent;
    protected StringConverter<? extends Number> intConverter = new IntegerStringConverter(){

        public String toString(Integer object) {
            if (object != null) {
                return Integer.toString(object);
            }
            return null;
        }

        public Integer fromString(String string) {
            Integer d = 0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Integer.parseInt(string);
            }
            return d;
        }
    };

    public CrossDockItemDialog(final CrossDockPane parent) {
        super("CrossDockItemDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Cross Dock";
        this.parent = parent;
        if (parent.selectedStock == null) {
            this.product = new CrossDockItem(this.da);
            this.product.setParentCode(parent.crossDock.getCode());
            this.product.setSn(parent.crossDock.getItems().size() + 1);
        } else {
            this.product = parent.selectedStock;
        }
        this.tbItemCode.textProperty().bindBidirectional((Property)this.product.itemCodeProperty());
        this.tbName.textProperty().bindBidirectional((Property)this.product.itemNameProperty());
        this.tbQty.textProperty().bindBidirectional((Property)this.product.quantityProperty(), this.intConverter);
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.dialog.close();
            }
        });
        this.btnSave.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.selectedStock == null || !parent.selectedStock.getItemCode().equals(CrossDockItemDialog.this.product.getItemCode())) {
                    parent.crossDock.getItems().add((Object)CrossDockItemDialog.this.product);
                }
                parent.dialog.close();
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CrossDockItemDialog.this.rebind();
            }
        });
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.tbItemCode, t -> {
            List<StockItemData> result = this.searchResult(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<StockItemData>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<StockItemData> event) {
                CrossDockItemDialog.this.populateResult((StockItemData)event.getCompletion());
            }
        });
        autoCompletionBinding.setPrefWidth(550.0);
    }

    public List<StockItemData> searchResult(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<StockItemData>();
        }
        List result = this.santa.Products.stream().filter(e -> e.getItemCode().toLowerCase().contains(searchString.toLowerCase()) || e.getDescription().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
        LinkedList searchResult = new LinkedList();
        searchResult.addAll(result.isEmpty() ? this.santa.Products : result);
        return searchResult.subList(0, searchResult.size());
    }

    public void populateResult(StockItemData data) {
        this.tbItemCode.setText(data.getItemCode());
        this.tbName.setText(data.getDescription());
    }

    public void rebind() {
        this.tbItemCode.textProperty().unbindBidirectional((Property)this.product.itemCodeProperty());
        this.tbQty.textProperty().unbindBidirectional((Object)this.product.quantityProperty());
        this.tbName.textProperty().unbindBidirectional((Property)this.product.itemNameProperty());
        if (this.parent.selectedStock == null || !this.parent.selectedStock.getItemCode().equals(this.product.getItemCode())) {
            this.parent.crossDock.getItems().add((Object)this.product);
        }
        this.product = new CrossDockItem(this.parent.da);
        this.product.setParentCode(this.parent.crossDock.getCode());
        this.product.setSn(this.parent.crossDock.getItems().size() + 1);
        this.tbItemCode.textProperty().bindBidirectional((Property)this.product.itemCodeProperty());
        this.tbQty.textProperty().bindBidirectional((Property)this.product.quantityProperty(), this.intConverter);
        this.tbName.textProperty().bindBidirectional((Property)this.product.itemNameProperty());
    }
}

