/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.Approval;
import com.xputertechnologies.santa.ApprovalStage;
import com.xputertechnologies.santa.StageUser;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.ApprovalDataList;
import com.xputertechnologies.santa.list.ApprovalStageDataList;
import com.xputertechnologies.santa.list.StageUserDataList;
import com.xputertechnologies.santa.ui.ApprovalDialog;
import com.xputertechnologies.santa.ui.ApprovalStageAuthorizerListDialog;
import com.xputertechnologies.santa.ui.ApprovalStageDialog;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.JDBCType;
import java.text.SimpleDateFormat;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApprovalPane
extends UIParent {
    @FXML
    JFXListView<Approval> list;
    @FXML
    StackPane stackPane;
    @FXML
    JFXButton btnNew;
    @FXML
    JFXButton btnPost;
    @FXML
    JFXButton btnReload;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colEditable;
    @FXML
    private TableColumn colMinApprove;
    @FXML
    private TableColumn colMinReject;
    @FXML
    private TableColumn colOrder;
    @FXML
    private TableColumn colUsers;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableView<ApprovalStage> table;
    @FXML
    JFXDialog dialog;
    public Approval approval;
    public ApprovalStage currentApprovalStage;
    ApprovalDataList approvalList;

    public ApprovalPane(Santa app) {
        super("ApprovalPane.fxml", app);
        this.santa = app;
        this.title = "Approval Setup";
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.btnPost.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(Color.WHITE).size(15.0));
        this.btnReload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(Color.WHITE).size(15.0));
        this.btnNew.setOnAction(v -> {
            this.approval = null;
            this.showDialog(DialogTypeEnum.Approval);
        });
        this.approvalList = new ApprovalDataList(this.da);
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colEditable.setCellValueFactory((Callback)new PropertyValueFactory("canEdit"));
        this.colMinApprove.setCellValueFactory((Callback)new PropertyValueFactory("minimumApprove"));
        this.colMinReject.setCellValueFactory((Callback)new PropertyValueFactory("minimumReject"));
        this.colOrder.setCellValueFactory((Callback)new PropertyValueFactory("order"));
        this.colUsers.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory(""));
        Callback<TableColumn<ApprovalStage, String>, TableCell<ApprovalStage, String>> cellFactoryViewEdit = new Callback<TableColumn<ApprovalStage, String>, TableCell<ApprovalStage, String>>(){

            public TableCell call(TableColumn<ApprovalStage, String> param) {
                TableCell<ApprovalStage, String> cell = new TableCell<ApprovalStage, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)ApprovalPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            ApprovalStage req = (ApprovalStage)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                ApprovalPane.this.currentApprovalStage = req;
                                ApprovalPane.this.showDialog(DialogTypeEnum.Stage);
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryViewEdit);
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory(""));
        Callback<TableColumn<ApprovalStage, String>, TableCell<ApprovalStage, String>> cellFactoryViewUsers = new Callback<TableColumn<ApprovalStage, String>, TableCell<ApprovalStage, String>>(){

            public TableCell call(TableColumn<ApprovalStage, String> param) {
                TableCell<ApprovalStage, String> cell = new TableCell<ApprovalStage, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)ApprovalPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.btn.setStyle("-fx-background-color: #7D3C98;");
                            ApprovalStage req = (ApprovalStage)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                ApprovalPane.this.currentApprovalStage = req;
                                ApprovalPane.this.showDialog(DialogTypeEnum.StageUser);
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colUsers.setCellFactory((Callback)cellFactoryViewUsers);
        this.list.setItems(this.approvalList.getOriginalList());
        this.list.setCellFactory((Callback)new Callback<ListView<Approval>, ListCell<Approval>>(){

            public ListCell<Approval> call(ListView<Approval> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<Approval> cell = new ListCell<Approval>(){

                    public void updateItem(Approval approvall, boolean empty) {
                        super.updateItem((Object)approvall, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label name = new Label();
                            name.setText(approvall.getDescription());
                            HBox bLabel = new HBox(new Node[]{name});
                            bLabel.setAlignment(Pos.CENTER_LEFT);
                            HBox hBoxRight = new HBox(10.0);
                            hBoxRight.setMinSize(-1.0, -1.0);
                            hBoxRight.setAlignment(Pos.CENTER);
                            JFXButton edit = new JFXButton();
                            edit.setButtonType(JFXButton.ButtonType.RAISED);
                            edit.setStyle("-fx-background-color: #4FC4F6;");
                            edit.setGraphic((Node)ApprovalPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(15.0));
                            edit.setOnAction(v -> ApprovalPane.this.showDialog(DialogTypeEnum.Approval));
                            JFXButton newStage = new JFXButton();
                            newStage.setButtonType(JFXButton.ButtonType.RAISED);
                            newStage.setStyle("-fx-background-color: #999999;");
                            newStage.setGraphic((Node)ApprovalPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
                            newStage.setOnAction(v -> {
                                ApprovalPane.this.approval = approvall;
                                ApprovalPane.this.showDialog(DialogTypeEnum.Stage);
                            });
                            Pane spacer = new Pane();
                            spacer.setMinSize(10.0, 1.0);
                            HBox root = new HBox();
                            root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                            name.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                            hBoxRight.getChildren().addAll((Object[])new Node[]{edit, newStage});
                            root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, hBoxRight});
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)root);
                        }
                    }
                };
                return cell;
            }
        });
        this.btnPost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                final String url = ApprovalPane.this.santa.syncSetting.getBEURL() + "RApprovalTemplate/CreateApprovalTemplate";
                JFXProgressBar progressIndicator = new JFXProgressBar();
                progressIndicator.setProgress(-1.0);
                final VBox box = new VBox(new Node[]{progressIndicator});
                box.setAlignment(Pos.CENTER);
                VBox progressContainer = box;
                ApprovalPane.this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                try {
                                    JSONArray jSONArray = new JSONArray();
                                    for (Approval approval : ApprovalPane.this.approvalList.getOriginalList()) {
                                        JSONObject job = new JSONObject();
                                        job.put("Description", (Object)approval.getDescription());
                                        job.put("DateCreated", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()));
                                        job.put("IsDisable", approval.getIsDisable());
                                        JSONArray stagesJSONArray = new JSONArray();
                                        for (ApprovalStage stage : approval.getStages()) {
                                            JSONObject stageJSONObject = new JSONObject();
                                            stage.setApprovalDescription(approval.getDescription());
                                            stageJSONObject.put("ApprovalDescription", (Object)stage.getApprovalDescription());
                                            stageJSONObject.put("Code", (Object)stage.getCode());
                                            stageJSONObject.put("Description", (Object)stage.getDescription());
                                            stageJSONObject.put("IsDisable", stage.getIsDisable());
                                            stageJSONObject.put("CanEdit", stage.getCanEdit());
                                            stageJSONObject.put("Order", stage.getOrder());
                                            stageJSONObject.put("Name", (Object)stage.getName());
                                            stageJSONObject.put("MinimumApprove", stage.getMinimumApprove());
                                            stageJSONObject.put("MinimumReject", stage.getMinimumReject());
                                            JSONArray stageUsersJSONArray = new JSONArray();
                                            for (StageUser stageUser : stage.getStageUsers()) {
                                                JSONObject stageUserJSONObject = new JSONObject();
                                                stageUser.setApprovalDescription(approval.getDescription());
                                                stageUserJSONObject.put("ApprovalDescription", (Object)stageUser.getApprovalDescription());
                                                stageUser.setStageCode(stage.getCode());
                                                stageUserJSONObject.put("StageCode", (Object)stageUser.getStageCode());
                                                stageUser.setStageName(stage.getName());
                                                stageUserJSONObject.put("StageName", (Object)stageUser.getStageName());
                                                stageUserJSONObject.put("Email", (Object)stageUser.getEmail());
                                                stageUserJSONObject.put("Name", (Object)stageUser.getName());
                                                stageUserJSONObject.put("IsDisable", stageUser.getIsDisable());
                                                stageUsersJSONArray.put((Object)stageUserJSONObject);
                                            }
                                            stageJSONObject.put("StageUsers", (Object)stageUsersJSONArray);
                                            stagesJSONArray.put((Object)stageJSONObject);
                                        }
                                        job.put("Stages", (Object)stagesJSONArray);
                                        jSONArray.put((Object)job);
                                    }
                                    HttpPost httpPost = new HttpPost(url);
                                    RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                    CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                    StringEntity stringEntity = new StringEntity(jSONArray.toString());
                                    httpPost.setEntity((HttpEntity)stringEntity);
                                    httpPost.setHeader("Content-type", "application/json");
                                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                    if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                        ApprovalStageDataList approvalStageDataListSave = new ApprovalStageDataList(ApprovalPane.this.da);
                                        StageUserDataList stageUserDataListSave = new StageUserDataList(ApprovalPane.this.da);
                                        ApprovalPane.this.approvalList.getOriginalList().forEach(c -> {
                                            ApprovalDataList appList = new ApprovalDataList(ApprovalPane.this.da);
                                            appList.selectAll("Select * From Approval where Description=?", new ParameterValue[]{new ParameterValue("Description", JDBCType.VARCHAR, c.getDescription())});
                                            if (appList.getOriginalList().size() == 1) {
                                                c.setState(ObjectState.Changed);
                                                for (ApprovalStage stage : c.getStages()) {
                                                    ApprovalStageDataList approvalStageDataList = new ApprovalStageDataList(ApprovalPane.this.da);
                                                    approvalStageDataList.selectAll("Select * From ApprovalStage where Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, stage.getCode())});
                                                    if (approvalStageDataList.getOriginalList().size() == 1) {
                                                        stage.setState(ObjectState.Changed);
                                                        for (StageUser stageUser : stage.getStageUsers()) {
                                                            StageUserDataList stageUserDataList = new StageUserDataList(ApprovalPane.this.da);
                                                            stageUserDataList.selectAll("Select * From StageUser where Email=? and StageCode=?", new ParameterValue[]{new ParameterValue("Email", JDBCType.VARCHAR, stageUser.getEmail()), new ParameterValue("StageCode", JDBCType.VARCHAR, stageUser.getStageCode())});
                                                            if (stageUserDataList.getOriginalList().size() != 1) continue;
                                                            stageUser.setState(ObjectState.Changed);
                                                        }
                                                    }
                                                    stageUserDataListSave.getOriginalList().addAll(stage.getStageUsers());
                                                }
                                            }
                                            approvalStageDataListSave.getOriginalList().addAll(c.getStages());
                                        });
                                        ApprovalPane.this.approvalList.update();
                                        approvalStageDataListSave.update();
                                        stageUserDataListSave.update();
                                        Platform.runLater(() -> {
                                            ApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                            ApprovalPane.this.mainPage.showNotification(NotificationType.Success, "Approval Template successfully saved.", ApprovalPane.this);
                                        });
                                    } else {
                                        String output;
                                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                        StringBuilder stringBuilder = new StringBuilder();
                                        while ((output = br.readLine()) != null) {
                                            System.out.println(output);
                                            stringBuilder.append(output + "\n");
                                        }
                                        br.close();
                                        String fullError = stringBuilder.toString();
                                        Platform.runLater(() -> {
                                            ApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                            ApprovalPane.this.mainPage.showNotification(NotificationType.Error, fullError, ApprovalPane.this);
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    Platform.runLater(() -> {
                                        ApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                        ApprovalPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), ApprovalPane.this);
                                    });
                                }
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
        });
        this.btnReload.setOnAction(c -> this.loadTemplate());
        this.list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Approval>(){

            public void changed(ObservableValue<? extends Approval> observable, Approval oldValue, Approval newValue) {
                if (newValue != null) {
                    ApprovalPane.this.approval = newValue;
                    ApprovalPane.this.setTableSource();
                }
            }
        });
        this.loadTemplate();
    }

    public void loadTemplate() {
        final String url = this.santa.syncSetting.getBEURL() + "RApprovalTemplate/GetApprovalTemplates";
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        VBox progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                if (ra.length() > 0) {
                                    ApprovalPane.this.approvalList.getOriginalList().clear();
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        Approval apppvApproval = new Approval(ApprovalPane.this.da);
                                        apppvApproval.setDescription(jSONObject.isNull("Description") ? "" : jSONObject.getString("Description"));
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        java.util.Date dt = df.parse(jSONObject.getString("DateCreated"));
                                        apppvApproval.setDateCreated(new Date(dt.getTime()));
                                        apppvApproval.setIsDisable(jSONObject.isNull("IsDisable") ? true : jSONObject.getBoolean("IsDisable"));
                                        apppvApproval.setSyncFlag(Boolean.TRUE);
                                        apppvApproval.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        JSONArray approvalStageArray = jSONObject.getJSONArray("Stages");
                                        for (int j = 0; j < approvalStageArray.length(); ++j) {
                                            JSONObject stageJSONObject = approvalStageArray.getJSONObject(j);
                                            ApprovalStage approvalStage = new ApprovalStage(ApprovalPane.this.da);
                                            approvalStage.setApprovalDescription(stageJSONObject.isNull("ApprovalDescription") ? "" : stageJSONObject.getString("ApprovalDescription"));
                                            approvalStage.setDescription(stageJSONObject.isNull("Description") ? "" : stageJSONObject.getString("Description"));
                                            approvalStage.setCode(stageJSONObject.isNull("Code") ? "" : stageJSONObject.getString("Code"));
                                            approvalStage.setIsDisable(stageJSONObject.isNull("IsDisable") ? true : stageJSONObject.getBoolean("IsDisable"));
                                            approvalStage.setCanEdit(stageJSONObject.isNull("CanEdit") ? false : stageJSONObject.getBoolean("CanEdit"));
                                            approvalStage.setOrder(stageJSONObject.isNull("Order") ? 0 : stageJSONObject.getInt("Order"));
                                            approvalStage.setName(stageJSONObject.isNull("Name") ? "" : stageJSONObject.getString("Name"));
                                            approvalStage.setMinimumApprove(stageJSONObject.isNull("MinimumApprove") ? 0 : stageJSONObject.getInt("MinimumApprove"));
                                            approvalStage.setMinimumReject(stageJSONObject.isNull("MinimumReject") ? 0 : stageJSONObject.getInt("MinimumReject"));
                                            JSONArray stageuserArray = stageJSONObject.getJSONArray("StageUsers");
                                            for (int k = 0; k < stageuserArray.length(); ++k) {
                                                JSONObject stageUserJSONObject = stageuserArray.getJSONObject(k);
                                                StageUser stageUser = new StageUser(ApprovalPane.this.da);
                                                stageUser.setApprovalDescription(stageUserJSONObject.isNull("ApprovalDescription") ? "" : stageUserJSONObject.getString("ApprovalDescription"));
                                                stageUser.setStageName(stageUserJSONObject.isNull("StageName") ? "" : stageUserJSONObject.getString("StageName"));
                                                stageUser.setStageCode(stageUserJSONObject.isNull("StageCode") ? "" : stageUserJSONObject.getString("StageCode"));
                                                stageUser.setEmail(stageUserJSONObject.isNull("Email") ? "" : stageUserJSONObject.getString("Email"));
                                                stageUser.setName(stageUserJSONObject.isNull("Name") ? "" : stageUserJSONObject.getString("Name"));
                                                stageUser.setIsDisable(stageUserJSONObject.isNull("IsDisable") ? true : stageUserJSONObject.getBoolean("IsDisable"));
                                                approvalStage.getStageUsers().add((Object)stageUser);
                                            }
                                            apppvApproval.getStages().add((Object)approvalStage);
                                        }
                                        ApprovalPane.this.approvalList.getOriginalList().add((Object)apppvApproval);
                                    }
                                    Platform.runLater(() -> {
                                        try {
                                            ApprovalPane.this.table.getItems().clear();
                                            ApprovalStageDataList approvalStageDataListSave = new ApprovalStageDataList(ApprovalPane.this.da);
                                            StageUserDataList stageUserDataListSave = new StageUserDataList(ApprovalPane.this.da);
                                            ApprovalPane.this.approvalList.getOriginalList().forEach(c -> {
                                                ApprovalDataList appList = new ApprovalDataList(ApprovalPane.this.da);
                                                appList.selectAll("Select * From Approval where Description=?", new ParameterValue[]{new ParameterValue("Description", JDBCType.VARCHAR, c.getDescription())});
                                                if (appList.getOriginalList().size() == 1) {
                                                    c.setState(ObjectState.Changed);
                                                    for (ApprovalStage stage : c.getStages()) {
                                                        ApprovalStageDataList approvalStageDataList = new ApprovalStageDataList(ApprovalPane.this.da);
                                                        approvalStageDataList.selectAll("Select * From ApprovalStage where Code=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, stage.getCode())});
                                                        if (approvalStageDataList.getOriginalList().size() == 1) {
                                                            stage.setState(ObjectState.Changed);
                                                            for (StageUser stageUser : stage.getStageUsers()) {
                                                                StageUserDataList stageUserDataList = new StageUserDataList(ApprovalPane.this.da);
                                                                stageUserDataList.selectAll("Select * From StageUser where Email=? and StageCode=?", new ParameterValue[]{new ParameterValue("Email", JDBCType.VARCHAR, stageUser.getEmail()), new ParameterValue("StageCode", JDBCType.VARCHAR, stageUser.getStageCode())});
                                                                if (stageUserDataList.getOriginalList().size() != 1) continue;
                                                                stageUser.setState(ObjectState.Changed);
                                                            }
                                                        }
                                                        stageUserDataListSave.getOriginalList().addAll(stage.getStageUsers());
                                                    }
                                                }
                                                approvalStageDataListSave.getOriginalList().addAll(c.getStages());
                                            });
                                            ApprovalPane.this.approvalList.update();
                                            approvalStageDataListSave.update();
                                            stageUserDataListSave.update();
                                        }
                                        catch (Exception ex) {
                                            ApprovalPane.this.mainPage.showNotification(NotificationType.Error, "Error saving template " + ex.getMessage(), ApprovalPane.this);
                                        }
                                        ApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        ApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                        ApprovalPane.this.mainPage.showNotification(NotificationType.Information, "No Template  Found", ApprovalPane.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    ApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                    ApprovalPane.this.mainPage.showNotification(NotificationType.Error, fullError, ApprovalPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                ApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                ApprovalPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), ApprovalPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void setTableSource() {
        if (this.approval != null) {
            this.table.setItems(this.approval.getStages());
            this.table.refresh();
        }
    }

    void showDialog(DialogTypeEnum dialogTypeEnum) {
        switch (dialogTypeEnum) {
            case Approval: {
                this.dialog = new JFXDialog(this.stackPane, (Region)new ApprovalDialog(this), JFXDialog.DialogTransition.CENTER);
                break;
            }
            case Stage: {
                this.dialog = new JFXDialog(this.stackPane, (Region)new ApprovalStageDialog(this), JFXDialog.DialogTransition.CENTER);
                break;
            }
            case StageUser: {
                this.dialog = new JFXDialog(this.stackPane, (Region)new ApprovalStageAuthorizerListDialog(this), JFXDialog.DialogTransition.CENTER);
                break;
            }
        }
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    static enum DialogTypeEnum {
        Approval,
        Stage,
        StageUser;

    }
}

